/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import de.cau.cs.kieler.kiml.options.Direction;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.comment.formatter.DVTComment;
import ro.amiq.dvt.diagrams.design.editor.actions.DDesignFiltersContentAssistProvider;
import ro.amiq.dvt.diagrams.design.editor.actions.DDesignFiltersDialog;
import ro.amiq.dvt.diagrams.filters.DDiagramFiltersTextInput;
import ro.amiq.dvt.diagrams.filters.IDiagramFiltersValidator;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.diagrams.fsm.editor.actions.menu.DFSMActionMessages;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.specador.templates.SpecadorGenerator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTProfilingUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.wizards.AbstractWizardPage;
import ro.amiq.dvt.wizards.specador.SpecadorManager;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorWizard;
import ro.amiq.dvt.wizards.specador.SpecadorWizardPackagePage;

public class SpecadorWizardContent
extends AbstractWizardPage
implements SpecadorModel.IProjectChangeListener {
    private boolean isAnyNatureChecked;
    private boolean showLoadedFilePath = true;
    private String outputPath = "";
    private String outputFolderName = "";
    private String customIndexPath = "";
    private String customCSSFilePath = "";
    private String customJSFilePath = "";
    private static final String SCHEMATIC_FILTERS_INFO = "Highlight/filter ports, signals or blocks using regular expressions and colors.";
    private SpecadorModel.OutputFormat outputFormat;
    private static final Pattern COMMENT_FILTERS_SEPARATOR = Pattern.compile("\\s*,\\s*");
    private static final int TAB_PADDING = 5;
    FieldDecoration infoField = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
    FieldDecoration warningField = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
    private static final String[] DIAGRAM_DIRECTIONS = new String[]{Direction.UP.toString(), Direction.DOWN.toString(), Direction.LEFT.toString(), Direction.RIGHT.toString()};
    private static final String[] PLACEMENT_STRATEGIES = new String[]{PrefConst.FSM_NODE_PLACEMENT_STRATEGY_VALUES[0][0], PrefConst.FSM_NODE_PLACEMENT_STRATEGY_VALUES[1][0]};
    private static final String[] ENFORCE_EDGE_PORT_SIDE = new String[]{FSMDiagramConfiguration.EnforceTransitionPortsOption.NONE.toString(), FSMDiagramConfiguration.EnforceTransitionPortsOption.ALL_STATES.toString(), FSMDiagramConfiguration.EnforceTransitionPortsOption.ALL_STATES_EXCEPT_INITIAL.toString()};
    private static final String[] INITIAL_STATE_POSITIONS = new String[]{PrefConst.FSM_ENFORCE_INITIAL_STATE_LAYER_VALUES[0][0], PrefConst.FSM_ENFORCE_INITIAL_STATE_LAYER_VALUES[1][0], PrefConst.FSM_ENFORCE_INITIAL_STATE_LAYER_VALUES[2][0]};

    public SpecadorWizardContent(String pageName) {
        super(pageName);
        this.setTitle("Edit settings and launch");
        this.setDescription("Specify title, author and export location.");
    }

    @Override
    public void createControl(Composite parent) {
        File preferencesFile;
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)gridData);
        CTabFolder tabFolder = new CTabFolder(composite, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        tabFolder.setSelectionBackground(tabFolder.getBackground());
        this.createCommonSettings(tabFolder);
        this.createAdvancedSettings(tabFolder);
        this.createAPISettings(tabFolder);
        this.createDiagramsSettings(tabFolder);
        tabFolder.pack();
        tabFolder.setSelection(0);
        if (this.showLoadedFilePath && (preferencesFile = this.getModel().getPreferencesFile()) != null && preferencesFile.exists()) {
            Path projectPath = Paths.get(this.getModel().getProject().getLocation().toOSString(), new String[0]);
            this.setMessage("Preferences loaded from: " + projectPath.getFileName() + File.separator + projectPath.relativize(Paths.get(preferencesFile.getAbsolutePath(), new String[0])), 1);
        }
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.validate();
        List<Control> wizardWidgets = Arrays.asList(((Composite)this.getContainer().getShell().getChildren()[0]).getChildren());
        for (Control widget : wizardWidgets) {
            if (!(widget instanceof Text)) continue;
            Utils.setWidgetSWTBotId((Widget)widget, "wizardTextId");
            break;
        }
        parent.layout();
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    private void createDiagramsSettings(CTabFolder tabFolder) {
        CTabItem cTabItem = new CTabItem(tabFolder, 0);
        cTabItem.setImage(DVTImages.imageCache.getImage(DVTImages.DIAGRAMS));
        cTabItem.setText("Diagrams");
        ScrolledComposite scroller = new ScrolledComposite((Composite)tabFolder, 512);
        Composite group = new Composite((Composite)scroller, 0);
        GridData scrolledData = new GridData(1808);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)scrolledData);
        scroller.setContent((Control)group);
        this.createUMLDiagramsGroup(group);
        this.createUVMDiagramsGroup(group);
        this.createDesignDiagramsGroup(group);
        this.createFSMDiagramsGroup(group);
        scroller.setExpandVertical(true);
        scroller.setExpandHorizontal(true);
        scroller.setMinSize(group.computeSize(-1, -1));
        cTabItem.setControl((Control)scroller);
    }

    private void createUMLDiagramsGroup(Composite parent) {
        Group umlGroup = new Group(parent, 0);
        umlGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginLeft = 5;
        umlGroup.setLayout((Layout)layout);
        umlGroup.setText("UML Diagrams");
        final Button umlClassInheritanceButton = SpecadorWizardContent.createPushButton((Composite)umlGroup, "UML Inheritance diagrams", 96);
        Utils.setWidgetSWTBotId((Widget)umlClassInheritanceButton, "umlClassInheritanceButtonId");
        umlClassInheritanceButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        umlClassInheritanceButton.setEnabled(this.getModel().hasEdtNature() || this.getModel().hasVlogNature());
        umlClassInheritanceButton.setSelection(umlClassInheritanceButton.getEnabled() && this.getModel().getUMLClassInheritanceDiagram());
        umlClassInheritanceButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setUMLClassInheritanceDiagram(umlClassInheritanceButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        final Button umlCollaborationButton = SpecadorWizardContent.createPushButton((Composite)umlGroup, "UML Collaboration diagrams", 96);
        Utils.setWidgetSWTBotId((Widget)umlCollaborationButton, "umlCollaborationButtonId");
        umlCollaborationButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        umlCollaborationButton.setEnabled(this.getModel().hasEdtNature() || this.getModel().hasVlogNature());
        umlCollaborationButton.setSelection(umlCollaborationButton.getEnabled() && this.getModel().getUMLCollaborationDiagram());
        umlCollaborationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setUMLCollaborationDiagram(umlCollaborationButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        final Button umlOrthogonalRoutingButton = SpecadorWizardContent.createPushButton((Composite)umlGroup, "Use orthogonal edge routing", 96);
        Utils.setWidgetSWTBotId((Widget)umlOrthogonalRoutingButton, "umlOrthogonalRoutingButtonId");
        umlOrthogonalRoutingButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        umlOrthogonalRoutingButton.setEnabled(this.getModel().hasEdtNature() || this.getModel().hasVlogNature());
        umlOrthogonalRoutingButton.setSelection(umlOrthogonalRoutingButton.getEnabled() && this.getModel().getOrthogonalClassDiagrams());
        umlOrthogonalRoutingButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setOrthogonalClassDiagrams(umlOrthogonalRoutingButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite selectAllComposite = new Composite((Composite)umlGroup, 0);
        selectAllComposite.setLayoutData((Object)new GridData(0x1000008, 1024, true, false, 2, 1));
        selectAllComposite.setLayout((Layout)new GridLayout(2, false));
        Button selectAllButton = SpecadorWizardContent.createPushButton(selectAllComposite, "Select all", 72);
        selectAllButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                umlClassInheritanceButton.setSelection(umlClassInheritanceButton.getEnabled());
                umlCollaborationButton.setSelection(umlCollaborationButton.getEnabled());
                umlOrthogonalRoutingButton.setSelection(umlOrthogonalRoutingButton.getEnabled());
                SpecadorWizardContent.this.getModel().setUMLClassInheritanceDiagram(umlClassInheritanceButton.getSelection());
                SpecadorWizardContent.this.getModel().setUMLCollaborationDiagram(umlCollaborationButton.getSelection());
                SpecadorWizardContent.this.getModel().setOrthogonalClassDiagrams(umlOrthogonalRoutingButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button deselectAllButton = SpecadorWizardContent.createPushButton(selectAllComposite, "Deselect all", 72);
        deselectAllButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                umlClassInheritanceButton.setSelection(false);
                umlCollaborationButton.setSelection(false);
                umlOrthogonalRoutingButton.setSelection(false);
                SpecadorWizardContent.this.getModel().setUMLClassInheritanceDiagram(umlClassInheritanceButton.getSelection());
                SpecadorWizardContent.this.getModel().setUMLCollaborationDiagram(umlCollaborationButton.getSelection());
                SpecadorWizardContent.this.getModel().setOrthogonalClassDiagrams(umlOrthogonalRoutingButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createUVMDiagramsGroup(Composite parent) {
        Group uvmGroup = new Group(parent, 0);
        uvmGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginLeft = 5;
        uvmGroup.setLayout((Layout)layout);
        uvmGroup.setText("UVM Diagrams");
        Composite leftColumn = new Composite((Composite)uvmGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 6;
        leftColumn.setLayout((Layout)layout);
        leftColumn.setLayoutData((Object)new GridData(4, 4, false, true));
        Composite rightColumn = new Composite((Composite)uvmGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        rightColumn.setLayout((Layout)layout);
        rightColumn.setLayoutData((Object)new GridData(4, 4, true, true));
        final Button uvmButton = SpecadorWizardContent.createPushButton(leftColumn, "UVM Components diagrams", 96);
        Utils.setWidgetSWTBotId((Widget)uvmButton, "umvButtonId");
        uvmButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        uvmButton.setEnabled(this.getModel().hasVlogNature());
        uvmButton.setSelection(uvmButton.getEnabled() && this.getModel().getUvmTestDiagram());
        uvmButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setUvmTestDiagram(uvmButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        final Button bitfieldButton = SpecadorWizardContent.createPushButton(leftColumn, "Bit Field diagrams", 96);
        Utils.setWidgetSWTBotId((Widget)bitfieldButton, "bitfieldButtonId");
        bitfieldButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        bitfieldButton.setEnabled(this.getModel().hasVlogNature());
        bitfieldButton.setSelection(bitfieldButton.getEnabled() && this.getModel().getBitfieldDiagram());
        bitfieldButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setBitfieldDiagram(bitfieldButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite depthSpinnerComposite = new Composite(rightColumn, 0);
        depthSpinnerComposite.setLayoutData((Object)new GridData(16384, 4, true, true, 1, 1));
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginLeft = 5;
        depthSpinnerComposite.setLayout((Layout)layout);
        Label depthLabel = new Label(depthSpinnerComposite, 0);
        depthLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        depthLabel.setText("Depth:");
        Spinner depthSpinner = new Spinner(depthSpinnerComposite, 2048);
        depthSpinner.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        depthSpinner.setTextLimit(3);
        depthSpinner.setMinimum(1);
        depthSpinner.setMaximum(999);
        depthSpinner.setSelection(this.getModel().getUvmComponentDiagramDepth());
        depthSpinner.addModifyListener(e -> this.getModel().setUvmComponentDiagramDepth(Integer.parseInt(depthSpinner.getText().trim())));
        Composite selectAllComposite = new Composite(rightColumn, 0);
        selectAllComposite.setLayoutData((Object)new GridData(0x1000008, 1024, true, false, 2, 1));
        selectAllComposite.setLayout((Layout)new GridLayout(2, false));
        Button selectAllButton = SpecadorWizardContent.createPushButton(selectAllComposite, "Select all", 72);
        selectAllButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                uvmButton.setSelection(uvmButton.getEnabled());
                bitfieldButton.setSelection(bitfieldButton.getEnabled());
                SpecadorWizardContent.this.getModel().setUvmTestDiagram(uvmButton.getSelection());
                SpecadorWizardContent.this.getModel().setBitfieldDiagram(bitfieldButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button deselectAllButton = SpecadorWizardContent.createPushButton(selectAllComposite, "Deselect all", 72);
        deselectAllButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                uvmButton.setSelection(false);
                bitfieldButton.setSelection(false);
                SpecadorWizardContent.this.getModel().setUvmTestDiagram(uvmButton.getSelection());
                SpecadorWizardContent.this.getModel().setBitfieldDiagram(bitfieldButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private String trimLines(String originalString) {
        if (originalString == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(originalString.length());
        String sep = System.lineSeparator();
        String[] lines = originalString.split(sep);
        int i = 0;
        while (i < lines.length) {
            if (!lines[i].trim().isEmpty()) {
                out.append(lines[i].trim());
                if (i < lines.length - 1) {
                    out.append(sep);
                }
            }
            ++i;
        }
        return out.toString();
    }

    private void createDesignDiagramsGroup(Composite parent) {
        Group designGroup = new Group(parent, 0);
        designGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 5;
        designGroup.setLayout((Layout)layout);
        designGroup.setText("Design Diagrams");
        Composite leftColumn = new Composite((Composite)designGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        leftColumn.setLayout((Layout)layout);
        leftColumn.setLayoutData((Object)new GridData(4, 128, false, false));
        final Button blockButton = SpecadorWizardContent.createPushButton(leftColumn, "Block diagrams", 96);
        Utils.setWidgetSWTBotId((Widget)blockButton, "blockButtonId");
        blockButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        blockButton.setEnabled(this.getModel().hasVhdlNature() || this.getModel().hasVlogNature());
        blockButton.setSelection(blockButton.getEnabled() && this.getModel().getDesignBlockDiagram());
        blockButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setDesignBlockDiagram(blockButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        boolean hasTops = SpecadorGenerator.INSTANCE.hasTops(this.getModel().getProject(), this.getModel());
        final Button flowButton = SpecadorWizardContent.createPushButton(leftColumn, "Flow diagrams", 96);
        Utils.setWidgetSWTBotId((Widget)flowButton, "flowButtonId");
        flowButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        flowButton.setEnabled(hasTops);
        flowButton.setSelection(flowButton.getEnabled() && this.getModel().getDesignFlowDiagram());
        final Button subInstancesDiagrams = SpecadorWizardContent.createPushButton(leftColumn, "Sub-Instances diagrams", 96);
        Utils.setWidgetSWTBotId((Widget)subInstancesDiagrams, "subInstancesButtonId");
        subInstancesDiagrams.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        subInstancesDiagrams.setEnabled(hasTops);
        subInstancesDiagrams.setSelection(subInstancesDiagrams.getEnabled() && this.getModel().getDesignSubInstancesDiagram());
        final Button schematicButton = SpecadorWizardContent.createPushButton(leftColumn, "Schematic diagrams", 96);
        Utils.setWidgetSWTBotId((Widget)schematicButton, "schematicButtonId");
        schematicButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        schematicButton.setEnabled(hasTops);
        schematicButton.setSelection(schematicButton.getEnabled() && this.getModel().getDesignSchematicDiagram());
        List<Button> designButtons = Arrays.asList(schematicButton, subInstancesDiagrams, flowButton);
        if (!hasTops && (this.getModel().hasVlogNature() || this.getModel().hasVhdlNature())) {
            for (Button button : designButtons) {
                ControlDecoration buttonDecoration = new ControlDecoration((Control)button, 16512);
                buttonDecoration.setImage(this.warningField.getImage());
                buttonDecoration.setDescriptionText("Missing -top directive in build file!");
            }
        }
        Composite rightColumn = new Composite((Composite)designGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        rightColumn.setLayout((Layout)layout);
        rightColumn.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite filterComposite = new Composite(rightColumn, 0);
        filterComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout(2, false);
        layout.marginLeft = 5;
        filterComposite.setLayout((Layout)layout);
        CLabel label = new CLabel(filterComposite, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, true, 1, 1));
        label.setText("Filters:");
        label.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_FILTERS));
        IDiagramFiltersValidator validator = new IDiagramFiltersValidator(){

            @Override
            public void updateStatus(IStatus status) {
            }

            @Override
            public String getTooltipText() {
                return "Examples:\n\nhide instances matching [regex]\nshow types matching [regex]\ncolor ports, signals matching [regex]\ncolor signals matching [regex] using blue\ncolor ports matching [regex] using random";
            }

            @Override
            public String getLineRegex() {
                return "(show|hide)\\s+((port(s{0,1})|block(s{0,1})|instance(s{0,1})|type(s{0,1})|signal(s{0,1})|input port(s{0,1})|output port(s{0,1})|inout port(s{0,1})){0,1},{0,1} *)*\\s+matching\\s+(\\S+\\s+\\S+)+";
            }

            @Override
            public List<String> getKindNames() {
                return DDesignFiltersDialog.KINDS;
            }

            @Override
            public IContentProposalProvider getContentProposalProvider() {
                return DDesignFiltersContentAssistProvider.getInstance();
            }
        };
        StyledText filterDiagramsText = new DDiagramFiltersTextInput((IDiagramFiltersValidator)validator, (Composite)filterComposite, (int)2818).filterText;
        GridData gd = new GridData(4, 4, true, false, 1, 25);
        gd.heightHint = 25;
        filterDiagramsText.setLayoutData((Object)gd);
        String rawFilters = this.getModel().getDesignDiagramFilters();
        if (rawFilters != null) {
            filterDiagramsText.setText(this.trimLines(rawFilters));
        }
        filterDiagramsText.addModifyListener(e -> this.getModel().setDesignDiagramFilters(this.trimLines(filterDiagramsText.getText())));
        ControlDecoration decoration = new ControlDecoration((Control)label, 16512);
        decoration.setImage(this.infoField.getImage());
        decoration.setDescriptionText(SCHEMATIC_FILTERS_INFO);
        for (final Button button : designButtons) {
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SpecadorWizardContent.this.getModel().setDesignSchematicDiagram(button.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        Composite selectAllComposite = new Composite(rightColumn, 0);
        selectAllComposite.setLayoutData((Object)new GridData(0x1000008, 1024, true, false, 2, 1));
        selectAllComposite.setLayout((Layout)new GridLayout(2, false));
        Button selectAllButton = SpecadorWizardContent.createPushButton(selectAllComposite, "Select all", 72);
        selectAllButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                blockButton.setSelection(blockButton.getEnabled());
                schematicButton.setSelection(schematicButton.getEnabled());
                subInstancesDiagrams.setSelection(subInstancesDiagrams.getEnabled());
                flowButton.setSelection(flowButton.getEnabled());
                SpecadorWizardContent.this.getModel().setDesignBlockDiagram(blockButton.getSelection());
                SpecadorWizardContent.this.getModel().setDesignSchematicDiagram(schematicButton.getSelection());
                SpecadorWizardContent.this.getModel().setDesignSubInstancesDiagram(subInstancesDiagrams.getSelection());
                SpecadorWizardContent.this.getModel().setDesignFlowDiagram(flowButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button deselectAllButton = SpecadorWizardContent.createPushButton(selectAllComposite, "Deselect all", 72);
        deselectAllButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                blockButton.setSelection(false);
                schematicButton.setSelection(false);
                subInstancesDiagrams.setSelection(false);
                flowButton.setSelection(false);
                SpecadorWizardContent.this.getModel().setDesignBlockDiagram(blockButton.getSelection());
                SpecadorWizardContent.this.getModel().setDesignSchematicDiagram(schematicButton.getSelection());
                SpecadorWizardContent.this.getModel().setDesignSubInstancesDiagram(subInstancesDiagrams.getSelection());
                SpecadorWizardContent.this.getModel().setDesignFlowDiagram(flowButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createFSMDiagramsGroup(Composite parent) {
        Group fsmGroup = new Group(parent, 0);
        fsmGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginLeft = 5;
        fsmGroup.setLayout((Layout)layout);
        fsmGroup.setText("FSM Diagrams");
        final Button fsmButton = SpecadorWizardContent.createPushButton((Composite)fsmGroup, "Finite State Machine diagrams", 96);
        Utils.setWidgetSWTBotId((Widget)fsmButton, "fsmButtonId");
        final Label graphDirectionLabel = new Label((Composite)fsmGroup, 0);
        final Combo graphDirectionCombo = new Combo((Composite)fsmGroup, 2056);
        Utils.setWidgetSWTBotId((Widget)graphDirectionCombo, "graphDirectionComboId");
        final Label placementStrategyLabel = new Label((Composite)fsmGroup, 0);
        final Combo placementStrategyCombo = new Combo((Composite)fsmGroup, 2056);
        Utils.setWidgetSWTBotId((Widget)placementStrategyCombo, "placementStrategyComboId");
        final Label initialStatePositionLabel = new Label((Composite)fsmGroup, 0);
        final Combo initialStatePositionCombo = new Combo((Composite)fsmGroup, 2056);
        Utils.setWidgetSWTBotId((Widget)initialStatePositionCombo, "initialStatePositionComboId");
        final Label enforceEdgePortSideLabel = new Label((Composite)fsmGroup, 0);
        final Combo enforceEdgePortSideCombo = new Combo((Composite)fsmGroup, 2056);
        Utils.setWidgetSWTBotId((Widget)enforceEdgePortSideCombo, "enforceEdgePortSideComboId");
        final Button showDefaultStateButton = SpecadorWizardContent.createPushButton((Composite)fsmGroup, "Show DEFAULT state value", 96);
        Utils.setWidgetSWTBotId((Widget)showDefaultStateButton, "showDefaultStateButtonId");
        final Button showLoopbackEdgesButton = SpecadorWizardContent.createPushButton((Composite)fsmGroup, "Show explicit loopback edges", 96);
        Utils.setWidgetSWTBotId((Widget)showLoopbackEdgesButton, "showLoopbackEdgesId");
        final Button filterCommonExpressionsInConditions = SpecadorWizardContent.createPushButton((Composite)fsmGroup, DFSMActionMessages.preferencesHideCommonExpressionInConditionText, 96);
        Utils.setWidgetSWTBotId((Widget)filterCommonExpressionsInConditions, "filterCommonExpressionsButtonId");
        fsmButton.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        fsmButton.setEnabled(this.getModel().hasVhdlNature() || this.getModel().hasVlogNature());
        fsmButton.setSelection(fsmButton.getEnabled() && this.getModel().getFSMDiagrams());
        fsmButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setFSMDiagram(fsmButton.getSelection());
                boolean enableFSMSettings = fsmButton.getEnabled() && fsmButton.getSelection();
                showDefaultStateButton.setEnabled(enableFSMSettings);
                showLoopbackEdgesButton.setEnabled(enableFSMSettings);
                filterCommonExpressionsInConditions.setEnabled(enableFSMSettings);
                graphDirectionLabel.setEnabled(enableFSMSettings);
                graphDirectionCombo.setEnabled(enableFSMSettings);
                placementStrategyLabel.setEnabled(enableFSMSettings);
                placementStrategyCombo.setEnabled(enableFSMSettings);
                enforceEdgePortSideLabel.setEnabled(enableFSMSettings);
                enforceEdgePortSideCombo.setEnabled(enableFSMSettings);
                initialStatePositionLabel.setEnabled(enableFSMSettings);
                initialStatePositionCombo.setEnabled(enableFSMSettings);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        boolean enableFSMSettings = fsmButton.getEnabled() && fsmButton.getSelection();
        graphDirectionLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        graphDirectionLabel.setText("Graph direction:");
        graphDirectionLabel.setEnabled(enableFSMSettings);
        graphDirectionCombo.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        graphDirectionCombo.setData((Object)DIAGRAM_DIRECTIONS);
        graphDirectionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setFSMDiagramDirection(DVTStringUtil.toNiceTitleCase(DIAGRAM_DIRECTIONS[graphDirectionCombo.getSelectionIndex()]));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        int i = 0;
        while (i < DIAGRAM_DIRECTIONS.length) {
            String direction = DVTStringUtil.toNiceTitleCase(DIAGRAM_DIRECTIONS[i]);
            graphDirectionCombo.add(direction);
            if (direction.equals(DVTStringUtil.toNiceTitleCase(this.getModel().getFSMDiagramDirection()))) {
                graphDirectionCombo.select(i);
            }
            ++i;
        }
        graphDirectionCombo.setEnabled(enableFSMSettings);
        placementStrategyLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        placementStrategyLabel.setText("Placement strategy:");
        placementStrategyLabel.setEnabled(enableFSMSettings);
        placementStrategyCombo.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        placementStrategyCombo.setData((Object)PLACEMENT_STRATEGIES);
        placementStrategyCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setFSMPlacementStrategy(PLACEMENT_STRATEGIES[placementStrategyCombo.getSelectionIndex()]);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        i = 0;
        while (i < PLACEMENT_STRATEGIES.length) {
            String strategy = DVTStringUtil.toNiceTitleCase(PLACEMENT_STRATEGIES[i]);
            placementStrategyCombo.add(strategy);
            if (strategy.equals(DVTStringUtil.toNiceTitleCase(this.getModel().getFSMPlacementStrategy()))) {
                placementStrategyCombo.select(i);
            }
            ++i;
        }
        placementStrategyCombo.setEnabled(enableFSMSettings);
        enforceEdgePortSideLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        enforceEdgePortSideLabel.setText("Opposite in/out edges for:");
        enforceEdgePortSideLabel.setEnabled(enableFSMSettings);
        enforceEdgePortSideCombo.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        enforceEdgePortSideCombo.setData((Object)ENFORCE_EDGE_PORT_SIDE);
        enforceEdgePortSideCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setFSMEnforceEdgePortSide(DVTStringUtil.toNiceTitleCase(ENFORCE_EDGE_PORT_SIDE[enforceEdgePortSideCombo.getSelectionIndex()]));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        i = 0;
        while (i < ENFORCE_EDGE_PORT_SIDE.length) {
            String states = DVTStringUtil.toNiceTitleCase(ENFORCE_EDGE_PORT_SIDE[i]);
            enforceEdgePortSideCombo.add(states);
            if (states.equals(DVTStringUtil.toNiceTitleCase(this.getModel().getFSMEnforceEdgePortSide()))) {
                enforceEdgePortSideCombo.select(i);
            }
            ++i;
        }
        enforceEdgePortSideCombo.setEnabled(enableFSMSettings);
        initialStatePositionLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        initialStatePositionLabel.setText("Initial state position:");
        initialStatePositionLabel.setEnabled(enableFSMSettings);
        initialStatePositionCombo.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        initialStatePositionCombo.setData((Object)INITIAL_STATE_POSITIONS);
        initialStatePositionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setFSMInitialStatePosition(INITIAL_STATE_POSITIONS[initialStatePositionCombo.getSelectionIndex()]);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        i = 0;
        while (i < INITIAL_STATE_POSITIONS.length) {
            String statePosition = DVTStringUtil.toNiceTitleCase(INITIAL_STATE_POSITIONS[i]);
            initialStatePositionCombo.add(statePosition);
            if (statePosition.equals(DVTStringUtil.toNiceTitleCase(this.getModel().getFSMInitialStatePosition()))) {
                initialStatePositionCombo.select(i);
            }
            ++i;
        }
        initialStatePositionCombo.setEnabled(enableFSMSettings);
        showDefaultStateButton.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        showDefaultStateButton.setEnabled(enableFSMSettings);
        showDefaultStateButton.setSelection(showDefaultStateButton.getEnabled() && this.getModel().getFSMShowDefaultState());
        showDefaultStateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setFSMShowDefaultState(showDefaultStateButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        showLoopbackEdgesButton.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        showLoopbackEdgesButton.setEnabled(enableFSMSettings);
        showLoopbackEdgesButton.setSelection(showLoopbackEdgesButton.getEnabled() && this.getModel().getFSMShowLoopbackEdges());
        showLoopbackEdgesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setFSMShowLoopbackEdges(showLoopbackEdgesButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        filterCommonExpressionsInConditions.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        filterCommonExpressionsInConditions.setEnabled(enableFSMSettings);
        filterCommonExpressionsInConditions.setSelection(filterCommonExpressionsInConditions.getEnabled() && this.getModel().getFSMFilterCommonExpressionsInConditions());
        filterCommonExpressionsInConditions.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setFSMFilterCommonExpressionsInConditions(filterCommonExpressionsInConditions.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createAPISettings(CTabFolder tabFolder) {
        SpecadorWizardPackagePage.CustomElementWrapper[] rootWrappers;
        CTabItem cTabItem = new CTabItem(tabFolder, 0);
        cTabItem.setImage(DVTImages.imageCache.getImage(DVTImages.TYPES));
        cTabItem.setText("API Selection");
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Tree tree = new Tree(composite, 2086);
        GridData data = new GridData(4, 4, true, true, 1, 1);
        tree.setLayoutData((Object)data);
        tree.setHeaderVisible(false);
        tree.setLinesVisible(true);
        ContainerCheckedTreeViewer treeViewer = new ContainerCheckedTreeViewer(tree);
        treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        treeViewer.setContentProvider((IContentProvider)new SpecadorWizardPackagePage.ContentProviderSphinx(this.getModel()));
        treeViewer.setLabelProvider((IBaseLabelProvider)new SpecadorWizardPackagePage.LabelProvider());
        treeViewer.setCheckStateProvider((ICheckStateProvider)new SpecadorWizardPackagePage.CheckStateProvider(this.getModel()));
        treeViewer.setInput((Object)"root");
        treeViewer.expandAll();
        treeViewer.collapseAll();
        treeViewer.expandToLevel(3);
        treeViewer.addPostSelectionChangedListener(event -> {
            ArrayList<String> selectedVlogPackagesNames = new ArrayList<String>();
            LinkedHashSet<String> selectedVlogLibrariesNames = new LinkedHashSet<String>();
            LinkedHashSet<String> selectedVhdlLibrariesNames = new LinkedHashSet<String>();
            ArrayList<String> selectedEdtPackagesNames = new ArrayList<String>();
            this.isAnyNatureChecked = false;
            List<TreeItem> items = this.getAllItems(tree);
            for (TreeItem item : items) {
                if (!(item.getData() instanceof SpecadorWizardPackagePage.CustomElementWrapper)) continue;
                SpecadorWizardPackagePage.CustomElementWrapper wrapper = (SpecadorWizardPackagePage.CustomElementWrapper)item.getData();
                boolean checked = item.getChecked();
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VLOG_ROOT && checked) {
                    this.isAnyNatureChecked = true;
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VLOG_MODULES) {
                    this.getModel().setExportVlogModules(checked);
                    if (wrapper.enclosingLibrary != null) {
                        if (checked) {
                            this.getModel().addVlogLibraryWithModules(wrapper.enclosingLibrary);
                        } else {
                            this.getModel().removeVlogLibraryWithModules(wrapper.enclosingLibrary);
                        }
                    }
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VLOG_INTERFACES) {
                    this.getModel().setExportVlogInterfaces(checked);
                    if (wrapper.enclosingLibrary != null) {
                        if (checked) {
                            this.getModel().addVlogLibraryWithInterfaces(wrapper.enclosingLibrary);
                        } else {
                            this.getModel().removeVlogLibraryWithInterfaces(wrapper.enclosingLibrary);
                        }
                    }
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VLOG_PROGRAMS) {
                    this.getModel().setExportVlogPrograms(checked);
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VLOG_MACROS) {
                    this.getModel().setExportVlogMacros(checked);
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VLOG_CONTROL_DEFINES) {
                    this.getModel().setExportVlogControlDefines(checked);
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VLOG_IFNDEF_GUARDS) {
                    this.getModel().setExportVlogIfndefGuards(checked);
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VLOG_GLOBAL_SCOPE) {
                    this.getModel().setExportVlogGlobalScope(checked);
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VLOG_ALL_ASSERTIONS) {
                    this.getModel().setExportVlogAssertions(checked);
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VLOG_ALL_COVERGROUPS) {
                    this.getModel().setExportVlogCovergroups(checked);
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VLOG_PACKAGES) {
                    this.getModel().setExportVlogPackages(checked);
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VLOG_PACKAGE) {
                    if (checked) {
                        selectedVlogPackagesNames.add(wrapper.label);
                        if (wrapper.enclosingLibrary != null) {
                            this.getModel().addVlogPackageFromLibrary(wrapper.enclosingLibrary, wrapper.label);
                        }
                    } else {
                        this.getModel().removeVlogPackageFromLibrary(wrapper.enclosingLibrary, wrapper.label);
                    }
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VLOG_LIBRARIES) {
                    this.getModel().setExportVlogLibraries(checked);
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VLOG_LIBRARY && checked) {
                    selectedVlogLibrariesNames.add(wrapper.label);
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VHDL_ROOT && checked) {
                    this.isAnyNatureChecked = true;
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VHDL_LIBRARIES) {
                    this.getModel().setExportVhdlLibraries(checked);
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VHDL_LIBRARY && checked) {
                    selectedVhdlLibrariesNames.add(wrapper.label);
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VHDL_ENTITIES && wrapper.enclosingLibrary != null) {
                    if (checked) {
                        this.getModel().addVhdlLibrariesWithEntities(wrapper.enclosingLibrary);
                    } else {
                        this.getModel().removeVhdlLibrariesWithEntities(wrapper.enclosingLibrary);
                    }
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.VHDL_PACKAGE && wrapper.enclosingLibrary != null) {
                    if (checked) {
                        this.getModel().addVhdlPackageFromLibrary(wrapper.enclosingLibrary, wrapper.label);
                    } else {
                        this.getModel().removeVhdlPackageFromLibrary(wrapper.enclosingLibrary, wrapper.label);
                    }
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.EDT_ROOT && checked) {
                    this.isAnyNatureChecked = true;
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.EDT_CHECKS) {
                    this.getModel().setExportEdtChecks(checked);
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.EDT_COVERGROUPS) {
                    this.getModel().setExportEdtCovergroups(checked);
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.EDT_MACROS) {
                    this.getModel().setExportEdtMacros(checked);
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.EDT_TESTS) {
                    this.getModel().setExportEdtTests(checked);
                }
                if (wrapper.kind == SpecadorWizardPackagePage.CustomElementWrapperKind.EDT_PACKAGES) {
                    this.getModel().setExportEdtPackages(checked);
                }
                if (wrapper.kind != SpecadorWizardPackagePage.CustomElementWrapperKind.EDT_PACKAGE || !checked) continue;
                selectedEdtPackagesNames.add(wrapper.label);
            }
            this.getModel().setVlogSelectedPackageNames(selectedVlogPackagesNames);
            this.getModel().setVlogSelectedLibraryNames(selectedVlogLibrariesNames);
            this.getModel().setVhdlSelectedLibraryNames(selectedVhdlLibrariesNames);
            this.getModel().setEdtSelectedPackageNames(selectedEdtPackagesNames);
            this.validate();
        });
        SpecadorWizardPackagePage.CustomElementWrapper[] customElementWrapperArray = rootWrappers = SpecadorWizardPackagePage.getRootWrappers(this.getModel());
        int n = rootWrappers.length;
        int n2 = 0;
        while (n2 < n) {
            SpecadorWizardPackagePage.CustomElementWrapper root = customElementWrapperArray[n2];
            if (treeViewer.getChecked((Object)root)) {
                this.isAnyNatureChecked = true;
            }
            ++n2;
        }
        cTabItem.setControl((Control)composite);
        this.validate();
    }

    private List<TreeItem> getAllItems(Object item) {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        if (item == null) {
            return result;
        }
        TreeItem[] children = new TreeItem[]{};
        if (item instanceof Tree) {
            children = ((Tree)item).getItems();
        } else if (item instanceof TreeItem) {
            children = ((TreeItem)item).getItems();
        }
        TreeItem[] treeItemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            result.add(child);
            result.addAll(this.getAllItems(child));
            ++n2;
        }
        return result;
    }

    private void createCommonSettings(CTabFolder tabFolder) {
        CTabItem cTabItem = new CTabItem(tabFolder, 0);
        cTabItem.setImage(DVTImages.imageCache.getImage(DVTImages.IMG_TAB_GRAPHVIZ_PREFERENCES));
        cTabItem.setText("Common");
        Composite group = new Composite((Composite)tabFolder, 0);
        GridData gridData = new GridData(4, 4, true, false);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        CLabel label = new CLabel(group, 0);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        label.setLayoutData((Object)gridData);
        label.setText("Title:");
        label.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_TITLE));
        Text titleField = new Text(group, 2048);
        Utils.setWidgetSWTBotId((Widget)titleField, "titleFieldId");
        titleField.setData(this.customCSSFilePath, (Object)titleField);
        gridData = new GridData(4, 0x1000000, true, false, 2, 1);
        titleField.setLayoutData((Object)gridData);
        titleField.setText(this.getModel().getTitleText());
        titleField.addModifyListener(e -> this.getModel().setTitleText(titleField.getText().trim()));
        label = new CLabel(group, 0);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        label.setLayoutData((Object)gridData);
        label.setText("Author:");
        label.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_AUTHOR));
        Text authorField = new Text(group, 2048);
        Utils.setWidgetSWTBotId((Widget)authorField, "authorFieldId");
        gridData = new GridData(4, 0x1000000, true, false, 2, 1);
        authorField.setLayoutData((Object)gridData);
        authorField.setText(this.getModel().getAuthor().isEmpty() ? System.getProperty("user.name") : this.getModel().getAuthor());
        authorField.addModifyListener(e -> this.getModel().setAuthor(authorField.getText().trim()));
        label = new CLabel(group, 0);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        label.setLayoutData((Object)gridData);
        label.setText("Copyright:");
        label.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_COPYRIGHT));
        Text copyrightField = new Text(group, 2048);
        Utils.setWidgetSWTBotId((Widget)copyrightField, "copyrightFieldId");
        gridData = new GridData(4, 0x1000000, true, false, 2, 1);
        copyrightField.setLayoutData((Object)gridData);
        copyrightField.setText(this.getModel().getCopyright());
        copyrightField.addModifyListener(e -> this.getModel().setCopyright(copyrightField.getText().trim()));
        label = new CLabel(group, 0);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        label.setLayoutData((Object)gridData);
        label.setText("Output path:");
        label.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_OUTPUT_PATH));
        final Text outputField = new Text(group, 2048);
        Utils.setWidgetSWTBotId((Widget)outputField, "outputFieldId");
        gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        outputField.setLayoutData((Object)gridData);
        this.outputPath = outputField.getText().trim();
        outputField.addModifyListener(e -> {
            this.outputPath = outputField.getText().trim();
            this.validate();
        });
        String rawLocation = this.getModel().getRawLocation();
        outputField.setText(rawLocation.isEmpty() || rawLocation.equals("specador_docs") ? this.getModel().getProject().getLocation().toOSString() : rawLocation);
        outputField.addModifyListener(e -> this.getModel().setRawLocation(outputField.getText().trim()));
        Button browseButton = SpecadorWizardContent.createPushButton(group, "Browse...", 8);
        browseButton.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_BROWSE));
        gridData = new GridData(3, 2, false, false, 1, 1);
        browseButton.setLayoutData((Object)gridData);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(SpecadorWizardContent.this.getShell());
                String filterPath = DVTFileUtils.getInstance().getLastDirectory();
                if (filterPath.equals(System.getProperty("user.home"))) {
                    filterPath = SpecadorWizardContent.this.getModel().getProject().getLocation().toOSString();
                }
                dialog.setFilterPath(filterPath);
                String path = dialog.open();
                if (path == null || path.length() == 0) {
                    return;
                }
                outputField.setText(path);
                DVTFileUtils.getInstance().setLastDirectory(path);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        label = new CLabel(group, 0);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        label.setLayoutData((Object)gridData);
        label.setText("Output folder name:");
        label.setImage(DVTImages.imageCache.getImage(DVTImages.CREATE_NEW_FOLDER_IMG));
        Text outputFolderNameField = new Text(group, 2048);
        Utils.setWidgetSWTBotId((Widget)outputFolderNameField, "outputFolderNameFieldId");
        gridData = new GridData(4, 0x1000000, true, false, 2, 1);
        outputFolderNameField.setLayoutData((Object)gridData);
        outputFolderNameField.setText(this.getModel().getOutputFolderName());
        this.outputFolderName = outputFolderNameField.getText().trim();
        outputFolderNameField.addModifyListener(e -> {
            this.outputFolderName = outputFolderNameField.getText().trim();
            this.validate();
        });
        outputFolderNameField.addModifyListener(e -> this.getModel().setOutputFolderName(outputFolderNameField.getText().trim()));
        label = new CLabel(group, 0);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        label.setLayoutData((Object)gridData);
        label.setText("Output format:");
        label.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_OUTPUT));
        final Combo outputFormatCombo = new Combo(group, 2056);
        Utils.setWidgetSWTBotId((Widget)outputFormatCombo, "outputFormatComboId");
        gridData = new GridData(16384, 4, false, false, 2, 1);
        outputFormatCombo.setLayoutData((Object)gridData);
        outputFormatCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.outputFormat = SpecadorModel.OutputFormat.valueOf(outputFormatCombo.getText().toUpperCase());
                SpecadorWizardContent.this.validate();
                SpecadorWizardContent.this.getModel().setOutputFormat(SpecadorWizardContent.this.outputFormat);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        outputFormatCombo.setData((Object)SpecadorModel.OutputFormat.values());
        int i = 0;
        while (i < SpecadorModel.OutputFormat.values().length) {
            SpecadorModel.OutputFormat format = SpecadorModel.OutputFormat.values()[i];
            if (format != SpecadorModel.OutputFormat.RST) {
                outputFormatCombo.add(format.toString().toUpperCase());
                if (format.equals((Object)this.getModel().getOutputFormat()) || i == 0) {
                    outputFormatCombo.select(i);
                    this.outputFormat = format;
                    this.validate();
                }
            }
            ++i;
        }
        label = new CLabel(group, 0);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        label.setLayoutData((Object)gridData);
        label.setText("Include source code:");
        label.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_SOURCE_CODE));
        final Button exportSourceButton = SpecadorWizardContent.createPushButton(group, "", 32);
        Utils.setWidgetSWTBotId((Widget)exportSourceButton, "exportSourceButtonId");
        gridData = new GridData(16384, 0x1000000, true, false, 2, 1);
        exportSourceButton.setLayoutData((Object)gridData);
        exportSourceButton.setSelection(this.getModel().getExportSourceCode());
        exportSourceButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setExportSourceCode(exportSourceButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        ControlDecoration decoration = new ControlDecoration((Control)label, 16512);
        decoration.setImage(this.infoField.getImage());
        decoration.setDescriptionText("Include source code for documented API.");
        final CLabel clearLabel = new CLabel(group, 0);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        clearLabel.setLayoutData((Object)gridData);
        clearLabel.setText("Clear output folder:");
        if (this.getModel().isCleanLocation()) {
            clearLabel.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_CLEAN_OUTPUT));
        } else {
            clearLabel.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_DO_NOT_CLEAN_OUTPUT));
        }
        final Button cleanButton = SpecadorWizardContent.createPushButton(group, "", 32);
        Utils.setWidgetSWTBotId((Widget)cleanButton, "cleanButtonId");
        gridData = new GridData(16384, 0x1000000, true, false, 2, 1);
        cleanButton.setLayoutData((Object)gridData);
        cleanButton.setSelection(this.getModel().isCleanLocation());
        cleanButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setCleanLocation(cleanButton.getSelection());
                if (SpecadorWizardContent.this.getModel().isCleanLocation()) {
                    clearLabel.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_CLEAN_OUTPUT));
                } else {
                    clearLabel.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_DO_NOT_CLEAN_OUTPUT));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        decoration = new ControlDecoration((Control)clearLabel, 16512);
        decoration.setImage(this.infoField.getImage());
        decoration.setDescriptionText("If disabled, Specador will speed-up the generation by analyzing only changed files.");
        label = new CLabel(group, 0);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        label.setLayoutData((Object)gridData);
        label.setText("Open documentation in browser:");
        label.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_WEB_BROWSER));
        final Button openInBrowser = SpecadorWizardContent.createPushButton(group, "", 32);
        Utils.setWidgetSWTBotId((Widget)openInBrowser, "openInBrowserButtonId");
        gridData = new GridData(16384, 0x1000000, true, false, 2, 1);
        openInBrowser.setLayoutData((Object)gridData);
        openInBrowser.setSelection(this.getModel().isOpenInBrowser());
        openInBrowser.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setOpenInBrowser(openInBrowser.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        cTabItem.setControl((Control)group);
    }

    private void createAdvancedSettings(CTabFolder tabFolder) {
        CTabItem cTabItem = new CTabItem(tabFolder, 0);
        cTabItem.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_ADVANCED));
        cTabItem.setText("Advanced");
        ScrolledComposite scroller = new ScrolledComposite((Composite)tabFolder, 512);
        Composite group = new Composite((Composite)scroller, 0);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        GridLayout groupGridLayout = new GridLayout();
        group.setLayout((Layout)groupGridLayout);
        group.setLayoutData((Object)gridData);
        Group userDocsGroup = new Group(group, 0);
        userDocsGroup.setText("User Documentation");
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginLeft = 5;
        gridData = new GridData(768);
        userDocsGroup.setLayout((Layout)layout);
        userDocsGroup.setLayoutData((Object)gridData);
        CLabel label = new CLabel((Composite)userDocsGroup, 0);
        gridData = new GridData(16384, 0x1000000, false, true, 1, 1);
        label.setLayoutData((Object)gridData);
        label.setText("Table of Contents Description:");
        label.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_TABLE_OF_CONTENT));
        final Text customTocField = new Text((Composite)userDocsGroup, 2048);
        Utils.setWidgetSWTBotId((Widget)customTocField, "customTocFieldId");
        gridData = new GridData(4, 4, true, true, 1, 1);
        customTocField.setLayoutData((Object)gridData);
        customTocField.addModifyListener(e -> {
            this.customIndexPath = customTocField.getText().trim();
            this.validate();
        });
        if (this.getModel().getCustomIndexFilePath() != null) {
            customTocField.setText(this.getModel().getCustomIndexFilePath().getKey());
        }
        customTocField.addModifyListener(e -> this.getModel().setCustomIndexFile(customTocField.getText()));
        ControlDecoration decoration = new ControlDecoration((Control)label, 16512);
        decoration.setImage(this.infoField.getImage());
        decoration.setDescriptionText("Provide a Sphinx index.[rst|md] file to generate a custom Table of Contents menu.");
        Button browseButton = SpecadorWizardContent.createPushButton((Composite)userDocsGroup, "Browse...", 8);
        browseButton.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_BROWSE));
        gridData = new GridData(1, 2, false, false, 1, 1);
        browseButton.setLayoutData((Object)gridData);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SpecadorWizardContent.this.getShell(), 4096);
                String filterPath = DVTFileUtils.getInstance().getLastDirectory();
                if (filterPath.equals(System.getProperty("user.home"))) {
                    filterPath = SpecadorWizardContent.this.getModel().getProject().getLocation().toOSString();
                }
                dialog.setFilterPath(filterPath);
                String path = dialog.open();
                if (path == null || path.length() == 0) {
                    return;
                }
                Path relativePath = Paths.get(SpecadorWizardContent.this.getModel().getProject().getLocation().toOSString(), new String[0]).relativize(Paths.get(path, new String[0])).normalize();
                customTocField.setText(relativePath.toString());
                DVTFileUtils.getInstance().setLastDirectory(path);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        label = new CLabel((Composite)userDocsGroup, 0);
        gridData = new GridData(16384, 128, false, true, 1, 1);
        label.setLayoutData((Object)gridData);
        label.setText("User Documentation:");
        label.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_ADD_OTHERS));
        ScrolledComposite userDocsScrolledComposite = new ScrolledComposite((Composite)userDocsGroup, 768);
        userDocsScrolledComposite.setLayout((Layout)new FillLayout());
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 75;
        userDocsScrolledComposite.setLayoutData((Object)layoutData);
        final Table userDocsTable = new Table((Composite)userDocsScrolledComposite, 2052);
        Utils.setWidgetSWTBotId((Widget)userDocsTable, "userDocsTableId");
        userDocsTable.setHeaderVisible(false);
        userDocsTable.setLinesVisible(true);
        userDocsTable.setLayout((Layout)new GridLayout(1, false));
        layoutData = new GridData(768);
        layoutData.heightHint = 75;
        userDocsTable.setLayoutData((Object)layoutData);
        userDocsScrolledComposite.setContent((Control)userDocsTable);
        userDocsScrolledComposite.setExpandHorizontal(true);
        userDocsScrolledComposite.setExpandVertical(true);
        userDocsScrolledComposite.setMinSize(userDocsTable.computeSize(-1, -1));
        TableColumn userDocsColumn = new TableColumn(userDocsTable, 0);
        userDocsColumn.setWidth(50);
        for (String path : this.getModel().getAttachedRelativePaths()) {
            TableItem item = new TableItem(userDocsTable, 0);
            item.setText(path);
        }
        TableEditor userDocsEditor = new TableEditor(userDocsTable);
        userDocsEditor.horizontalAlignment = 16384;
        userDocsEditor.grabHorizontal = true;
        userDocsTable.addListener(8, this.getTableEditListener(userDocsTable, userDocsEditor, "userDocsTableFieldId", p -> this.getModel().removeAttachedPaths((String[])p), p -> this.getModel().addAttachPath((String)p)));
        decoration = new ControlDecoration((Control)label, 16512);
        decoration.setImage(this.infoField.getImage());
        decoration.setDescriptionText("Embed the user documentation, referenced by the custom Table of Contents, in the generated output.");
        Composite buttonsComposite = new Composite((Composite)userDocsGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Button addButton = new Button(buttonsComposite, 8);
        addButton.setText("Add...");
        addButton.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        addButton.setImage(DVTImages.imageCache.getImage(DVTImages.DESC_ADD_CORRECTION));
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(SpecadorWizardContent.this.getShell());
                String filterPath = DVTFileUtils.getInstance().getLastDirectory();
                if (filterPath.equals(System.getProperty("user.home"))) {
                    filterPath = SpecadorWizardContent.this.getModel().getProject().getLocation().toOSString();
                }
                dialog.setFilterPath(filterPath);
                String path = dialog.open();
                if (path == null || path.length() == 0) {
                    return;
                }
                Path relativePath = Paths.get(SpecadorWizardContent.this.getModel().getProject().getLocation().toOSString(), new String[0]).relativize(Paths.get(path, new String[0]));
                TableItem item = new TableItem(userDocsTable, 0);
                item.setText(relativePath.toString());
                SpecadorWizardContent.this.getModel().addAttachPath(relativePath.toString());
                DVTFileUtils.getInstance().setLastDirectory(path);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button removeButton = new Button(buttonsComposite, 8);
        removeButton.setText("Remove...");
        removeButton.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        removeButton.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_REMOVE_ATTACH));
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().removeAttachedPaths((String[])Arrays.stream(userDocsTable.getSelection()).map(i -> i.getText()).toArray(String[]::new));
                userDocsTable.remove(userDocsTable.getSelectionIndices());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        label = new CLabel((Composite)userDocsGroup, 0);
        gridData = new GridData(16384, 0x1000000, false, true, 1, 1);
        label.setLayoutData((Object)gridData);
        label.setText("Custom CSS:");
        final Text customCSS = new Text((Composite)userDocsGroup, 2048);
        Utils.setWidgetSWTBotId((Widget)customCSS, "customCssFieldId");
        gridData = new GridData(4, 4, true, true, 1, 1);
        customCSS.setLayoutData((Object)gridData);
        customCSS.addModifyListener(e -> {
            this.customCSSFilePath = customCSS.getText().trim();
            this.validate();
        });
        if (this.getModel().getCustomCssFile() != null) {
            customCSS.setText(this.getModel().getCustomCssFile());
        }
        customCSS.addModifyListener(e -> this.getModel().setCustomCssFile(customCSS.getText()));
        Button browseButtonCustomCSS = SpecadorWizardContent.createPushButton((Composite)userDocsGroup, "Browse...", 8);
        browseButtonCustomCSS.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_BROWSE));
        gridData = new GridData(1, 2, false, false, 1, 1);
        browseButtonCustomCSS.setLayoutData((Object)gridData);
        browseButtonCustomCSS.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SpecadorWizardContent.this.getShell(), 4096);
                String filterPath = DVTFileUtils.getInstance().getLastDirectory();
                if (filterPath.equals(System.getProperty("user.home"))) {
                    filterPath = SpecadorWizardContent.this.getModel().getProject().getLocation().toOSString();
                }
                dialog.setFilterPath(filterPath);
                String path = dialog.open();
                if (path == null || path.length() == 0) {
                    return;
                }
                Path relativePath = Paths.get(SpecadorWizardContent.this.getModel().getProject().getLocation().toOSString(), new String[0]).relativize(Paths.get(path, new String[0])).normalize();
                customCSS.setText(relativePath.toString());
                DVTFileUtils.getInstance().setLastDirectory(path);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        label = new CLabel((Composite)userDocsGroup, 0);
        gridData = new GridData(16384, 0x1000000, false, true, 1, 1);
        label.setLayoutData((Object)gridData);
        label.setText("Custom JavaScript:");
        final Text customJS = new Text((Composite)userDocsGroup, 2048);
        Utils.setWidgetSWTBotId((Widget)customJS, "customJsFieldId");
        gridData = new GridData(4, 4, true, true, 1, 1);
        customJS.setLayoutData((Object)gridData);
        customJS.addModifyListener(e -> {
            this.customJSFilePath = customJS.getText().trim();
            this.validate();
        });
        if (this.getModel().getCustomCssFile() != null) {
            customJS.setText(this.getModel().getCustomJsFile());
        }
        customJS.addModifyListener(e -> this.getModel().setCustomJsFile(customJS.getText()));
        Button browseButtonCustomJS = SpecadorWizardContent.createPushButton((Composite)userDocsGroup, "Browse...", 8);
        browseButtonCustomJS.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_BROWSE));
        gridData = new GridData(1, 2, false, false, 1, 1);
        browseButtonCustomJS.setLayoutData((Object)gridData);
        browseButtonCustomJS.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SpecadorWizardContent.this.getShell(), 4096);
                String filterPath = DVTFileUtils.getInstance().getLastDirectory();
                if (filterPath.equals(System.getProperty("user.home"))) {
                    filterPath = SpecadorWizardContent.this.getModel().getProject().getLocation().toOSString();
                }
                dialog.setFilterPath(filterPath);
                String path = dialog.open();
                if (path == null || path.length() == 0) {
                    return;
                }
                Path relativePath = Paths.get(SpecadorWizardContent.this.getModel().getProject().getLocation().toOSString(), new String[0]).relativize(Paths.get(path, new String[0])).normalize();
                customJS.setText(relativePath.toString());
                DVTFileUtils.getInstance().setLastDirectory(path);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Group commentsGroup = new Group(group, 0);
        commentsGroup.setText("Comments");
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginLeft = 5;
        gridData = new GridData(768);
        commentsGroup.setLayout((Layout)layout);
        commentsGroup.setLayoutData((Object)gridData);
        CLabel formatterLabel = new CLabel((Composite)commentsGroup, 0);
        gridData = new GridData(16384, 4, false, false, 1, 1);
        formatterLabel.setLayoutData((Object)gridData);
        formatterLabel.setText("Formatter:");
        formatterLabel.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_FORMATTER));
        final Combo formatterCombo = new Combo((Composite)commentsGroup, 2056);
        Utils.setWidgetSWTBotId((Widget)formatterCombo, "formatterComboId");
        gridData = new GridData(16384, 4, false, false, 2, 1);
        formatterCombo.setLayoutData((Object)gridData);
        formatterCombo.setData((Object)DVTComment.CommentFormat.values());
        formatterCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setDocFormattingType(DVTComment.CommentFormat.values()[formatterCombo.getSelectionIndex()]);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        int i = 0;
        while (i < DVTComment.CommentFormat.values().length) {
            DVTComment.CommentFormat format = DVTComment.CommentFormat.values()[i];
            formatterCombo.add(format.toNiceTitleCase());
            if (format.equals((Object)this.getModel().getDocFormattingType()) || i == 0) {
                formatterCombo.select(i);
            }
            ++i;
        }
        CLabel commentFilterLabel = new CLabel((Composite)commentsGroup, 0);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        commentFilterLabel.setLayoutData((Object)gridData);
        commentFilterLabel.setText("Filters:");
        commentFilterLabel.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_FILTERS));
        Text commentFilters = new Text((Composite)commentsGroup, 2048);
        Utils.setWidgetSWTBotId((Widget)commentFilters, "commentFiltersFieldId");
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        commentFilters.setLayoutData((Object)gridData);
        commentFilters.setText(this.getModel().getCommentFiltersString());
        commentFilters.setMessage("Enter a comma separated list of comment filters...");
        decoration = new ControlDecoration((Control)commentFilters, 16512);
        decoration.setImage(this.infoField.getImage());
        decoration.setDescriptionText("Inline or above comments containing one of the keywords from the list below (comma separated list) will not be included.");
        final Combo commentFiltersStrategy = new Combo((Composite)commentsGroup, 2056);
        Utils.setWidgetSWTBotId((Widget)commentFiltersStrategy, "commentFiltersStrategyComboId");
        commentFiltersStrategy.setData((Object)FiltersStrategy.values());
        int i2 = 0;
        while (i2 < FiltersStrategy.values().length) {
            FiltersStrategy strategy = FiltersStrategy.values()[i2];
            commentFiltersStrategy.add(strategy.name);
            if (strategy.tag.equals((Object)this.getModel().getFilterStrategy()) || i2 == 0) {
                commentFiltersStrategy.select(i2);
            }
            ++i2;
        }
        commentFiltersStrategy.setEnabled(!commentFilters.getText().isEmpty());
        commentFilters.addModifyListener(e -> {
            this.getModel().setCommentFilter(new HashSet<String>(Arrays.asList(DVTStringUtil.split(COMMENT_FILTERS_SEPARATOR, commentFilters.getText()))));
            commentFiltersStrategy.setEnabled(!commentFilters.getText().isEmpty());
        });
        commentFiltersStrategy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setFilterStrategy(FiltersStrategy.values()[commentFiltersStrategy.getSelectionIndex()].tag);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        CLabel tags = new CLabel((Composite)commentsGroup, 0);
        gridData = new GridData(16384, 4, false, false, 1, 1);
        tags.setLayoutData((Object)gridData);
        tags.setText("Tags:");
        tags.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_COMMENT_TAG));
        Text startTag = new Text((Composite)commentsGroup, 2048);
        Utils.setWidgetSWTBotId((Widget)startTag, "startTagFieldId");
        gridData = new GridData(16384, 4, false, false, 1, 1);
        startTag.setLayoutData((Object)gridData);
        startTag.setMessage("Enter start tag for comments content...");
        startTag.setText(this.getModel().getCommentFiltersStartTag());
        startTag.addModifyListener(e -> this.getModel().setCommentFilterStartTag(startTag.getText()));
        decoration = new ControlDecoration((Control)startTag, 16512);
        decoration.setImage(this.infoField.getImage());
        decoration.setDescriptionText("Specador will collect comments content AFTER the specified tag.");
        Text endTag = new Text((Composite)commentsGroup, 2048);
        Utils.setWidgetSWTBotId((Widget)endTag, "endTagFieldId");
        gridData = new GridData(16384, 4, false, false, 1, 1);
        endTag.setLayoutData((Object)gridData);
        endTag.setMessage("Enter end tag for comments content...");
        endTag.setText(this.getModel().getCommentFiltersEndTag());
        endTag.addModifyListener(e -> this.getModel().setCommentFilterEndTag(endTag.getText()));
        decoration = new ControlDecoration((Control)endTag, 16512);
        decoration.setImage(this.infoField.getImage());
        decoration.setDescriptionText("Specador will collect comments content UNTIL the specified tag.");
        Group filterGroup = new Group(group, 0);
        filterGroup.setText("Filters");
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginLeft = 5;
        gridData = new GridData(768);
        filterGroup.setLayout((Layout)layout);
        filterGroup.setLayoutData((Object)gridData);
        label = new CLabel((Composite)filterGroup, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        label.setText("Filter Private API:");
        label.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_FILTER_PRIVATE));
        final Button onlyPublicAPI = SpecadorWizardContent.createPushButton((Composite)filterGroup, "", 32);
        Utils.setWidgetSWTBotId((Widget)onlyPublicAPI, "onlyPublicApiButtonId");
        onlyPublicAPI.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        onlyPublicAPI.setSelection(this.getModel().isPublicOnlyAPI());
        onlyPublicAPI.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().setPublicOnlyAPI(onlyPublicAPI.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (this.getModel().hasVlogNature()) {
            label = new CLabel((Composite)filterGroup, 0);
            gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
            label.setLayoutData((Object)gridData);
            label.setText("Filter SystemVerilog module variables:");
            label.setImage(DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD));
            final Button exportVlogModulesVariables = SpecadorWizardContent.createPushButton((Composite)filterGroup, "", 32);
            Utils.setWidgetSWTBotId((Widget)exportVlogModulesVariables, "exportVlogModuleVariablesButtonId");
            gridData = new GridData(16384, 0x1000000, true, false, 1, 1);
            exportVlogModulesVariables.setLayoutData((Object)gridData);
            exportVlogModulesVariables.setSelection(!this.getModel().isExportVlogModulesVariables());
            exportVlogModulesVariables.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SpecadorWizardContent.this.getModel().setExportVlogModulesVariables(!exportVlogModulesVariables.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            label = new CLabel((Composite)filterGroup, 0);
            gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
            label.setLayoutData((Object)gridData);
            label.setText("Filter SystemVerilog package variables:");
            label.setImage(DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD));
            final Button exportVlogPackagesVariables = SpecadorWizardContent.createPushButton((Composite)filterGroup, "", 32);
            Utils.setWidgetSWTBotId((Widget)exportVlogPackagesVariables, "exportVlogPackageVariablesButtonId");
            gridData = new GridData(16384, 0x1000000, true, false, 1, 1);
            exportVlogPackagesVariables.setLayoutData((Object)gridData);
            exportVlogPackagesVariables.setSelection(!this.getModel().isExportVlogPackagesVariables());
            exportVlogPackagesVariables.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SpecadorWizardContent.this.getModel().setExportVlogPackagesVariables(!exportVlogPackagesVariables.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            label = new CLabel((Composite)filterGroup, 0);
            gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
            label.setLayoutData((Object)gridData);
            label.setText("Filter SystemVerilog inner classes:");
            label.setImage(DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS));
            final Button exportVlogInnerClasses = SpecadorWizardContent.createPushButton((Composite)filterGroup, "", 32);
            Utils.setWidgetSWTBotId((Widget)exportVlogInnerClasses, "exportVlogInnerClassesButtonId");
            gridData = new GridData(16384, 0x1000000, true, false, 1, 1);
            exportVlogInnerClasses.setLayoutData((Object)gridData);
            exportVlogInnerClasses.setSelection(!this.getModel().isExportVlogInnerClasses());
            exportVlogInnerClasses.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SpecadorWizardContent.this.getModel().setExportVlogInnerClasses(!exportVlogInnerClasses.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            label = new CLabel((Composite)filterGroup, 0);
            gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
            label.setLayoutData((Object)gridData);
            label.setText("Filter SystemVerilog localparams:");
            label.setImage(DVTImages.imageCache.getImage(DVTImages.OUTLINE_LOCAL_PARAM));
            final Button exportVlogLocalparams = SpecadorWizardContent.createPushButton((Composite)filterGroup, "", 32);
            Utils.setWidgetSWTBotId((Widget)exportVlogLocalparams, "exportVlogLocalparamsButtonId");
            gridData = new GridData(16384, 0x1000000, true, false, 1, 1);
            exportVlogLocalparams.setLayoutData((Object)gridData);
            exportVlogLocalparams.setSelection(!this.getModel().isExportVlogLocalparams());
            exportVlogLocalparams.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SpecadorWizardContent.this.getModel().setExportVlogLocalparams(!exportVlogLocalparams.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        if (this.getModel().hasVlogNature() || this.getModel().hasVhdlNature()) {
            label = new CLabel((Composite)filterGroup, 0);
            gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
            label.setLayoutData((Object)gridData);
            label.setText("Filter parameters from instances" + (this.getModel().hasVlogNature() ? " and submodules" : "") + ":");
            label.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_INSTANCE_PARAMS));
            final Button exportInstanceParameters = SpecadorWizardContent.createPushButton((Composite)filterGroup, "", 32);
            Utils.setWidgetSWTBotId((Widget)exportInstanceParameters, "exportInstanceParametersButtonId");
            gridData = new GridData(16384, 0x1000000, true, false, 1, 1);
            exportInstanceParameters.setLayoutData((Object)gridData);
            exportInstanceParameters.setSelection(!this.getModel().isExportInstanceParameters());
            exportInstanceParameters.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SpecadorWizardContent.this.getModel().setExportInstanceParameters(!exportInstanceParameters.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            label = new CLabel((Composite)filterGroup, 0);
            gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
            label.setLayoutData((Object)gridData);
            label.setText("Filter unnamed always blocks/processes:");
            label.setImage(DVTImages.imageCache.getImage(DVTImages.OUTLINE_ALWAYS));
            final Button exportUnnamedAlwaysBlocks = SpecadorWizardContent.createPushButton((Composite)filterGroup, "", 32);
            Utils.setWidgetSWTBotId((Widget)exportUnnamedAlwaysBlocks, "exportUnnamedAlwaysBlocksButtonId");
            gridData = new GridData(16384, 0x1000000, true, false, 1, 1);
            exportUnnamedAlwaysBlocks.setLayoutData((Object)gridData);
            exportUnnamedAlwaysBlocks.setSelection(!this.getModel().isExportUnnamedAlwaysBlocks());
            exportUnnamedAlwaysBlocks.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SpecadorWizardContent.this.getModel().setExportUnnamedAlwaysBlocks(!exportUnnamedAlwaysBlocks.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        label = new CLabel((Composite)filterGroup, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        label.setText("Filter names:");
        label.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_FILTERS));
        Text patternsField = new Text((Composite)filterGroup, 2114);
        Utils.setWidgetSWTBotId((Widget)patternsField, "patternsFieldId");
        patternsField.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        patternsField.setText(this.getModel().getFiltersString());
        patternsField.addModifyListener(e -> this.getModel().setFiltersString(patternsField.getText()));
        decoration = new ControlDecoration((Control)label, 16512);
        decoration.setImage(this.infoField.getImage());
        decoration.setDescriptionText("API declaration names matching the filters will not be included in the specification\n(comma separated list, patterns may contain: * = any string, ? = any character).");
        Composite includePathComposite = new Composite((Composite)filterGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        includePathComposite.setLayout((Layout)layout);
        includePathComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        label = new CLabel(includePathComposite, 0);
        gridData = new GridData(16384, 128, false, true, 1, 1);
        label.setLayoutData((Object)gridData);
        label.setText("Include paths: ");
        label.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_INCLUDE_PATHS));
        ScrolledComposite includeScrolledComposite = new ScrolledComposite(includePathComposite, 768);
        includeScrolledComposite.setLayout((Layout)new FillLayout());
        layoutData = new GridData(768);
        layoutData.heightHint = 75;
        includeScrolledComposite.setLayoutData((Object)layoutData);
        final Table includeTable = new Table((Composite)includeScrolledComposite, 2052);
        Utils.setWidgetSWTBotId((Widget)includeTable, "includeTableId");
        includeTable.setHeaderVisible(false);
        includeTable.setLinesVisible(true);
        includeTable.setLayout((Layout)new GridLayout(1, false));
        layoutData = new GridData(768);
        layoutData.heightHint = 75;
        includeTable.setLayoutData((Object)layoutData);
        includeScrolledComposite.setContent((Control)includeTable);
        includeScrolledComposite.setExpandHorizontal(true);
        includeScrolledComposite.setExpandVertical(true);
        includeScrolledComposite.setMinSize(includeTable.computeSize(-1, -1));
        TableColumn includeColumn = new TableColumn(includeTable, 0);
        includeColumn.setWidth(50);
        for (String paths : this.getModel().getIncludePathsStrings()) {
            TableItem item = new TableItem(includeTable, 0);
            item.setText(paths);
        }
        TableEditor includeEditor = new TableEditor(includeTable);
        includeEditor.horizontalAlignment = 16384;
        includeEditor.grabHorizontal = true;
        includeTable.addListener(8, this.getTableEditListener(includeTable, includeEditor, "includeTableFieldId", p -> this.getModel().removeIncludePaths((String[])p), p -> this.getModel().addIncludePath((String)p)));
        decoration = new ControlDecoration((Control)label, 16512);
        decoration.setImage(this.infoField.getImage());
        decoration.setDescriptionText("Only API defined under these file system paths will be exported\n(paths may contain: * = any string, ? = any character).");
        Composite includeButtonsComposite = new Composite(includePathComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        includeButtonsComposite.setLayout((Layout)layout);
        includeButtonsComposite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Button addIncludeButton = new Button(includeButtonsComposite, 8);
        addIncludeButton.setText("Add...");
        addIncludeButton.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        addIncludeButton.setImage(DVTImages.imageCache.getImage(DVTImages.DESC_ADD_CORRECTION));
        addIncludeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(SpecadorWizardContent.this.getShell());
                String includePath = DVTFileUtils.getInstance().getLastDirectory();
                if (includePath.equals(System.getProperty("user.home"))) {
                    includePath = SpecadorWizardContent.this.getModel().getProject().getLocation().toOSString();
                }
                dialog.setFilterPath(includePath);
                String path = dialog.open();
                if (path == null || path.length() == 0) {
                    return;
                }
                Path relativePath = Paths.get(SpecadorWizardContent.this.getModel().getProject().getLocation().toOSString(), new String[0]).relativize(Paths.get(path, new String[0]));
                TableItem item = new TableItem(includeTable, 0);
                item.setText(relativePath.toString());
                SpecadorWizardContent.this.getModel().addIncludePath(relativePath.toString());
                DVTFileUtils.getInstance().setLastDirectory(path);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button removeIncludeButton = new Button(includeButtonsComposite, 8);
        removeIncludeButton.setText("Remove...");
        removeIncludeButton.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        removeIncludeButton.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_REMOVE_ATTACH));
        removeIncludeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().removeIncludePaths((String[])Arrays.stream(includeTable.getSelection()).map(i -> i.getText()).toArray(String[]::new));
                includeTable.remove(includeTable.getSelectionIndices());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite filterPathComposite = new Composite((Composite)filterGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        filterPathComposite.setLayout((Layout)layout);
        filterPathComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        label = new CLabel(filterPathComposite, 0);
        gridData = new GridData(16384, 128, false, true, 1, 1);
        label.setLayoutData((Object)gridData);
        label.setText("Exclude paths:");
        label.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_FILTER_PATHS));
        ScrolledComposite filterScrolledComposite = new ScrolledComposite(filterPathComposite, 768);
        filterScrolledComposite.setLayout((Layout)new FillLayout());
        layoutData = new GridData(768);
        layoutData.heightHint = 75;
        filterScrolledComposite.setLayoutData((Object)layoutData);
        final Table filterTable = new Table((Composite)filterScrolledComposite, 2052);
        Utils.setWidgetSWTBotId((Widget)filterTable, "filterTableId");
        filterTable.setHeaderVisible(false);
        filterTable.setLinesVisible(true);
        filterTable.setLayout((Layout)new GridLayout(1, false));
        layoutData = new GridData(768);
        layoutData.heightHint = 75;
        filterTable.setLayoutData((Object)layoutData);
        filterScrolledComposite.setContent((Control)filterTable);
        filterScrolledComposite.setExpandHorizontal(true);
        filterScrolledComposite.setExpandVertical(true);
        filterScrolledComposite.setMinSize(filterTable.computeSize(-1, -1));
        TableColumn filterColumn = new TableColumn(filterTable, 0);
        filterColumn.setWidth(50);
        for (String path : this.getModel().getFilterPathsStrings()) {
            TableItem item = new TableItem(filterTable, 0);
            item.setText(path);
        }
        TableEditor filterEditor = new TableEditor(filterTable);
        filterEditor.horizontalAlignment = 16384;
        filterEditor.grabHorizontal = true;
        filterTable.addListener(8, this.getTableEditListener(filterTable, filterEditor, "filterTableFieldId", p -> this.getModel().removeFilterPaths((String[])p), p -> this.getModel().addFilterPath((String)p)));
        decoration = new ControlDecoration((Control)label, 16512);
        decoration.setImage(this.infoField.getImage());
        decoration.setDescriptionText("You can select path to files or directories that contains API that you want to exclude from the documentation\n(paths may contain: * = any string, ? = any character).");
        Composite filterButtonsComposite = new Composite(filterPathComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        filterButtonsComposite.setLayout((Layout)layout);
        filterButtonsComposite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Button addFilterButton = new Button(filterButtonsComposite, 8);
        addFilterButton.setText("Add...");
        addFilterButton.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        addFilterButton.setImage(DVTImages.imageCache.getImage(DVTImages.DESC_ADD_CORRECTION));
        addFilterButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(SpecadorWizardContent.this.getShell());
                String filterPath = DVTFileUtils.getInstance().getLastDirectory();
                if (filterPath.equals(System.getProperty("user.home"))) {
                    filterPath = SpecadorWizardContent.this.getModel().getProject().getLocation().toOSString();
                }
                dialog.setFilterPath(filterPath);
                String path = dialog.open();
                if (path == null || path.length() == 0) {
                    return;
                }
                Path relativePath = Paths.get(SpecadorWizardContent.this.getModel().getProject().getLocation().toOSString(), new String[0]).relativize(Paths.get(path, new String[0]));
                TableItem item = new TableItem(filterTable, 0);
                item.setText(relativePath.toString());
                SpecadorWizardContent.this.getModel().addFilterPath(relativePath.toString());
                DVTFileUtils.getInstance().setLastDirectory(path);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button removeFilterButton = new Button(filterButtonsComposite, 8);
        removeFilterButton.setText("Remove...");
        removeFilterButton.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        removeFilterButton.setImage(DVTImages.imageCache.getImage(DVTImages.SPECADOR_REMOVE_ATTACH));
        removeFilterButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpecadorWizardContent.this.getModel().removeFilterPaths((String[])Arrays.stream(filterTable.getSelection()).map(i -> i.getText()).toArray(String[]::new));
                filterTable.remove(filterTable.getSelectionIndices());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        scroller.setContent((Control)group);
        scroller.setExpandVertical(true);
        scroller.setExpandHorizontal(true);
        scroller.setMinSize(group.computeSize(-1, -1));
        cTabItem.setControl((Control)scroller);
    }

    private Listener getTableEditListener(Table table, TableEditor editor, String fieldId, Consumer<String[]> remove, Consumer<String> add) {
        return event -> {
            TableItem item = table.getItem(new Point(event.x, event.y));
            if (item == null) {
                return;
            }
            Text text = new Text((Composite)table, 0);
            Utils.setWidgetSWTBotId((Widget)text, fieldId);
            text.setText(item.getText());
            text.selectAll();
            text.setFocus();
            editor.setEditor((Control)text, item, 0);
            text.addListener(16, e -> this.tableEditListenerMethod(item, text, remove, add));
            text.addListener(31, e -> {
                if (e.detail == 4) {
                    this.tableEditListenerMethod(item, text, remove, add);
                }
            });
        };
    }

    private void tableEditListenerMethod(TableItem item, Text text, Consumer<String[]> remove, Consumer<String> add) {
        remove.accept(new String[]{item.getText()});
        add.accept(text.getText());
        item.setText(text.getText());
        text.dispose();
    }

    private boolean isOutputPathValid() {
        return this.outputPath != null && !this.outputPath.isEmpty();
    }

    private boolean isOutputFolderValid() {
        if (this.outputFolderName == null || this.outputFolderName.isEmpty()) {
            this.setErrorMessage("Output folder name cannot be empty!");
            return false;
        }
        char[] cArray = "/\\\n$%#".toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (this.outputFolderName.indexOf(ch) != -1) {
                this.setErrorMessage("Output folder name cannot contain special characters.");
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isCustomIndexPathValid() {
        if (this.customIndexPath.isEmpty()) {
            return true;
        }
        if (this.doesFileExist(this.customIndexPath)) {
            if (this.isFileValid(this.customIndexPath, "rst") || this.isFileValid(this.customIndexPath, "md")) {
                return true;
            }
            this.setErrorMessage("Custom index file is not a reStructuredText/Markdown file!");
            return false;
        }
        this.setErrorMessage("Custom index file path does not point to an existing file!");
        return false;
    }

    private boolean doesFileExist(String path) {
        String expandedPath = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(path, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, envVarName -> BuildConfigManager.getUserDefinedEnvVar(this.getModel().getProject(), envVarName, BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
        File file = new File(expandedPath);
        if (!file.isAbsolute()) {
            file = new File(this.getModel().getProject().getLocation().toOSString(), expandedPath);
        }
        return file != null && file.exists();
    }

    private boolean isFileValid(String path, String extension) {
        String expandedPath = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(path, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, envVarName -> BuildConfigManager.getUserDefinedEnvVar(this.getModel().getProject(), envVarName, BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
        return !path.isEmpty() && expandedPath.endsWith(extension);
    }

    private boolean isCustomCSSFileValid() {
        if (this.customCSSFilePath.isEmpty()) {
            return true;
        }
        if (!this.doesFileExist(this.customCSSFilePath)) {
            this.setErrorMessage("Custom css file path does not point to an existing file!");
            return false;
        }
        if (!this.isFileValid(this.customCSSFilePath, ".css")) {
            this.setErrorMessage("The provided file is not a .css file!");
            return false;
        }
        return true;
    }

    private boolean isCustomJSFileValid() {
        if (this.customJSFilePath.isEmpty()) {
            return true;
        }
        if (!this.doesFileExist(this.customJSFilePath)) {
            this.setErrorMessage("Custom js file path does not point to an existing file!");
            return false;
        }
        if (!this.isFileValid(this.customJSFilePath, ".js")) {
            this.setErrorMessage("The provided file is not a .js file!");
            return false;
        }
        return true;
    }

    private boolean isOutputFormatValid() {
        return !SpecadorModel.OutputFormat.PDF.equals((Object)this.outputFormat) || SpecadorWizardContent.isLatexmkInstalled();
    }

    private static boolean isLatexmkInstalled() {
        try {
            Process process = Runtime.getRuntime().exec("latexmk --version");
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (IOException | InterruptedException exception) {
            return false;
        }
    }

    private static boolean isMakeInstalled() {
        block3: {
            if (!DVTProfilingUtils.isWinOS()) break block3;
            return true;
        }
        try {
            Process process = Runtime.getRuntime().exec("make --version");
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (IOException | InterruptedException exception) {
            return false;
        }
    }

    private SpecadorModel getModel() {
        IWizard wizard = this.getWizard();
        return ((SpecadorWizard)wizard).getModel();
    }

    @Override
    public void projectChanged(IProject project) {
    }

    public void setShowLoadedPath(boolean showLoadedFilePath) {
        this.showLoadedFilePath = showLoadedFilePath;
    }

    private boolean isProjectBuilt(IProject project) {
        RfMixedLangProject rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (rfMixedLangProject == null) {
            return false;
        }
        return rfMixedLangProject.isState(RfProjectState.BUILT) || rfMixedLangProject.isState(RfProjectState.RESTORED);
    }

    private static boolean isProjectValid(IProject project) {
        try {
            return project.hasNature("ro.amiq.vlogdt.VlogNature") || project.hasNature("ro.amiq.vhdldt.VhdlNature") || project.hasNature("ro.amiq.edt.enature");
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private void validate() {
        IProject project = this.getModel().getProject();
        if (!SpecadorWizardContent.isProjectValid(project)) {
            this.setErrorMessage("Only projects with SystemVerilog, VHDL or eLanguage natures are supported!");
            this.setPageComplete(false);
            return;
        }
        if (!this.isProjectBuilt(project)) {
            RfMixedLangProject rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
            if (rfMixedLangProject.isState(RfProjectState.PRE_RESTORED)) {
                this.setErrorMessage("Full build required! Please wait for the restore job to finish and try again!");
            } else {
                this.setErrorMessage("Full build required! Please start a full build and try again!");
            }
            this.setPageComplete(false);
            return;
        }
        if (!SpecadorWizardContent.isMakeInstalled()) {
            this.setErrorMessage("The 'make' executable is missing! Documentation cannot be generated without this package!");
            this.setPageComplete(false);
            return;
        }
        if (!this.isAnyNatureChecked) {
            this.setErrorMessage("Missing API selections!");
            this.setPageComplete(false);
            return;
        }
        if (!this.isOutputFormatValid()) {
            this.setErrorMessage("The 'latexmk' executable is missing! PDF cannot be generated without this package!");
            this.setPageComplete(false);
            return;
        }
        if (!this.isOutputPathValid()) {
            this.setErrorMessage("Output path cannot be empty!");
            this.setPageComplete(false);
            return;
        }
        if (!this.isOutputFolderValid()) {
            this.setPageComplete(false);
            return;
        }
        if (!this.isCustomIndexPathValid()) {
            this.setPageComplete(false);
            return;
        }
        if (!this.isCustomCSSFileValid()) {
            this.setPageComplete(false);
            return;
        }
        if (!this.isCustomJSFileValid()) {
            this.setPageComplete(false);
            return;
        }
        if (SpecadorManager.INSTANCE.wasBuildCanceled(project)) {
            this.setMessage("Last build/restore was cancelled, generated documentation might not be accurate!", 2);
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private static enum FiltersStrategy {
        ALL(SpecadorModel.CommentFilterStrategy.ALL, "Skip entire comment"),
        LINE(SpecadorModel.CommentFilterStrategy.LINE, "Skip only line");

        SpecadorModel.CommentFilterStrategy tag;
        String name;

        private FiltersStrategy(SpecadorModel.CommentFilterStrategy tag, String name) {
            this.tag = tag;
            this.name = name;
        }
    }
}

