/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.IResourceSelectionChangeListener;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.actions.ProjectSelectionDialog;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtils;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.wizards.specador.SpecadorJob;
import ro.amiq.dvt.wizards.specador.SpecadorWizard;

public class SpecadorWizardHandler
extends AbstractHandler
implements IResourceSelectionChangeListener {
    public static final String ID = "ro.amiq.dvt.wizards.htmldoc.HtmlDocWizardHandler";
    private boolean openWizardDialog;

    public SpecadorWizardHandler() {
        DVTPlugin.getSelectionManager().addResourceSelectionChangeListener(this);
    }

    public void setOpenWizardDialog(boolean openWizardDialog) {
        this.openWizardDialog = openWizardDialog;
    }

    public boolean isEnabled() {
        IProject[] projects = DVTUtilsCommon.getProjects();
        return projects.length != 0;
    }

    public boolean isHandled() {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        RfMixedLangProject rfProject;
        IProject project;
        block9: {
            block8: {
                block6: {
                    block7: {
                        try {
                            project = DVTPlugin.getSelectionManager().getLastSelectedProject();
                            if (project != null && project.isAccessible() && Utils.hasDvtNature(project)) break block6;
                            IProject[] projects = DVTUtilsCommon.getProjects();
                            if (projects.length != 0) break block7;
                            return null;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return null;
                        }
                    }
                    project = ProjectSelectionDialog.selectProject();
                    if (project != null) break block6;
                    return null;
                }
                if (DVTPlugin.getDefault().collect().c(project, "F636F7265")) break block8;
                return null;
            }
            DVTBuildUtils.waitForAllBuildJobsDone(IDVTConstants.VLOG_FAMILY_REPARSE);
            DVTBuildUtils.waitForAllBuildJobsDone(IDVTConstants.VHDL_FAMILY_REPARSE);
            rfProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
            if (rfProject != null) break block9;
            return null;
        }
        rfProject.initXvmFactory();
        return this.startWizard(project, event);
    }

    public static boolean isEditPreferencesEvent(ExecutionEvent event) {
        if (event == null) {
            return false;
        }
        if (SpecadorWizardHandler.getPreferencesFileForEdit(event) != null) {
            return true;
        }
        Object trigger = event.getTrigger();
        if (!(trigger instanceof Event)) {
            return false;
        }
        if (!(((Event)trigger).widget instanceof MenuItem)) {
            return false;
        }
        MenuItem menuItem = (MenuItem)((Event)trigger).widget;
        return !menuItem.isDisposed() && "Edit Preferences...".equals(menuItem.getText());
    }

    public static boolean isNewPreferencesEvent(ExecutionEvent event) {
        if (event == null) {
            return false;
        }
        if (SpecadorWizardHandler.getPreferencesFileForEdit(event) != null) {
            return false;
        }
        Object trigger = event.getTrigger();
        return trigger == null;
    }

    private static String getPreferencesFileForEdit(ExecutionEvent event) {
        if (event == null) {
            return null;
        }
        return event.getParameter("preferencesFile");
    }

    private DVTPair<Integer, String> startWizard(IProject finalProject, final ExecutionEvent event) {
        SpecadorWizard wizard = new SpecadorWizard(finalProject, SpecadorWizardHandler.isEditPreferencesEvent(event), SpecadorWizardHandler.isNewPreferencesEvent(event), SpecadorWizardHandler.getPreferencesFileForEdit(event));
        wizard.init(PlatformUI.getWorkbench(), null);
        if (TestHelper.isTestMode() && !TestHelper.isSWTBotSuite()) {
            if (this.openWizardDialog) {
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.setBlockOnOpen(false);
                dialog.open();
                wizard.performFinish();
                dialog.close();
            } else {
                wizard.performFinish();
            }
        } else {
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard){

                protected void createButtonsForButtonBar(Composite parent) {
                    super.createButtonsForButtonBar(parent);
                    if (SpecadorWizardHandler.isEditPreferencesEvent(event) || SpecadorWizardHandler.isNewPreferencesEvent(event)) {
                        Button finishButton = this.getButton(16);
                        finishButton.setText("Save");
                        this.setButtonLayoutData(finishButton);
                    }
                }

                public boolean isHelpAvailable() {
                    return false;
                }
            };
            Job[] jobs = Job.getJobManager().find(SpecadorJob.class);
            if (jobs.length > 0) {
                SmartCopyUtils.updateStatusBarWithWarning("Wait for the current Specador documentation to be generated!");
            } else {
                dialog.open();
            }
            return new DVTPair<Integer, String>(dialog.getReturnCode(), wizard.getPreferenceFilePath());
        }
        wizard.dispose();
        return null;
    }

    @Override
    public void resourceSelectionChanged(IResource resource) {
        this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
    }

    public void dispose() {
        super.dispose();
        DVTPlugin.getSelectionManager().removeResourceSelectionChangeListener(ro.amiq.dvt.ui.Utils.getActiveWorkbenchWindow(), this);
    }
}

