/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import ro.amiq.dvt.specador.templates.ILibraryWrapper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.wizards.specador.HDWAbstractWizardPage;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorWizard;

public class SpecadorWizardPackagePage
extends HDWAbstractWizardPage {
    protected ContainerCheckedTreeViewer fTreeViewer;
    private ContentProvider fContentProvider;
    private LabelProvider fLabelProvider;
    private CheckStateProvider fCheckedStateProvider;
    private static Object fTreeRoot = new Object();
    private static CustomElementWrapper fVlogRoot = new CustomElementWrapper(CustomElementWrapperKind.VLOG_ROOT, "SystemVerilog");
    private static CustomElementWrapper fVlogModulesWrapper = new CustomElementWrapper(CustomElementWrapperKind.VLOG_MODULES, "Modules");
    private static CustomElementWrapper fVlogInterfacesWrapper = new CustomElementWrapper(CustomElementWrapperKind.VLOG_INTERFACES, "Interfaces");
    private static CustomElementWrapper fVlogProgramsWrapper = new CustomElementWrapper(CustomElementWrapperKind.VLOG_PROGRAMS, "Programs");
    private static CustomElementWrapper fVlogMacrosWrapper = new CustomElementWrapper(CustomElementWrapperKind.VLOG_MACROS, "Macros");
    private static CustomElementWrapper fVlogDefinesControlWrapper = new CustomElementWrapper(CustomElementWrapperKind.VLOG_CONTROL_DEFINES, "Control Defines");
    private static CustomElementWrapper fVlogIfndefGuardWrapper = new CustomElementWrapper(CustomElementWrapperKind.VLOG_IFNDEF_GUARDS, "Ifndef Guards");
    private static CustomElementWrapper fVlogGlobalScopeWrapper = new CustomElementWrapper(CustomElementWrapperKind.VLOG_GLOBAL_SCOPE, "Global Scope");
    private static CustomElementWrapper fVlogPackagesWrapper = new CustomElementWrapper(CustomElementWrapperKind.VLOG_PACKAGES, "Packages");
    private static CustomElementWrapper fVlogLibrariesWrapper = new CustomElementWrapper(CustomElementWrapperKind.VLOG_LIBRARIES, "Libraries");
    private static CustomElementWrapper fVlogAllAssertionsWrapper = new CustomElementWrapper(CustomElementWrapperKind.VLOG_ALL_ASSERTIONS, "Assertions");
    private static CustomElementWrapper fVlogAllCovergroupsWrapper = new CustomElementWrapper(CustomElementWrapperKind.VLOG_ALL_COVERGROUPS, "Covergroups");
    private static CustomElementWrapper fVhdlRoot = new CustomElementWrapper(CustomElementWrapperKind.VHDL_ROOT, "VHDL");
    private static CustomElementWrapper fVhdlLibrariesWrapper = new CustomElementWrapper(CustomElementWrapperKind.VHDL_LIBRARIES, "Libraries");
    private static CustomElementWrapper fEdtRoot = new CustomElementWrapper(CustomElementWrapperKind.EDT_ROOT, "e Language");
    private static CustomElementWrapper fEdtMacrosWrapper = new CustomElementWrapper(CustomElementWrapperKind.EDT_MACROS, "Macros");
    private static CustomElementWrapper fEdtCovergroupsWrapper = new CustomElementWrapper(CustomElementWrapperKind.EDT_COVERGROUPS, "Covergroups");
    private static CustomElementWrapper fEdtChecksWrapper = new CustomElementWrapper(CustomElementWrapperKind.EDT_CHECKS, "Checks");
    private static CustomElementWrapper fEdtPackagesWrapper = new CustomElementWrapper(CustomElementWrapperKind.EDT_PACKAGES, "Packages");
    private static CustomElementWrapper fEdtTestsWrapper = new CustomElementWrapper(CustomElementWrapperKind.EDT_TESTS, "Tests");
    private Tree fTree;

    public static CustomElementWrapper[] getRootWrappers(SpecadorModel model) {
        ArrayList<CustomElementWrapper> roots = new ArrayList<CustomElementWrapper>();
        if (model.hasEdtNature()) {
            roots.add(fEdtRoot);
        }
        if (model.hasVlogNature()) {
            roots.add(fVlogRoot);
        }
        if (model.hasVhdlNature()) {
            roots.add(fVhdlRoot);
        }
        return roots.toArray(new CustomElementWrapper[0]);
    }

    public void dispose() {
        this.fTreeViewer = null;
        super.dispose();
    }

    protected SpecadorWizardPackagePage(String pageName) {
        super(pageName);
        this.setTitle("API Selection");
        this.setDescription("Select the API you want to export.");
        this.setImageDescriptor(DVTImages.HTML_EXPORT_WIZARD);
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.fTree = new Tree(composite, 2086);
        GridData data = new GridData(4, 4, true, true, 1, 1);
        this.fTree.setLayoutData((Object)data);
        this.fTree.setHeaderVisible(false);
        this.fTree.setLinesVisible(true);
        this.fContentProvider = new ContentProvider(this.getModel());
        this.fLabelProvider = new LabelProvider();
        this.fCheckedStateProvider = new CheckStateProvider(this.getModel());
        this.fTreeViewer = new ContainerCheckedTreeViewer(this.fTree);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTreeViewer.setCheckStateProvider((ICheckStateProvider)this.fCheckedStateProvider);
        this.fTreeViewer.expandAll();
        this.fTreeViewer.addSelectionChangedListener(event -> this.updatePageProperties());
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        Button selectAllButton = SpecadorWizardPackagePage.createPushButton(buttons, "Select All", 8);
        selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                for (TreeItem ti : SpecadorWizardPackagePage.this.getAllItems(SpecadorWizardPackagePage.this.fTree)) {
                    ti.setChecked(true);
                    ti.setGrayed(false);
                }
                SpecadorWizardPackagePage.this.updatePageProperties();
            }
        });
        Button clearAllButton = SpecadorWizardPackagePage.createPushButton(buttons, "Clear All", 8);
        clearAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                for (TreeItem ti : SpecadorWizardPackagePage.this.getAllItems(SpecadorWizardPackagePage.this.fTree)) {
                    ti.setChecked(false);
                    ti.setGrayed(false);
                }
                SpecadorWizardPackagePage.this.updatePageProperties();
            }
        });
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
        this.projectChanged(this.getModel().getProject());
        this.updatePageProperties();
    }

    private List<TreeItem> getAllItems(Object item) {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        if (item == null) {
            return result;
        }
        TreeItem[] children = new TreeItem[]{};
        if (item instanceof Tree) {
            children = ((Tree)item).getItems();
        } else if (item instanceof TreeItem) {
            children = ((TreeItem)item).getItems();
        }
        TreeItem[] treeItemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            result.add(child);
            result.addAll(this.getAllItems(child));
            ++n2;
        }
        return result;
    }

    private void updatePageProperties() {
        if (this.fTreeViewer == null) {
            return;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        ArrayList<String> selectedVlogPackagesNames = new ArrayList<String>();
        LinkedHashSet<String> selectedVhdlLibrariesNames = new LinkedHashSet<String>();
        ArrayList<String> selectedEdtPackagesNames = new ArrayList<String>();
        HashSet<String> selectedNatures = new HashSet<String>();
        List<TreeItem> items = this.getAllItems(this.fTree);
        for (TreeItem item : items) {
            if (!(item.getData() instanceof CustomElementWrapper)) continue;
            CustomElementWrapper wrapper = (CustomElementWrapper)item.getData();
            boolean checked = item.getChecked();
            if (wrapper.kind == CustomElementWrapperKind.VLOG_ROOT && checked) {
                selectedNatures.add("ro.amiq.vlogdt.VlogNature");
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_MODULES) {
                this.getModel().setExportVlogModules(checked);
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_INTERFACES) {
                this.getModel().setExportVlogInterfaces(checked);
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_PROGRAMS) {
                this.getModel().setExportVlogPrograms(checked);
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_MACROS) {
                this.getModel().setExportVlogMacros(checked);
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_CONTROL_DEFINES) {
                this.getModel().setExportVlogControlDefines(checked);
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_IFNDEF_GUARDS) {
                this.getModel().setExportVlogIfndefGuards(checked);
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_GLOBAL_SCOPE) {
                this.getModel().setExportVlogGlobalScope(checked);
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_ALL_ASSERTIONS) {
                this.getModel().setExportVlogAssertions(checked);
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_ALL_COVERGROUPS) {
                this.getModel().setExportVlogCovergroups(checked);
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_PACKAGES) {
                this.getModel().setExportVlogPackages(checked);
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_PACKAGE && checked) {
                selectedVlogPackagesNames.add(wrapper.label);
            }
            if (wrapper.kind == CustomElementWrapperKind.VHDL_ROOT && checked) {
                selectedNatures.add("ro.amiq.vhdldt.VhdlNature");
            }
            if (wrapper.kind == CustomElementWrapperKind.VHDL_LIBRARIES) {
                this.getModel().setExportVhdlLibraries(checked);
            }
            if (wrapper.kind == CustomElementWrapperKind.VHDL_LIBRARY && checked) {
                selectedVhdlLibrariesNames.add(wrapper.label);
            }
            if (wrapper.kind == CustomElementWrapperKind.EDT_ROOT && checked) {
                selectedNatures.add("ro.amiq.edt.enature");
            }
            if (wrapper.kind == CustomElementWrapperKind.EDT_MACROS) {
                this.getModel().setExportEdtMacros(checked);
            }
            if (wrapper.kind == CustomElementWrapperKind.EDT_COVERGROUPS) {
                this.getModel().setExportEdtCovergroups(checked);
            }
            if (wrapper.kind == CustomElementWrapperKind.EDT_CHECKS) {
                this.getModel().setExportEdtChecks(checked);
            }
            if (wrapper.kind == CustomElementWrapperKind.EDT_PACKAGES) {
                this.getModel().setExportEdtPackages(checked);
            }
            if (wrapper.kind == CustomElementWrapperKind.EDT_PACKAGE && checked) {
                selectedEdtPackagesNames.add(wrapper.label);
            }
            if (wrapper.kind != CustomElementWrapperKind.EDT_TESTS) continue;
            this.getModel().setExportEdtTests(checked);
        }
        this.getModel().setVlogSelectedPackageNames(selectedVlogPackagesNames);
        this.getModel().setEdtSelectedPackageNames(selectedEdtPackagesNames);
        this.getModel().setVhdlSelectedLibraryNames(selectedVhdlLibrariesNames);
        if (selectedNatures.isEmpty()) {
            this.setErrorMessage("You must select at least one nature!");
            return;
        }
        this.getModel().setSelectedProjectNatures(selectedNatures);
        IWizard wiz = this.getWizard();
        SpecadorWizard cfr_ignored_0 = (SpecadorWizard)wiz;
    }

    @Override
    public void projectChanged(IProject project) {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setInput(fTreeRoot);
            List<TreeItem> items = this.getAllItems(this.fTree);
            for (TreeItem item : items) {
                if (!(item.getData() instanceof CustomElementWrapper)) continue;
                CustomElementWrapper wrapper = (CustomElementWrapper)item.getData();
                boolean hasVlogNature = this.getModel().getSelectedProjectNatures().contains("ro.amiq.vlogdt.VlogNature");
                if (wrapper.kind == CustomElementWrapperKind.VLOG_ROOT) {
                    item.setChecked(hasVlogNature);
                }
                if (wrapper.kind == CustomElementWrapperKind.VLOG_PACKAGE) {
                    item.setChecked(hasVlogNature && this.getModel().getVlogSelectedPackageNames().contains(wrapper.label));
                }
                if (wrapper.kind == CustomElementWrapperKind.VLOG_MODULES) {
                    item.setChecked(hasVlogNature && this.getModel().isExportVlogModules());
                }
                if (wrapper.kind == CustomElementWrapperKind.VLOG_INTERFACES) {
                    item.setChecked(hasVlogNature && this.getModel().isExportVlogInterfaces());
                }
                if (wrapper.kind == CustomElementWrapperKind.VLOG_PROGRAMS) {
                    item.setChecked(hasVlogNature && this.getModel().isExportVlogPrograms());
                }
                if (wrapper.kind == CustomElementWrapperKind.VLOG_MACROS) {
                    item.setChecked(hasVlogNature && this.getModel().isExportVlogMacros());
                }
                if (wrapper.kind == CustomElementWrapperKind.VLOG_CONTROL_DEFINES) {
                    item.setChecked(hasVlogNature && this.getModel().isExportVlogControlDefines());
                }
                if (wrapper.kind == CustomElementWrapperKind.VLOG_IFNDEF_GUARDS) {
                    item.setChecked(hasVlogNature && this.getModel().isExportVlogIfndefGuards());
                }
                if (wrapper.kind == CustomElementWrapperKind.VLOG_GLOBAL_SCOPE) {
                    item.setChecked(hasVlogNature && this.getModel().isExportVlogGlobalScope());
                }
                if (wrapper.kind == CustomElementWrapperKind.VLOG_ALL_ASSERTIONS) {
                    item.setChecked(hasVlogNature && this.getModel().isExportVlogAssertions());
                }
                if (wrapper.kind == CustomElementWrapperKind.VLOG_ALL_COVERGROUPS) {
                    item.setChecked(hasVlogNature && this.getModel().isExportVlogCovergroups());
                }
                if (wrapper.kind == CustomElementWrapperKind.VLOG_PACKAGES) {
                    item.setChecked(hasVlogNature && this.getModel().isExportVlogPackages());
                }
                boolean hasVhdlNature = this.getModel().getSelectedProjectNatures().contains("ro.amiq.vhdldt.VhdlNature");
                if (wrapper.kind == CustomElementWrapperKind.VHDL_ROOT) {
                    item.setChecked(hasVhdlNature);
                }
                if (wrapper.kind == CustomElementWrapperKind.VHDL_LIBRARY) {
                    item.setChecked(hasVhdlNature && this.getModel().getVhdlSelectedLibraryNames().contains(wrapper.label));
                }
                if (wrapper.kind == CustomElementWrapperKind.VHDL_LIBRARIES) {
                    item.setChecked(hasVhdlNature && this.getModel().isExportVhdlLibraries());
                }
                boolean hasEdtNature = this.getModel().getSelectedProjectNatures().contains("ro.amiq.edt.enature");
                if (wrapper.kind == CustomElementWrapperKind.EDT_ROOT) {
                    item.setChecked(hasEdtNature);
                }
                if (wrapper.kind == CustomElementWrapperKind.EDT_PACKAGE) {
                    item.setChecked(hasEdtNature && this.getModel().getEdtSelectedPackageNames().contains(wrapper.label));
                }
                if (wrapper.kind == CustomElementWrapperKind.EDT_PACKAGES) {
                    item.setChecked(hasEdtNature && this.getModel().isExportEdtPackages());
                }
                if (wrapper.kind == CustomElementWrapperKind.EDT_MACROS) {
                    item.setChecked(hasEdtNature && this.getModel().isExportEdtMacros());
                }
                if (wrapper.kind == CustomElementWrapperKind.EDT_COVERGROUPS) {
                    item.setChecked(hasEdtNature && this.getModel().isExportEdtCovergroups());
                }
                if (wrapper.kind == CustomElementWrapperKind.EDT_CHECKS) {
                    item.setChecked(hasEdtNature && this.getModel().isExportEdtChecks());
                }
                if (wrapper.kind != CustomElementWrapperKind.EDT_TESTS) continue;
                item.setChecked(hasEdtNature && this.getModel().isExportEdtTests());
            }
            this.fTreeViewer.refresh();
            this.fTreeViewer.expandAll();
        }
    }

    public static final class CheckStateProvider
    implements ICheckStateProvider {
        private SpecadorModel model;

        public CheckStateProvider(SpecadorModel model) {
            this.model = model;
        }

        public boolean isGrayed(Object element) {
            return false;
        }

        public boolean isChecked(Object element) {
            if (!(element instanceof CustomElementWrapper)) {
                return false;
            }
            CustomElementWrapper wrapper = (CustomElementWrapper)element;
            boolean hasVlogNature = this.model.getSelectedProjectNatures().contains("ro.amiq.vlogdt.VlogNature");
            if (wrapper.kind == CustomElementWrapperKind.VLOG_ROOT) {
                return hasVlogNature;
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_MODULES) {
                if (wrapper.enclosingLibrary != null) {
                    return hasVlogNature && this.model.getVlogLibrariesWithModules().contains(wrapper.enclosingLibrary);
                }
                return hasVlogNature && this.model.isExportVlogModules();
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_INTERFACES) {
                if (wrapper.enclosingLibrary != null) {
                    return hasVlogNature && this.model.getVlogLibrariesWithInterfaces().contains(wrapper.enclosingLibrary);
                }
                return hasVlogNature && this.model.isExportVlogInterfaces();
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_PROGRAMS) {
                return hasVlogNature && this.model.isExportVlogPrograms();
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_MACROS) {
                return hasVlogNature && this.model.isExportVlogMacros();
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_CONTROL_DEFINES) {
                return hasVlogNature && this.model.isExportVlogControlDefines();
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_IFNDEF_GUARDS) {
                return hasVlogNature && this.model.isExportVlogIfndefGuards();
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_GLOBAL_SCOPE) {
                return hasVlogNature && this.model.isExportVlogGlobalScope();
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_ALL_ASSERTIONS) {
                return hasVlogNature && this.model.isExportVlogAssertions();
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_ALL_COVERGROUPS) {
                return hasVlogNature && this.model.isExportVlogCovergroups();
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_PACKAGES) {
                return hasVlogNature && this.model.isExportVlogPackages();
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_PACKAGE) {
                if (wrapper.enclosingLibrary != null) {
                    return hasVlogNature && this.model.getVlogLibrariesWithPackages().containsKey(wrapper.enclosingLibrary) && this.model.getVlogLibrariesWithPackages().get(wrapper.enclosingLibrary).contains(wrapper.label);
                }
                return hasVlogNature && this.model.getVlogSelectedPackageNames().contains(wrapper.label);
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_LIBRARIES) {
                return hasVlogNature && this.model.isExportVlogLibraries();
            }
            if (wrapper.kind == CustomElementWrapperKind.VLOG_LIBRARY) {
                return hasVlogNature && this.model.getVlogSelectedLibraryNames().contains(wrapper.label);
            }
            boolean hasVhdlNature = this.model.getSelectedProjectNatures().contains("ro.amiq.vhdldt.VhdlNature");
            if (wrapper.kind == CustomElementWrapperKind.VHDL_ROOT) {
                return hasVhdlNature;
            }
            if (wrapper.kind == CustomElementWrapperKind.VHDL_LIBRARIES) {
                return hasVhdlNature && this.model.isExportVhdlLibraries();
            }
            if (wrapper.kind == CustomElementWrapperKind.VHDL_LIBRARY) {
                return hasVhdlNature && this.model.getVhdlSelectedLibraryNames().contains(wrapper.label);
            }
            if (wrapper.kind == CustomElementWrapperKind.VHDL_ENTITIES) {
                if (wrapper.enclosingLibrary != null) {
                    return hasVhdlNature && this.model.getVhdlLibrariesWithEntities().contains(wrapper.enclosingLibrary);
                }
                return hasVhdlNature;
            }
            if (wrapper.kind == CustomElementWrapperKind.VHDL_PACKAGES) {
                return hasVhdlNature;
            }
            if (wrapper.kind == CustomElementWrapperKind.VHDL_PACKAGE) {
                if (wrapper.enclosingLibrary != null) {
                    return hasVhdlNature && this.model.getVhdlLibrariesWithPackages().containsKey(wrapper.enclosingLibrary) && this.model.getVhdlLibrariesWithPackages().get(wrapper.enclosingLibrary).contains(wrapper.label);
                }
                return hasVhdlNature;
            }
            boolean hasEdtNature = this.model.getSelectedProjectNatures().contains("ro.amiq.edt.enature");
            if (wrapper.kind == CustomElementWrapperKind.EDT_ROOT) {
                return hasEdtNature;
            }
            if (wrapper.kind == CustomElementWrapperKind.EDT_MACROS) {
                return hasEdtNature && this.model.isExportEdtMacros();
            }
            if (wrapper.kind == CustomElementWrapperKind.EDT_COVERGROUPS) {
                return hasEdtNature && this.model.isExportEdtCovergroups();
            }
            if (wrapper.kind == CustomElementWrapperKind.EDT_CHECKS) {
                return hasEdtNature && this.model.isExportEdtChecks();
            }
            if (wrapper.kind == CustomElementWrapperKind.EDT_PACKAGES) {
                return hasEdtNature && this.model.isExportEdtPackages();
            }
            if (wrapper.kind == CustomElementWrapperKind.EDT_PACKAGE) {
                return hasEdtNature && this.model.getEdtSelectedPackageNames().contains(wrapper.label);
            }
            if (wrapper.kind == CustomElementWrapperKind.EDT_TESTS) {
                return hasEdtNature && this.model.isExportEdtTests();
            }
            return true;
        }
    }

    public static class ContentProvider
    implements ITreeContentProvider {
        private SpecadorModel model;

        public ContentProvider(SpecadorModel model) {
            this.model = model;
        }

        public Object[] getElements(Object inputElement) {
            return SpecadorWizardPackagePage.getRootWrappers(this.model);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == fTreeRoot) {
                return SpecadorWizardPackagePage.getRootWrappers(this.model);
            }
            if (!(parentElement instanceof CustomElementWrapper)) {
                return null;
            }
            CustomElementWrapper cew = (CustomElementWrapper)parentElement;
            if (cew.kind == CustomElementWrapperKind.VLOG_ROOT) {
                return new ArrayList<CustomElementWrapper>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(fVlogModulesWrapper);
                        this.add(fVlogInterfacesWrapper);
                        this.add(fVlogProgramsWrapper);
                        this.add(fVlogMacrosWrapper);
                        this.add(fVlogDefinesControlWrapper);
                        this.add(fVlogIfndefGuardWrapper);
                        this.add(fVlogGlobalScopeWrapper);
                        if (!contentProvider.model.getAllVlogPackageNames().isEmpty()) {
                            this.add(fVlogPackagesWrapper);
                        }
                        this.add(fVlogAllAssertionsWrapper);
                        this.add(fVlogAllCovergroupsWrapper);
                    }
                }.toArray(new CustomElementWrapper[0]);
            }
            if (cew.kind == CustomElementWrapperKind.VHDL_ROOT) {
                return new ArrayList<CustomElementWrapper>(){
                    private static final long serialVersionUID = 1L;
                    {
                        if (!contentProvider.model.getAllVhdlLibraryNames().isEmpty()) {
                            this.add(fVhdlLibrariesWrapper);
                        }
                    }
                }.toArray(new CustomElementWrapper[0]);
            }
            if (cew.kind == CustomElementWrapperKind.EDT_ROOT) {
                return new ArrayList<CustomElementWrapper>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(fEdtTestsWrapper);
                        this.add(fEdtMacrosWrapper);
                        if (!contentProvider.model.getAllEdtPackageNames().isEmpty()) {
                            this.add(fEdtPackagesWrapper);
                        }
                        this.add(fEdtCovergroupsWrapper);
                        this.add(fEdtChecksWrapper);
                    }
                }.toArray(new CustomElementWrapper[0]);
            }
            if (cew.kind == CustomElementWrapperKind.VLOG_PACKAGES) {
                List<String> pkgs = this.model.getAllVlogPackageNames();
                ArrayList<CustomElementWrapper> pkgElems = new ArrayList<CustomElementWrapper>();
                for (String string : pkgs) {
                    pkgElems.add(new CustomElementWrapper(CustomElementWrapperKind.VLOG_PACKAGE, string));
                }
                return pkgElems.toArray(new CustomElementWrapper[0]);
            }
            if (cew.kind == CustomElementWrapperKind.VHDL_LIBRARIES) {
                List<String> pkgs = this.model.getAllVhdlLibraryNames();
                ArrayList<CustomElementWrapper> pkgElems = new ArrayList<CustomElementWrapper>();
                for (String string : pkgs) {
                    pkgElems.add(new CustomElementWrapper(CustomElementWrapperKind.VHDL_LIBRARY, string));
                }
                return pkgElems.toArray(new CustomElementWrapper[0]);
            }
            if (cew.kind == CustomElementWrapperKind.EDT_PACKAGES) {
                List<String> pkgs = this.model.getAllEdtPackageNames();
                ArrayList<CustomElementWrapper> pkgElems = new ArrayList<CustomElementWrapper>();
                for (String string : pkgs) {
                    pkgElems.add(new CustomElementWrapper(CustomElementWrapperKind.EDT_PACKAGE, string));
                }
                return pkgElems.toArray(new CustomElementWrapper[0]);
            }
            return null;
        }

        public Object getParent(Object element) {
            if (!(element instanceof CustomElementWrapper)) {
                return null;
            }
            CustomElementWrapper cew = (CustomElementWrapper)element;
            if (cew.kind == CustomElementWrapperKind.VLOG_ROOT || cew.kind == CustomElementWrapperKind.VHDL_ROOT || cew.kind == CustomElementWrapperKind.EDT_ROOT) {
                return fTreeRoot;
            }
            if (cew.kind == CustomElementWrapperKind.VLOG_PACKAGE) {
                return fVlogPackagesWrapper;
            }
            if (cew.kind == CustomElementWrapperKind.VHDL_LIBRARY) {
                return fVhdlLibrariesWrapper;
            }
            if (cew.kind == CustomElementWrapperKind.EDT_PACKAGE) {
                return fEdtPackagesWrapper;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element == fTreeRoot) {
                return true;
            }
            if (!(element instanceof CustomElementWrapper)) {
                return false;
            }
            CustomElementWrapper cew = (CustomElementWrapper)element;
            if (cew.kind == CustomElementWrapperKind.EDT_ROOT || cew.kind == CustomElementWrapperKind.VHDL_ROOT || cew.kind == CustomElementWrapperKind.VLOG_ROOT) {
                return true;
            }
            return cew.kind == CustomElementWrapperKind.VLOG_PACKAGES && !this.model.getAllVlogPackageNames().isEmpty() || cew.kind == CustomElementWrapperKind.VHDL_LIBRARIES && !this.model.getAllVhdlLibraryNames().isEmpty() || cew.kind == CustomElementWrapperKind.EDT_PACKAGES && !this.model.getAllEdtPackageNames().isEmpty();
        }
    }

    public static class ContentProviderSphinx
    implements ITreeContentProvider {
        private SpecadorModel model;

        public ContentProviderSphinx(SpecadorModel model) {
            this.model = model;
        }

        public Object[] getElements(Object inputElement) {
            return SpecadorWizardPackagePage.getRootWrappers(this.model);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == fTreeRoot) {
                return SpecadorWizardPackagePage.getRootWrappers(this.model);
            }
            if (!(parentElement instanceof CustomElementWrapper)) {
                return null;
            }
            CustomElementWrapper cew = (CustomElementWrapper)parentElement;
            if (cew.kind == CustomElementWrapperKind.VLOG_ROOT) {
                return new ArrayList<CustomElementWrapper>(){
                    private static final long serialVersionUID = 1L;
                    {
                        if (!contentProviderSphinx.model.getAllVlogLibraries().isEmpty()) {
                            this.add(fVlogLibrariesWrapper);
                        }
                        this.add(fVlogMacrosWrapper);
                        this.add(fVlogDefinesControlWrapper);
                        this.add(fVlogIfndefGuardWrapper);
                        this.add(fVlogAllAssertionsWrapper);
                        this.add(fVlogAllCovergroupsWrapper);
                    }
                }.toArray(new CustomElementWrapper[0]);
            }
            if (cew.kind == CustomElementWrapperKind.VHDL_ROOT) {
                return new ArrayList<CustomElementWrapper>(){
                    private static final long serialVersionUID = 1L;
                    {
                        if (!contentProviderSphinx.model.getAllVhdlLibraryNames().isEmpty()) {
                            this.add(fVhdlLibrariesWrapper);
                        }
                    }
                }.toArray(new CustomElementWrapper[0]);
            }
            if (cew.kind == CustomElementWrapperKind.EDT_ROOT) {
                return new ArrayList<CustomElementWrapper>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(fEdtTestsWrapper);
                        this.add(fEdtMacrosWrapper);
                        if (!contentProviderSphinx.model.getAllEdtPackageNames().isEmpty()) {
                            this.add(fEdtPackagesWrapper);
                        }
                        this.add(fEdtCovergroupsWrapper);
                        this.add(fEdtChecksWrapper);
                    }
                }.toArray(new CustomElementWrapper[0]);
            }
            if (cew.kind == CustomElementWrapperKind.VLOG_LIBRARIES) {
                List<ILibraryWrapper> libs = this.model.getAllVlogLibraries();
                ArrayList<CustomElementWrapper> libraries = new ArrayList<CustomElementWrapper>();
                for (ILibraryWrapper lib : libs) {
                    libraries.add(new CustomElementWrapper(CustomElementWrapperKind.VLOG_LIBRARY, lib));
                }
                return libraries.toArray(new CustomElementWrapper[0]);
            }
            if (cew.kind == CustomElementWrapperKind.VLOG_LIBRARY) {
                List<String> packages;
                ArrayList<CustomElementWrapper> apiElems = new ArrayList<CustomElementWrapper>();
                if (cew.library.hasModules(this.model.hasVlogNature())) {
                    apiElems.add(new CustomElementWrapper(CustomElementWrapperKind.VLOG_MODULES, "Modules", cew.library.getName()));
                }
                if (cew.library.hasInterfaces(this.model.hasVlogNature())) {
                    apiElems.add(new CustomElementWrapper(CustomElementWrapperKind.VLOG_INTERFACES, "Interfaces", cew.library.getName()));
                }
                if (!(packages = cew.library.getPackageNames(this.model.hasVlogNature())).isEmpty()) {
                    apiElems.add(new CustomElementWrapper(CustomElementWrapperKind.VLOG_PACKAGES, "Packages", cew.library.getName(), packages));
                }
                return apiElems.toArray(new CustomElementWrapper[0]);
            }
            if (cew.kind == CustomElementWrapperKind.VLOG_PACKAGES) {
                List<String> pkgs = cew.packageNames.isEmpty() ? this.model.getAllVlogPackageNames() : cew.packageNames;
                ArrayList<CustomElementWrapper> pkgElems = new ArrayList<CustomElementWrapper>();
                for (String string : pkgs) {
                    pkgElems.add(new CustomElementWrapper(CustomElementWrapperKind.VLOG_PACKAGE, string, cew.enclosingLibrary));
                }
                return pkgElems.toArray(new CustomElementWrapper[0]);
            }
            if (cew.kind == CustomElementWrapperKind.VHDL_LIBRARIES) {
                List<ILibraryWrapper> libs = this.model.getAllVhdlLibraries();
                ArrayList<CustomElementWrapper> libraries = new ArrayList<CustomElementWrapper>();
                for (ILibraryWrapper lib : libs) {
                    libraries.add(new CustomElementWrapper(CustomElementWrapperKind.VHDL_LIBRARY, lib));
                }
                return libraries.toArray(new CustomElementWrapper[0]);
            }
            if (cew.kind == CustomElementWrapperKind.VHDL_LIBRARY) {
                List<String> packages;
                ArrayList<CustomElementWrapper> apiElems = new ArrayList<CustomElementWrapper>();
                if (cew.library.hasEntities(this.model.hasVhdlNature())) {
                    apiElems.add(new CustomElementWrapper(CustomElementWrapperKind.VHDL_ENTITIES, "Entities", cew.library.getName()));
                }
                if (!(packages = cew.library.getPackageNames(this.model.hasVhdlNature())).isEmpty()) {
                    apiElems.add(new CustomElementWrapper(CustomElementWrapperKind.VHDL_PACKAGES, "Packages", cew.library.getName(), packages));
                }
                return apiElems.toArray(new CustomElementWrapper[0]);
            }
            if (cew.kind == CustomElementWrapperKind.VHDL_PACKAGES) {
                List<String> pkgs = cew.packageNames;
                ArrayList<CustomElementWrapper> pkgElems = new ArrayList<CustomElementWrapper>();
                for (String string : pkgs) {
                    pkgElems.add(new CustomElementWrapper(CustomElementWrapperKind.VHDL_PACKAGE, string, cew.enclosingLibrary));
                }
                return pkgElems.toArray(new CustomElementWrapper[0]);
            }
            if (cew.kind == CustomElementWrapperKind.EDT_PACKAGES) {
                List<String> pkgs = this.model.getAllEdtPackageNames();
                ArrayList<CustomElementWrapper> pkgElems = new ArrayList<CustomElementWrapper>();
                for (String string : pkgs) {
                    pkgElems.add(new CustomElementWrapper(CustomElementWrapperKind.EDT_PACKAGE, string));
                }
                return pkgElems.toArray(new CustomElementWrapper[0]);
            }
            return null;
        }

        public Object getParent(Object element) {
            if (!(element instanceof CustomElementWrapper)) {
                return null;
            }
            CustomElementWrapper cew = (CustomElementWrapper)element;
            if (cew.kind == CustomElementWrapperKind.VLOG_ROOT || cew.kind == CustomElementWrapperKind.VHDL_ROOT || cew.kind == CustomElementWrapperKind.EDT_ROOT) {
                return fTreeRoot;
            }
            if (cew.kind == CustomElementWrapperKind.VLOG_PACKAGE) {
                return fVlogPackagesWrapper;
            }
            if (cew.kind == CustomElementWrapperKind.VLOG_LIBRARY) {
                return fVlogLibrariesWrapper;
            }
            if (cew.kind == CustomElementWrapperKind.VHDL_LIBRARY) {
                return fVhdlLibrariesWrapper;
            }
            if (cew.kind == CustomElementWrapperKind.EDT_PACKAGE) {
                return fEdtPackagesWrapper;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element == fTreeRoot) {
                return true;
            }
            if (!(element instanceof CustomElementWrapper)) {
                return false;
            }
            CustomElementWrapper cew = (CustomElementWrapper)element;
            if (cew.kind == CustomElementWrapperKind.EDT_ROOT || cew.kind == CustomElementWrapperKind.VHDL_ROOT || cew.kind == CustomElementWrapperKind.VLOG_ROOT) {
                return true;
            }
            return cew.kind == CustomElementWrapperKind.VLOG_PACKAGES && !this.model.getAllVlogPackageNames().isEmpty() || cew.kind == CustomElementWrapperKind.VLOG_LIBRARIES && !this.model.getAllVlogLibraries().isEmpty() || cew.kind == CustomElementWrapperKind.VLOG_LIBRARY || cew.kind == CustomElementWrapperKind.VHDL_LIBRARIES && !this.model.getAllVhdlLibraryNames().isEmpty() || cew.kind == CustomElementWrapperKind.VHDL_LIBRARY || cew.kind == CustomElementWrapperKind.VHDL_PACKAGES || cew.kind == CustomElementWrapperKind.EDT_PACKAGES && !this.model.getAllEdtPackageNames().isEmpty();
        }
    }

    public static class CustomElementWrapper {
        public CustomElementWrapperKind kind;
        public String label;
        public String enclosingLibrary;
        public ILibraryWrapper library;
        public List<String> packageNames = Collections.emptyList();

        public CustomElementWrapper(CustomElementWrapperKind kind, String label) {
            this.label = label;
            this.kind = kind;
        }

        public CustomElementWrapper(CustomElementWrapperKind kind, String label, String enclosingLibrary) {
            this.label = label;
            this.kind = kind;
            this.enclosingLibrary = enclosingLibrary;
        }

        public CustomElementWrapper(CustomElementWrapperKind kind, String label, String enclosingLibrary, List<String> packageNames) {
            this(kind, label, enclosingLibrary);
            this.packageNames = packageNames;
        }

        public CustomElementWrapper(CustomElementWrapperKind kind, ILibraryWrapper library) {
            this.library = library;
            this.kind = kind;
            this.label = library.getName();
        }
    }

    public static enum CustomElementWrapperKind {
        VLOG_MODULES,
        VLOG_INTERFACES,
        VLOG_PROGRAMS,
        VLOG_MACROS,
        VLOG_CONTROL_DEFINES,
        VLOG_IFNDEF_GUARDS,
        VLOG_LIBRARIES,
        VLOG_LIBRARY,
        VLOG_PACKAGES,
        VLOG_PACKAGE,
        VLOG_GLOBAL_SCOPE,
        VLOG_ALL_ASSERTIONS,
        VLOG_ALL_COVERGROUPS,
        VHDL_LIBRARIES,
        VHDL_LIBRARY,
        VHDL_ENTITIES,
        VHDL_PACKAGES,
        VHDL_PACKAGE,
        EDT_MACROS,
        EDT_COVERGROUPS,
        EDT_CHECKS,
        EDT_PACKAGES,
        EDT_PACKAGE,
        EDT_TESTS,
        VLOG_ROOT,
        VHDL_ROOT,
        EDT_ROOT;

    }

    public static class LabelProvider
    extends ColumnLabelProvider {
        Map<CustomElementWrapperKind, Image> fVlogIcons = new EnumMap<CustomElementWrapperKind, Image>(CustomElementWrapperKind.class){
            private static final long serialVersionUID = 1L;
            {
                super($anonymous0);
                this.put(CustomElementWrapperKind.VLOG_PACKAGES, DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE));
                this.put(CustomElementWrapperKind.VLOG_PACKAGE, DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE));
                this.put(CustomElementWrapperKind.VLOG_GLOBAL_SCOPE, DVTImages.imageCache.getImage(DVTImages.PACKAGE_GRAY));
                this.put(CustomElementWrapperKind.VLOG_MACROS, DVTImages.imageCache.getImage(DVTImages.MACROS));
                this.put(CustomElementWrapperKind.VLOG_CONTROL_DEFINES, DVTImages.imageCache.getImage(DVTImages.PREPROC_IFDEF));
                this.put(CustomElementWrapperKind.VLOG_IFNDEF_GUARDS, DVTImages.imageCache.getImage(DVTImages.MACROS));
                this.put(CustomElementWrapperKind.VLOG_MODULES, DVTImages.imageCache.getImage(DVTImages.OUTLINE_MODULE));
                this.put(CustomElementWrapperKind.VLOG_PROGRAMS, DVTImages.imageCache.getImage(DVTImages.OUTLINE_PROGRAM));
                this.put(CustomElementWrapperKind.VLOG_INTERFACES, DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE));
                this.put(CustomElementWrapperKind.VLOG_ALL_ASSERTIONS, DVTImages.imageCache.getImage(DVTImages.OUTLINE_ASSERT_IMMEDIATE));
                this.put(CustomElementWrapperKind.VLOG_ALL_COVERGROUPS, DVTImages.imageCache.getImage(DVTImages.OUTLINE_COVERGROUP));
                this.put(CustomElementWrapperKind.VLOG_LIBRARIES, DVTImages.imageCache.getImage(DVTImages.OUTLINE_LIBRARY));
                this.put(CustomElementWrapperKind.VLOG_LIBRARY, DVTImages.imageCache.getImage(DVTImages.OUTLINE_LIBRARY));
            }
        };
        Map<CustomElementWrapperKind, Image> fVhdlIcons = new EnumMap<CustomElementWrapperKind, Image>(CustomElementWrapperKind.class){
            private static final long serialVersionUID = 1L;
            {
                super($anonymous0);
                this.put(CustomElementWrapperKind.VHDL_LIBRARIES, DVTImages.imageCache.getImage(DVTImages.OUTLINE_LIBRARY));
                this.put(CustomElementWrapperKind.VHDL_LIBRARY, DVTImages.imageCache.getImage(DVTImages.OUTLINE_LIBRARY));
                this.put(CustomElementWrapperKind.VHDL_ENTITIES, DVTImages.imageCache.getImage(DVTImages.OUTLINE_ENTITY));
                this.put(CustomElementWrapperKind.VHDL_PACKAGES, DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE));
                this.put(CustomElementWrapperKind.VHDL_PACKAGE, DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE));
            }
        };
        Map<CustomElementWrapperKind, Image> fEdtIcons = new EnumMap<CustomElementWrapperKind, Image>(CustomElementWrapperKind.class){
            private static final long serialVersionUID = 1L;
            {
                super($anonymous0);
                this.put(CustomElementWrapperKind.EDT_TESTS, DVTImages.imageCache.getImage(DVTImages.DESC_E_MODULE));
                this.put(CustomElementWrapperKind.EDT_PACKAGES, DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE));
                this.put(CustomElementWrapperKind.EDT_PACKAGE, DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE));
                this.put(CustomElementWrapperKind.EDT_MACROS, DVTImages.imageCache.getImage(DVTImages.MACROS));
                this.put(CustomElementWrapperKind.EDT_COVERGROUPS, DVTImages.imageCache.getImage(DVTImages.OUTLINE_COVERGROUP));
                this.put(CustomElementWrapperKind.EDT_CHECKS, DVTImages.imageCache.getImage(DVTImages.CHECK));
            }
        };

        public Image getImage(Object element) {
            if (!(element instanceof CustomElementWrapper)) {
                return null;
            }
            CustomElementWrapper cew = (CustomElementWrapper)element;
            if (cew.kind == CustomElementWrapperKind.EDT_ROOT) {
                return DVTImages.imageCache.getImage(DVTImages.E_PERSPECTIVE);
            }
            if (cew.kind == CustomElementWrapperKind.VLOG_ROOT) {
                return DVTImages.imageCache.getImage(DVTImages.VLOG_PERSPECTIVE);
            }
            if (cew.kind == CustomElementWrapperKind.VHDL_ROOT) {
                return DVTImages.imageCache.getImage(DVTImages.VHDL_PERSPECTIVE);
            }
            if (this.fVlogIcons.containsKey((Object)cew.kind)) {
                return this.fVlogIcons.get((Object)cew.kind);
            }
            if (this.fVhdlIcons.containsKey((Object)cew.kind)) {
                return this.fVhdlIcons.get((Object)cew.kind);
            }
            if (this.fEdtIcons.containsKey((Object)cew.kind)) {
                return this.fEdtIcons.get((Object)cew.kind);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof CustomElementWrapper) {
                return ((CustomElementWrapper)element).label;
            }
            return null;
        }
    }
}

