/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.XMLErrorHandler;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorXMLParser6;
import ro.amiq.dvt.wizards.specador.SpecadorXMLParser7;

public abstract class SpecadorXMLParser {
    public static final Map<String, String> naturesFullName2ShortName = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("ro.amiq.vlogdt.VlogNature", "vlog");
            this.put("ro.amiq.vhdldt.VhdlNature", "vhdl");
            this.put("ro.amiq.edt.enature", "e");
        }
    };
    public static final Map<String, String> naturesShortName2FullName = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("vlog", "ro.amiq.vlogdt.VlogNature");
            this.put("vhdl", "ro.amiq.vhdldt.VhdlNature");
            this.put("e", "ro.amiq.edt.enature");
        }
    };
    private static final String LATEST_VERSION = "7";
    private static final String DEPRECATED_VERSION = "6";
    private final File fFile;
    protected static String TAG_SPECHTML = "spechtml";
    protected static final String ATTR_VERSION = "version";

    protected SpecadorXMLParser(File file) {
        this.fFile = file;
    }

    public void saveDoc() throws Exception {
    }

    public abstract void save(SpecadorModel var1, SpecadorModel var2) throws Exception;

    public abstract void load(SpecadorModel var1, boolean var2) throws Exception;

    public File getFile() {
        return this.fFile;
    }

    public static SpecadorXMLParser newParser(File file, boolean useTheLatestVersion) throws Exception {
        return SpecadorXMLParser.newParser(file, useTheLatestVersion ? LATEST_VERSION : SpecadorXMLParser.detectVersion(file));
    }

    private static SpecadorXMLParser newParser(File file, String version) {
        if (version == null) {
            throw new IllegalArgumentException("Unknown file version.");
        }
        if (DEPRECATED_VERSION.equals(version)) {
            return new SpecadorXMLParser6(file);
        }
        if (LATEST_VERSION.equals(version)) {
            return new SpecadorXMLParser7(file);
        }
        return new SpecadorXMLParser6(file);
    }

    private static String detectVersion(File file) throws Exception {
        if (file == null || !file.exists()) {
            return LATEST_VERSION;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(XMLErrorHandler.INSTANCE);
        Document document = builder.parse(file);
        NodeList waiversNodes = document.getElementsByTagName(TAG_SPECHTML);
        if (waiversNodes.getLength() < 1) {
            return null;
        }
        Element waiversNode = (Element)waiversNodes.item(0);
        return waiversNode.getAttribute(ATTR_VERSION);
    }

    public static boolean isSpecadorPreferenceFile(File file) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(XMLErrorHandler.INSTANCE);
            Document document = builder.parse(file);
            NodeList waiversNodes = document.getElementsByTagName(TAG_SPECHTML);
            return waiversNodes.getLength() >= 1;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }
}

