/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.settings.DVTSConstants;
import ro.amiq.dvt.specador.api.annotations.PreferenceKind;
import ro.amiq.dvt.specador.api.annotations.PreferenceTag;
import ro.amiq.dvt.specador.api.annotations.PreferenceTagAnnotation;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.XMLErrorHandler;
import ro.amiq.dvt.wizards.specador.FilterStrategy;
import ro.amiq.dvt.wizards.specador.SpecadorManager;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorXMLParser;

public class SpecadorXMLParser6
extends SpecadorXMLParser {
    public static final String VERSION_ID = "6";
    private static final String DOXYGEN_TAG_FILE_ATTR = "doxygen-tag-file";
    private static final String FILTER_COMMENT_STRATEGY = "strategy";
    private static final Pattern COMMENT_FILTERS_SEPARATOR = Pattern.compile("\\s*,\\s*");
    private Document fDocument;
    private Element fRootElement;

    public SpecadorXMLParser6(File file) {
        super(file);
    }

    private void startSave() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.fDocument = builder.newDocument();
        this.fRootElement = this.fDocument.createElement(TAG_SPECHTML);
        this.fDocument.appendChild(this.fRootElement);
        this.fRootElement.setAttribute("version", VERSION_ID);
    }

    private void endSave() throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "-//DVT//specador-preferences");
        transformer.setOutputProperty("doctype-system", "specador-preferences.dtd");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter output = new BufferedWriter(new FileWriter(this.getFile()));){
            StreamResult result = new StreamResult(output);
            DOMSource source = new DOMSource(this.fDocument);
            transformer.transform(source, result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.fDocument = null;
        this.fRootElement = null;
    }

    @Override
    public void saveDoc() throws Exception {
        Field[] fields;
        this.startSave();
        Field[] fieldArray = fields = SpecadorModel.class.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceTag tag;
            PreferenceTagAnnotation annot;
            Field field = fieldArray[n2];
            PreferenceTagAnnotation[] annots = (PreferenceTagAnnotation[])field.getAnnotationsByType(PreferenceTagAnnotation.class);
            if (!(annots.length == 0 || (annot = annots[0]) == null || (tag = annot.tag()) == null || tag.getPrefKind() == PreferenceKind.GUI || tag.getDescription().isEmpty() || tag.equals((Object)PreferenceTag.VLOG_PACKAGE) || tag.equals((Object)PreferenceTag.VHDL_LIBRARY) || tag.equals((Object)PreferenceTag.EDT_PACKAGE))) {
                StringBuilder preferenceDescription = new StringBuilder();
                if (tag.isDeprecated()) {
                    preferenceDescription.append("DEPRECATED (-v23 only). ");
                }
                preferenceDescription.append(tag.getDescription());
                this.appendCommentNode(this.fDocument, this.fRootElement, preferenceDescription.toString());
                if (!tag.isEmpty()) {
                    List<Class> asIs = Arrays.asList(Boolean.class, Boolean.TYPE, Integer.TYPE, String.class);
                    if (asIs.contains(field.getType())) {
                        this.appendTextNode(this.fDocument, this.fRootElement, tag, tag.getDefaultValue());
                    } else if (field.getType() == Set.class || field.getType() == List.class || field.getType() == Map.class) {
                        this.appendTextNode(this.fDocument, this.fRootElement, tag, "");
                    } else if (field.getType() == SpecadorModel.OutputFormat.class) {
                        this.appendTextNode(this.fDocument, this.fRootElement, tag, SpecadorModel.OutputFormat.HTML.toString());
                    } else {
                        DVTLogger.INSTANCE.logError("Unhandled preference class '" + field.getType().toGenericString() + "' for '" + field.getName() + "'");
                    }
                }
            }
            ++n2;
        }
        this.endSave();
    }

    @Override
    public void save(SpecadorModel model, SpecadorModel baseModel) throws Exception {
        this.startSave();
        Field[] modelFields = SpecadorModel.class.getFields();
        int i = 0;
        while (i < modelFields.length) {
            PreferenceTagAnnotation annot;
            PreferenceTag tag;
            PreferenceTagAnnotation[] annots = (PreferenceTagAnnotation[])modelFields[i].getAnnotationsByType(PreferenceTagAnnotation.class);
            if (!(annots.length == 0 || (tag = (annot = annots[0]).tag()).isEmpty() || tag.getPrefKind() == PreferenceKind.BATCH || tag.getDescription().isEmpty() || DVTSConstants.MANAGE_SETTINGS && !tag.isReadOnly() && modelFields[i].get(model).equals(modelFields[i].get(baseModel)))) {
                if (modelFields[i].getType() == Boolean.class || modelFields[i].getType() == Boolean.TYPE) {
                    this.appendCommentNode(this.fDocument, this.fRootElement, tag.getDescription());
                    this.appendBooleanNode(this.fDocument, this.fRootElement, tag, modelFields[i].getBoolean(model));
                } else if (modelFields[i].getType() == String.class || modelFields[i].getType() == Integer.TYPE) {
                    this.appendCommentNode(this.fDocument, this.fRootElement, tag.getDescription());
                    value = modelFields[i].get(model).toString();
                    if (((String)value).isEmpty()) {
                        value = tag.getDefaultValue();
                    }
                    this.appendTextNode(this.fDocument, this.fRootElement, tag, (String)value);
                } else if (modelFields[i].getType() == Set.class || modelFields[i].getType() == List.class || modelFields[i].getType() == Map.class) {
                    if (tag == PreferenceTag.FILTER_COMMENTS) {
                        if (!model.getCommentFilters().isEmpty()) {
                            this.appendCommentNode(this.fDocument, this.fRootElement, tag.getDescription());
                            String tagName = tag.getTagName();
                            Element elem = this.fDocument.createElement(tagName);
                            elem.setTextContent(model.getCommentFiltersString());
                            this.fRootElement.appendChild(elem);
                            elem.setAttribute(FILTER_COMMENT_STRATEGY, model.getFilterStrategy().toString());
                        }
                    } else {
                        Set collection = null;
                        collection = modelFields[i].getType() == Map.class ? ((Map)modelFields[i].get(model)).keySet() : (Set)modelFields[i].get(model);
                        if (collection != null && !collection.isEmpty()) {
                            this.appendCommentNode(this.fDocument, this.fRootElement, tag.getDescription());
                            for (Object element : collection) {
                                if (!(element instanceof String)) {
                                    DVTLogger.INSTANCE.logError("Unhandled list preference element class '" + element.getClass().toGenericString() + "' for '" + modelFields[i].getName() + "'");
                                    continue;
                                }
                                String value = element.toString();
                                if (tag.equals((Object)PreferenceTag.PROJECT_NATURE)) {
                                    value = (String)naturesFullName2ShortName.get(value);
                                }
                                Element newNode = this.appendTextNode(this.fDocument, this.fRootElement, tag, value);
                                if (tag != PreferenceTag.EXTERNAL_DOC_PATH || !model.fExternalDocPaths.containsKey(value) || !model.getDoxygenTagFiles().containsKey(model.fExternalDocPaths.get(value))) continue;
                                newNode.setAttribute(DOXYGEN_TAG_FILE_ATTR, model.getDoxygenTagFiles().get(model.fExternalDocPaths.get(value)));
                            }
                        }
                    }
                } else if (modelFields[i].getType() == SpecadorModel.OutputFormat.class) {
                    if (tag.equals((Object)PreferenceTag.OUTPUT_FORMAT)) {
                        value = model.getOutputFormat();
                        this.appendCommentNode(this.fDocument, this.fRootElement, tag.getDescription());
                        this.appendTextNode(this.fDocument, this.fRootElement, tag, ((SpecadorModel.OutputFormat)((Object)value)).toString());
                    }
                } else {
                    DVTLogger.INSTANCE.logError("Unhandled preference class '" + modelFields[i].getType().toGenericString() + "' for '" + modelFields[i].getName() + "'");
                }
            }
            ++i;
        }
        this.endSave();
    }

    private void appendBooleanNode(Document document, Element root, PreferenceTag tag, boolean b) {
        this.appendTextNode(document, root, tag, b ? "true" : "false");
    }

    private void appendCommentNode(Document document, Element root, String textContent) {
        if (textContent == null || textContent.trim().isEmpty()) {
            return;
        }
        Comment elem = document.createComment(" " + textContent + " ");
        root.appendChild(elem);
    }

    private Element appendTextNode(Document document, Element root, PreferenceTag tag, String textContent) {
        String tagName = tag.getTagName();
        Element elem = document.createElement(tagName);
        elem.setTextContent(textContent);
        root.appendChild(elem);
        return elem;
    }

    @Override
    public void load(SpecadorModel model, boolean projectLevelFile) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(XMLErrorHandler.INSTANCE);
        Document document = builder.parse(this.getFile());
        PreferenceTag[] preferenceTagArray = PreferenceTag.values();
        int n = preferenceTagArray.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceTag preferenceTag = preferenceTagArray[n2];
            preferenceTag.setReadOnly(false);
            this.setPref(model, preferenceTag, document, projectLevelFile);
            ++n2;
        }
    }

    private void setPref(SpecadorModel model, PreferenceTag prefTag, Document document, boolean projectLevelFile) {
        try {
            Field[] fields = model.getClass().getFields();
            Field targetField = null;
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                PreferenceTagAnnotation annot;
                Field field = fieldArray[n2];
                PreferenceTagAnnotation[] annots = (PreferenceTagAnnotation[])field.getAnnotationsByType(PreferenceTagAnnotation.class);
                if (annots != null && annots.length != 0 && (annot = annots[0]).tag().equals((Object)prefTag)) {
                    targetField = field;
                    break;
                }
                ++n2;
            }
            if (targetField == null) {
                return;
            }
            if (this.isSpecialPref(prefTag)) {
                this.setSpecialPref(model, prefTag, document, projectLevelFile);
                return;
            }
            Class<?> type = targetField.getType();
            if (type == String.class) {
                String tagTextContent = this.getTagTextContent(document, prefTag);
                if (tagTextContent == null) {
                    return;
                }
                if (projectLevelFile) {
                    prefTag.setReadOnly(true);
                }
                targetField.set(model, tagTextContent);
                return;
            }
            if (type == Boolean.TYPE) {
                Boolean tagBooleanContent = this.getTagBooleanContent(document, prefTag);
                if (tagBooleanContent == null) {
                    return;
                }
                if (projectLevelFile) {
                    prefTag.setReadOnly(true);
                }
                targetField.set(model, tagBooleanContent);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected boolean isSpecialPref(PreferenceTag prefTag) {
        return PreferenceTag.FILTER_PATH.equals((Object)prefTag) || PreferenceTag.ATTACH_PATH.equals((Object)prefTag) || PreferenceTag.EXTERNAL_DOC_PATH.equals((Object)prefTag) || PreferenceTag.PROJECT_NATURE.equals((Object)prefTag) || PreferenceTag.MAX_NOF_ELABORATED_INSTANCES.equals((Object)prefTag) || PreferenceTag.VLOG_FILTER_INDEX.equals((Object)prefTag) || PreferenceTag.VLOG_PACKAGE.equals((Object)prefTag) || PreferenceTag.VHDL_LIBRARY.equals((Object)prefTag) || PreferenceTag.EDT_PACKAGE.equals((Object)prefTag) || PreferenceTag.FILTER_COMMENTS.equals((Object)prefTag) || PreferenceTag.OUTPUT_FORMAT.equals((Object)prefTag) || PreferenceTag.EXPORT_VLOG_MODULES.equals((Object)prefTag) || PreferenceTag.EXPORT_VLOG_INTERFACES.equals((Object)prefTag) || PreferenceTag.EXPORT_VLOG_PACKAGES.equals((Object)prefTag) || PreferenceTag.UVM_COMPONENTS_DIAGRAM_DEPTH.equals((Object)prefTag);
    }

    private void setSpecialPref(SpecadorModel model, PreferenceTag prefTag, Document document, boolean projectLevelFile) {
        if (PreferenceTag.OUTPUT_FORMAT.equals((Object)prefTag)) {
            String tagTextContent = this.getTagTextContent(document, prefTag);
            if (tagTextContent == null) {
                return;
            }
            model.setOutputFormat(SpecadorModel.OutputFormat.valueOf(tagTextContent.toUpperCase()));
            return;
        }
        if (PreferenceTag.MAX_NOF_ELABORATED_INSTANCES.equals((Object)prefTag)) {
            String tagTextContent = this.getTagTextContent(document, prefTag);
            if (tagTextContent == null) {
                return;
            }
            int maxNoElaboratedInstances = 0;
            try {
                maxNoElaboratedInstances = Integer.parseInt(PreferenceTag.MAX_NOF_ELABORATED_INSTANCES.getDefaultValue());
                maxNoElaboratedInstances = Integer.parseInt(this.getTagTextContent(document, PreferenceTag.MAX_NOF_ELABORATED_INSTANCES));
            }
            catch (NumberFormatException numberFormatException) {}
            if (projectLevelFile) {
                prefTag.setReadOnly(true);
            }
            model.setNoElaboratedInstances(maxNoElaboratedInstances);
            return;
        }
        if (PreferenceTag.UVM_COMPONENTS_DIAGRAM_DEPTH.equals((Object)prefTag)) {
            String tagTextContent = this.getTagTextContent(document, prefTag);
            if (tagTextContent == null) {
                return;
            }
            int uvmComponentDiagramDepth = 0;
            try {
                uvmComponentDiagramDepth = Integer.parseInt(PreferenceTag.UVM_COMPONENTS_DIAGRAM_DEPTH.getDefaultValue());
                uvmComponentDiagramDepth = Integer.parseInt(this.getTagTextContent(document, PreferenceTag.UVM_COMPONENTS_DIAGRAM_DEPTH));
            }
            catch (NumberFormatException numberFormatException) {}
            if (projectLevelFile) {
                prefTag.setReadOnly(true);
            }
            model.setUvmComponentDiagramDepth(uvmComponentDiagramDepth);
            return;
        }
        List<String> tagTextContents = this.getTagTextContents(document, prefTag);
        if (tagTextContents.isEmpty()) {
            return;
        }
        if (projectLevelFile) {
            prefTag.setReadOnly(true);
        }
        if (PreferenceTag.FILTER_PATH.equals((Object)prefTag) || PreferenceTag.EXTERNAL_DOC_PATH.equals((Object)prefTag) || PreferenceTag.ATTACH_PATH.equals((Object)prefTag)) {
            model.clearPaths(prefTag);
            for (String filterPath : tagTextContents) {
                if (filterPath.trim().isEmpty()) continue;
                model.addPath(filterPath, prefTag);
            }
            if (PreferenceTag.EXTERNAL_DOC_PATH.equals((Object)prefTag)) {
                model.addDoxygenTagFiles(this.getDoxygenTagFiles(document, prefTag));
            }
            return;
        }
        if (PreferenceTag.FILTER_COMMENTS.equals((Object)prefTag)) {
            model.clearCommentFitlers();
            List<String> filters = Arrays.asList(DVTStringUtil.split(COMMENT_FILTERS_SEPARATOR, tagTextContents.get(0)));
            for (String filter : filters) {
                model.addCommentFilter(filter);
            }
            String strategy = FilterStrategy.ALL.getName();
            NodeList nodes = document.getElementsByTagName(prefTag.getTagName());
            int j = 0;
            while (j < nodes.getLength()) {
                NamedNodeMap attributes = nodes.item(j).getAttributes();
                Node node = attributes.getNamedItem(FILTER_COMMENT_STRATEGY);
                if (node != null) {
                    strategy = node.getTextContent();
                }
                ++j;
            }
            model.setFilterStrategy(SpecadorModel.CommentFilterStrategy.valueOf(strategy.toUpperCase()));
            return;
        }
        if (PreferenceTag.PROJECT_NATURE.equals((Object)prefTag)) {
            HashSet<String> selNatures = new HashSet<String>();
            for (String nature : tagTextContents) {
                String natureId = (String)naturesShortName2FullName.get(nature);
                if (!model.getProjectNatures().contains(natureId)) continue;
                selNatures.add(natureId);
            }
            if (selNatures.isEmpty()) {
                selNatures.addAll(SpecadorManager.getProjectNatures(model.getProject()));
            }
            model.setSelectedProjectNatures(selNatures);
            return;
        }
        Boolean tagBooleanContent = this.getTagBooleanContent(document, prefTag);
        if (PreferenceTag.EXPORT_VLOG_MODULES.equals((Object)prefTag)) {
            if (model.getProjectNatures().contains("ro.amiq.vlogdt.VlogNature")) {
                model.setExportVlogModules(tagBooleanContent);
                if (!tagBooleanContent.booleanValue()) {
                    model.fVlogLibrariesWithModules.clear();
                }
            }
            return;
        }
        if (PreferenceTag.EXPORT_VLOG_INTERFACES.equals((Object)prefTag)) {
            if (model.getProjectNatures().contains("ro.amiq.vlogdt.VlogNature")) {
                model.setExportVlogInterfaces(tagBooleanContent);
                if (!tagBooleanContent.booleanValue()) {
                    model.fVlogLibrariesWithInterfaces.clear();
                }
            }
            return;
        }
        if (PreferenceTag.EXPORT_VLOG_PACKAGES.equals((Object)prefTag)) {
            if (model.getProjectNatures().contains("ro.amiq.vlogdt.VlogNature")) {
                model.setExportVlogPackages(tagBooleanContent);
                if (!tagBooleanContent.booleanValue()) {
                    model.fVlogLibrariesWithPackages.clear();
                }
            }
            return;
        }
        if (PreferenceTag.VLOG_PACKAGE.equals((Object)prefTag)) {
            if (model.isExportVlogPackages() && model.getProjectNatures().contains("ro.amiq.vlogdt.VlogNature")) {
                if (tagTextContents.stream().allMatch(content -> content.trim().isEmpty())) {
                    return;
                }
                model.setVlogSelectedPackageNames(new ArrayList<String>(tagTextContents));
                model.removeVlogUnselectedPackages(tagTextContents);
            }
            return;
        }
        if (PreferenceTag.VHDL_LIBRARY.equals((Object)prefTag)) {
            if (model.isExportVhdlLibraries() && model.getProjectNatures().contains("ro.amiq.vhdldt.VhdlNature")) {
                if (tagTextContents.stream().allMatch(content -> content.trim().isEmpty())) {
                    return;
                }
                model.setVhdlSelectedLibraryNames(new HashSet<String>(tagTextContents));
                model.removeVhdlUnselectedLibraries(tagTextContents);
            }
            return;
        }
        if (PreferenceTag.EDT_PACKAGE.equals((Object)prefTag)) {
            if (model.isExportEdtPackages() && model.getProjectNatures().contains("ro.amiq.edt.enature")) {
                if (tagTextContents.stream().allMatch(content -> content.trim().isEmpty())) {
                    return;
                }
                model.setEdtSelectedPackageNames(new ArrayList<String>(tagTextContents));
            }
            return;
        }
        if (PreferenceTag.VLOG_FILTER_INDEX.equals((Object)prefTag)) {
            model.setVlogFilterIndex(tagTextContents);
        }
    }

    private String getTagTextContent(Document document, PreferenceTag tag) {
        NodeList nodes = document.getElementsByTagName(tag.getTagName());
        if (nodes.getLength() > 0) {
            return nodes.item(0).getTextContent();
        }
        return null;
    }

    private List<String> getTagTextContents(Document document, PreferenceTag tag) {
        ArrayList<String> result = new ArrayList<String>();
        String tagName = tag.getTagName();
        NodeList nodes = document.getElementsByTagName(tagName);
        int j = 0;
        while (j < nodes.getLength()) {
            result.add(nodes.item(j).getTextContent());
            ++j;
        }
        return result;
    }

    private Map<String, String> getDoxygenTagFiles(Document document, PreferenceTag tag) {
        HashMap<String, String> result = new HashMap<String, String>();
        String tagName = tag.getTagName();
        NodeList nodes = document.getElementsByTagName(tagName);
        int j = 0;
        while (j < nodes.getLength()) {
            Node tagFileNode;
            String externalPath = nodes.item(j).getTextContent();
            NamedNodeMap attributes = nodes.item(j).getAttributes();
            if (attributes != null && (tagFileNode = attributes.getNamedItem(DOXYGEN_TAG_FILE_ATTR)) != null) {
                result.put(externalPath, tagFileNode.getTextContent());
            }
            ++j;
        }
        return result;
    }

    private Boolean getTagBooleanContent(Document document, PreferenceTag tag) {
        String content = this.getTagTextContent(document, tag);
        if (content == null) {
            return null;
        }
        return Boolean.parseBoolean(content.trim());
    }
}

