/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.specador;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.specador.api.annotations.PreferenceKind;
import ro.amiq.dvt.specador.api.annotations.PreferenceTag;
import ro.amiq.dvt.specador.api.annotations.PreferenceTagAnnotation;
import ro.amiq.dvt.specador.templates.ILibraryWrapper;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.XMLErrorHandler;
import ro.amiq.dvt.wizards.specador.FilterStrategy;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorXMLParser;

public class SpecadorXMLParser7
extends SpecadorXMLParser {
    public static final String VERSION_ID = "7";
    private static final String FILTER_COMMENT_STRATEGY = "strategy";
    private static final String LIBRARY_NAME = "name";
    private static final Pattern COMMENT_FILTERS_SEPARATOR = Pattern.compile("\\s*,\\s*");
    private Document fDocument;
    private Element fRootElement;

    public SpecadorXMLParser7(File file) {
        super(file);
    }

    private void startSave() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.fDocument = builder.newDocument();
        this.fRootElement = this.fDocument.createElement(TAG_SPECHTML);
        this.fDocument.appendChild(this.fRootElement);
        this.fRootElement.setAttribute("version", VERSION_ID);
    }

    private void endSave() throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "-//DVT//specador-preferences");
        transformer.setOutputProperty("doctype-system", "specador-preferences.dtd");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter output = new BufferedWriter(new FileWriter(this.getFile()));){
            StreamResult result = new StreamResult(output);
            DOMSource source = new DOMSource(this.fDocument);
            transformer.transform(source, result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.fDocument = null;
        this.fRootElement = null;
    }

    @Override
    public void saveDoc() throws Exception {
        Field[] fields;
        this.startSave();
        Field[] fieldArray = fields = SpecadorModel.class.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceTag tag;
            PreferenceTagAnnotation annot;
            Field field = fieldArray[n2];
            PreferenceTagAnnotation[] annots = (PreferenceTagAnnotation[])field.getAnnotationsByType(PreferenceTagAnnotation.class);
            if (!(annots.length == 0 || (annot = annots[0]) == null || (tag = annot.tag()) == null || tag.getPrefKind() == PreferenceKind.GUI || tag.getDescription().isEmpty() || tag.isDeprecated() || this.isAPIPref(tag))) {
                this.appendCommentNode(this.fDocument, this.fRootElement, tag.getDescription());
                if (!tag.isEmpty()) {
                    List<Class> asIs = Arrays.asList(Boolean.class, Boolean.TYPE, Integer.TYPE, String.class);
                    if (asIs.contains(field.getType())) {
                        this.appendTextNode(this.fDocument, this.fRootElement, tag, tag.getDefaultValue());
                    } else if (field.getType() == Set.class || field.getType() == List.class || field.getType() == Map.class) {
                        this.appendTextNode(this.fDocument, this.fRootElement, tag, "");
                    } else if (field.getType() == SpecadorModel.OutputFormat.class) {
                        this.appendTextNode(this.fDocument, this.fRootElement, tag, SpecadorModel.OutputFormat.HTML.toString());
                    } else {
                        DVTLogger.INSTANCE.logError("Unhandled preference class '" + field.getType().toGenericString() + "' for '" + field.getName() + "'");
                    }
                }
            }
            ++n2;
        }
        this.endSave();
    }

    private boolean isAPIPref(PreferenceTag prefTag) {
        return PreferenceTag.VLOG_LIBRARY.equals((Object)prefTag) || PreferenceTag.EXPORT_VLOG_MODULES.equals((Object)prefTag) || PreferenceTag.EXPORT_VLOG_INTERFACES.equals((Object)prefTag) || PreferenceTag.EXPORT_VLOG_PACKAGES.equals((Object)prefTag) || PreferenceTag.VLOG_PACKAGE.equals((Object)prefTag) || PreferenceTag.VHDL_LIBRARY.equals((Object)prefTag) || PreferenceTag.EXPORT_VHDL_ENTITIES.equals((Object)prefTag) || PreferenceTag.EXPORT_VHDL_PACKAGES.equals((Object)prefTag) || PreferenceTag.VHDL_PACKAGE.equals((Object)prefTag) || PreferenceTag.EDT_PACKAGE.equals((Object)prefTag);
    }

    @Override
    public void save(SpecadorModel model, SpecadorModel baseModel) throws Exception {
        this.startSave();
        Field[] modelFields = SpecadorModel.class.getFields();
        int i = 0;
        while (i < modelFields.length) {
            PreferenceTagAnnotation annot;
            PreferenceTag tag;
            PreferenceTagAnnotation[] annots = (PreferenceTagAnnotation[])modelFields[i].getAnnotationsByType(PreferenceTagAnnotation.class);
            if (annots.length != 0 && !(tag = (annot = annots[0]).tag()).isEmpty() && tag.getPrefKind() != PreferenceKind.BATCH && !tag.getDescription().isEmpty()) {
                if (PreferenceTag.EXPORT_VLOG_LIBRARIES.equals((Object)tag)) {
                    this.appendVlogLibraries(this.fDocument, this.fRootElement, model);
                } else if (PreferenceTag.EXPORT_VHDL_LIBRARIES.equals((Object)tag)) {
                    this.appendVhdlLibraries(this.fDocument, this.fRootElement, model);
                } else if (PreferenceTag.EXPORT_EDT_PACKAGES.equals((Object)tag)) {
                    this.appendPackages(this.fDocument, this.fRootElement, new TreeSet<String>(model.getEdtSelectedPackageNames()), PreferenceTag.EXPORT_EDT_PACKAGES, PreferenceTag.EDT_PACKAGE, model.getAllEdtPackageNames());
                } else if (tag.isReadOnly() || !modelFields[i].get(model).equals(modelFields[i].get(baseModel))) {
                    if (modelFields[i].getType() == Boolean.class || modelFields[i].getType() == Boolean.TYPE) {
                        if (!this.isAPIPref(tag)) {
                            this.appendCommentNode(this.fDocument, this.fRootElement, tag.getDescription());
                            this.appendBooleanNode(this.fDocument, this.fRootElement, tag, modelFields[i].getBoolean(model));
                        }
                    } else if (modelFields[i].getType() == String.class || modelFields[i].getType() == Integer.TYPE) {
                        this.appendCommentNode(this.fDocument, this.fRootElement, tag.getDescription());
                        value = modelFields[i].get(model).toString();
                        if (((String)value).isEmpty()) {
                            value = tag.getDefaultValue();
                        }
                        this.appendTextNode(this.fDocument, this.fRootElement, tag, (String)value);
                    } else if (modelFields[i].getType() == Set.class || modelFields[i].getType() == List.class || modelFields[i].getType() == Map.class) {
                        if (!this.isAPIPref(tag)) {
                            if (tag == PreferenceTag.FILTER_COMMENTS) {
                                if (!model.getCommentFilters().isEmpty()) {
                                    this.appendCommentNode(this.fDocument, this.fRootElement, tag.getDescription());
                                    String tagName = tag.getTagName();
                                    Element elem = this.fDocument.createElement(tagName);
                                    elem.setTextContent(model.getCommentFiltersString());
                                    this.fRootElement.appendChild(elem);
                                    elem.setAttribute(FILTER_COMMENT_STRATEGY, model.getFilterStrategy().toString());
                                }
                            } else {
                                Set collection = null;
                                collection = modelFields[i].getType() == Map.class ? ((Map)modelFields[i].get(model)).keySet() : (Set)modelFields[i].get(model);
                                if (collection != null && !collection.isEmpty()) {
                                    this.appendCommentNode(this.fDocument, this.fRootElement, tag.getDescription());
                                    for (Object element : collection) {
                                        if (!(element instanceof String)) {
                                            DVTLogger.INSTANCE.logError("Unhandled list preference element class '" + element.getClass().toGenericString() + "' for '" + modelFields[i].getName() + "'");
                                            continue;
                                        }
                                        String value = element.toString();
                                        if (tag.equals((Object)PreferenceTag.PROJECT_NATURE)) {
                                            value = (String)naturesFullName2ShortName.get(value);
                                        }
                                        this.appendTextNode(this.fDocument, this.fRootElement, tag, value);
                                    }
                                }
                            }
                        }
                    } else if (modelFields[i].getType() == SpecadorModel.OutputFormat.class) {
                        if (tag.equals((Object)PreferenceTag.OUTPUT_FORMAT)) {
                            value = model.getOutputFormat();
                            this.appendCommentNode(this.fDocument, this.fRootElement, tag.getDescription());
                            this.appendTextNode(this.fDocument, this.fRootElement, tag, ((SpecadorModel.OutputFormat)((Object)value)).toString());
                        }
                    } else {
                        DVTLogger.INSTANCE.logError("Unhandled preference class '" + modelFields[i].getType().toGenericString() + "' for '" + modelFields[i].getName() + "'");
                    }
                }
            }
            ++i;
        }
        this.endSave();
    }

    private void appendBooleanNode(Document document, Element root, PreferenceTag tag, boolean b) {
        this.appendTextNode(document, root, tag, b ? "true" : "false");
    }

    private void appendCommentNode(Document document, Element root, String textContent) {
        if (textContent == null || textContent.trim().isEmpty()) {
            return;
        }
        Comment elem = document.createComment(" " + textContent + " ");
        root.appendChild(elem);
    }

    private Element appendTextNode(Document document, Element root, PreferenceTag tag, String textContent) {
        String tagName = tag.getTagName();
        Element elem = document.createElement(tagName);
        elem.setTextContent(textContent);
        root.appendChild(elem);
        return elem;
    }

    private boolean isVlogLibraryFull(String libraryName, SpecadorModel model) {
        boolean hasAllPackages;
        ILibraryWrapper vlogLibrary = model.getVlogLibrary(libraryName);
        List<String> packageNames = vlogLibrary.getPackageNames(model.hasVlogNature());
        boolean hasModules = !vlogLibrary.hasModules(true) || model.getVlogLibrariesWithModules().contains(libraryName);
        boolean hasInterfaces = !vlogLibrary.hasInterfaces(true) || model.getVlogLibrariesWithInterfaces().contains(libraryName);
        boolean bl = hasAllPackages = packageNames == null || packageNames.isEmpty() || new TreeSet<String>(packageNames).equals(model.getVlogLibrariesWithPackages().get(libraryName));
        return hasModules && hasInterfaces && hasAllPackages;
    }

    private void appendVlogLibraries(Document document, Element root, SpecadorModel model) {
        Element libraries = document.createElement(PreferenceTag.EXPORT_VLOG_LIBRARIES.getTagName());
        TreeSet<String> vlogSelectedLibraryNames = new TreeSet<String>(model.getVlogSelectedLibraryNames());
        if (vlogSelectedLibraryNames == null || vlogSelectedLibraryNames.isEmpty()) {
            libraries.setTextContent("false");
            root.appendChild(libraries);
            return;
        }
        Set allLibraries = model.getAllVlogLibraries().stream().map(lib -> lib.getName()).collect(Collectors.toCollection(TreeSet::new));
        if (allLibraries.equals(vlogSelectedLibraryNames) && vlogSelectedLibraryNames.stream().allMatch(lib -> this.isVlogLibraryFull((String)lib, model))) {
            libraries.setTextContent("true");
            root.appendChild(libraries);
            return;
        }
        for (String libraryName : vlogSelectedLibraryNames) {
            Element lib2 = document.createElement(PreferenceTag.VLOG_LIBRARY.getTagName());
            lib2.setAttribute(LIBRARY_NAME, libraryName);
            if (this.isVlogLibraryFull(libraryName, model)) {
                lib2.setTextContent("true");
                libraries.appendChild(lib2);
                continue;
            }
            boolean isEmpty = true;
            if (model.getVlogLibrariesWithModules().contains(libraryName)) {
                this.appendBooleanNode(document, lib2, PreferenceTag.EXPORT_VLOG_MODULES, true);
                isEmpty = false;
            }
            if (model.getVlogLibrariesWithInterfaces().contains(libraryName)) {
                this.appendBooleanNode(document, lib2, PreferenceTag.EXPORT_VLOG_INTERFACES, true);
                isEmpty = false;
            }
            if (model.getVlogLibrariesWithPackages().containsKey(libraryName)) {
                ILibraryWrapper vlogLibrary = model.getVlogLibrary(libraryName);
                List<String> packageNames = vlogLibrary.getPackageNames(model.hasVlogNature());
                this.appendPackages(document, lib2, new TreeSet<String>((Collection)model.getVlogLibrariesWithPackages().get(libraryName)), PreferenceTag.EXPORT_VLOG_PACKAGES, PreferenceTag.VLOG_PACKAGE, packageNames);
                isEmpty = false;
            }
            if (isEmpty) {
                lib2.setTextContent("false");
            }
            libraries.appendChild(lib2);
        }
        root.appendChild(libraries);
    }

    private boolean isVhdlLibraryFull(String libraryName, SpecadorModel model) {
        boolean hasAllPackages;
        ILibraryWrapper vhdlLibrary = model.getVhdlLibrary(libraryName);
        List<String> packageNames = vhdlLibrary.getPackageNames(model.hasVhdlNature());
        boolean hasEntities = !vhdlLibrary.hasEntities(true) || model.getVhdlLibrariesWithEntities().contains(libraryName);
        boolean bl = hasAllPackages = packageNames == null || packageNames.isEmpty() || new TreeSet<String>(packageNames).equals(model.getVhdlLibrariesWithPackages().get(libraryName));
        return hasEntities && hasAllPackages;
    }

    private void appendVhdlLibraries(Document document, Element root, SpecadorModel model) {
        Element libraries = document.createElement(PreferenceTag.EXPORT_VHDL_LIBRARIES.getTagName());
        TreeSet<String> vhdlSelectedLibraryNames = new TreeSet<String>(model.getVhdlSelectedLibraryNames());
        if (vhdlSelectedLibraryNames == null || vhdlSelectedLibraryNames.isEmpty()) {
            libraries.setTextContent("false");
            root.appendChild(libraries);
            return;
        }
        Set allLibraries = model.getAllVhdlLibraries().stream().map(lib -> lib.getName()).collect(Collectors.toCollection(TreeSet::new));
        if (allLibraries.equals(vhdlSelectedLibraryNames) && vhdlSelectedLibraryNames.stream().allMatch(lib -> this.isVhdlLibraryFull((String)lib, model))) {
            libraries.setTextContent("true");
            root.appendChild(libraries);
            return;
        }
        for (String libraryName : vhdlSelectedLibraryNames) {
            Element lib2 = document.createElement(PreferenceTag.VHDL_LIBRARY.getTagName());
            lib2.setAttribute(LIBRARY_NAME, libraryName);
            if (this.isVhdlLibraryFull(libraryName, model)) {
                lib2.setTextContent("true");
                libraries.appendChild(lib2);
                continue;
            }
            boolean isEmpty = true;
            if (model.getVhdlLibrariesWithEntities().contains(libraryName)) {
                this.appendBooleanNode(document, lib2, PreferenceTag.EXPORT_VHDL_ENTITIES, true);
                isEmpty = false;
            }
            if (model.getVhdlLibrariesWithPackages().containsKey(libraryName)) {
                ILibraryWrapper vhdlLibrary = model.getVhdlLibrary(libraryName);
                List<String> packageNames = vhdlLibrary.getPackageNames(model.hasVhdlNature());
                this.appendPackages(document, lib2, new TreeSet<String>((Collection)model.getVhdlLibrariesWithPackages().get(libraryName)), PreferenceTag.EXPORT_VHDL_PACKAGES, PreferenceTag.VHDL_PACKAGE, packageNames);
                isEmpty = false;
            }
            if (isEmpty) {
                lib2.setTextContent("false");
            }
            libraries.appendChild(lib2);
        }
        root.appendChild(libraries);
    }

    private void appendPackages(Document document, Element root, Set<String> selectedPackageNames, PreferenceTag exportPackagesTag, PreferenceTag specificPackageTag, List<String> allPackagesNames) {
        Element packages = document.createElement(exportPackagesTag.getTagName());
        if (selectedPackageNames == null || selectedPackageNames.isEmpty()) {
            packages.setTextContent("false");
            root.appendChild(packages);
            return;
        }
        if (allPackagesNames != null && selectedPackageNames.equals(new TreeSet<String>(allPackagesNames))) {
            packages.setTextContent("true");
            root.appendChild(packages);
            return;
        }
        for (String packageName : selectedPackageNames) {
            Element pkg = document.createElement(specificPackageTag.getTagName());
            pkg.setTextContent(packageName);
            packages.appendChild(pkg);
        }
        root.appendChild(packages);
    }

    @Override
    public void load(SpecadorModel model, boolean projectLevelFile) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(XMLErrorHandler.INSTANCE);
        Document document = builder.parse(this.getFile());
        Node specHTMLChild = document.getLastChild();
        this.readPreferences(model, specHTMLChild);
    }

    public boolean containsPreference(String tag, String value) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(XMLErrorHandler.INSTANCE);
        Document document = builder.parse(this.getFile());
        Node parentNode = document.getLastChild();
        Node child = parentNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() != 8 && child.getNodeType() != 3) {
                String tagName = child.getNodeName();
                String textContent = child.getTextContent();
                if (tag.equals(tagName) && textContent.equals(value)) {
                    return true;
                }
            }
            child = child.getNextSibling();
        }
        return false;
    }

    private void readPreferences(SpecadorModel model, Node parentNode) {
        Node child = parentNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() != 8 && child.getNodeType() != 3) {
                String tagName = child.getNodeName();
                String textContent = child.getTextContent();
                Field targetField = this.getFieldForPreferenceTag(model, tagName);
                if (targetField != null) {
                    try {
                        if (this.isSpecialPref(tagName)) {
                            this.setSpecialPref(model, tagName, child);
                        } else {
                            Boolean tagBooleanContent;
                            Class<?> type = targetField.getType();
                            if (type == String.class) {
                                String tagTextContent = textContent;
                                if (tagTextContent != null) {
                                    targetField.set(model, tagTextContent);
                                }
                            } else if (type == Boolean.TYPE && (tagBooleanContent = this.getTagBooleanContent(textContent)) != null) {
                                targetField.set(model, tagBooleanContent);
                            }
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
            child = child.getNextSibling();
        }
    }

    private Field getFieldForPreferenceTag(SpecadorModel model, String tagName) {
        Field[] fields = model.getClass().getFields();
        Field targetField = null;
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceTagAnnotation annot;
            Field field = fieldArray[n2];
            PreferenceTagAnnotation[] annots = (PreferenceTagAnnotation[])field.getAnnotationsByType(PreferenceTagAnnotation.class);
            if (annots != null && annots.length != 0 && (annot = annots[0]).tag().getTagName().equals(tagName)) {
                targetField = field;
                break;
            }
            ++n2;
        }
        return targetField;
    }

    private boolean isSpecialPref(String prefTag) {
        return PreferenceTag.FILTER_PATH.getTagName().equals(prefTag) || PreferenceTag.ATTACH_PATH.getTagName().equals(prefTag) || PreferenceTag.INCLUDE_PATH.getTagName().equals(prefTag) || PreferenceTag.MAX_NOF_ELABORATED_INSTANCES.getTagName().equals(prefTag) || PreferenceTag.EXPORT_VLOG_LIBRARIES.getTagName().equals(prefTag) || PreferenceTag.EXPORT_VHDL_LIBRARIES.getTagName().equals(prefTag) || PreferenceTag.EXPORT_EDT_PACKAGES.getTagName().equals(prefTag) || PreferenceTag.FILTER_COMMENTS.getTagName().equals(prefTag) || PreferenceTag.OUTPUT_FORMAT.getTagName().equals(prefTag) || PreferenceTag.UVM_COMPONENTS_DIAGRAM_DEPTH.getTagName().equals(prefTag);
    }

    private void setSpecialPref(SpecadorModel model, String prefTag, Node node) {
        String tagTextContent = node.getTextContent();
        if (PreferenceTag.OUTPUT_FORMAT.getTagName().equals(prefTag)) {
            if (tagTextContent == null) {
                return;
            }
            model.setOutputFormat(SpecadorModel.OutputFormat.valueOf(tagTextContent.toUpperCase()));
            return;
        }
        if (PreferenceTag.MAX_NOF_ELABORATED_INSTANCES.getTagName().equals(prefTag)) {
            if (tagTextContent == null) {
                return;
            }
            int maxNoElaboratedInstances = 0;
            try {
                maxNoElaboratedInstances = Integer.parseInt(tagTextContent);
            }
            catch (NumberFormatException numberFormatException) {
                maxNoElaboratedInstances = Integer.parseInt(PreferenceTag.MAX_NOF_ELABORATED_INSTANCES.getDefaultValue());
            }
            model.setNoElaboratedInstances(maxNoElaboratedInstances);
            return;
        }
        if (PreferenceTag.UVM_COMPONENTS_DIAGRAM_DEPTH.getTagName().equals(prefTag)) {
            if (tagTextContent == null) {
                return;
            }
            int uvmComponentDiagramDepth = 0;
            try {
                uvmComponentDiagramDepth = Integer.parseInt(tagTextContent);
            }
            catch (NumberFormatException numberFormatException) {
                uvmComponentDiagramDepth = Integer.parseInt(PreferenceTag.UVM_COMPONENTS_DIAGRAM_DEPTH.getDefaultValue());
            }
            model.setUvmComponentDiagramDepth(uvmComponentDiagramDepth);
            return;
        }
        if (PreferenceTag.FILTER_COMMENTS.getTagName().equals(prefTag)) {
            model.clearCommentFitlers();
            List<String> filters = Arrays.asList(DVTStringUtil.split(COMMENT_FILTERS_SEPARATOR, tagTextContent));
            for (String filter : filters) {
                model.addCommentFilter(filter);
            }
            NamedNodeMap attributes = node.getAttributes();
            Node strategyAttribute = attributes.getNamedItem(FILTER_COMMENT_STRATEGY);
            String strategy = strategyAttribute == null ? FilterStrategy.ALL.getName() : strategyAttribute.getTextContent();
            model.setFilterStrategy(SpecadorModel.CommentFilterStrategy.valueOf(strategy.toUpperCase()));
            return;
        }
        if (PreferenceTag.FILTER_PATH.getTagName().equals(prefTag)) {
            model.addPath(tagTextContent, PreferenceTag.FILTER_PATH);
            return;
        }
        if (PreferenceTag.ATTACH_PATH.getTagName().equals(prefTag)) {
            model.addPath(tagTextContent, PreferenceTag.ATTACH_PATH);
            return;
        }
        if (PreferenceTag.INCLUDE_PATH.getTagName().equals(prefTag)) {
            model.addPath(tagTextContent, PreferenceTag.INCLUDE_PATH);
            return;
        }
        if (PreferenceTag.EXPORT_VLOG_LIBRARIES.getTagName().equals(prefTag)) {
            if (!node.hasChildNodes()) {
                return;
            }
            if (model.getProjectNatures().contains("ro.amiq.vlogdt.VlogNature")) {
                this.collectVlogAPIPreferences(node, model);
            }
            return;
        }
        if (PreferenceTag.EXPORT_VHDL_LIBRARIES.getTagName().equals(prefTag)) {
            if (!node.hasChildNodes()) {
                return;
            }
            if (model.getProjectNatures().contains("ro.amiq.vhdldt.VhdlNature")) {
                this.collectVhdlAPIPreferences(node, model);
            }
            return;
        }
        if (PreferenceTag.EXPORT_EDT_PACKAGES.getTagName().equals(prefTag)) {
            if (!node.hasChildNodes()) {
                return;
            }
            if (model.getProjectNatures().contains("ro.amiq.edt.enature")) {
                this.collectPackagesFromLibrary(node, model, "", LanguageKind.E);
            }
            return;
        }
    }

    private void collectVlogAPIPreferences(Node node, SpecadorModel model) {
        int numberOfChildren = node.getChildNodes().getLength();
        model.clearVlogLibraries();
        if (numberOfChildren < 1) {
            model.setExportVlogLibraries(false);
            return;
        }
        if (numberOfChildren < 2 && node.getFirstChild().getNodeType() == 3) {
            Boolean hasVlogLabraries = this.getTagBooleanContent(node.getTextContent());
            model.setExportVlogLibraries(hasVlogLabraries);
            if (hasVlogLabraries.booleanValue()) {
                model.populateDefaultVlogLibraries();
            }
            return;
        }
        Node child = node.getFirstChild();
        while (child != null) {
            this.collectVlogLibraryAPI(child, model);
            child = child.getNextSibling();
        }
    }

    private void collectVlogLibraryAPI(Node node, SpecadorModel model) {
        if (!PreferenceTag.VLOG_LIBRARY.getTagName().equals(node.getNodeName())) {
            return;
        }
        NamedNodeMap attributes = node.getAttributes();
        Node library = attributes.getNamedItem(LIBRARY_NAME);
        if (library == null) {
            return;
        }
        String libraryName = library.getTextContent();
        model.addVlogSelectedLibraryNames(libraryName);
        int numberOfChildren = node.getChildNodes().getLength();
        if (numberOfChildren < 1) {
            return;
        }
        if (numberOfChildren < 2 && node.getFirstChild().getNodeType() == 3) {
            Boolean exportVlogLibrary = this.getTagBooleanContent(node.getTextContent());
            if (exportVlogLibrary.booleanValue()) {
                ILibraryWrapper lib = model.getVlogLibrary(libraryName);
                if (lib.hasModules(model.hasVlogNature())) {
                    model.addVlogLibraryWithModules(libraryName);
                }
                if (lib.hasInterfaces(model.hasVlogNature())) {
                    model.addVlogLibraryWithInterfaces(libraryName);
                }
                if (!lib.getPackageNames(model.hasVlogNature()).isEmpty()) {
                    model.addVlogPackagesFromLibrary(libraryName);
                }
            } else {
                model.removeVlogSelectedLibraryNames(libraryName);
            }
            return;
        }
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() != 3) {
                if (PreferenceTag.EXPORT_VLOG_MODULES.getTagName().equals(child.getNodeName())) {
                    Boolean exportModules = this.getTagBooleanContent(child.getTextContent());
                    if (exportModules.booleanValue()) {
                        model.addVlogLibraryWithModules(libraryName);
                    }
                } else if (PreferenceTag.EXPORT_VLOG_INTERFACES.getTagName().equals(child.getNodeName())) {
                    Boolean exportInterfaces = this.getTagBooleanContent(child.getTextContent());
                    if (exportInterfaces.booleanValue()) {
                        model.addVlogLibraryWithInterfaces(libraryName);
                    }
                } else {
                    this.collectPackagesFromLibrary(child, model, libraryName, LanguageKind.VLOG);
                }
            }
            child = child.getNextSibling();
        }
    }

    private void collectVhdlAPIPreferences(Node node, SpecadorModel model) {
        int numberOfChildren = node.getChildNodes().getLength();
        model.clearVhdlLibraries();
        if (numberOfChildren < 1) {
            model.setExportVhdlLibraries(false);
            return;
        }
        if (numberOfChildren < 2 && node.getFirstChild().getNodeType() == 3) {
            Boolean hasVhdlLabraries = this.getTagBooleanContent(node.getTextContent());
            model.setExportVhdlLibraries(hasVhdlLabraries);
            if (hasVhdlLabraries.booleanValue()) {
                model.populateDefaultVhdlLibraries();
            }
            return;
        }
        Node child = node.getFirstChild();
        while (child != null) {
            this.collectVhdlLibraryAPI(child, model);
            child = child.getNextSibling();
        }
    }

    private void collectVhdlLibraryAPI(Node node, SpecadorModel model) {
        if (!PreferenceTag.VHDL_LIBRARY.getTagName().equals(node.getNodeName())) {
            return;
        }
        NamedNodeMap attributes = node.getAttributes();
        Node library = attributes.getNamedItem(LIBRARY_NAME);
        if (library == null) {
            return;
        }
        String libraryName = library.getTextContent();
        model.addVhdlSelectedLibraryNames(libraryName);
        int numberOfChildren = node.getChildNodes().getLength();
        if (numberOfChildren < 1) {
            return;
        }
        if (numberOfChildren < 2 && node.getFirstChild().getNodeType() == 3) {
            Boolean exportVhdlLibrary = this.getTagBooleanContent(node.getTextContent());
            if (exportVhdlLibrary.booleanValue()) {
                ILibraryWrapper lib = model.getVhdlLibrary(libraryName);
                if (lib.hasEntities(model.hasVhdlNature())) {
                    model.addVhdlLibrariesWithEntities(libraryName);
                }
                if (!lib.getPackageNames(model.hasVhdlNature()).isEmpty()) {
                    model.addVhdlPackagesFromLibrary(libraryName);
                }
            } else {
                model.removeVhdlSelectedLibraryNames(libraryName);
            }
            return;
        }
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() != 3) {
                if (PreferenceTag.EXPORT_VHDL_ENTITIES.getTagName().equals(child.getNodeName())) {
                    Boolean exportEntities = this.getTagBooleanContent(child.getTextContent());
                    if (exportEntities.booleanValue()) {
                        model.addVhdlLibrariesWithEntities(libraryName);
                    }
                } else {
                    this.collectPackagesFromLibrary(child, model, libraryName, LanguageKind.VHDL);
                }
            }
            child = child.getNextSibling();
        }
    }

    private void collectPackagesFromLibrary(Node node, SpecadorModel model, String libraryName, LanguageKind language) {
        if (LanguageKind.VLOG.equals((Object)language) && !PreferenceTag.EXPORT_VLOG_PACKAGES.getTagName().equals(node.getNodeName())) {
            return;
        }
        if (LanguageKind.VHDL.equals((Object)language) && !PreferenceTag.EXPORT_VHDL_PACKAGES.getTagName().equals(node.getNodeName())) {
            return;
        }
        if (LanguageKind.E.equals((Object)language) && !PreferenceTag.EXPORT_EDT_PACKAGES.getTagName().equals(node.getNodeName())) {
            return;
        }
        int numberOfChildren = node.getChildNodes().getLength();
        if (numberOfChildren < 1) {
            return;
        }
        if (numberOfChildren < 2 && node.getFirstChild().getNodeType() == 3) {
            Boolean exportPackages = this.getTagBooleanContent(node.getTextContent());
            if (LanguageKind.E.equals((Object)language)) {
                model.setExportEdtPackages(exportPackages);
                if (!exportPackages.booleanValue()) {
                    model.clearEdtPackages();
                }
            }
            if (!exportPackages.booleanValue()) {
                return;
            }
            if (LanguageKind.E.equals((Object)language)) {
                model.setEdtSelectedPackageNames(model.getAllEdtPackageNames());
            }
            if (LanguageKind.VLOG.equals((Object)language)) {
                model.addVlogPackagesFromLibrary(libraryName);
            }
            if (LanguageKind.VHDL.equals((Object)language)) {
                model.addVhdlPackagesFromLibrary(libraryName);
            }
            return;
        }
        Node child = node.getFirstChild();
        while (child != null) {
            String packageName;
            if (!(LanguageKind.VLOG.equals((Object)language) && !PreferenceTag.VLOG_PACKAGE.getTagName().equals(child.getNodeName()) || LanguageKind.VHDL.equals((Object)language) && !PreferenceTag.VHDL_PACKAGE.getTagName().equals(child.getNodeName()) || LanguageKind.E.equals((Object)language) && !PreferenceTag.EDT_PACKAGE.getTagName().equals(child.getNodeName()) || (packageName = child.getTextContent()) == null || packageName.isEmpty())) {
                if (LanguageKind.VLOG.equals((Object)language)) {
                    model.addVlogPackageFromLibrary(libraryName, packageName);
                }
                if (LanguageKind.VHDL.equals((Object)language)) {
                    model.addVhdlPackageFromLibrary(libraryName, packageName);
                }
                if (LanguageKind.E.equals((Object)language)) {
                    model.addEdtSelectedPackageNames(packageName);
                }
            }
            child = child.getNextSibling();
        }
    }

    private Boolean getTagBooleanContent(String content) {
        if (content == null || content.isEmpty()) {
            return null;
        }
        return Boolean.parseBoolean(content.trim());
    }
}

