/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.templatecomponents;

import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.wizards.templatecomponents.AddFromProjectTemplateModel;
import ro.amiq.dvt.wizards.templatecomponents.AddFromProjectTemplatePathsPage;
import ro.amiq.dvt.wizards.templatecomponents.AddFromProjectTemplateWizard;
import ro.amiq.dvt.wizards.util.AttributeElement;

public class AddFromProjectTemplateAttributesPage
extends WizardPage {
    private final String[] EXCLUDED_FILES = new String[]{"CVS", ".svn"};
    private AddFromProjectTemplateModel fModel;
    private Map<String, AttributeContainer> fAttributesContainers;
    protected TreeModelElement fTemplateElement = null;
    protected TreeModelElement fTargetElement = null;
    private TreeViewer fTargetTree;
    private Button fCheckFileRoot;
    private CheckboxTreeViewer fTemplatesTree;
    protected boolean fConsiderFileRoot = false;
    private Button fOverwrite;
    private boolean fIsOverwrite;
    private ContentProvider fTargetContentProvider;
    private ICheckStateListener fSelectionListener;

    protected AddFromProjectTemplateAttributesPage(AddFromProjectTemplateModel model) {
        super("NewAddFromProjectTemplateAttributesPage");
        this.fModel = model;
        this.fTemplateElement = null;
        this.fTargetElement = null;
        this.setTitle("Select files and template parameters");
        this.setDescription("Select the template files and directories which you want to add to the target, and specify the template parameters");
        this.setImageDescriptor(this.getImageDescriptor());
    }

    protected void updateModel(AddFromProjectTemplateModel model) {
        this.fModel = model;
        this.fTemplateElement = null;
        this.fTargetElement = null;
    }

    protected void setControl(Control newControl) {
        super.setControl(newControl);
    }

    private File transformPath(String path, String target) {
        String retStr = this.fModel.getTemplateEngine().generateTargetPath(path, target);
        return new File(retStr);
    }

    private void moveFormTemplateToTarget(List<TreeModelElement> elements) {
        if (this.fTemplateElement != null && this.fTargetElement != null) {
            for (TreeModelElement elemToBeAdded : elements) {
                File targetAbsolutePath;
                String targetParentPath;
                HashMap<Integer, TreeModelElement> parents = new HashMap<Integer, TreeModelElement>();
                int nrPar = 0;
                Object localParent = elemToBeAdded.getParent();
                while (!(localParent instanceof String)) {
                    TreeModelElement prnt = (TreeModelElement)localParent;
                    if (prnt.isTemplate()) {
                        parents.put(nrPar, prnt);
                    }
                    localParent = prnt.getParent();
                    ++nrPar;
                }
                int nrOfParents = parents.size() - 1;
                if (!this.fConsiderFileRoot) {
                    --nrOfParents;
                }
                boolean isRoot = false;
                if (nrOfParents == -2) {
                    isRoot = true;
                }
                TreeModelElement target = this.fTargetElement;
                while (nrOfParents > -1) {
                    TreeModelElement parent = (TreeModelElement)parents.get(nrOfParents);
                    String targetParentPath2 = !target.getTransformedElementName().isEmpty() ? target.getTransformedElementName() : target.getOriginalElementName();
                    String targetAbsolutePath2 = this.transformPath(parent.getOriginalElementName(), targetParentPath2).getAbsolutePath();
                    if (!target.containsChild(targetAbsolutePath2)) {
                        target.addChild(new TreeModelElement(parent.getOriginalElement(), true, target, true, true));
                    }
                    target = target.getChild(targetAbsolutePath2);
                    --nrOfParents;
                }
                String string = targetParentPath = !target.getTransformedElementName().isEmpty() ? target.getTransformedElementName() : target.getOriginalElementName();
                if (isRoot && !this.fConsiderFileRoot || target.containsChild((targetAbsolutePath = this.transformPath(elemToBeAdded.getOriginalElementName(), targetParentPath)).getAbsolutePath())) continue;
                target.addChild(new TreeModelElement(elemToBeAdded.getOriginalElement(), true, target, true, true));
            }
            this.updatePageState();
            this.fTargetTree.refresh();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AddFromProjectTemplateAttributesPage.this.fTargetTree.expandAll();
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeFromTarget(List<TreeModelElement> elements) {
        if (this.fTemplateElement == null || this.fTargetElement == null) {
            return;
        }
        block0: for (TreeModelElement elemToBeRemoved : elements) {
            target = this.computeTargetForElement(elemToBeRemoved);
            targetPath = target.getTransformedElementName().isEmpty() == false ? target.getTransformedElementName() : target.getOriginalElementName();
            targetElem = this.fTargetElement.getChildRecursively(this.transformPath(elemToBeRemoved.getOriginalElementName(), targetPath).getAbsolutePath());
            templateElem = null;
            templateElem = this.fTemplateElement.getOriginalElementName().equals(elemToBeRemoved.getOriginalElementName()) != false ? this.fTemplateElement : this.fTemplateElement.getChildRecursively(elemToBeRemoved.getOriginalElementName());
            if (targetElem == null) continue;
            if (!(targetElem.getParent() instanceof String)) ** GOTO lbl28
            if (!this.fTemplatesTree.getChecked((Object)templateElem)) continue;
            this.fTargetElement.removeChild(targetElem.getTransformedElementName());
            continue;
lbl-1000:
            // 1 sources

            {
                targetParent = (TreeModelElement)targetElem.getParent();
                ans = true;
                if (templateElem == null) {
                    ans = true;
                } else {
                    templateParent = templateElem.getParent();
                    if (templateParent instanceof TreeModelElement) {
                        templateParent = templateElem.getParent();
                        ans = this.fTemplatesTree.getChecked(templateParent);
                    } else {
                        ans = true;
                    }
                }
                targetParent.removeChild(targetElem.getTransformedElementName());
                if (targetParent.hasChildren() || ans) continue block0;
                targetElem = targetParent;
lbl28:
                // 2 sources

                ** while (targetElem.getParent() instanceof TreeModelElement)
            }
lbl29:
            // 1 sources

        }
        this.updatePageState();
        this.fTargetTree.refresh();
    }

    private TreeModelElement computeTargetForElement(TreeModelElement elemToBeRemoved) {
        HashMap<Integer, TreeModelElement> parents = new HashMap<Integer, TreeModelElement>();
        int nrPar = 0;
        Object localParent = elemToBeRemoved.getParent();
        while (!(localParent instanceof String)) {
            TreeModelElement prnt = (TreeModelElement)localParent;
            if (prnt.isTemplate()) {
                parents.put(nrPar, prnt);
            }
            localParent = prnt.getParent();
            ++nrPar;
        }
        int nrOfParents = parents.size() - 1;
        if (!this.fConsiderFileRoot) {
            --nrOfParents;
        }
        TreeModelElement target = this.fTargetElement;
        while (nrOfParents > -1) {
            TreeModelElement parent = (TreeModelElement)parents.get(nrOfParents);
            String targetPath = !target.getTransformedElementName().isEmpty() ? target.getTransformedElementName() : target.getOriginalElementName();
            String originalElementName = parent.getOriginalElementName();
            if (target.containsChild(this.transformPath(originalElementName, targetPath).getAbsolutePath())) {
                target = target.getChild(this.transformPath(originalElementName, targetPath).getAbsolutePath());
            }
            --nrOfParents;
        }
        return target;
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "ro.amiq.dvt.help.project_template_wizard");
        int heightHint = 400;
        int widthHint = 250;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Group templatesGroup = new Group(composite, 0);
        templatesGroup.setLayout((Layout)new FillLayout());
        GridData gdTemplatesGroup = new GridData(4, 4, true, true, 1, 1);
        gdTemplatesGroup.heightHint = heightHint;
        gdTemplatesGroup.widthHint = widthHint;
        templatesGroup.setLayoutData((Object)gdTemplatesGroup);
        templatesGroup.setText("Template");
        this.fTemplatesTree = new CheckboxTreeViewer((Composite)templatesGroup, 2048);
        ContentProvider provider = new ContentProvider(true);
        this.fTemplatesTree.setContentProvider((IContentProvider)provider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fTemplatesTree, (int)2);
        this.fTemplatesTree.setLabelProvider((IBaseLabelProvider)new TemplatesLabelProvider());
        this.fTemplatesTree.setInput((Object)this.fModel);
        this.fSelectionListener = event -> {
            TreeModelElement clickedElement = (TreeModelElement)event.getElement();
            boolean isChecked = this.fTemplatesTree.getChecked((Object)clickedElement);
            ArrayList<TreeModelElement> toBeAdded = new ArrayList<TreeModelElement>();
            toBeAdded.add(clickedElement);
            if (!clickedElement.getAllChildrenRecursively().isEmpty()) {
                for (TreeModelElement child : clickedElement.getAllChildrenRecursively()) {
                    this.fTemplatesTree.setChecked((Object)child, isChecked);
                    toBeAdded.add(child);
                }
            }
            if (isChecked) {
                this.moveFormTemplateToTarget(toBeAdded);
            } else {
                this.removeFromTarget(toBeAdded);
            }
        };
        this.fTemplatesTree.addCheckStateListener(this.fSelectionListener);
        this.fTemplatesTree.expandAll();
        Group projectGroup = new Group(composite, 0);
        projectGroup.setLayout((Layout)new FillLayout());
        GridData gdProjectGroup = new GridData(4, 4, true, true, 1, 1);
        gdProjectGroup.heightHint = heightHint;
        gdProjectGroup.widthHint = widthHint;
        projectGroup.setLayoutData((Object)gdProjectGroup);
        projectGroup.setText("Target");
        this.fTargetTree = new TreeViewer((Composite)projectGroup, 2048);
        this.fTargetContentProvider = new ContentProvider(false);
        this.fTargetTree.setContentProvider((IContentProvider)this.fTargetContentProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fTargetTree, (int)2);
        this.fTargetTree.setLabelProvider((IBaseLabelProvider)new TemplatesLabelProvider());
        this.fTargetTree.setInput((Object)this.fModel);
        this.fTargetTree.expandAll();
        Group attributesGroup = new Group(composite, 0);
        attributesGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gdAttributesGroup = new GridData(131072, 4, false, false, 1, 1);
        attributesGroup.setLayoutData((Object)gdAttributesGroup);
        attributesGroup.setText("Parameters");
        ScrolledComposite scomposite = new ScrolledComposite((Composite)attributesGroup, 768);
        GridData gdScomposite = new GridData(131072, 4, false, false, 2, 1);
        scomposite.setLayoutData((Object)gdScomposite);
        Composite acomposite = new Composite((Composite)scomposite, 0);
        GridLayout acompositeLayout = new GridLayout(2, false);
        acompositeLayout.marginBottom = 20;
        acomposite.setLayout((Layout)acompositeLayout);
        acomposite.setFont(parent.getFont());
        Map<String, AttributeElement> attributes = this.fModel.getTemplateEngine().parseTemplate();
        Map<Object, Object> templateConfigDefaults = new HashMap();
        File localConfigFile = new File(String.valueOf(this.fModel.getProjectPath()) + File.separator + "template.config");
        File localConfigFileXML = new File(String.valueOf(this.fModel.getProjectPath()) + File.separator + "template-config.xml");
        if (localConfigFile.exists() && localConfigFile.canRead() || localConfigFileXML.exists() && localConfigFileXML.canRead()) {
            this.fModel.getTemplateEngine().parseConfigFileAttributes(this.fModel.getProjectPath());
            reader = this.fModel.getTemplateEngine().parseTemplateConfigXML(this.fModel.getProjectPath());
            if (reader != null) {
                this.fModel.getTemplateEngine().parseConfigsFromXML(reader.getParameterConfig());
            }
            templateConfigDefaults = this.fModel.getTemplateEngine().getDefaultAttributesInTemplateConfig(this.fModel.getTemplatePath());
        } else {
            this.fModel.getTemplateEngine().parseConfigFileAttributes(this.fModel.getTemplatePath());
            reader = this.fModel.getTemplateEngine().parseTemplateConfigXML(this.fModel.getTemplatePath());
            if (reader != null) {
                this.fModel.getTemplateEngine().parseConfigsFromXML(reader.getParameterConfig());
            }
        }
        AddFromProjectTemplateWizard.fTemplateHistory.loadHistory(this.fModel.getProjectPath());
        if (attributes == null) {
            this.setErrorMessage("Go back and set the template path!");
            this.setPageComplete(false);
            this.setControl((Control)acomposite);
        } else {
            this.fAttributesContainers = new LinkedHashMap<String, AttributeContainer>();
            for (Map.Entry<String, AttributeElement> entry : attributes.entrySet()) {
                String name = entry.getKey();
                ArrayList<String> defaultHistoryValues = new ArrayList<String>();
                if (templateConfigDefaults.containsKey(name)) {
                    defaultHistoryValues.add(((AttributeElement)templateConfigDefaults.get(name)).getDefaultValue());
                }
                this.fAttributesContainers.put(name, new AttributeContainer(acomposite, name, entry.getValue(), defaultHistoryValues));
            }
            scomposite.setContent((Control)acomposite);
            scomposite.setExpandHorizontal(true);
            scomposite.setExpandVertical(true);
            scomposite.setMinSize(acomposite.computeSize(-1, -1));
            scomposite.setFont(parent.getFont());
            this.fCheckFileRoot = new Button(composite, 32);
            this.fCheckFileRoot.setLayoutData((Object)new GridData(16384, 0, false, false, 2, 1));
            this.fCheckFileRoot.setText("Include File Root");
            this.fCheckFileRoot.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    List<TreeModelElement> allChildren = AddFromProjectTemplateAttributesPage.this.fTemplateElement.getAllChildrenRecursively();
                    ArrayList<TreeModelElement> selected = new ArrayList<TreeModelElement>();
                    for (TreeModelElement child : allChildren) {
                        if (!AddFromProjectTemplateAttributesPage.this.fTemplatesTree.getChecked((Object)child)) continue;
                        selected.add(child);
                    }
                    if (AddFromProjectTemplateAttributesPage.this.fConsiderFileRoot && AddFromProjectTemplateAttributesPage.this.fTemplatesTree.getChecked((Object)AddFromProjectTemplateAttributesPage.this.fTemplateElement)) {
                        selected.add(AddFromProjectTemplateAttributesPage.this.fTemplateElement);
                    }
                    AddFromProjectTemplateAttributesPage.this.removeFromTarget(selected);
                    AddFromProjectTemplateAttributesPage.this.fConsiderFileRoot = AddFromProjectTemplateAttributesPage.this.fCheckFileRoot.getSelection();
                    AddFromProjectTemplateAttributesPage.this.moveFormTemplateToTarget(selected);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fOverwrite = new Button(composite, 32);
            this.fOverwrite.setLayoutData((Object)new GridData(16384, 0, false, false, 2, 1));
            this.fOverwrite.setText("Overwrite (this will overwrite all the marked files in the target tree)");
            this.fOverwrite.setSelection(false);
            this.fOverwrite.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AddFromProjectTemplateAttributesPage.this.fIsOverwrite = AddFromProjectTemplateAttributesPage.this.fOverwrite.getSelection();
                    AddFromProjectTemplateAttributesPage.this.updatePageState();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button defaults = new Button(composite, 8);
            defaults.setFont(parent.getFont());
            defaults.setText("Restore &Defaults");
            defaults.setLayoutData((Object)new GridData(131072, 0, false, false, 1, 1));
            defaults.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AddFromProjectTemplateAttributesPage.this.setDefaults();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.updatePageState();
            this.setControl((Control)composite);
        }
    }

    private void updatePageState() {
        boolean pageComplete = false;
        boolean isAttributesOk = true;
        for (AttributeContainer container : this.fAttributesContainers.values()) {
            if (container.getReplacement().length() >= 1) continue;
            isAttributesOk = false;
            this.setErrorMessage(String.valueOf(container.fName) + " is empty. Please fill the field or use default value \"" + container.getAttribute().getDefaultValue() + "\".");
            break;
        }
        boolean isDuplicateFilesOk = true;
        List<Object> children = new ArrayList();
        children = this.fTargetElement.getAllChildrenRecursively();
        String duplicateFileName = "";
        for (TreeModelElement treeModelElement : children) {
            if (!treeModelElement.isConflicting()) continue;
            isDuplicateFilesOk = false;
            duplicateFileName = treeModelElement.getTransformedElementName();
            break;
        }
        if (isAttributesOk && (isDuplicateFilesOk || this.fIsOverwrite)) {
            pageComplete = true;
        }
        if (isAttributesOk) {
            this.saveAttributes();
        }
        this.setMessage(isDuplicateFilesOk, duplicateFileName);
        this.setPageComplete(pageComplete);
    }

    private void setMessage(boolean isDuplicateFilesOk, String duplicateFileName) {
        this.resetMessages(true, true);
        if (!isDuplicateFilesOk) {
            if (this.fIsOverwrite) {
                this.setMessage("All the marked files in the target tree will be overwritten.", 2);
            } else {
                this.setErrorMessage("Duplicate file: " + duplicateFileName);
            }
        }
    }

    private void resetMessages(boolean resetErrorMessage, boolean resetWarningMessage) {
        if (resetErrorMessage) {
            this.setErrorMessage(null);
        }
        if (resetWarningMessage) {
            this.setMessage(null);
        }
    }

    public void setDefaults() {
        for (AttributeContainer container : this.fAttributesContainers.values()) {
            container.setDefault();
        }
    }

    private void saveAttributes() {
        for (AttributeContainer container : this.fAttributesContainers.values()) {
            container.saveAttribute();
        }
    }

    public void setVisible(boolean visible) {
        if (visible && AddFromProjectTemplatePathsPage.fSomethingChanged.get()) {
            this.fTemplateElement = null;
            this.fTargetElement = null;
            Composite parent = this.getControl().getParent();
            this.getControl().dispose();
            this.createControl(parent);
            parent.layout();
        } else {
            AddFromProjectTemplatePathsPage.fSomethingChanged.set(false);
        }
    }

    protected ImageDescriptor getImageDescriptor() {
        return DVTImages.NEW_TEMPLATE_DVT_PROJECT_WIZ;
    }

    public boolean isOverwrite() {
        return this.fIsOverwrite;
    }

    public ICheckStateListener testGetSelectionListener() {
        return this.fSelectionListener;
    }

    public Map<String, AttributeContainer> testGetAttributesContainers() {
        return this.fAttributesContainers;
    }

    public CheckboxTreeViewer testGetTemplatesTree() {
        return this.fTemplatesTree;
    }

    public final class AttributeContainer {
        private static final int MAX_CHARS_IN_ROW = 20;
        private Label fNameLabel;
        private Combo fReplacementCombo;
        private String fName;
        private AttributeElement fAttribute;

        private String split(String text) {
            if (text == null) {
                return "";
            }
            StringTokenizer strTok = new StringTokenizer(text);
            StringBuilder result = new StringBuilder();
            StringBuilder line = new StringBuilder();
            while (strTok.hasMoreElements()) {
                line.append(strTok.nextToken()).append(' ');
                if (line.toString().length() <= 20) continue;
                result.append(line.toString()).append('\n');
                line = new StringBuilder();
            }
            result.append(line.toString());
            return result.toString();
        }

        public AttributeContainer(Composite parent, String name, final AttributeElement attribute, List<String> defaultReplacements) {
            this.fName = name;
            this.fAttribute = attribute;
            this.fNameLabel = new Label(parent, 131136);
            this.fNameLabel.setAlignment(131072);
            this.fNameLabel.setFont(parent.getFont());
            this.fNameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            String text = attribute.getDescription();
            text = text == null || text.isEmpty() ? name : text;
            text = this.split(text);
            this.fNameLabel.setText(text);
            this.fReplacementCombo = new Combo(parent, 2048);
            this.fReplacementCombo.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fReplacementCombo.setFont(parent.getFont());
            LinkedHashSet<String> replacements = new LinkedHashSet<String>();
            List<String> historyReplacements = AddFromProjectTemplateWizard.fTemplateHistory.getAllHistory(name);
            if (historyReplacements != null) {
                replacements.addAll(historyReplacements);
            }
            if (attribute.getDefaultValue() != null || !attribute.getDefaultValue().isEmpty()) {
                replacements.add(attribute.getDefaultValue());
            }
            if (defaultReplacements != null) {
                replacements.addAll(defaultReplacements);
            }
            String[] elems = replacements.toArray(new String[replacements.size()]);
            this.fReplacementCombo.setItems(elems);
            this.fReplacementCombo.setText(elems[0]);
            this.fReplacementCombo.setToolTipText(String.valueOf(attribute.getDescription()) + (attribute.isInProjectPath() ? "\nThis attribute value is used to generate the project path, if the path exists the content will be overwritten!" : ""));
            this.fReplacementCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddFromProjectTemplateAttributesPage.this.updatePageState();
                    List<TreeModelElement> children = ((AttributeContainer)AttributeContainer.this).AddFromProjectTemplateAttributesPage.this.fTargetElement.getAllChildrenRecursively();
                    for (TreeModelElement child : children) {
                        if (!child.isTemplate()) continue;
                        ((TreeModelElement)child.getParent()).removeChild(child.getOriginalElementName());
                        String targetPath = ((TreeModelElement)child.getParent()).isTemplate() ? ((TreeModelElement)child.getParent()).getTransformedElementName() : ((TreeModelElement)child.getParent()).getOriginalElementName();
                        child.setTransformedElement(AddFromProjectTemplateAttributesPage.this.transformPath(child.getOriginalElementName(), targetPath));
                    }
                    Object[] chElems = ((AttributeContainer)AttributeContainer.this).AddFromProjectTemplateAttributesPage.this.fTemplatesTree.getCheckedElements();
                    ArrayList<TreeModelElement> elemsToBeAdded = new ArrayList<TreeModelElement>();
                    Object[] objectArray = chElems;
                    int n = chElems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object elem = objectArray[n2];
                        elemsToBeAdded.add((TreeModelElement)elem);
                        ++n2;
                    }
                    if (elemsToBeAdded != null && !elemsToBeAdded.isEmpty()) {
                        AddFromProjectTemplateAttributesPage.this.moveFormTemplateToTarget(elemsToBeAdded);
                    }
                    ((AttributeContainer)AttributeContainer.this).AddFromProjectTemplateAttributesPage.this.fTargetTree.refresh();
                }
            });
            this.fReplacementCombo.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    if (attribute.getDescription() != null && !attribute.getDescription().isEmpty()) {
                        AddFromProjectTemplateAttributesPage.this.setMessage(attribute.getDescription(), 1);
                    }
                }

                public void focusLost(FocusEvent e) {
                    AddFromProjectTemplateAttributesPage.this.setMessage(null);
                }
            });
        }

        public String getReplacement() {
            return this.fReplacementCombo.getText().trim();
        }

        public AttributeElement getAttribute() {
            return this.fAttribute;
        }

        public void setDefault() {
            this.fReplacementCombo.setText(this.fAttribute.getDefaultValue());
        }

        public void saveAttribute() {
            this.fAttribute.setReplacement(this.fReplacementCombo.getText().trim());
        }

        public Combo testGetReplacementCombo() {
            return this.fReplacementCombo;
        }
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private boolean fIsForTemplates = false;

        public ContentProvider(boolean isForTemplates) {
            this.fIsForTemplates = isForTemplates;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof AddFromProjectTemplateModel) {
                TreeModelElement topElement;
                if (AddFromProjectTemplateAttributesPage.this.fTemplateElement == null) {
                    AddFromProjectTemplateAttributesPage.this.fTemplateElement = new TreeModelElement(new File(AddFromProjectTemplateAttributesPage.this.fModel.getTemplatePath()), true, "root", false, false);
                }
                if (this.fIsForTemplates) {
                    topElement = AddFromProjectTemplateAttributesPage.this.fTemplateElement;
                } else {
                    if (AddFromProjectTemplateAttributesPage.this.fTargetElement == null) {
                        AddFromProjectTemplateAttributesPage.this.fTargetElement = new TreeModelElement(new File(AddFromProjectTemplateAttributesPage.this.fModel.getTargetFullPath()), false, "root", false, false);
                    }
                    topElement = AddFromProjectTemplateAttributesPage.this.fTargetElement;
                }
                Object[] ret = new Object[]{topElement};
                return ret;
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TreeModelElement) {
                return ((TreeModelElement)parentElement).getChildren().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof TreeModelElement) {
                return ((TreeModelElement)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TreeModelElement) {
                return ((TreeModelElement)element).hasChildren();
            }
            return false;
        }
    }

    private class TemplatesLabelProvider
    extends ColumnLabelProvider {
        private TemplatesLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            if (!(element instanceof TreeModelElement)) {
                return null;
            }
            TreeModelElement elem = (TreeModelElement)element;
            if (elem.getOriginalElement().isDirectory()) {
                Image folderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                if (Files.isSymbolicLink(elem.getOriginalElement().toPath())) {
                    return DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(folderImage, DVTImages.OVR_SYMLINK, 1));
                }
                return folderImage;
            }
            if (elem.isConflicting()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            Image fileImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            if (Files.isSymbolicLink(elem.getOriginalElement().toPath())) {
                return DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(fileImage, DVTImages.OVR_SYMLINK, 1));
            }
            return fileImage;
        }

        public String getText(Object element) {
            if (!(element instanceof TreeModelElement)) {
                return (String)element;
            }
            TreeModelElement helement = (TreeModelElement)element;
            if (helement.getParent() instanceof String && !helement.isTemplate()) {
                String absPath = helement.getOriginalElement().getAbsolutePath();
                return String.valueOf(AddFromProjectTemplateAttributesPage.this.fModel.getProject().getName()) + absPath.replace(AddFromProjectTemplateAttributesPage.this.fModel.getProject().getLocation().toOSString(), "");
            }
            if (helement.fTransformedElement == null) {
                return helement.getOriginalElement().getName();
            }
            return String.valueOf(helement.getTransformedElement().getName()) + (helement.isConflicting() ? "[X]" : "");
        }

        public String getToolTipText(Object element) {
            if (!(element instanceof TreeModelElement)) {
                return "";
            }
            TreeModelElement tme = (TreeModelElement)element;
            if (tme.isTemplate()) {
                if (tme.isConflicting()) {
                    return String.valueOf(tme.getTransformedElementName()) + "\n\nThere is another file with the same name in this directory!";
                }
                return tme.getTransformedElementName().isEmpty() ? tme.getOriginalElementName() : tme.getTransformedElementName();
            }
            return tme.getOriginalElementName();
        }
    }

    public class TreeModelElement {
        private boolean fIsFromTemplate = false;
        private File fOriginalElement;
        private File fTransformedElement;
        private List<TreeModelElement> fChildren = new ArrayList<TreeModelElement>();
        private Object fParent;

        public TreeModelElement(File elemFile, boolean isTemplate, Object parent, boolean isEmpty, boolean addTransformedElement) {
            if (elemFile != null && !isEmpty && !Files.isSymbolicLink(elemFile.toPath())) {
                File[] files;
                if (isTemplate) {
                    if (elemFile.isDirectory() && (files = elemFile.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return !Arrays.asList(((TreeModelElement)TreeModelElement.this).AddFromProjectTemplateAttributesPage.this.EXCLUDED_FILES).contains(name);
                        }
                    })) != null) {
                        File[] fileArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            this.fChildren.add(new TreeModelElement(file, isTemplate, this, false, addTransformedElement));
                            ++n2;
                        }
                    }
                } else if (elemFile.isDirectory() && (files = elemFile.listFiles()) != null) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n3 = 0;
                    while (n3 < n) {
                        File file = fileArray[n3];
                        if (file.isDirectory() && !Files.isSymbolicLink(file.toPath())) {
                            this.fChildren.add(new TreeModelElement(file, isTemplate, this, false, addTransformedElement));
                        }
                        ++n3;
                    }
                }
            }
            this.fOriginalElement = elemFile;
            this.fIsFromTemplate = isTemplate;
            if (addTransformedElement && this.fOriginalElement != null) {
                String targetPath = ((TreeModelElement)parent).getTransformedElementName().isEmpty() ? ((TreeModelElement)parent).getOriginalElementName() : ((TreeModelElement)parent).getTransformedElementName();
                this.fTransformedElement = new File(AddFromProjectTemplateAttributesPage.this.fModel.getTemplateEngine().generateTargetPath(this.fOriginalElement.getAbsolutePath(), targetPath));
            }
            this.fParent = parent;
        }

        public void setParent(Object parent) {
            if (parent != null) {
                this.fParent = parent;
            }
        }

        public Object getParent() {
            return this.fParent;
        }

        public boolean hasParent() {
            if (this.fParent == null) {
                return false;
            }
            return this.fParent instanceof TreeModelElement;
        }

        public void addChild(TreeModelElement child) {
            if (!this.fChildren.contains(child) && child != null) {
                child.setParent(this);
                this.fChildren.add(child);
            }
        }

        public void addChildren(List<TreeModelElement> children) {
            for (TreeModelElement child : children) {
                if (this.fChildren.contains(child)) continue;
                this.fChildren.add(child);
            }
        }

        public List<TreeModelElement> getChildren() {
            return this.fChildren;
        }

        public List<TreeModelElement> getAllChildrenRecursively() {
            ArrayList<TreeModelElement> ret = new ArrayList<TreeModelElement>();
            if (this.hasChildren()) {
                for (TreeModelElement child : this.fChildren) {
                    ret.add(child);
                    if (!child.hasChildren()) continue;
                    ret.addAll(child.getAllChildrenRecursively());
                }
            }
            return ret;
        }

        public TreeModelElement getChild(String name) {
            if (name == null || name.isEmpty()) {
                return null;
            }
            for (TreeModelElement child : this.fChildren) {
                if (!child.getOriginalElementName().equals(name) && !child.getTransformedElementName().equals(name)) continue;
                return child;
            }
            return null;
        }

        public TreeModelElement getChildRecursively(String name) {
            List<TreeModelElement> allChildren = this.getAllChildrenRecursively();
            for (TreeModelElement child : allChildren) {
                if (!child.getOriginalElementName().equals(name) && !child.getTransformedElementName().equals(name)) continue;
                return child;
            }
            return null;
        }

        public void removeChild(String name) {
            if (name == null || name.isEmpty()) {
                return;
            }
            TreeModelElement toBeRemoved = null;
            for (TreeModelElement child : this.fChildren) {
                if (!child.getOriginalElementName().equals(name) && !child.getTransformedElementName().equals(name)) continue;
                toBeRemoved = child;
                break;
            }
            if (toBeRemoved != null && toBeRemoved.getParent() == this) {
                this.fChildren.remove(toBeRemoved);
            }
        }

        public File getOriginalElement() {
            return this.fOriginalElement;
        }

        public void setOriginalElement(File element) {
            this.fOriginalElement = element;
        }

        public String getOriginalElementName() {
            if (this.fOriginalElement == null) {
                return "";
            }
            return this.fOriginalElement.getAbsolutePath();
        }

        public File getTransformedElement() {
            return this.fTransformedElement;
        }

        public void setTransformedElement(File element) {
            this.fTransformedElement = element;
        }

        public String getTransformedElementName() {
            if (this.fTransformedElement == null) {
                return "";
            }
            return this.fTransformedElement.getAbsolutePath();
        }

        public boolean isConflicting() {
            return this.fTransformedElement == null ? false : this.fTransformedElement.exists();
        }

        public boolean containsChild(TreeModelElement child) {
            return this.fChildren.contains(child);
        }

        public boolean containsChildRecursively(String childName) {
            if (childName.isEmpty()) {
                return false;
            }
            List<TreeModelElement> children = this.getAllChildrenRecursively();
            for (TreeModelElement child : children) {
                if (!child.getOriginalElementName().equals(childName) && !child.getTransformedElementName().equals(childName)) continue;
                return true;
            }
            return false;
        }

        public boolean containsChild(String childName) {
            if (childName == null || childName.isEmpty()) {
                return false;
            }
            for (TreeModelElement child : this.fChildren) {
                if (!child.getOriginalElementName().equals(childName) && !child.getTransformedElementName().equals(childName)) continue;
                return true;
            }
            return false;
        }

        public boolean hasChildren() {
            return !this.fChildren.isEmpty();
        }

        public boolean isTemplate() {
            return this.fIsFromTemplate;
        }
    }
}

