/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.templatecomponents;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.wizards.util.AttributeElement;
import ro.amiq.dvt.wizards.util.FilterElement;
import ro.amiq.dvt.wizards.util.TemplateConfigReaderWriter;

public class AddFromProjectTemplateEngine {
    public static final String CONFIG_FILENAME = "template.config";
    public static final String XML_CONFIG_FILENAME = "template-config.xml";
    public static final String DESCRIPTION_LINE_SEPARATOR = "[,;]";
    public static final String DESCRIPTION_LINE_COMMENT_CHAR = "#";
    public static final String EXCLUDE_ATTRIBUTE_LINE = "__LINE__";
    public static final String EXCLUDE_ATTRIBUTE_FILE = "__FILE__";
    private static final List<String> EXCLUDED_FILES = Arrays.asList(".dvt", "template.config", "template-config.xml", ".project");
    private final FilenameFilter FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !EXCLUDED_FILES.contains(name);
        }
    };
    private final String ATTRIBUTE_NAME_PATTERN = "([a-zA-Z][a-zA-Z0-9_]*?)";
    private final String NEW_LINE_CHAR = System.getProperty("line.separator");
    private final List<Matcher> fMatchers = new ArrayList<Matcher>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(Pattern.compile("(__(([a-zA-Z][a-zA-Z0-9_]*?))__)").matcher(""));
            this.add(Pattern.compile("(x_(([a-zA-Z][a-zA-Z0-9_]*?))_x)").matcher(""));
        }
    };
    private Map<String, AttributeElement> fAttributes = new LinkedHashMap<String, AttributeElement>();
    private List<FilterElement> fFilters = new ArrayList<FilterElement>();
    private String fTemplatePath = "";
    private TemplateConfigReaderWriter fReader;

    public void setPaths(String templatePath) {
        this.fTemplatePath = templatePath;
    }

    public Map<String, AttributeElement> parseTemplate() {
        try {
            this.fAttributes.clear();
            this.fFilters.clear();
            this.fReader = this.parseTemplateConfigXML(this.fTemplatePath);
            if (this.fReader != null) {
                this.fFilters.addAll(this.fReader.getParameterFilter());
            }
            this.collectAttributesFromLine(this.fTemplatePath, this.fTemplatePath, true);
            this.collectFilesAndAttributesFrom(this.fTemplatePath);
            return this.fAttributes;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public String generateTargetPath(String templatePath, String target) {
        try {
            String templateFileName;
            File templateFile = new File(templatePath);
            File templateParentFile = templateFile.getParentFile();
            if (templateParentFile == null) {
                return templatePath;
            }
            String templateCanonicalPath = templateFile.getCanonicalPath();
            String templateParentCanonicalPath = templateParentFile.getCanonicalPath();
            if (templateCanonicalPath == null || templateParentCanonicalPath == null) {
                return templatePath;
            }
            if (Files.isSymbolicLink(templateFile.toPath())) {
                String parentPath = templateParentFile.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
                templateFileName = templateFile.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
                if (templateFileName == null) {
                    return templatePath;
                }
                templateFileName = templateFileName.substring(parentPath.length());
            } else {
                templateFileName = templateCanonicalPath.substring(templateParentCanonicalPath.length());
            }
            StringBuilder replacedFileName = this.replaceWithAttribute(templateFileName, templatePath);
            return replacedFileName.insert(0, target).toString();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return templatePath;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateProjectContents(String templatePath, String target) {
        try {
            File generatedFile;
            File templateFile;
            block20: {
                String targetPath = this.generateTargetPath(templatePath, target);
                templateFile = new File(templatePath);
                generatedFile = new File(targetPath);
                if (Files.isSymbolicLink(templateFile.toPath())) {
                    this.generateSymlink(templateFile, generatedFile);
                    return;
                }
                if (templateFile.isDirectory()) {
                    generatedFile.mkdirs();
                    return;
                }
                if (!templateFile.isFile()) return;
                if (DVTFileUtils.getInstance().isBinary(templateFile)) {
                    DVTFileUtils.getInstance().copyFile(templateFile, generatedFile);
                    return;
                }
                Throwable throwable = null;
                Object var7_9 = null;
                try {
                    BufferedReader inFileBuf = new BufferedReader(new FileReader(templateFile));
                    try {
                        try (BufferedWriter outFileBuf = new BufferedWriter(new FileWriter(generatedFile));){
                            String line = null;
                            while ((line = inFileBuf.readLine()) != null) {
                                outFileBuf.append(this.replaceWithAttribute(line, templatePath).append(this.NEW_LINE_CHAR));
                            }
                        }
                        if (inFileBuf == null) break block20;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inFileBuf == null) throw throwable;
                        inFileBuf.close();
                        throw throwable;
                    }
                    inFileBuf.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            if (templateFile.canExecute()) {
                generatedFile.setExecutable(true);
            }
            if (!templateFile.canWrite()) return;
            generatedFile.setWritable(true);
            return;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void generateSymlink(File templateFile, File generatedFile) throws IOException {
        Path firstLevelSymlink = Files.readSymbolicLink(Paths.get(templateFile.getAbsolutePath(), new String[0]));
        StringBuilder replacedIDSymlink = this.replaceWithAttribute(firstLevelSymlink.toString(), "");
        Path target = Paths.get(replacedIDSymlink.toString(), new String[0]);
        Path symlinkResolvedPath = templateFile.getCanonicalFile().toPath();
        if (!symlinkResolvedPath.startsWith(this.fTemplatePath)) {
            target = firstLevelSymlink;
        }
        Path generatedPath = generatedFile.exists() ? generatedFile.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS) : Paths.get(generatedFile.getAbsolutePath(), new String[0]);
        Files.deleteIfExists(generatedPath);
        Files.createSymbolicLink(generatedPath, target, new FileAttribute[0]);
    }

    public String getProposedProjectName() {
        return this.replaceWithAttribute(new File(this.fTemplatePath).getName(), this.fTemplatePath).toString();
    }

    private boolean fileNameMatchesFilter(FilterElement filter, String path) {
        return new StringMatcher(filter.getPathPattern(), false, false).match(path);
    }

    private boolean isAttributeFiltered(String path, String attributeMatch) {
        int i = this.fFilters.size() - 1;
        while (i >= 0) {
            FilterElement filter = this.fFilters.get(i);
            if (this.fileNameMatchesFilter(filter, path)) {
                StringMatcher pattern = new StringMatcher(filter.getIdentifier(), false, false);
                if (filter.getType().equals("REJECT")) {
                    if (filter.getIdentifier().isEmpty() || pattern.match(attributeMatch.toLowerCase())) {
                        return true;
                    }
                } else if (filter.getType().equals("ALLOW") && (filter.getIdentifier().isEmpty() || pattern.match(attributeMatch.toLowerCase()))) {
                    return false;
                }
            }
            --i;
        }
        return false;
    }

    private void collectAttributesFromLine(String input, String path, boolean isInProjectPath) {
        for (Matcher matcher : this.fMatchers) {
            matcher.reset(input);
            while (matcher.find()) {
                boolean ignoreAttribute;
                String match = matcher.group(1);
                if (match.equalsIgnoreCase(EXCLUDE_ATTRIBUTE_FILE) || match.equalsIgnoreCase(EXCLUDE_ATTRIBUTE_LINE) || (ignoreAttribute = this.isAttributeFiltered(path, match)) || this.fAttributes.containsKey(match = matcher.group(2))) continue;
                this.fAttributes.put(match.toLowerCase(), new AttributeElement(match, isInProjectPath));
            }
        }
    }

    public StringBuilder replaceWithAttribute(String input, String path) {
        for (Matcher matcher : this.fMatchers) {
            matcher.reset(input);
            while (matcher.find()) {
                String replacement;
                AttributeElement attributeElement;
                String shortVarname;
                boolean ignoreVariable;
                String varname = matcher.group(1);
                if (varname.equalsIgnoreCase(EXCLUDE_ATTRIBUTE_FILE) || varname.equalsIgnoreCase(EXCLUDE_ATTRIBUTE_LINE) || (ignoreVariable = this.isAttributeFiltered(path, varname)) || (shortVarname = matcher.group(2)) == null || (attributeElement = this.fAttributes.get(shortVarname.toLowerCase())) == null || (replacement = attributeElement.getReplacement()) == null || replacement.isEmpty()) continue;
                if (shortVarname.compareTo(shortVarname.toUpperCase()) == 0) {
                    replacement = replacement.toUpperCase();
                } else if (shortVarname.substring(0, 1).compareTo(shortVarname.substring(0, 1).toUpperCase()) == 0) {
                    replacement = String.valueOf(replacement.substring(0, 1).toUpperCase()) + replacement.substring(1);
                }
                input = input.replace(varname, replacement);
            }
        }
        return new StringBuilder(input);
    }

    private void collectFilesAndAttributesFrom(String rootPath) throws IOException {
        String[] childrenPaths;
        String[] stringArray = childrenPaths = new File(rootPath).list(this.FILE_FILTER);
        int n = childrenPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(rootPath, path);
            if (file.canRead()) {
                String canonicalPath = file.getCanonicalPath();
                this.collectAttributesFromLine(path, canonicalPath, false);
                if (file.isFile()) {
                    if (!DVTFileUtils.getInstance().isBinary(file)) {
                        Throwable throwable = null;
                        Object var10_11 = null;
                        try (BufferedReader fileBuf = new BufferedReader(new FileReader(file));){
                            String line = null;
                            while ((line = fileBuf.readLine()) != null) {
                                this.collectAttributesFromLine(line, canonicalPath, false);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                } else if (file.isDirectory() && !Files.isSymbolicLink(file.toPath())) {
                    this.collectFilesAndAttributesFrom(canonicalPath);
                }
            }
            ++n2;
        }
    }

    public Map<String, AttributeElement> getAttributes() {
        return this.fAttributes;
    }

    public TemplateConfigReaderWriter parseTemplateConfigXML(String templatePath) {
        try {
            File configFile = new File(templatePath, XML_CONFIG_FILENAME);
            if (configFile.exists() && configFile.isFile() && configFile.canRead()) {
                TemplateConfigReaderWriter reader = new TemplateConfigReaderWriter();
                reader.read(configFile);
                return reader;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public void parseConfigsFromXML(List<AttributeElement> parameterConfig) {
        for (AttributeElement element : parameterConfig) {
            AttributeElement attribute = this.fAttributes.get(element.getName());
            if (attribute == null) continue;
            attribute.updateValues(element.getDefaultValue(), element.getDescription());
        }
    }

    public void parseConfigFileAttributes(String templatePath) {
        block13: {
            try {
                if (this.fAttributes == null || this.fAttributes.isEmpty()) {
                    return;
                }
                File configFile = new File(templatePath, CONFIG_FILENAME);
                if (!configFile.exists() || !configFile.isFile() || !configFile.canRead()) break block13;
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedReader inFileBuf = new BufferedReader(new FileReader(configFile));){
                    String line = null;
                    while ((line = inFileBuf.readLine()) != null) {
                        AttributeElement attribute;
                        String[] lineData;
                        if ((line = line.trim()).startsWith(DESCRIPTION_LINE_COMMENT_CHAR) || (lineData = line.split(DESCRIPTION_LINE_SEPARATOR, 3)).length != 3 || (attribute = this.fAttributes.get(lineData[0])) == null) continue;
                        attribute.updateValues(lineData[1], lineData[2]);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public Map<String, AttributeElement> getDefaultAttributesInTemplateConfig(String templatePath) {
        HashMap<String, AttributeElement> result = new HashMap<String, AttributeElement>();
        try {
            File configFileXML;
            File configFile = new File(templatePath, CONFIG_FILENAME);
            if (configFile.canRead() && configFile.isFile()) {
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedReader inFileBuf = new BufferedReader(new FileReader(configFile));){
                    String line = null;
                    while ((line = inFileBuf.readLine()) != null) {
                        String[] lineData;
                        if ((line = line.trim()).startsWith(DESCRIPTION_LINE_COMMENT_CHAR) || (lineData = line.split(DESCRIPTION_LINE_SEPARATOR, 3)).length != 3) continue;
                        result.put(lineData[0], new AttributeElement(lineData[0], lineData[1], lineData[2], true));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if ((configFileXML = new File(templatePath, XML_CONFIG_FILENAME)).exists() && configFileXML.isFile() && configFileXML.canRead()) {
                TemplateConfigReaderWriter reader = this.parseTemplateConfigXML(templatePath);
                reader.read(configFileXML);
                for (AttributeElement element : reader.getParameterConfig()) {
                    if (!result.containsKey(element.getName())) continue;
                    result.put(element.getName(), element);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }
}

