/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.templatecomponents;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.ContainerSelectionDialog;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.wizards.templatecomponents.AddFromProjectTemplateModel;
import ro.amiq.dvt.wizards.templatecomponents.AddFromProjectTemplateWizard;
import ro.amiq.dvt.wizards.util.PredefinedProjectsUtils;
import ro.amiq.dvt.wizards.util.QuickPredefinedTemplateProjectSelection;

public class AddFromProjectTemplatePathsPage
extends WizardPage {
    protected static AtomicBoolean fSomethingChanged = new AtomicBoolean(false);
    private final AddFromProjectTemplateModel fModel;
    private final String DVT_PREDEFINED_PROJECTS = "DVT_PREDEFINED_PROJECTS";
    private LocationContainer fTemplateLocation;
    private Map<IProjectDescription, String> fProjects = new LinkedHashMap<IProjectDescription, String>();
    private Text fTargetText;

    protected AddFromProjectTemplatePathsPage(AddFromProjectTemplateModel model) {
        super("NewAddFromProjectTemplatePathsPage");
        this.fModel = model;
        this.setTitle("Template and target directories");
        this.setDescription("The template directory will be parametrized and merged into the target directory");
        this.setImageDescriptor(this.getImageDescriptor());
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setFont(parent.getFont());
        this.fTemplateLocation = new LocationContainer(composite, "Template Directory");
        this.fTemplateLocation.setFont(parent.getFont());
        GridData templateLocationGridData = new GridData(768);
        templateLocationGridData.horizontalSpan = 2;
        templateLocationGridData.verticalIndent = 20;
        this.fTemplateLocation.setLayoutData(templateLocationGridData);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "ro.amiq.dvt.help.project_template_wizard");
        this.updatePageState();
    }

    private void updatePageState() {
        boolean pageComplete = true;
        if (this.fTemplateLocation == null || this.fTargetText == null) {
            return;
        }
        String template = this.fTemplateLocation.getDirectory();
        if (template.length() < 1) {
            this.setErrorMessage("Invalid template location!");
            pageComplete = false;
        } else {
            File templatetPath = new File(template);
            if (!templatetPath.exists()) {
                this.setErrorMessage("Invalid template location!");
                pageComplete = false;
            } else if (!templatetPath.canRead()) {
                this.setErrorMessage("You don't have permission to read template directory!");
                pageComplete = false;
            } else if (!templatetPath.isDirectory()) {
                this.setErrorMessage("Template location is not a directory!");
                pageComplete = false;
            }
        }
        String target = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(this.fTargetText.getText());
        if (target.length() < 1) {
            this.setErrorMessage("Invalid target location!");
            pageComplete = false;
        } else {
            File targetPath = new File(this.fModel.relativeToFullPath(target));
            if (!targetPath.exists()) {
                this.setErrorMessage("Invalid target location! Check if target directory exists and it is not a virtual folder.");
                pageComplete = false;
            } else if (!targetPath.canWrite()) {
                this.setErrorMessage("You don't have permission to write in target directory!");
                pageComplete = false;
            } else if (!targetPath.isDirectory()) {
                this.setErrorMessage("Target location is not a directory!");
                pageComplete = false;
            }
        }
        if (pageComplete) {
            this.setErrorMessage(null);
            this.setMessage(null);
            this.savePaths();
        }
        this.setPageComplete(pageComplete);
    }

    private void savePaths() {
        this.fModel.setTemplatePath(this.fTemplateLocation.getDirectory().trim());
        this.fModel.setTargetPath(this.fTargetText.getText().trim());
        this.fModel.getTemplateEngine().setPaths(this.fModel.getTemplatePath());
    }

    protected ImageDescriptor getImageDescriptor() {
        return DVTImages.NEW_TEMPLATE_DVT_PROJECT_WIZ;
    }

    private final class LocationContainer
    extends Composite {
        final Text fDirectoryText;

        public LocationContainer(Composite parent, String info) {
            super(parent, 0);
            this.setLayout((Layout)new FillLayout());
            Composite composite = new Composite((Composite)this, 0);
            composite.setLayout((Layout)new GridLayout(1, false));
            Group group = new Group(composite, 0);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)new GridData(768));
            group.setFont(parent.getFont());
            group.setText(info);
            AddFromProjectTemplateWizard.fTemplateHistory.loadHistory(AddFromProjectTemplatePathsPage.this.fModel.getProjectPath());
            this.fDirectoryText = new Text((Composite)group, 2048);
            this.fDirectoryText.setFont(parent.getFont());
            this.fDirectoryText.setLayoutData((Object)new GridData(768));
            String historicalTemplatePath = AddFromProjectTemplateWizard.fTemplateHistory.popFromHistory("Template_Path");
            if (historicalTemplatePath != null && new File(historicalTemplatePath).exists()) {
                this.fDirectoryText.setText(historicalTemplatePath);
            }
            DVTFileUtils.getInstance().setLastDirectory(this.fDirectoryText.getText());
            this.fDirectoryText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    fSomethingChanged.set(true);
                    AddFromProjectTemplatePathsPage.this.updatePageState();
                }
            });
            Button directoryButton = new Button((Composite)group, 8);
            directoryButton.setFont(parent.getFont());
            directoryButton.setLayoutData((Object)new GridData(32));
            directoryButton.setText("Browse...");
            directoryButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String filterPath = DVTFileUtils.getInstance().getLastDirectory();
                    DirectoryDialog directoryDialog = new DirectoryDialog(LocationContainer.this.getShell());
                    directoryDialog.setFilterPath(filterPath);
                    String selectedDirectory = directoryDialog.open();
                    if (selectedDirectory != null) {
                        LocationContainer.this.fDirectoryText.setText(selectedDirectory);
                        DVTFileUtils.getInstance().setLastDirectory(selectedDirectory);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Link infoLabel = new Link((Composite)group, 64);
            infoLabel.setFont(parent.getFont());
            infoLabel.setText("Specify the template directory you want to add or pick one of the <a>Predefined Project Templates</a>.");
            DVTUiUtils.setPlatformLinkColor((Link)infoLabel);
            GridData infoLabelGridData = new GridData(768);
            infoLabelGridData.horizontalSpan = 3;
            infoLabel.setLayoutData((Object)infoLabelGridData);
            infoLabel.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String systemVarPath = System.getenv("DVT_PREDEFINED_PROJECTS");
                    if (systemVarPath == null || systemVarPath.trim().isEmpty()) {
                        AddFromProjectTemplatePathsPage.this.setErrorMessage("Environment variable DVT_PREDEFINED_PROJECTS is not set!");
                        return;
                    }
                    File projectDir = new File(systemVarPath);
                    if (!projectDir.exists()) {
                        AddFromProjectTemplatePathsPage.this.setErrorMessage("The folder " + systemVarPath + " does not exist!");
                        return;
                    }
                    ((LocationContainer)LocationContainer.this).AddFromProjectTemplatePathsPage.this.fProjects = PredefinedProjectsUtils.getPredefinedProjects(true);
                    QuickPredefinedTemplateProjectSelection sel = new QuickPredefinedTemplateProjectSelection(((LocationContainer)LocationContainer.this).AddFromProjectTemplatePathsPage.this.fProjects);
                    String projectPath = sel.openCustom();
                    if (projectPath == null) {
                        return;
                    }
                    File projectFile = new File(projectPath);
                    if (projectFile.exists()) {
                        LocationContainer.this.fDirectoryText.setText(projectPath);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            Group targetGroup = new Group(composite, 0);
            targetGroup.setLayout((Layout)new GridLayout(2, false));
            targetGroup.setLayoutData((Object)new GridData(768));
            targetGroup.setFont(parent.getFont());
            targetGroup.setText("Target Directory");
            AddFromProjectTemplatePathsPage.this.fTargetText = new Text((Composite)targetGroup, 2048);
            AddFromProjectTemplatePathsPage.this.fTargetText.setFont(parent.getFont());
            AddFromProjectTemplatePathsPage.this.fTargetText.setLayoutData((Object)new GridData(768));
            AddFromProjectTemplatePathsPage.this.fTargetText.setText(AddFromProjectTemplatePathsPage.this.fModel.getTargetPath());
            AddFromProjectTemplatePathsPage.this.fTargetText.setEnabled(false);
            AddFromProjectTemplatePathsPage.this.fTargetText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    fSomethingChanged.set(true);
                    AddFromProjectTemplatePathsPage.this.updatePageState();
                }
            });
            Button targetDirButton = new Button((Composite)targetGroup, 8);
            targetDirButton.setFont(parent.getFont());
            targetDirButton.setLayoutData((Object)new GridData(32));
            targetDirButton.setText("Browse...");
            targetDirButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String parentPath = ((LocationContainer)LocationContainer.this).AddFromProjectTemplatePathsPage.this.fModel.getProject().getLocation().toFile().getParent();
                    if (parentPath == null || parentPath.isEmpty()) {
                        return;
                    }
                    String resourceName = ((LocationContainer)LocationContainer.this).AddFromProjectTemplatePathsPage.this.fModel.getTargetPath().replace(parentPath, "");
                    resourceName = resourceName.substring(1);
                    IProject selectedResource = ((LocationContainer)LocationContainer.this).AddFromProjectTemplatePathsPage.this.fModel.getProject();
                    if (!((LocationContainer)LocationContainer.this).AddFromProjectTemplatePathsPage.this.fModel.getProject().getName().equals(resourceName)) {
                        selectedResource = ResourcesPlugin.getWorkspace().getRoot().getFolder(Path.fromOSString((String)resourceName));
                    }
                    ContainerSelectionDialog dialog = new ContainerSelectionDialog(LocationContainer.this.getShell(), null, (IContainer)selectedResource, true, "Select a target directory:", "Select a target directory:");
                    dialog.setBlockOnOpen(true);
                    dialog.showClosedProjects(false);
                    dialog.setTitle("Target Directory Selection");
                    dialog.open();
                    Object[] result = dialog.getResult();
                    if (result == null || result.length != 1) {
                        return;
                    }
                    Object file = result[0];
                    if (file instanceof IPath) {
                        String relativePath = ((IPath)file).toOSString();
                        String[] parts = relativePath.split(Pattern.quote(File.separator));
                        String projectPath = String.valueOf(File.separator) + parts[1];
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        IProject project = root.getProject(projectPath);
                        ((LocationContainer)LocationContainer.this).AddFromProjectTemplatePathsPage.this.fModel.setIProject(project);
                        ((LocationContainer)LocationContainer.this).AddFromProjectTemplatePathsPage.this.fTargetText.setText(relativePath);
                        ((LocationContainer)LocationContainer.this).AddFromProjectTemplatePathsPage.this.fModel.setTargetPath(relativePath);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Label targetInfoLabel = new Label((Composite)targetGroup, 64);
            targetInfoLabel.setFont(parent.getFont());
            targetInfoLabel.setText("Specify where the processed template directory will be placed.");
            GridData tagetInfoLabelGridData = new GridData(768);
            tagetInfoLabelGridData.horizontalSpan = 3;
            targetInfoLabel.setLayoutData((Object)tagetInfoLabelGridData);
        }

        public String getDirectory() {
            return DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(this.fDirectoryText.getText().trim());
        }
    }
}

