/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.templatecomponents;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.wizards.templatecomponents.AddFromProjectTemplateAttributesPage;
import ro.amiq.dvt.wizards.templatecomponents.AddFromProjectTemplateModel;
import ro.amiq.dvt.wizards.templatecomponents.AddFromProjectTemplatePathsPage;
import ro.amiq.dvt.wizards.templatecomponents.TemplateHistory;
import ro.amiq.dvt.wizards.util.AttributeElement;

public class AddFromProjectTemplateWizard
extends Wizard
implements INewWizard,
IExecutableExtension,
IPageChangedListener {
    public static final String ID = "ro.amiq.dvt.wizards.AddFromProjectTemplateWizard";
    protected static final TemplateHistory fTemplateHistory = new TemplateHistory();
    private final AddFromProjectTemplateModel fModel = new AddFromProjectTemplateModel();
    private AddFromProjectTemplatePathsPage fPathsPage;
    private AddFromProjectTemplateAttributesPage fAttributesPage;
    private IContainer fSelectedContainer;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        ISelection newSelection;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Add From Project Template Wizard");
        if (selection == null && (newSelection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection()) instanceof IStructuredSelection) {
            selection = (IStructuredSelection)newSelection;
        }
        this.fSelectedContainer = this.getSelectedTarget(selection);
        if (this.fSelectedContainer != null) {
            IPath targetIPath = this.fSelectedContainer.getFullPath();
            this.fModel.setTargetPath(targetIPath.toFile().getAbsolutePath());
            this.fModel.setIProject(this.fSelectedContainer.getProject());
        }
        this.fPathsPage = new AddFromProjectTemplatePathsPage(this.fModel);
        this.fAttributesPage = new AddFromProjectTemplateAttributesPage(this.fModel);
    }

    private IContainer getSelectedTarget(IStructuredSelection selection) {
        if (selection == null) {
            return null;
        }
        if (selection.toArray().length == 0 || selection.toArray().length > 1) {
            return null;
        }
        if (selection.getFirstElement() instanceof IContainer) {
            return (IContainer)selection.getFirstElement();
        }
        if (selection.getFirstElement() instanceof IFile) {
            return ((IFile)selection.getFirstElement()).getParent();
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void addPages() {
        this.addPage((IWizardPage)this.fPathsPage);
        this.addPage((IWizardPage)this.fAttributesPage);
    }

    public boolean canFinish() {
        return this.fAttributesPage.isPageComplete() && this.fPathsPage.isPageComplete();
    }

    public boolean performFinish() {
        block7: {
            if (DVTPlugin.getDefault().collect().ccc()) break block7;
            return false;
        }
        try {
            List<AddFromProjectTemplateAttributesPage.TreeModelElement> elements = this.fAttributesPage.fTargetElement.getAllChildrenRecursively();
            for (AddFromProjectTemplateAttributesPage.TreeModelElement element : elements) {
                if (!element.isTemplate() || element.isConflicting() && !this.fAttributesPage.isOverwrite()) continue;
                String targetPath = element.isTemplate() ? element.getTransformedElement().getParent() : element.getTransformedElementName();
                this.fModel.getTemplateEngine().generateProjectContents(element.getOriginalElementName(), targetPath);
            }
            if (this.fSelectedContainer != null) {
                this.fSelectedContainer.refreshLocal(2, null);
            } else {
                this.fModel.getProject().refreshLocal(2, null);
            }
            Map<String, AttributeElement> attrElems = this.fModel.getTemplateEngine().getAttributes();
            for (AttributeElement ae : attrElems.values()) {
                fTemplateHistory.pushToHistory(ae.getName(), ae.getReplacement());
            }
            fTemplateHistory.replace("Template_Path", Arrays.asList(this.fModel.getTemplatePath()));
            fTemplateHistory.saveHistory();
            ObjectionManager.getInstance().clear(Objection.ADD_FROM_TEMPLATE);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    public void pageChanged(PageChangedEvent event) {
    }

    public void createPageControls(Composite pageContainer) {
        IWizardPage[] wizardPages = this.getPages();
        int i = 0;
        while (i < wizardPages.length) {
            if (wizardPages[i] == this.fPathsPage) {
                wizardPages[i].createControl(pageContainer);
                Assert.isNotNull((Object)wizardPages[i].getControl());
            }
            ++i;
        }
    }

    protected ImageDescriptor getImageDescriptor() {
        return DVTImages.NEW_TEMPLATE_DVT_PROJECT_WIZ;
    }

    public AddFromProjectTemplateModel testGetModel() {
        return this.fModel;
    }

    public AddFromProjectTemplateAttributesPage testGetAttributesPage() {
        return this.fAttributesPage;
    }
}

