/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.templatecomponents;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.XMLParser;

public class TemplateHistory {
    private String fProjectPath;
    private final Map<String, List<String>> fHistory = new HashMap<String, List<String>>(){

        @Override
        public List<String> put(String key, List<String> value) {
            return super.put(key.toLowerCase(), value);
        }

        @Override
        public List<String> get(Object key) {
            return (List)super.get(key.toString().toLowerCase());
        }

        @Override
        public boolean containsKey(Object key) {
            return super.containsKey(key.toString().toLowerCase());
        }

        @Override
        public Set<String> keySet() {
            return super.keySet().stream().map(x -> x.toLowerCase()).collect(Collectors.toSet());
        }
    };

    public boolean loadHistory(String projectPath) {
        if (projectPath == null) {
            return false;
        }
        this.fProjectPath = projectPath;
        XMLParser parser = new XMLParser("attributes");
        try {
            File src = new File(String.valueOf(projectPath) + File.separator + ".dvt" + File.separator + "template-history.xml");
            parser.load(src.getAbsolutePath());
            Map items = parser.getAllArrayItems();
            for (Map.Entry entry : items.entrySet()) {
                String[] strItems;
                LinkedList<String> list = new LinkedList<String>();
                String[] stringArray = strItems = (String[])entry.getValue();
                int n = strItems.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    list.addLast(string);
                    ++n2;
                }
                this.fHistory.put((String)entry.getKey(), list);
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public List<String> getAllHistory(String variableName) {
        if (variableName == null || variableName.isEmpty()) {
            return null;
        }
        if (this.fHistory.containsKey(variableName)) {
            return this.fHistory.get(variableName);
        }
        return null;
    }

    public void replace(String key, List<String> value) {
        if (value == null || key == null) {
            return;
        }
        this.fHistory.put(key, value);
    }

    public void pushToHistory(String variableName, String replacementName) {
        if (variableName == null || replacementName == null) {
            return;
        }
        if (variableName.isEmpty() || replacementName.isEmpty()) {
            return;
        }
        if (this.fHistory.containsKey(variableName)) {
            List<String> list = this.fHistory.get(variableName);
            if (!list.contains(replacementName)) {
                list.add(0, replacementName);
            }
        } else {
            LinkedList<String> elems = new LinkedList<String>();
            elems.add(0, replacementName);
            this.fHistory.put(variableName, elems);
        }
    }

    public String popFromHistory(String variableName) {
        if (variableName == null || variableName.isEmpty()) {
            return null;
        }
        if (this.fHistory.containsKey(variableName)) {
            return this.fHistory.get(variableName).get(0);
        }
        return null;
    }

    public void saveHistory() {
        try {
            XMLParser parser = new XMLParser("attributes");
            for (Map.Entry<String, List<String>> entry : this.fHistory.entrySet()) {
                List<String> vars = entry.getValue();
                parser.put(entry.getKey(), vars.toArray(new String[vars.size()]));
            }
            File dest = new File(String.valueOf(this.fProjectPath) + File.separator + ".dvt" + File.separator + "template-history.xml");
            if (!dest.exists()) {
                dest.createNewFile();
            }
            parser.save(dest.getAbsolutePath());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

