/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.templates;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.wizards.templates.FileElement;
import ro.amiq.dvt.wizards.util.AttributeElement;
import ro.amiq.dvt.wizards.util.FilterElement;
import ro.amiq.dvt.wizards.util.TemplateConfigReaderWriter;

public final class TemplateEngine {
    private static final String CONFIG_FILENAME = "template.config";
    private static final String XML_CONFIG_FILENAME = "template-config.xml";
    private static final String EXCLUDE_ATTRIBUTE_LINE = "__LINE__";
    private static final String EXCLUDE_ATTRIBUTE_FILE = "__FILE__";
    private static final String[] EXCLUDED_FILES = new String[]{"template.config", ".project", "template-config.xml"};
    private static final FilenameFilter FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !Arrays.asList(EXCLUDED_FILES).contains(name);
        }
    };
    private static final String ATTRIBUTE_NAME_PATTERN = "[a-zA-Z][a-zA-Z0-9_]*?";
    private static final String DESCRIPTION_LINE_SEPARATOR = "[,;]";
    private static final String DESCRIPTION_LINE_COMMENT_CHAR = "#";
    private static final List<Matcher> fMatchers = new ArrayList<Matcher>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(Pattern.compile("(__([a-zA-Z][a-zA-Z0-9_]*?)__)").matcher(""));
            this.add(Pattern.compile("(x_([a-zA-Z][a-zA-Z0-9_]*?)_x)").matcher(""));
        }
    };
    private List<FileElement> fPaths;
    private Map<String, AttributeElement> fAttributes;
    private List<FilterElement> fFilters;
    private String fTemplateParentPath = "";
    private String fTemplatePath = "";
    private String fTargetPath = "";

    public TemplateEngine() {
        this.setPaths(new ArrayList<FileElement>());
        this.setAttributes(new LinkedHashMap<String, AttributeElement>());
        this.fFilters = new ArrayList<FilterElement>();
    }

    public void setSourceAndTargetPaths(String templatePath, String targetPath) {
        this.fTemplatePath = templatePath;
        this.fTargetPath = targetPath;
    }

    public void parseTemplate() {
        try {
            this.fPaths.clear();
            this.fAttributes.clear();
            this.fFilters.clear();
            File templateFile = new File(this.fTemplatePath);
            this.fTemplateParentPath = templateFile.getParentFile().getCanonicalPath();
            this.fPaths.add(new FileElement(templateFile.getCanonicalPath()));
            TemplateConfigReaderWriter reader = this.parseTemplateConfigXML(this.fTemplatePath);
            if (reader != null) {
                this.fFilters.addAll(reader.getParameterFilter());
            }
            this.collectAttributesFromLine(this.fTemplatePath, this.fTemplatePath, true);
            this.collectFilesAndAttributesFrom(this.fTemplatePath);
            this.parseConfigFile(this.fTemplatePath);
            if (reader != null) {
                this.parseConfigsFromXML(reader.getParameterConfig());
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void generateProjectPaths() {
        if (this.fPaths == null || this.fPaths.isEmpty()) {
            return;
        }
        FileElement fileElement = this.fPaths.get(0);
        int parentFileNameLength = this.fTemplateParentPath.length();
        String templateFileName = fileElement.getTemplatePath().substring(parentFileNameLength);
        StringBuilder replacedFileName = this.replaceWithAttribute(templateFileName, fileElement.getTemplatePath());
        String generatedPath = replacedFileName.insert(0, this.fTargetPath).toString();
        fileElement.setGeneratedPath(generatedPath);
        this.computeGeneratedPaths(fileElement.getTemplatePath(), fileElement.getGeneratedPath());
    }

    private void computeGeneratedPaths(String templateRoot, String generatedParentPath) {
        File rootFile = new File(templateRoot);
        String[] childrenPaths = rootFile.list(FILE_FILTER);
        if (childrenPaths == null) {
            return;
        }
        String[] stringArray = childrenPaths;
        int n = childrenPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(rootFile, path);
            FileElement fileElement = this.searchFileElement(file);
            if (fileElement != null) {
                String templatePath = String.valueOf(templateRoot) + File.separator + path;
                StringBuilder generatedFileName = this.replaceWithAttribute(path, templatePath);
                fileElement.setGeneratedPath(String.valueOf(generatedParentPath) + File.separator + generatedFileName.toString());
                if (file.isDirectory() && !Files.isSymbolicLink(file.toPath())) {
                    this.computeGeneratedPaths(file.getAbsolutePath(), fileElement.getGeneratedPath());
                }
            }
            ++n2;
        }
    }

    private FileElement searchFileElement(File file) {
        for (FileElement element : this.fPaths) {
            if (!element.getTemplatePath().equals(file.getAbsolutePath())) continue;
            return element;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateProjectContents() {
        try {
            File targetFile = new File(this.fTargetPath);
            if (!targetFile.exists() && !targetFile.mkdirs()) {
                return;
            }
            String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject(null);
            Iterator<FileElement> iterator = this.fPaths.iterator();
            while (true) {
                File generatedFile;
                File templateFile;
                block24: {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    FileElement fileElement = iterator.next();
                    templateFile = new File(fileElement.getTemplatePath());
                    generatedFile = new File(fileElement.getGeneratedPath());
                    if (fileElement.isSymlink()) {
                        this.generateSymlink(templateFile, generatedFile);
                        continue;
                    }
                    if (templateFile.isDirectory()) {
                        generatedFile.mkdirs();
                        continue;
                    }
                    if (!templateFile.isFile()) continue;
                    if (DVTFileUtils.getInstance().isBinary(templateFile)) {
                        DVTFileUtils.getInstance().copyFile(templateFile, generatedFile);
                        continue;
                    }
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try {
                        BufferedReader inFileBuf = new BufferedReader(new FileReader(templateFile));
                        try {
                            try (BufferedWriter outFileBuf = new BufferedWriter(new FileWriter(generatedFile));){
                                String line = null;
                                while (true) {
                                    if ((line = inFileBuf.readLine()) == null) {
                                        outFileBuf.close();
                                        inFileBuf.close();
                                        break;
                                    }
                                    outFileBuf.append(this.replaceWithAttribute(line, fileElement.getTemplatePath()).append(lineDelimiter));
                                }
                            }
                            if (inFileBuf == null) break block24;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (inFileBuf == null) throw throwable;
                            inFileBuf.close();
                            throw throwable;
                        }
                        inFileBuf.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                if (templateFile.canExecute()) {
                    generatedFile.setExecutable(true);
                }
                if (!templateFile.canWrite()) continue;
                generatedFile.setWritable(true);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void generateSymlink(File templateFile, File generatedFile) throws IOException {
        Path firstLevelSymlink = Files.readSymbolicLink(Paths.get(templateFile.getAbsolutePath(), new String[0]));
        StringBuilder replacedIDSymlink = this.replaceWithAttribute(firstLevelSymlink.toString(), "");
        Path target = Paths.get(replacedIDSymlink.toString(), new String[0]);
        Path symlinkResolvedPath = templateFile.getCanonicalFile().toPath();
        if (!symlinkResolvedPath.startsWith(this.fTemplatePath)) {
            target = firstLevelSymlink;
        }
        Path generatedPath = generatedFile.exists() ? generatedFile.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS) : Paths.get(generatedFile.getAbsolutePath(), new String[0]);
        Files.deleteIfExists(generatedPath);
        Files.createSymbolicLink(generatedPath, target, new FileAttribute[0]);
    }

    public String getProposedProjectName() {
        return this.replaceWithAttribute(new File(this.fTemplatePath).getName(), this.fTemplatePath).toString();
    }

    private void collectAttributesFromLine(String input, String path, boolean isInProjectPath) {
        for (Matcher matcher : fMatchers) {
            matcher.reset(input);
            while (matcher.find()) {
                boolean ignoreAttribute;
                String match = matcher.group(1);
                if (match.equalsIgnoreCase(EXCLUDE_ATTRIBUTE_FILE) || match.equalsIgnoreCase(EXCLUDE_ATTRIBUTE_LINE) || (ignoreAttribute = this.isAttributeFiltered(path, match)) || this.fAttributes.containsKey(match = matcher.group(2))) continue;
                this.fAttributes.put(match.toLowerCase(), new AttributeElement(match, isInProjectPath));
            }
        }
    }

    private boolean fileNameMatchesFilter(FilterElement filter, String path) {
        return new StringMatcher(filter.getPathPattern(), false, false).match(path);
    }

    private boolean isAttributeFiltered(String path, String attributeMatch) {
        int i = this.fFilters.size() - 1;
        while (i >= 0) {
            FilterElement filter = this.fFilters.get(i);
            if (this.fileNameMatchesFilter(filter, path)) {
                StringMatcher pattern = new StringMatcher(filter.getIdentifier(), false, false);
                if (filter.getType().equals("REJECT")) {
                    if (filter.getIdentifier().isEmpty() || pattern.match(attributeMatch.toLowerCase())) {
                        return true;
                    }
                } else if (filter.getType().equals("ALLOW") && (filter.getIdentifier().isEmpty() || pattern.match(attributeMatch.toLowerCase()))) {
                    return false;
                }
            }
            --i;
        }
        return false;
    }

    public StringBuilder replaceWithAttribute(String input, String path) {
        for (Matcher matcher : fMatchers) {
            matcher.reset(input);
            while (matcher.find()) {
                String replacement;
                AttributeElement attributeElement;
                String shortVarname;
                boolean ignoreVariable;
                String varname = matcher.group(1);
                if (varname.equalsIgnoreCase(EXCLUDE_ATTRIBUTE_FILE) || varname.equalsIgnoreCase(EXCLUDE_ATTRIBUTE_LINE) || (ignoreVariable = this.isAttributeFiltered(path, varname)) || (shortVarname = matcher.group(2)) == null || (attributeElement = this.fAttributes.get(shortVarname.toLowerCase())) == null || (replacement = attributeElement.getReplacement()) == null || replacement.isEmpty()) continue;
                if (shortVarname.compareTo(shortVarname.toUpperCase()) == 0) {
                    replacement = replacement.toUpperCase();
                } else if (shortVarname.substring(0, 1).compareTo(shortVarname.substring(0, 1).toUpperCase()) == 0) {
                    replacement = String.valueOf(replacement.substring(0, 1).toUpperCase()) + replacement.substring(1);
                }
                input = input.replace(varname, replacement);
            }
        }
        return new StringBuilder(input);
    }

    private void collectFilesAndAttributesFrom(String rootPath) throws IOException {
        String[] childrenPaths;
        String[] stringArray = childrenPaths = new File(rootPath).list(FILE_FILTER);
        int n = childrenPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(rootPath, path);
            if (file.canRead()) {
                FileElement fileElement = new FileElement(file.getCanonicalPath());
                this.fPaths.add(fileElement);
                this.collectAttributesFromLine(path, fileElement.getTemplatePath(), false);
                if (file.isFile()) {
                    if (Files.isSymbolicLink(file.toPath())) {
                        fileElement.setTemplatePath(file.getAbsolutePath());
                        fileElement.setIsSymlink();
                    } else if (!DVTFileUtils.getInstance().isBinary(file)) {
                        Throwable throwable = null;
                        Object var10_11 = null;
                        try (BufferedReader fileBuf = new BufferedReader(new FileReader(file));){
                            String line = null;
                            while ((line = fileBuf.readLine()) != null) {
                                this.collectAttributesFromLine(line, fileElement.getTemplatePath(), false);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                } else if (file.isDirectory()) {
                    if (Files.isSymbolicLink(file.toPath())) {
                        fileElement.setIsSymlink();
                        fileElement.setTemplatePath(file.getAbsolutePath());
                    } else {
                        this.collectFilesAndAttributesFrom(file.getCanonicalPath());
                    }
                }
            }
            ++n2;
        }
    }

    private TemplateConfigReaderWriter parseTemplateConfigXML(String templatePath) {
        try {
            File configFile = new File(templatePath, XML_CONFIG_FILENAME);
            if (configFile.exists() && configFile.isFile() && configFile.canRead()) {
                TemplateConfigReaderWriter reader = new TemplateConfigReaderWriter();
                reader.read(configFile);
                return reader;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    private void parseConfigsFromXML(List<AttributeElement> parameterConfig) {
        for (AttributeElement element : parameterConfig) {
            AttributeElement attribute = this.fAttributes.get(element.getName());
            if (attribute == null) continue;
            attribute.updateValues(element.getDefaultValue(), element.getDescription());
        }
    }

    private void parseConfigFile(String templatePath) {
        block12: {
            try {
                File configFile = new File(templatePath, CONFIG_FILENAME);
                if (!configFile.exists() || !configFile.isFile() || !configFile.canRead()) break block12;
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedReader inFileBuf = new BufferedReader(new FileReader(configFile));){
                    String line = null;
                    while ((line = inFileBuf.readLine()) != null) {
                        AttributeElement attribute;
                        String[] lineData;
                        if ((line = line.trim()).startsWith(DESCRIPTION_LINE_COMMENT_CHAR) || (lineData = line.split(DESCRIPTION_LINE_SEPARATOR, 3))[0].length() <= 1 || (attribute = this.fAttributes.get(lineData[0])) == null) continue;
                        attribute.updateValues(lineData[1], lineData.length > 2 ? lineData[2] : "");
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public Map<String, AttributeElement> getConfigFileAttributes(String templatePath) {
        File configFile = new File(templatePath, CONFIG_FILENAME);
        File configFileXML = new File(templatePath, XML_CONFIG_FILENAME);
        LinkedHashMap<String, AttributeElement> result = new LinkedHashMap<String, AttributeElement>();
        try {
            if (configFile.exists() && configFile.isFile() && configFile.canRead()) {
                Throwable throwable = null;
                Object var6_8 = null;
                try (BufferedReader inFileBuf = new BufferedReader(new FileReader(configFile));){
                    String line = null;
                    while ((line = inFileBuf.readLine()) != null) {
                        AttributeElement attribute;
                        String[] lineData;
                        if ((line = line.trim()).startsWith(DESCRIPTION_LINE_COMMENT_CHAR) || (lineData = line.split(DESCRIPTION_LINE_SEPARATOR, 3))[0].length() <= 1 || (attribute = this.fAttributes.get(lineData[0])) == null) continue;
                        result.put(lineData[0], attribute);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (configFileXML.exists() && configFileXML.isFile() && configFileXML.canRead()) {
                TemplateConfigReaderWriter reader = this.parseTemplateConfigXML(templatePath);
                if (reader == null) {
                    return result;
                }
                reader.read(configFileXML);
                for (AttributeElement element : reader.getParameterConfig()) {
                    if (!result.containsKey(element.getName())) continue;
                    result.put(element.getName(), element);
                }
            }
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return result;
        }
    }

    public Map<String, AttributeElement> getAttributes() {
        return this.fAttributes;
    }

    public String getFirstGeneratedPath() {
        return this.fPaths.get(0).getGeneratedPath();
    }

    public void setAttributes(Map<String, AttributeElement> fAttributes) {
        this.fAttributes = fAttributes;
    }

    public void setPaths(List<FileElement> fPaths) {
        this.fPaths = fPaths;
    }

    public void setFilters(List<FilterElement> fFilters) {
        this.fFilters = fFilters;
    }

    public void setTemplateParentPath() {
        File templateFile = new File(this.fTemplatePath);
        try {
            this.fTemplateParentPath = templateFile.getParentFile().getCanonicalPath();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

