/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.templates;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.wizards.templates.TemplateProjectModel;
import ro.amiq.dvt.wizards.util.AttributeElement;

public class TemplateProjectAttributesPage
extends WizardPage {
    private final TemplateProjectModel fModel;
    private Map<String, AttributeContainer> fAttributesContainers;
    private AttributeContainer fProjectNameContainer;
    private Button fInheritDVTSettingsButton;

    protected TemplateProjectAttributesPage(TemplateProjectModel model) {
        super("NewTemplateProjecttAttributesPage");
        this.fModel = model;
        this.setTitle("Project Configuration");
        this.setDescription("Specify project attributes");
        this.setImageDescriptor(DVTImages.NEW_TEMPLATE_DVT_PROJECT_WIZ);
        this.setPageComplete(false);
    }

    protected void setControl(Control newControl) {
        super.setControl(newControl);
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "ro.amiq.dvt.help.project_template_wizard");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        ScrolledComposite scomposite = new ScrolledComposite(composite, 512);
        scomposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite acomposite = new Composite((Composite)scomposite, 0);
        GridLayout acompositeLayout = new GridLayout(2, false);
        acompositeLayout.marginBottom = 20;
        acomposite.setLayout((Layout)acompositeLayout);
        acomposite.setFont(parent.getFont());
        this.fModel.runParseTemplate();
        Map<String, AttributeElement> attributes = this.fModel.getTemplateEngine().getAttributes();
        Map<Object, Object> templateConfigAttributes = new LinkedHashMap();
        templateConfigAttributes = this.fModel.getTemplateEngine().getConfigFileAttributes(this.fModel.getTemplatePath());
        if (attributes == null) {
            this.setErrorMessage("Go back and set the template path!");
            this.setPageComplete(false);
            this.setControl((Control)acomposite);
        } else {
            for (Map.Entry<String, AttributeElement> entry : attributes.entrySet()) {
                templateConfigAttributes.put(entry.getKey(), entry.getValue());
            }
            attributes = templateConfigAttributes;
            this.fAttributesContainers = new LinkedHashMap<String, AttributeContainer>();
            this.fProjectNameContainer = new AttributeContainer(acomposite, "Project Name", this.fModel.getProjectNameAttribute(), true);
            for (Map.Entry<String, AttributeElement> entry : attributes.entrySet()) {
                String name = entry.getKey();
                this.fAttributesContainers.put(name, new AttributeContainer(acomposite, name, entry.getValue()));
            }
            scomposite.setContent((Control)acomposite);
            scomposite.setExpandHorizontal(true);
            scomposite.setExpandVertical(true);
            scomposite.setMinSize(acomposite.computeSize(-1, -1));
            scomposite.setFont(parent.getFont());
            if (this.fModel.templateHasDotDVT()) {
                this.fInheritDVTSettingsButton = new Button(composite, 32);
                this.fInheritDVTSettingsButton.setFont(parent.getFont());
                this.fInheritDVTSettingsButton.setText("Inherit Template Project Settings");
                this.fInheritDVTSettingsButton.setLayoutData((Object)new GridData(16384, 0, false, false, 1, 1));
                this.fInheritDVTSettingsButton.setSelection(true);
                this.fInheritDVTSettingsButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        TemplateProjectAttributesPage.this.updatePageState();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
            }
            Button defaults = new Button(composite, 8);
            defaults.setFont(parent.getFont());
            defaults.setText("Restore &Defaults");
            defaults.setLayoutData((Object)new GridData(131072, 0, false, false, 1, 1));
            defaults.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TemplateProjectAttributesPage.this.setDefaults();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.updatePageState();
            this.setControl((Control)composite);
        }
    }

    private void updatePageState() {
        boolean pageComplete = true;
        this.fProjectNameContainer.setValue(this.fModel.getTemplateEngine().getProposedProjectName());
        if (this.fProjectNameContainer.getReplacement().length() < 1) {
            pageComplete = false;
            this.setErrorMessage(String.valueOf(this.fProjectNameContainer.fName) + " is empty. Please fill the field or use default value \"" + this.fProjectNameContainer.getAttribute().getDefaultValue() + "\".");
        } else if (ResourcesPlugin.getWorkspace().getRoot().getProject(this.fProjectNameContainer.getReplacement()).exists()) {
            pageComplete = false;
            this.setErrorMessage(String.valueOf(this.fProjectNameContainer.getReplacement()) + " exists in workspace, please change the name!");
        } else {
            for (AttributeContainer container : this.fAttributesContainers.values()) {
                if (container.getReplacement().length() >= 1) continue;
                pageComplete = false;
                this.setErrorMessage(String.valueOf(container.fName) + " is empty. Please fill the field or use default value \"" + container.getAttribute().getDefaultValue() + "\".");
                break;
            }
        }
        if (pageComplete) {
            this.setErrorMessage(null);
            this.saveAttributes();
            this.saveInheritDVTSettings();
        }
        this.setPageComplete(pageComplete);
    }

    public void setDefaults() {
        this.fProjectNameContainer.setDefault();
        for (AttributeContainer container : this.fAttributesContainers.values()) {
            container.setDefault();
        }
    }

    private void saveAttributes() {
        this.fProjectNameContainer.saveAttribute();
        for (AttributeContainer container : this.fAttributesContainers.values()) {
            container.saveAttribute();
        }
    }

    private void saveInheritDVTSettings() {
        if (this.fInheritDVTSettingsButton != null) {
            this.fModel.setUseTemplateDotDVT(this.fInheritDVTSettingsButton.getSelection());
        }
    }

    public Map<String, AttributeContainer> testGetAttributesContainers() {
        return this.fAttributesContainers;
    }

    public final class AttributeContainer {
        private Label fNameLabel;
        private Text fReplacementText;
        private String fName;
        private AttributeElement fAttribute;
        private boolean fReadOnly;

        public AttributeContainer(Composite parent, String name, final AttributeElement attribute, boolean readOnly) {
            this.fReadOnly = readOnly;
            this.fName = name;
            this.fAttribute = attribute;
            this.fNameLabel = new Label(parent, 0);
            this.fNameLabel.setFont(parent.getFont());
            this.fNameLabel.setLayoutData((Object)new GridData(128));
            String description = attribute.getDescription();
            this.fNameLabel.setText(description == null || description.trim().isEmpty() ? name : String.valueOf(description) + ":");
            this.fReplacementText = new Text(parent, 2048);
            this.fReplacementText.setFont(parent.getFont());
            this.fReplacementText.setLayoutData((Object)new GridData(768));
            this.fReplacementText.setText(attribute.getReplacement());
            this.fReplacementText.setToolTipText(String.valueOf(attribute.getDescription()) + (attribute.isInProjectPath() ? "\nThis attribute value is used to generate the project path, if the path exists the content will be overwritten!" : ""));
            if (this.fReadOnly) {
                this.fReplacementText.setEnabled(false);
            }
            this.fReplacementText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AttributeContainer.this.saveAttribute();
                    if (!AttributeContainer.this.fReadOnly) {
                        TemplateProjectAttributesPage.this.updatePageState();
                    }
                }
            });
            this.fReplacementText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    TemplateProjectAttributesPage.this.setMessage(attribute.getDescription(), 1);
                }

                public void focusLost(FocusEvent e) {
                }
            });
        }

        public AttributeContainer(Composite parent, String name, AttributeElement attribute) {
            this(parent, name, attribute, false);
        }

        public String getReplacement() {
            return this.fReplacementText.getText().trim();
        }

        public AttributeElement getAttribute() {
            return this.fAttribute;
        }

        public void setDefault() {
            this.fReplacementText.setText(this.fAttribute.getDefaultValue());
        }

        public void setValue(String value) {
            this.fReplacementText.setText(value);
        }

        public void saveAttribute() {
            this.fAttribute.setReplacement(this.fReplacementText.getText().trim());
        }
    }
}

