/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.templates;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.wizards.templates.TemplateProjectModelCommon;
import ro.amiq.dvt.wizards.templates.TemplateProjectWizard;
import ro.amiq.dvt.wizards.util.AttributeElement;
import ro.amiq.dvt.wizards.util.PredefinedProjectsUtils;

public class TemplateProjectModel
extends TemplateProjectModelCommon {
    private IWorkbench fWorkbench;
    private IConfigurationElement fConfigurationElement;
    private IProject fProject;
    private AttributeElement fProjectNameAttribute;
    private String fTargetPath;
    private String fTemplatePath;
    private boolean fIsParsed = false;
    private boolean fUseTemplateDotDVT = false;

    public TemplateProjectModel() {
        this.fIsGenerated = false;
        this.fTemplatePath = "";
        this.fTargetPath = "";
    }

    public void setWorkbench(IWorkbench workbench) {
        this.fWorkbench = workbench;
    }

    public void setConfigurationElement(IConfigurationElement configurationElement) {
        this.fConfigurationElement = configurationElement;
    }

    public String getProjectPath() {
        return this.fProjectPath;
    }

    public void setTemplatePath(String templatePath) {
        if (!this.fTemplatePath.equals(templatePath)) {
            this.fTemplatePath = templatePath;
            this.fIsParsed = false;
        }
    }

    public String getTemplatePath() {
        return this.fTemplatePath;
    }

    public void setTargetPath(String targetPath) {
        this.fTargetPath = targetPath;
    }

    public String getTargetPath() {
        return this.fTargetPath;
    }

    public void setUseTemplateDotDVT(boolean useTemplateDotDVT) {
        this.fUseTemplateDotDVT = useTemplateDotDVT;
    }

    public boolean isUseTemplateDotDVT() {
        return this.fUseTemplateDotDVT;
    }

    public AttributeElement getProjectNameAttribute() {
        return this.fProjectNameAttribute;
    }

    public boolean templateHasDotDVT() {
        File templateFile = new File(this.fTemplatePath, ".dvt");
        return templateFile.exists() && templateFile.canRead() && templateFile.isDirectory();
    }

    public void runParseTemplate() {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                TemplateProjectModel.this.fTemplateEngine.setSourceAndTargetPaths(TemplateProjectModel.this.fTemplatePath, TemplateProjectModel.this.fTargetPath);
                if (!TemplateProjectModel.this.fIsParsed) {
                    TemplateProjectModel.this.fTemplateEngine.parseTemplate();
                    TemplateProjectModel.this.fProjectNameAttribute = new AttributeElement("Project Name", TemplateProjectModel.this.fTemplateEngine.getProposedProjectName(), "Project Name", false);
                    TemplateProjectModel.this.fIsParsed = true;
                }
            }
        });
    }

    public void runGenerateProject() {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                TemplateProjectModel.this.generateProject();
            }
        });
    }

    public void createWorkspaceProject(TemplateProjectWizard wizard) {
        WorkspaceModifyDelegatingOperation newProjectOp = new WorkspaceModifyDelegatingOperation(this.createNewProjectOpRunnable());
        try {
            this.runGenerateProject();
            wizard.getContainer().run(false, true, (IRunnableWithProgress)newProjectOp);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigurationElement);
            DVTPlugin.getSelectionManager().selectAndReveal((IResource)this.fProject, this.fWorkbench.getActiveWorkbenchWindow());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private IRunnableWithProgress createNewProjectOpRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Creating Project...", 10);
                File srcProject = PredefinedProjectsUtils.getProjectFileFromDirectory(new File(TemplateProjectModel.this.fTemplatePath));
                IProjectDescription srcProjDescr = Utils.getProjectDescription(srcProject);
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot workspaceRoot = workspace.getRoot();
                String projectName = TemplateProjectModel.this.fProjectNameAttribute.getReplacement();
                TemplateProjectModel.this.fProject = workspaceRoot.getProject(projectName);
                IProjectDescription description = workspace.newProjectDescription(projectName);
                description.setLocation((IPath)new Path(TemplateProjectModel.this.fProjectPath));
                if (srcProjDescr != null) {
                    description.setNatureIds(srcProjDescr.getNatureIds());
                }
                File dotDvt = new File(String.valueOf(TemplateProjectModel.this.fProjectPath) + File.separator + ".dvt");
                if (!TemplateProjectModel.this.fUseTemplateDotDVT) {
                    Utils.deleteFileRecursively(dotDvt);
                }
                File defaultBuild = new File(dotDvt, "default.build");
                if (!dotDvt.exists()) {
                    dotDvt.mkdir();
                }
                if (!defaultBuild.exists() && !TemplateProjectModel.this.fUseTemplateDotDVT) {
                    try {
                        defaultBuild.createNewFile();
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                try {
                    try {
                        if (!TemplateProjectModel.this.fProject.exists()) {
                            TemplateProjectModel.this.fProject.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                            TemplateProjectModel.this.fProject.open(0, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        }
                        if (!TemplateProjectModel.this.fProject.isOpen()) {
                            TemplateProjectModel.this.fProject.open(0, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        }
                        IProjectDescription desc = TemplateProjectModel.this.fProject.getDescription();
                        ICommand[] commands = desc.getBuildSpec();
                        boolean found = false;
                        int i = 0;
                        while (i < commands.length) {
                            if (commands[i].getBuilderName().equals("ro.amiq.dvt.MixedLangBuilder")) {
                                found = true;
                                break;
                            }
                            ++i;
                        }
                        if (!found) {
                            ICommand command = desc.newCommand();
                            command.setBuilderName("ro.amiq.dvt.MixedLangBuilder");
                            ICommand[] newCommands = new ICommand[commands.length + 1];
                            System.arraycopy(commands, 0, newCommands, 1, commands.length);
                            newCommands[0] = command;
                            desc.setBuildSpec(newCommands);
                            TemplateProjectModel.this.fProject.setDescription(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
    }
}

