/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.templates;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.wizards.templates.TemplateProjectModel;
import ro.amiq.dvt.wizards.util.PredefinedProjectsUtils;
import ro.amiq.dvt.wizards.util.QuickPredefinedTemplateProjectSelection;

public class TemplateProjectPathsPage
extends WizardPage {
    private final TemplateProjectModel fModel;
    private static final String DVT_PREDEFINED_PROJECTS = "DVT_PREDEFINED_PROJECTS";
    private LocationContainer fTemplateLocation;
    private LocationContainer fTargetLocation;
    private Map<IProjectDescription, String> fProjects = new LinkedHashMap<IProjectDescription, String>();

    protected TemplateProjectPathsPage(TemplateProjectModel model) {
        super("NewTemplateProjectPathsPage");
        this.fModel = model;
        this.setTitle("Template and target directories");
        this.setDescription("The template directory will be parametrized and placed in the target directory");
        this.setImageDescriptor(DVTImages.NEW_TEMPLATE_DVT_PROJECT_WIZ);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setFont(parent.getFont());
        this.fTemplateLocation = new LocationContainer(composite, "Template Directory", this.fModel.getTemplatePath(), "Specify the template directory or select from <a>Predefined Project Templates</a>.");
        this.fTemplateLocation.setFont(parent.getFont());
        GridData templateLocationGridData = new GridData(768);
        templateLocationGridData.horizontalSpan = 2;
        templateLocationGridData.verticalIndent = 20;
        this.fTemplateLocation.setLayoutData(templateLocationGridData);
        this.fTargetLocation = new LocationContainer(composite, "Target Directory", this.fModel.getTargetPath(), "Specify where the processed template directory will be placed.");
        this.fTargetLocation.setFont(parent.getFont());
        GridData targetLocationGridData = new GridData(768);
        targetLocationGridData.horizontalSpan = 2;
        targetLocationGridData.verticalIndent = 20;
        this.fTargetLocation.setLayoutData(targetLocationGridData);
        this.updatePageState();
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "ro.amiq.dvt.help.project_template_wizard");
    }

    private void updatePageState() {
        boolean pageComplete = true;
        String template = this.fTemplateLocation.getDirectory();
        if (template.length() < 1) {
            this.setErrorMessage("Invalid template location!");
            pageComplete = false;
        } else {
            File templatePath = new File(template);
            if (!templatePath.exists()) {
                this.setErrorMessage("Invalid template location!");
                pageComplete = false;
            } else if (!templatePath.canRead()) {
                this.setErrorMessage("You don't have permision to read template directory!");
                pageComplete = false;
            } else if (!templatePath.isDirectory()) {
                this.setErrorMessage("Template location is not a directory!");
                pageComplete = false;
            }
        }
        if (pageComplete) {
            String target = this.fTargetLocation.getDirectory();
            if (target.length() < 1) {
                this.setErrorMessage("Invalid target location!");
                pageComplete = false;
            } else {
                File targetPath = new File(target);
                if (!targetPath.exists()) {
                    this.setErrorMessage("Invalid target location!");
                    pageComplete = false;
                } else if (!targetPath.canWrite()) {
                    this.setErrorMessage("You don't have permision to write target directory!");
                    pageComplete = false;
                } else if (!targetPath.isDirectory()) {
                    this.setErrorMessage("Target location is not a directory!");
                    pageComplete = false;
                }
            }
        }
        if (pageComplete) {
            this.setErrorMessage(null);
            this.setMessage(null);
            this.savePaths();
        }
        this.setPageComplete(pageComplete);
    }

    private void savePaths() {
        this.fModel.setTemplatePath(this.fTemplateLocation.getDirectory());
        this.fModel.setTargetPath(this.fTargetLocation.getDirectory());
    }

    private final class LocationContainer
    extends Composite {
        final Text fDirectoryText;

        public LocationContainer(Composite parent, String info, String path, String comment) {
            super(parent, 0);
            this.setLayout((Layout)new FillLayout());
            Composite composite = new Composite((Composite)this, 0);
            composite.setLayout((Layout)new GridLayout(1, false));
            Group group = new Group(composite, 0);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)new GridData(768));
            group.setFont(parent.getFont());
            group.setText(info);
            this.fDirectoryText = new Text((Composite)group, 2048);
            this.fDirectoryText.setFont(parent.getFont());
            this.fDirectoryText.setLayoutData((Object)new GridData(768));
            if (path != null && !path.isEmpty()) {
                this.fDirectoryText.setText(path);
            }
            this.fDirectoryText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TemplateProjectPathsPage.this.updatePageState();
                }
            });
            Button directoryButton = new Button((Composite)group, 8);
            directoryButton.setFont(parent.getFont());
            directoryButton.setLayoutData((Object)new GridData(32));
            directoryButton.setText("Browse...");
            directoryButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String filterPath = DVTFileUtils.getInstance().getLastDirectory();
                    DirectoryDialog directoryDialog = new DirectoryDialog(LocationContainer.this.getShell());
                    directoryDialog.setFilterPath(filterPath);
                    String selectedDirectory = directoryDialog.open();
                    if (selectedDirectory != null) {
                        LocationContainer.this.fDirectoryText.setText(selectedDirectory);
                        DVTFileUtils.getInstance().setLastDirectory(selectedDirectory);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Link infoLabel = new Link((Composite)group, 64);
            infoLabel.setFont(parent.getFont());
            infoLabel.setText(comment);
            DVTUiUtils.setPlatformLinkColor((Link)infoLabel);
            GridData infoLabelGridData = new GridData(768);
            infoLabelGridData.horizontalSpan = 3;
            infoLabel.setLayoutData((Object)infoLabelGridData);
            infoLabel.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String systemVarPath = System.getenv(TemplateProjectPathsPage.DVT_PREDEFINED_PROJECTS);
                    if (systemVarPath == null || systemVarPath.trim().isEmpty()) {
                        TemplateProjectPathsPage.this.setErrorMessage("Environment variable DVT_PREDEFINED_PROJECTS is not set!");
                        return;
                    }
                    File projectDir = new File(systemVarPath);
                    if (!projectDir.exists()) {
                        TemplateProjectPathsPage.this.setErrorMessage("The folder " + systemVarPath + " does not exist!");
                        return;
                    }
                    ((LocationContainer)LocationContainer.this).TemplateProjectPathsPage.this.fProjects = PredefinedProjectsUtils.getPredefinedProjects(true);
                    QuickPredefinedTemplateProjectSelection sel = new QuickPredefinedTemplateProjectSelection(((LocationContainer)LocationContainer.this).TemplateProjectPathsPage.this.fProjects);
                    String projectPath = sel.openCustom();
                    if (projectPath == null) {
                        return;
                    }
                    File projectFile = new File(projectPath);
                    if (projectFile.exists()) {
                        LocationContainer.this.fDirectoryText.setText(projectPath);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }

        public String getDirectory() {
            return DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(this.fDirectoryText.getText().trim());
        }
    }
}

