/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.templates;

import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.XMLParser;
import ro.amiq.dvt.wizards.templates.TemplateProjectAttributesPage;
import ro.amiq.dvt.wizards.templates.TemplateProjectModel;
import ro.amiq.dvt.wizards.templates.TemplateProjectPathsPage;
import ro.amiq.dvt.wizards.util.AttributeElement;

public class TemplateProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension,
IPageChangedListener {
    public static final String ID = "ro.amiq.dvt.wizards.NewProjectFromTemplateWizard";
    private final TemplateProjectModel fModel = new TemplateProjectModel();
    private final TemplateProjectPathsPage fPathsPage = new TemplateProjectPathsPage(this.fModel);
    private final TemplateProjectAttributesPage fAttributesPage = new TemplateProjectAttributesPage(this.fModel);

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New Project From Template");
        this.fModel.setWorkbench(workbench);
    }

    public void initForCli(IWorkbench workbench, String templatePath, String targetPath) {
        this.fModel.setTemplatePath(templatePath);
        this.fModel.setTargetPath(targetPath);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New Project From Template");
        this.fModel.setWorkbench(workbench);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fModel.setConfigurationElement(config);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.fPathsPage);
        this.addPage((IWizardPage)this.fAttributesPage);
    }

    public boolean canFinish() {
        return this.fAttributesPage.isPageComplete();
    }

    public boolean performFinish() {
        block5: {
            if (DVTPlugin.getDefault().collect().ccc()) break block5;
            return false;
        }
        try {
            Map<String, AttributeElement> attributes = this.fModel.getTemplateEngine().getAttributes();
            XMLParser parser = new XMLParser("attributes");
            for (AttributeElement ae : attributes.values()) {
                String attrName = ae.getName();
                String attrDefaultValue = ae.getDefaultValue();
                String attrReplVal = ae.getReplacement();
                LinkedList<String> params = new LinkedList<String>();
                params.push(attrDefaultValue);
                if (!attrDefaultValue.equals(attrReplVal)) {
                    params.push(attrReplVal);
                }
                String[] arrParams = new String[params.size()];
                params.toArray(arrParams);
                parser.put(attrName, arrParams);
            }
            parser.put("Template_Path", new String[]{this.fModel.getTemplatePath()});
            this.fModel.createWorkspaceProject(this);
            File dest = new File(String.valueOf(this.fModel.getProjectPath()) + File.separator + ".dvt" + File.separator + "template-history.xml");
            dest.createNewFile();
            parser.save(dest.getAbsolutePath());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    public void pageChanged(PageChangedEvent event) {
        if (event.getSelectedPage() == this.fPathsPage) {
            this.fAttributesPage.setControl(null);
        }
    }

    public void createPageControls(Composite pageContainer) {
        IWizardPage[] wizardPages = this.getPages();
        int i = 0;
        while (i < wizardPages.length) {
            if (wizardPages[i] == this.fPathsPage) {
                wizardPages[i].createControl(pageContainer);
                Assert.isNotNull((Object)wizardPages[i].getControl());
            }
            ++i;
        }
    }

    public void showAttributesPage() {
        this.getContainer().showPage((IWizardPage)this.fAttributesPage);
    }

    public TemplateProjectPathsPage testGetPathsPage() {
        return this.fPathsPage;
    }

    public TemplateProjectModel testGetModel() {
        return this.fModel;
    }

    public TemplateProjectAttributesPage testGetAttributesPage() {
        return this.fAttributesPage;
    }
}

