/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.util;

import java.util.Calendar;

public class AttributeElement {
    private String fName;
    private String fDefaultValue;
    private String fDescription;
    private String fReplacement;
    private boolean fIsInProjectPath;

    public AttributeElement(String name, boolean isInProjectPath) {
        this(name, AttributeElement.resolveSpecialValue(name), "", isInProjectPath);
    }

    private static String resolveSpecialValue(String specialName) {
        if (specialName.equals("date")) {
            return Calendar.getInstance().getTime().toString();
        }
        if (specialName.equals("year")) {
            return Integer.toString(Calendar.getInstance().get(1));
        }
        if (specialName.equals("user")) {
            return System.getProperty("user.name");
        }
        return specialName;
    }

    public AttributeElement(String name, String defaultValue, String description, boolean isInProjectPath) {
        this.setName(name);
        this.setDescription(description);
        this.setDefaultValue(defaultValue);
        this.setReplacement(defaultValue);
        this.setIsInProjectPath(isInProjectPath);
    }

    public void updateValues(String defaultValue, String description) {
        this.setDefaultValue(defaultValue);
        this.setReplacement(defaultValue);
        this.setDescription(description);
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public void setDefaultValue(String defaultValue) {
        this.fDefaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.fDefaultValue;
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public void setReplacement(String replacement) {
        this.fReplacement = replacement;
    }

    public String getReplacement() {
        return this.fReplacement;
    }

    public void setIsInProjectPath(boolean isInProjectPath) {
        this.fIsInProjectPath = isInProjectPath;
    }

    public boolean isInProjectPath() {
        return this.fIsInProjectPath;
    }
}

