/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.wizards.util.LabelProvider;

public class FileTemplateSelector
extends ElementListSelectionDialog {
    private static final String NO_PREVIEW_AVAILABLE = "No preview available!";
    private static final String UPDATING_TEMPLATES = "Updating Templates...";
    private static final String NO_TEMPLATES_AVAILABLE = "No Templates Available";
    private static final String ERROR_MESSAGE = "Directory name must be relative to workspace root e.g. /projectName/target/directory/ and the target project must have a valid nature";
    private MyFilterMatcher fFilterMatcher;
    private Text fFilterText;
    private Template fFirstSelection;
    private SourceViewerConfiguration fSourceViewerConfiguration;
    private IDocumentPartitioner fPartitioner;
    private SourceViewer fPatternViewer;
    private Label fTemplateDescription;
    private IProject fProject;
    private String fNatureName;
    private Combo fTemplateCategoryCombo;
    private List<String> fContextList = new ArrayList<String>();

    public FileTemplateSelector(List<String> contextList, Template firstSelection, IProject project, String natureName) {
        super(DVTUiUtils.getActiveWorkbenchShell(), (ILabelProvider)new LabelProvider());
        this.fContextList = contextList;
        this.fFirstSelection = firstSelection;
        this.fProject = project;
        this.fNatureName = natureName;
        this.fSourceViewerConfiguration = TemplatesViewUtils.getSourceViewerConfiguration(this.fNatureName);
        this.fPartitioner = TemplatesViewUtils.getDocumentPartitioner(this.fNatureName);
    }

    protected FilteredList createFilteredList(Composite parent) {
        super.createFilteredList(parent);
        this.fFilterMatcher = new MyFilterMatcher();
        this.fFilteredList.setFilterMatcher((FilteredList.FilterMatcher)this.fFilterMatcher);
        this.fFilteredList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (FileTemplateSelector.this.fPatternViewer == null || FileTemplateSelector.this.fFilteredList == null || FileTemplateSelector.this.fTemplateDescription == null || FileTemplateSelector.this.fFilteredList.isDisposed() || FileTemplateSelector.this.fFilteredList.getSelection().length == 0) {
                    return;
                }
                FileTemplateSelector.this.fPatternViewer.getTextWidget().setText("");
                FileTemplateSelector.this.fTemplateDescription.setText("");
                Template selectedTemplate = (Template)FileTemplateSelector.this.fFilteredList.getSelection()[0];
                if (selectedTemplate == null) {
                    return;
                }
                FileTemplateSelector.this.fPatternViewer.getTextWidget().setText(selectedTemplate.getPattern());
                FileTemplateSelector.this.fTemplateDescription.setText(selectedTemplate.getDescription());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return this.fFilteredList;
    }

    protected Text createFilterText(Composite parent) {
        this.fFilterText = super.createFilterText(parent);
        Listener[] listenerList = this.fFilterText.getListeners(24);
        if (listenerList.length > 0) {
            Listener[] listenerArray = listenerList;
            int n = listenerList.length;
            int n2 = 0;
            while (n2 < n) {
                Listener l = listenerArray[n2];
                this.fFilterText.removeListener(24, l);
                ++n2;
            }
        }
        this.fFilterText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FileTemplateSelector.this.fFilteredList.setFilter(FileTemplateSelector.this.fFilterText.getText());
                if (FileTemplateSelector.this.fFilterMatcher.fFilterMatchedOnce) {
                    FileTemplateSelector.this.fPatternViewer.getTextWidget().setText(FileTemplateSelector.UPDATING_TEMPLATES);
                    FileTemplateSelector.this.fTemplateDescription.setText("");
                } else {
                    FileTemplateSelector.this.fPatternViewer.getTextWidget().setText("");
                    FileTemplateSelector.this.fTemplateDescription.setText("");
                }
                FileTemplateSelector.this.fFilterMatcher.fFilterMatchedOnce = false;
            }
        });
        DVTColorUtil.INSTANCE.setForeground((Control)this.fFilterText, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.foregroundColor"), true);
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                FileTemplateSelector.this.fFilteredList.setEnabled(true);
                if (e.keyCode == 0x1000002) {
                    FileTemplateSelector.this.fFilteredList.setFocus();
                } else if (e.keyCode == 0x1000001) {
                    FileTemplateSelector.this.fFilteredList.setFocus();
                }
                this.setFilterTextColor();
            }

            public void keyReleased(KeyEvent e) {
                this.setFilterTextColor();
            }

            private void setFilterTextColor() {
                if (FileTemplateSelector.this.fFilterText.getText().length() == 0) {
                    DVTColorUtil.INSTANCE.setBackground((Control)FileTemplateSelector.this.fFilterText, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.emptyBackgroundColor"));
                } else {
                    DVTColorUtil.INSTANCE.setBackground((Control)FileTemplateSelector.this.fFilterText, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.backgroundColor"));
                }
            }
        });
        return this.fFilterText;
    }

    protected void handleEmptyList() {
        this.fPatternViewer.getTextWidget().setText("");
        this.fTemplateDescription.setText("");
        this.fFilterText.setEnabled(false);
        this.fFilteredList.setEnabled(false);
        this.updateOkState();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Group templatecategoryGroup = new Group(area, 0);
        templatecategoryGroup.setText("Template nature");
        templatecategoryGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        templatecategoryGroup.setLayout((Layout)new GridLayout(2, false));
        Label langSelectorLabel = new Label((Composite)templatecategoryGroup, 0);
        langSelectorLabel.setText("Select nature:");
        langSelectorLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fTemplateCategoryCombo = new Combo((Composite)templatecategoryGroup, 8);
        ArrayList<String> naturesTmp = new ArrayList<String>();
        try {
            if (Platform.getBundle((String)"ro.amiq.vlogdt") != null && this.fProject.hasNature("ro.amiq.vlogdt.VlogNature")) {
                naturesTmp.add("SystemVerilog");
            }
            if (Platform.getBundle((String)"ro.amiq.edt") != null && this.fProject.hasNature("ro.amiq.edt.enature")) {
                naturesTmp.add("e Language");
            }
            if (Platform.getBundle((String)"ro.amiq.slndt") != null && this.fProject.hasNature("ro.amiq.slndt.slnnature")) {
                naturesTmp.add("SLN");
            }
            if (Platform.getBundle((String)"ro.amiq.vhdldt") != null && this.fProject.hasNature("ro.amiq.vhdldt.VhdlNature")) {
                naturesTmp.add("VHDL");
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.fTemplateCategoryCombo.setItems(naturesTmp.toArray(new String[0]));
        this.fTemplateCategoryCombo.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fTemplateCategoryCombo.setText(this.fNatureName.equals("ro.amiq.vlogdt.VlogNature") ? "SystemVerilog" : (this.fNatureName.equals("ro.amiq.edt.enature") ? "e Language" : "VHDL"));
        this.fTemplateCategoryCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileTemplateSelector.this.fNatureName = FileTemplateSelector.this.fTemplateCategoryCombo.getText().equals("VHDL") ? "ro.amiq.vhdldt.VhdlNature" : (FileTemplateSelector.this.fTemplateCategoryCombo.getText().equals("e Language") ? "ro.amiq.edt.enature" : (FileTemplateSelector.this.fTemplateCategoryCombo.getText().equals("SLN") ? "ro.amiq.slndt.slnnature" : (FileTemplateSelector.this.fTemplateCategoryCombo.getText().equals("M-SDL") ? "ro.amiq.msdldt.msdlnature" : (FileTemplateSelector.this.fTemplateCategoryCombo.getText().equals("PSS") ? "ro.amiq.pssdt.pssnature" : "ro.amiq.vlogdt.VlogNature"))));
                FileTemplateSelector.this.refreshTemplates();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group listGroup = new Group(area, 2048);
        listGroup.setLayout((Layout)new GridLayout(3, true));
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 800;
        listGroup.setLayoutData((Object)gd);
        listGroup.setText("Select a file template");
        this.fFilterText.setParent((Composite)listGroup);
        this.fPatternViewer = new SourceViewer((Composite)listGroup, null, null, false, 2816);
        if (this.fSourceViewerConfiguration == null) {
            this.fPatternViewer.configure(new SourceViewerConfiguration());
        } else {
            this.fPatternViewer.configure(this.fSourceViewerConfiguration);
        }
        Document document = new Document();
        this.fPartitioner.connect((IDocument)document);
        document.setDocumentPartitioner(this.fPartitioner);
        this.fPatternViewer.setDocument((IDocument)document);
        this.fPatternViewer.setEditable(false);
        gd = new GridData(4, 4, true, true);
        gd.verticalSpan = 2;
        gd.horizontalSpan = 2;
        gd.heightHint = 400;
        this.fPatternViewer.getControl().setLayoutData((Object)gd);
        String previewMessage = NO_PREVIEW_AVAILABLE;
        if (this.fFirstSelection != null) {
            previewMessage = this.fFirstSelection.getPattern();
        }
        this.fPatternViewer.getTextWidget().setText(previewMessage);
        this.fFilteredList.setParent((Composite)listGroup);
        this.fFilteredList.setElements((Object[])this.getTemplates());
        if (this.fFirstSelection != null) {
            this.fFilteredList.setSelection((Object[])new Template[]{this.fFirstSelection});
        }
        Group infoGroup = new Group(area, 2048);
        infoGroup.setLayout((Layout)new GridLayout());
        gd = new GridData(4, 4, true, false);
        infoGroup.setLayoutData((Object)gd);
        infoGroup.setText("Template Description");
        this.fTemplateDescription = new Label((Composite)infoGroup, 64);
        this.fTemplateDescription.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.fFirstSelection != null) {
            this.fTemplateDescription.setText(this.fFirstSelection.getDescription());
        }
        Link l = new Link(area, 64);
        l.setText("To add/modify templates go to the <a href=\"globalTemplates\">Code templates preference page</a> for global templates (saved in the workspace directory)\nor to the <a href=\"projectTemplates\">Project templates property page</a> for project templates (saved in the my_project/.dvt directory)");
        DVTUiUtils.setPlatformLinkColor((Link)l);
        l.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.text.equals("globalTemplates")) {
                    FileTemplateSelector.this.openGlobalTemplatesPage();
                } else if (e.text.equals("projectTemplates")) {
                    FileTemplateSelector.this.openProjectTemplatesPage();
                }
            }
        });
        this.checkProjectName();
        this.fFilteredList.setEnabled(true);
        return area;
    }

    private boolean checkProjectName() {
        if (this.fProject == null || !this.fProject.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Link error", (String)ERROR_MESSAGE);
            return false;
        }
        try {
            if (this.fProject.getNature("ro.amiq.vlogdt.VlogNature") == null && this.fProject.getNature("ro.amiq.edt.enature") == null && this.fProject.getNature("ro.amiq.slndt.slnnature") == null && this.fProject.getNature("ro.amiq.msdldt.msdlnature") == null && this.fProject.getNature("ro.amiq.pssdt.pssnature") == null && this.fProject.getNature("ro.amiq.vhdldt.VhdlNature") == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Link error", (String)ERROR_MESSAGE);
                return false;
            }
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Link error", (String)ERROR_MESSAGE);
            return false;
        }
        return true;
    }

    public void openGlobalTemplatesPage() {
        if (this.fNatureName == null || this.fNatureName.isEmpty()) {
            return;
        }
        PreferenceDialog pref = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"ro.amiq.dvt.ui.codetemplates.TemplatesPreferencePage", null, null);
        if (pref != null) {
            this.close();
            pref.open();
        }
    }

    public void openProjectTemplatesPage() {
        if (!this.checkProjectName()) {
            return;
        }
        PreferenceDialog prop = PreferencesUtil.createPropertyDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IAdaptable)this.fProject, (String)"ro.amiq.dvt.ui.codetemplates.CodeTemplatesPropertyPage", null, null);
        if (prop != null) {
            this.close();
            prop.open();
        }
    }

    private Template[] getTemplates() {
        if (this.fProject == null) {
            return new Template[0];
        }
        List<Template> fileContextTemplates = TemplatesViewUtils.getGlobalTemplates(this.fNatureName);
        List<Template> projectTemplates = TemplatesViewUtils.getProjectTemplates(this.fProject, this.fNatureName);
        ArrayList<Template> allTemplates = new ArrayList<Template>();
        for (Template template : fileContextTemplates) {
            if (!this.fContextList.contains(template.getContextTypeId())) continue;
            allTemplates.add(template);
        }
        for (Template template : projectTemplates) {
            if (!this.fContextList.contains(template.getContextTypeId())) continue;
            allTemplates.add(template);
        }
        return allTemplates.toArray(new Template[fileContextTemplates.size() + projectTemplates.size()]);
    }

    private void refreshTemplates() {
        this.fTemplateDescription.setText("");
        this.fSourceViewerConfiguration = TemplatesViewUtils.getSourceViewerConfiguration(this.fNatureName);
        this.fPartitioner = TemplatesViewUtils.getDocumentPartitioner(this.fNatureName);
        if (this.fSourceViewerConfiguration == null || this.fPartitioner == null) {
            this.fPatternViewer.getTextWidget().setText(NO_TEMPLATES_AVAILABLE);
            this.fFilteredList.setElements(new Object[0]);
            this.fFilteredList.update();
            return;
        }
        this.fPatternViewer.unconfigure();
        this.fPatternViewer.configure(this.fSourceViewerConfiguration);
        Document document = new Document();
        this.fPartitioner.connect((IDocument)document);
        document.setDocumentPartitioner(this.fPartitioner);
        this.fPatternViewer.setDocument((IDocument)document);
        this.fPatternViewer.refresh();
        this.fPatternViewer.getTextWidget().setText(UPDATING_TEMPLATES);
        Object[] templates = this.getTemplates();
        if (templates.length == 0) {
            this.fPatternViewer.getTextWidget().setText(NO_TEMPLATES_AVAILABLE);
        }
        this.fFilteredList.setElements(templates);
        this.fFilteredList.update();
        if (!this.fFilterMatcher.fFilterMatchedOnce) {
            this.fPatternViewer.getTextWidget().setText("");
        }
        this.fFilterMatcher.fFilterMatchedOnce = false;
    }

    public Object getFirstResult() {
        ArrayList<Object> result = new ArrayList<Object>();
        Object template = super.getFirstResult();
        result.add(template);
        result.add(this.fNatureName);
        return result;
    }

    class MyFilterMatcher
    implements FilteredList.FilterMatcher {
        public boolean fFilterMatchedOnce;
        private StringMatcher fMatcher;

        MyFilterMatcher() {
        }

        public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
            this.fMatcher = new StringMatcher(String.valueOf('*') + pattern + '*', ignoreCase, ignoreWildCards);
        }

        public boolean match(Object element) {
            if (element == null) {
                return false;
            }
            boolean result = this.fMatcher.match(FileTemplateSelector.this.fFilteredList.getLabelProvider().getText(element));
            this.fFilterMatchedOnce |= result;
            return result;
        }
    }
}

