/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.util;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProjectDescription;
import ro.amiq.dvt.utils.Utils;

public class PredefinedProjectsUtils {
    private static final String DVT_PREDEFINED_PROJECTS_EXT = "DVT_PREDEFINED_PROJECTS_EXT_";
    private static final String DVT_PREDEFINED_PROJECTS = "DVT_PREDEFINED_PROJECTS";
    private static final String TEMPLATE_CONFIG = "template.config";
    private static final String XML_TEMPLATE_CONFIG = "template-config.xml";

    public static boolean hasNature(String[] natureIds, String name) {
        if (natureIds == null || name == null || name.isEmpty()) {
            return false;
        }
        return Arrays.asList(natureIds).contains(name);
    }

    public static boolean hasDVTNature(String[] natureIds) {
        if (natureIds == null) {
            return false;
        }
        List<String> naturesList = Arrays.asList(natureIds);
        return naturesList.contains("ro.amiq.edt.enature") || naturesList.contains("ro.amiq.slndt.slnnature") || naturesList.contains("ro.amiq.msdldt.msdlnature") || naturesList.contains("ro.amiq.pssdt.pssnature") || naturesList.contains("ro.amiq.vlogdt.VlogNature") || naturesList.contains("ro.amiq.vhdldt.VhdlNature");
    }

    public static File getProjectFileFromDirectory(File directory) {
        if (directory == null || !directory.exists()) {
            return null;
        }
        File dotProjFile = new File(directory, ".project");
        return dotProjFile.exists() ? dotProjFile : null;
    }

    public static Map getAllEnvVars() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Map<String, String> envVars = System.getenv();
        for (String variable : envVars.keySet()) {
            if (!variable.equals(DVT_PREDEFINED_PROJECTS) && !variable.startsWith(DVT_PREDEFINED_PROJECTS_EXT)) continue;
            result.put(variable, System.getenv(variable));
        }
        return result;
    }

    public static Map getPredefinedProjects(boolean justTemplates) {
        LinkedHashMap projects = new LinkedHashMap();
        Map<String, String> envVars = System.getenv();
        for (Map.Entry<String, String> entry : envVars.entrySet()) {
            String variable = entry.getKey();
            if (!variable.equals(DVT_PREDEFINED_PROJECTS) && !variable.startsWith(DVT_PREDEFINED_PROJECTS_EXT)) continue;
            projects.putAll(PredefinedProjectsUtils.getAllPredefinedProjects(entry.getValue(), justTemplates));
        }
        return projects;
    }

    private static Map getAllPredefinedProjects(String systemVarPath, boolean justTemplates) {
        LinkedHashMap<IProjectDescription, String> projects = new LinkedHashMap<IProjectDescription, String>();
        if (systemVarPath == null || systemVarPath.trim().isEmpty()) {
            return projects;
        }
        File projectDir = new File(systemVarPath);
        if (!projectDir.exists()) {
            return projects;
        }
        File[] files = projectDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        int i = 0;
        while (i < files.length) {
            IProjectDescription projectDescription;
            File projectFile = PredefinedProjectsUtils.getProjectFileFromDirectory(files[i]);
            if (projectFile != null && (projectDescription = Utils.getProjectDescription(projectFile)) != null) {
                projects.put(projectDescription, files[i].getAbsolutePath());
            }
            ++i;
        }
        if (justTemplates) {
            LinkedHashMap<IProjectDescription, String> templateProjects = new LinkedHashMap<IProjectDescription, String>();
            for (Map.Entry entry : projects.entrySet()) {
                IProjectDescription key = (IProjectDescription)entry.getKey();
                String projectPath = (String)entry.getValue();
                File templatePath = new File(String.valueOf(projectPath) + File.separator + TEMPLATE_CONFIG);
                File templatePathNewConfig = new File(String.valueOf(projectPath) + File.separator + XML_TEMPLATE_CONFIG);
                if (!templatePath.exists() && !templatePathNewConfig.exists()) continue;
                templateProjects.put(key, projectPath);
            }
            return templateProjects;
        }
        return projects;
    }
}

