/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.wizards.predefinedprojects.PredefinedProjectUI;

public class QuickPredefinedTemplateProjectSelection
extends MessageDialog {
    Map<IProjectDescription, String> fLocalProjects = new HashMap<IProjectDescription, String>();
    private PredefinedProjectUI fLocationGroup;
    private String fSelectedProjectPath;

    public QuickPredefinedTemplateProjectSelection(Map<IProjectDescription, String> projects) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Predefined Project Templates", null, "", 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.fLocalProjects = projects;
    }

    protected Control createCustomArea(Composite parent) {
        this.fLocationGroup = new PredefinedProjectUI(parent, true, this.fLocalProjects, null){

            @Override
            public void validateFields() {
                QuickPredefinedTemplateProjectSelection.this.localValidateFields();
            }

            @Override
            public void handleSelection(String selection) {
                this.resetOverwriteButton();
                QuickPredefinedTemplateProjectSelection.this.localHandleSelection(selection);
            }
        };
        GridData locationGroupGridData = new GridData(4, 4, true, true);
        locationGroupGridData.widthHint = 800;
        this.fLocationGroup.setLayoutData(locationGroupGridData);
        return this.fLocationGroup;
    }

    private void localValidateFields() {
        String projectNewPath = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(this.fSelectedProjectPath);
        try {
            projectNewPath = new File(projectNewPath).getCanonicalPath();
        }
        catch (IOException iOException) {}
    }

    private void localHandleSelection(String selection) {
        this.fSelectedProjectPath = this.fLocationGroup.getSelectedProjectPath();
        this.localValidateFields();
    }

    protected Control createMessageArea(Composite composite) {
        return super.createMessageArea(composite);
    }

    protected void buttonPressed(int buttonId) {
        this.fSelectedProjectPath = buttonId == 0 ? this.fLocationGroup.getSelectedProjectPath() : "";
        super.buttonPressed(buttonId);
    }

    public String openCustom() {
        int ret = super.open();
        if (ret == -1) {
            return "";
        }
        return this.fSelectedProjectPath;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void cancelPressed() {
        this.fSelectedProjectPath = "";
        super.cancelPressed();
    }
}

