/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.wizards.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.PositionalXMLReader;
import ro.amiq.dvt.wizards.util.AttributeElement;
import ro.amiq.dvt.wizards.util.FilterElement;

public class TemplateConfigReaderWriter {
    private static final String CONFIGS_ROOT = "template-config";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String PARAMETER_FILTER = "parameter-filter";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_IDENTIFIER = "identifier";
    private static final String ATTRIBUTE_FILE_PATH = "path";
    private static final String PARAMETER_CONFIG = "parameter-config";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_DEFAULT_VALUE = "default-value";
    private static final String ATTRIBUTE_DESCRIPTION_ATTRIBUTE = "description";
    private static final String VERSION_ONE = "1";
    private static final String ATTRIBUTE_LINE_NUMBER = "lineNumber";
    private List<AttributeElement> parameterConfig = new ArrayList<AttributeElement>();
    private List<FilterElement> parameterFilter = new ArrayList<FilterElement>();

    public List<AttributeElement> getParameterConfig() {
        return this.parameterConfig;
    }

    public List<FilterElement> getParameterFilter() {
        return this.parameterFilter;
    }

    public void read(File file) throws IOException {
        if (file == null) {
            return;
        }
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            this.read(input, null, file);
        }
        catch (Throwable throwable) {
            DVTUtilsCommon.INSTANCE.closeClosable(input);
            throw throwable;
        }
        DVTUtilsCommon.INSTANCE.closeClosable(input);
    }

    private void read(InputStream is, ResourceBundle bundle, File file) throws IOException {
        try {
            Document document = PositionalXMLReader.readXML(is);
            NodeList templateConfigsNodes = document.getElementsByTagName(CONFIGS_ROOT);
            if (templateConfigsNodes.getLength() < 1) {
                return;
            }
            NodeList configElements = document.getElementsByTagName(PARAMETER_CONFIG);
            NodeList filterElements = document.getElementsByTagName(PARAMETER_FILTER);
            Element templateConfigsNode = (Element)templateConfigsNodes.item(0);
            String version = templateConfigsNode.getAttribute(VERSION_ATTRIBUTE);
            if (version.equals(VERSION_ONE)) {
                this.readConfigs1(configElements, file);
                this.readFilters1(filterElements, file);
            }
        }
        catch (SAXException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t != null) {
                throw new IOException(t.getMessage());
            }
            throw new IOException(e.getMessage());
        }
    }

    private void readConfigs1(NodeList elements, File file) throws IOException {
        int count = elements.getLength();
        int i = 0;
        while (i != count) {
            Node node = elements.item(i);
            NamedNodeMap attributes = node.getAttributes();
            String line = (String)node.getUserData(ATTRIBUTE_LINE_NUMBER);
            if (attributes != null) {
                String attributeName = this.getStringValue(attributes, ATTRIBUTE_NAME, null);
                if (attributeName == null) {
                    DVTLogger.INSTANCE.logError("TemplateConfigReaderWriter.error.missing_attribute in file " + file.getAbsolutePath() + " at line " + line);
                } else {
                    String description = this.getStringValue(attributes, ATTRIBUTE_DESCRIPTION_ATTRIBUTE, "");
                    String defaultValue = this.getStringValue(attributes, ATTRIBUTE_DEFAULT_VALUE, "");
                    AttributeElement config = new AttributeElement(attributeName, defaultValue, description, true);
                    this.parameterConfig.add(config);
                }
            }
            ++i;
        }
    }

    private void readFilters1(NodeList elements, File file) throws IOException {
        int count = elements.getLength();
        int i = 0;
        while (i != count) {
            Node node = elements.item(i);
            NamedNodeMap attributes = node.getAttributes();
            String line = (String)node.getUserData(ATTRIBUTE_LINE_NUMBER);
            if (attributes != null) {
                String type = this.getStringValue(attributes, ATTRIBUTE_TYPE, null);
                if (type == null) {
                    DVTLogger.INSTANCE.logError("TemplateConfigReaderWriter.error.missing_attribute \"type\" in file " + file.getAbsolutePath() + " at line " + line);
                } else {
                    String identifier = this.getStringValue(attributes, ATTRIBUTE_IDENTIFIER, "");
                    String path = this.getStringValue(attributes, ATTRIBUTE_FILE_PATH, "");
                    if (identifier.isEmpty() && path.isEmpty()) {
                        DVTLogger.INSTANCE.logError("TemplateConfigReaderWriter.error.missing_attribute \"identifier\" or \"path\" in file " + file.getAbsolutePath() + " at line " + line);
                    } else {
                        if (identifier.isEmpty()) {
                            identifier = "*";
                        }
                        if (path.isEmpty()) {
                            path = "*";
                        }
                        String replacedPath = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(path, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, name -> System.getenv(name));
                        FilterElement filter = new FilterElement(type, identifier, replacedPath);
                        this.parameterFilter.add(filter);
                    }
                }
            }
            ++i;
        }
    }

    private String getStringValue(NamedNodeMap attributes, String name, String defaultValue) {
        if (attributes == null) {
            return null;
        }
        Node node = attributes.getNamedItem(name);
        return node == null ? defaultValue : node.getNodeValue();
    }
}

