/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.workspace;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTUiUtils;

public abstract class DVTDiskSpaceCheckDialog
extends MessageDialog {
    public Button dontShowAgain;
    public static final String WARNING_DIALOG_TITLE = "Not Enough Available Space";
    public static final String DONT_SHOW_AGAIN_LABEL = "Don't show me this message again during this session";
    public static final String WARNING_MESSAGE_1_FORMAT = "In order to work properly, DVT needs at least {0} MB of free space in the workspace location:";
    public static final String WARNING_MESSAGE_2_FORMAT = "Continuing may result in lossing unsaved data. It is recomended to exit DVT and free some space.";
    public static final String WARNING_PATH_FORMAT = "<a href=\"link\">{0}</a>";
    private String diskPath;

    public DVTDiskSpaceCheckDialog(String diskPath) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), WARNING_DIALOG_TITLE, null, "", 4, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.diskPath = diskPath;
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.imageLabel);
        }
        Composite wrapper = new Composite(composite, 0);
        wrapper.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)wrapper);
        Label label = new Label(wrapper, 64);
        label.setText(MessageFormat.format(WARNING_MESSAGE_1_FORMAT, 10L));
        GridDataFactory.fillDefaults().applyTo((Control)label);
        Link link = new Link(wrapper, 64);
        link.setText(MessageFormat.format(WARNING_PATH_FORMAT, this.diskPath));
        DVTUiUtils.setPlatformLinkColor((Link)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Program.launch((String)(this).DVTDiskSpaceCheckDialog.this.diskPath);
                    }
                });
                DVTDiskSpaceCheckDialog.this.cancelPressed();
                DVTDiskSpaceCheckDialog.this.close();
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)link);
        Label label2 = new Label(wrapper, 64);
        label2.setText(WARNING_MESSAGE_2_FORMAT);
        GridDataFactory.fillDefaults().indent(0, 10).applyTo((Control)label2);
        this.dontShowAgain = new Button(wrapper, 32);
        this.dontShowAgain.setText(DONT_SHOW_AGAIN_LABEL);
        return composite;
    }
}

