/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.workspace;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.workspace.DVTDiskSpaceCheckDialog;

public class WorkspaceDiskSpaceChecker
extends Job
implements IPropertyChangeListener {
    private static boolean disabledFromSystemVariable = Boolean.parseBoolean(System.getenv("DVT_SANITY_CHECK_DISABLE"));
    private static volatile boolean disabledForSession;
    private static volatile boolean warningDisplayed;
    private static volatile boolean firstRun;
    private static WorkspaceDiskSpaceChecker instance;
    private IPreferenceStore preferenceStore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkspaceDiskSpaceChecker getInstance() {
        Class<WorkspaceDiskSpaceChecker> clazz = WorkspaceDiskSpaceChecker.class;
        synchronized (WorkspaceDiskSpaceChecker.class) {
            if (instance == null) {
                instance = new WorkspaceDiskSpaceChecker();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private WorkspaceDiskSpaceChecker() {
        super("Workspace Disk Space Check Job");
        this.setSystem(true);
        this.setUser(false);
        this.setPriority(50);
    }

    public void start() {
        if (!disabledFromSystemVariable) {
            try {
                this.preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
                this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
                firstRun = true;
                this.schedule();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public void stop() {
        if (this.preferenceStore != null) {
            this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.preferenceStore = null;
        this.cancel();
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (disabledForSession) {
            return Status.OK_STATUS;
        }
        if (!firstRun && !this.isEnabled()) {
            return Status.OK_STATUS;
        }
        try {
            final File workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
            long availableSizeMB = workspaceFile.getUsableSpace() / 0x100000L;
            if (!warningDisplayed && availableSizeMB < 10L) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        warningDisplayed = true;
                        DVTDiskSpaceCheckDialog dialog = new DVTDiskSpaceCheckDialog(workspaceFile.getAbsolutePath()){

                            protected void buttonPressed(int buttonId) {
                                if (buttonId == 0 && this.dontShowAgain.getSelection()) {
                                    disabledForSession = true;
                                }
                                super.buttonPressed(buttonId);
                            }
                        };
                        dialog.open();
                        warningDisplayed = false;
                    }
                });
            }
            if (this.isEnabled()) {
                this.schedule(this.getDelay());
            }
            firstRun = false;
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
        return Status.OK_STATUS;
    }

    private long getDelay() {
        return (long)DVTPlugin.getDefault().getPreferenceStore().getInt("checkWorkspaceFreeSpaceInterval") * 1000L;
    }

    private boolean isEnabled() {
        return DVTPlugin.getDefault().getPreferenceStore().getBoolean("checkWorkspaceFreeSpace");
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!firstRun && (event.getProperty().equals("checkWorkspaceFreeSpaceInterval") || event.getProperty().equals("checkWorkspaceFreeSpace"))) {
            this.cancel();
            if (this.isEnabled()) {
                this.schedule(this.getDelay());
            }
        }
    }
}

