/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.workspace;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.workspace.DVTDiskSpaceCheckDialog;

public class WorkspaceDiskSpaceOnSaveChecker {
    private static volatile boolean warningDisplayed;
    private static volatile boolean disabledForSession;
    private static volatile DiskSpaceCheckOnSaveJob diskSpaceCheckJob;

    static {
        diskSpaceCheckJob = new DiskSpaceCheckOnSaveJob();
    }

    public static void tryDiskSpaceCheckOnSave(DVTEditor dvtEditor) {
        if (disabledForSession || !WorkspaceDiskSpaceOnSaveChecker.isCheckDiskSpaceOnSaveEnabled()) {
            return;
        }
        IEditorInput editorInput = dvtEditor.getEditorInput();
        if (editorInput == null) {
            return;
        }
        IResource adapter = (IResource)editorInput.getAdapter(IResource.class);
        if (adapter == null) {
            return;
        }
        IPath location = adapter.getLocation();
        if (location == null) {
            return;
        }
        File file = location.toFile();
        if (file == null) {
            return;
        }
        long availableSizeMB = file.getUsableSpace() / 0x100000L;
        diskSpaceCheckJob.setDiskPath(file.getAbsolutePath());
        if (!warningDisplayed && availableSizeMB < 10L) {
            diskSpaceCheckJob.cancel();
            diskSpaceCheckJob.schedule(200L);
        }
    }

    private static boolean isCheckDiskSpaceOnSaveEnabled() {
        return DVTPlugin.getDefault().getPreferenceStore().getBoolean("checkWorkspaceFreeSpaceOnSave");
    }

    private static class DiskSpaceCheckOnSaveJob
    extends Job {
        String diskPath;

        public DiskSpaceCheckOnSaveJob() {
            super("Workspace Disk Space Check Job");
            this.setUser(true);
        }

        public void setDiskPath(String absolutePath) {
            this.diskPath = absolutePath;
        }

        public IStatus run(IProgressMonitor monitor) {
            Runnable diskSpaceDisplay = new Runnable(){

                @Override
                public void run() {
                    warningDisplayed = true;
                    DVTDiskSpaceCheckDialog dialog = new DVTDiskSpaceCheckDialog(diskPath){

                        protected void buttonPressed(int buttonId) {
                            if (buttonId == 0 && this.dontShowAgain.getSelection()) {
                                disabledForSession = true;
                            }
                            super.buttonPressed(buttonId);
                        }
                    };
                    dialog.open();
                    warningDisplayed = false;
                }
            };
            PlatformUI.getWorkbench().getDisplay().asyncExec(diskSpaceDisplay);
            return Status.OK_STATUS;
        }
    }
}

