/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.node;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.Platform;

public class NodeBinaryProvider {
    public static final String ID = "ro.amiq.dvt.node";
    public static final String FRAGMENT = "ro.amiq.dvt.node." + Platform.getWS() + "." + Platform.getOS() + "." + Platform.getOSArch();
    public static final String BINARY = "win32".equals(Platform.getOS()) ? "node.exe" : "node";

    private NodeBinaryProvider() {
    }

    public static String getPath() {
        Path selfLocation = NodeBinaryProvider.computeSelfLocation();
        if (selfLocation == null) {
            return null;
        }
        Path location = null;
        location = selfLocation.getParent().resolve(String.valueOf(FRAGMENT) + "_" + Platform.getBundle((String)ID).getVersion().toString()).resolve("resources").resolve(BINARY);
        if (Files.exists(location, new LinkOption[0])) {
            return location.toString();
        }
        location = selfLocation.getParent().resolve(FRAGMENT).resolve("resources").resolve(BINARY);
        if (Files.exists(location, new LinkOption[0])) {
            return location.toString();
        }
        return null;
    }

    private static Path computeSelfLocation() {
        URL soruceCodeLocation = NodeBinaryProvider.class.getProtectionDomain().getCodeSource().getLocation();
        Path path = null;
        try {
            path = Paths.get(soruceCodeLocation.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            String stringPath = soruceCodeLocation.getPath();
            try {
                path = Paths.get(stringPath, new String[0]);
            }
            catch (InvalidPathException invalidPathException) {
                stringPath = stringPath.replaceFirst("^/(.:/)", "$1");
                try {
                    path = Paths.get(stringPath, new String[0]);
                }
                catch (InvalidPathException invalidPathException2) {}
            }
        }
        return path;
    }
}

