/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IResourceSelectionChangeListener;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.logviewer.ICurrentLogFileListener;
import ro.amiq.dvt.logviewer.LogFileManager;
import ro.amiq.dvt.logviewer.LogViewerEditor;
import ro.amiq.dvt.logviewer.webview.LogViewerWebviewManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.waveviewer.CurrentWaveStatusBarIndicator;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.utils.DVTFileUtils;

public enum CurrentLogFileStatusBarIndicator implements ICurrentLogFileListener,
IResourceChangeListener,
IResourceSelectionChangeListener
{
    INSTANCE;

    private static final String N_A = "N/A";
    private static final String CURRENT_LOG_FILE_NOT_SET = "No current log file";
    private Label label;
    private Button button;
    private Composite trimToolbar;

    public void init() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            this.trimToolbar = DVTUiUtils.getTrimToolbarParent((Composite)DVTUiUtils.getActiveWorkbenchShell());
            if (this.trimToolbar == null) {
                DVTLogger.INSTANCE.logError("Current log file status bar not initialized. Trim toolbar could not be found.");
                return;
            }
            Composite composite = new Composite(this.trimToolbar, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).spacing(2, 0).margins(2, 0).applyTo(composite);
            this.button = new Button(composite, 0);
            this.button.setImage(DVTImages.imageCache.getImage(DVTImages.LOGVIEWER_FILE_PIN));
            this.button.setEnabled(false);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.button);
            this.label = new Label(composite, 0);
            this.label.setToolTipText(CURRENT_LOG_FILE_NOT_SET);
            this.label.setText(N_A);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.label);
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IProject lastSelectedProject = DVTPlugin.getSelectionManager().getLastSelectedProject();
                    if (lastSelectedProject == null) {
                        return;
                    }
                    String logFilePath = LogFileManager.INSTANCE.getAssociatedLogFilePath(lastSelectedProject);
                    if (logFilePath == null) {
                        return;
                    }
                    IWorkbenchPage page = CurrentLogFileStatusBarIndicator.this.getActivePage();
                    if (page == null) {
                        return;
                    }
                    LogViewerEditor editor = LogViewerWebviewManager.INSTANCE.findLogViewerEditor(page, logFilePath);
                    if (editor == null) {
                        return;
                    }
                    page.activate((IWorkbenchPart)editor);
                }
            });
            LogFileManager.INSTANCE.addCurrentLogFileListener(this);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            DVTPlugin.getSelectionManager().addResourceSelectionChangeListener(Utils.getActiveWorkbenchWindow(), (IResourceSelectionChangeListener)this);
            composite.moveBelow((Control)CurrentWaveStatusBarIndicator.INSTANCE.getWaveStatusComposite());
            this.trimToolbar.addDisposeListener(e -> this.dispose());
            this.trimToolbar.layout();
        });
    }

    private IWorkbenchPage getActivePage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    private void dispose() {
        LogFileManager.INSTANCE.removeCurrentLogFileListener(this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        DVTPlugin.getSelectionManager().removeResourceSelectionChangeListener(Utils.getActiveWorkbenchWindow(), (IResourceSelectionChangeListener)this);
    }

    @Override
    public void notifyCurrentLogFileChanged(IProject project) {
        String logFilePath = LogFileManager.INSTANCE.getAssociatedLogFilePath(project);
        IFile file = DVTFileUtils.getInstance().findProjectFile(project, logFilePath);
        IPath location = file == null ? null : file.getLocation();
        String toolTipText = location == null ? null : "Current log file: " + location.toOSString();
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (toolTipText == null || location == null) {
                this.label.setToolTipText(CURRENT_LOG_FILE_NOT_SET);
                this.label.setText(N_A);
                this.button.setToolTipText(CURRENT_LOG_FILE_NOT_SET);
                this.button.setEnabled(false);
            } else {
                this.label.setToolTipText(toolTipText);
                this.label.setText(location.lastSegment());
                this.button.setToolTipText(String.valueOf(toolTipText) + " (click to reveal)");
                this.button.setEnabled(true);
            }
            if (this.trimToolbar != null) {
                this.trimToolbar.layout();
            }
            IProject lastSelectedProject = DVTPlugin.getSelectionManager().getLastSelectedProject();
            WaveDiagramEditor inputWaveEditor = DVTWaveViewIDEFactory.getInstance().getInputWaveEditor(lastSelectedProject);
            if (inputWaveEditor == null) {
                return;
            }
            DVTVCDUtils.getInstance().updateLogViewerActionButton((WCanvas)inputWaveEditor.getCanvas());
        });
    }

    public void resourceSelectionChanged(IResource resource) {
        if (resource != null && !(resource instanceof IProject)) {
            resource = resource.getProject();
        }
        if (!(resource instanceof IProject)) {
            return;
        }
        this.notifyCurrentLogFileChanged((IProject)resource);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getDelta() != null) {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta == null) {
                            return false;
                        }
                        if (delta.getResource() instanceof IProject && delta.getFlags() == 16384) {
                            CurrentLogFileStatusBarIndicator.this.notifyCurrentLogFileChanged((IProject)delta.getResource());
                            return false;
                        }
                        return delta.getResource() instanceof IWorkspaceRoot;
                    }
                });
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

