/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Canvas;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.logviewer.LogFileManager;
import ro.amiq.dvt.logviewer.LogViewerConsole;
import ro.amiq.dvt.logviewer.LogViewerConst;
import ro.amiq.dvt.logviewer.LogViewerContributorUtils;
import ro.amiq.dvt.logviewer.LogViewerEmptyFileException;
import ro.amiq.dvt.logviewer.LogViewerListener;
import ro.amiq.dvt.logviewer.LogViewerShutdownException;
import ro.amiq.dvt.logviewer.LogViewerShutdownJob;
import ro.amiq.dvt.logviewer.LogViewerUtils;
import ro.amiq.dvt.logviewer.indexing.LogViewerAttributeType;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructure;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructureCategory;
import ro.amiq.dvt.logviewer.indexing.LogViewerIndexingJob;
import ro.amiq.dvt.logviewer.indexing.LogViewerRefreshIndexingJob;
import ro.amiq.dvt.logviewer.query.LogViewerAttributeWrapper;
import ro.amiq.dvt.logviewer.query.LogViewerFinder;
import ro.amiq.dvt.logviewer.query.LogViewerFinderJob;
import ro.amiq.dvt.logviewer.query.LogViewerQueryWrapper;
import ro.amiq.dvt.logviewer.query.LogViewerSearchJob;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerContentAssistProvider;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerQueryParserUtils;
import ro.amiq.dvt.logviewer.webview.LogViewerRequestsManager;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerComputeFilterProposalsParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerComputeFilterProposalsResponse;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerFilterStatus;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerGetSearchMatchResponse;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerHandleFilterChangeResponse;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerHandleFullIndexingResponse;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerHandleTimeRulerDoubleClickParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerRefreshIndexingResponse;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerStatusMessageType;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerUpdateEntriesParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerUpdateHyperlinksParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerUpdateResultsNumberParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerValidateSearchResponse;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IXvmFactoryInitListener;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.utils.DVTConsoleHyperlinkUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public class LogFile {
    private IProject associatedProject;
    private final String filePath;
    private String pathInsideArchive;
    private final boolean isArchive;
    private Path configDirectoryLocation;
    private boolean fileInReadOnlyLocation;
    private FSDirectory indexDirectory;
    private Analyzer analyzer;
    private IndexWriter indexWriter;
    private LogViewerIndexingJob indexingJob;
    private final LogViewerFinder finder;
    private final Object finderLock = new Object();
    private volatile boolean isShutDown;
    private final Object configurationLock = new Object();
    private final List<LogViewerEntryStructure> entryStructures;
    private final LinkedHashMap<String, LogViewerAttributeType> allAttributes;
    private LogViewerFinderJob crtFinderJob;
    private LogViewerQueryWrapper crtQueryWrapper;
    private LogViewerSearchJob crtSearchJob;
    private Query crtSearchQuery;
    private final Object searchLock = new Object();
    private LogViewerListener logViewerListener;
    private String uvmTestTop;

    protected LogFile(String filePath) throws LogViewerEmptyFileException {
        if (LogViewerUtils.getFileSize(Paths.get(filePath, new String[0])) == 0L) {
            throw new LogViewerEmptyFileException();
        }
        this.filePath = filePath;
        this.configDirectoryLocation = Paths.get(filePath, new String[0]).getParent();
        this.isArchive = this.isArchive(filePath);
        this.entryStructures = new ArrayList<LogViewerEntryStructure>();
        this.allAttributes = new LinkedHashMap();
        this.initStructures();
        this.finder = new LogViewerFinder(this);
        this.indexingJob = new LogViewerIndexingJob(this);
        this.indexingJob.schedule();
        this.logViewerListener = new LogViewerListener(this);
        DVTMixedLangModelManager.getInstance().addXvmFactoryInitListeners((IXvmFactoryInitListener)this.logViewerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureIndexing() throws IOException, LogViewerShutdownException {
        if (this.isShutDown) {
            throw new LogViewerShutdownException();
        }
        Path configDirPath = null;
        Object object = this.configurationLock;
        synchronized (object) {
            if (this.isShutDown) {
                throw new LogViewerShutdownException();
            }
            if (this.indexDirectory != null) {
                return;
            }
            configDirPath = this.initConfigDirectory();
            this.indexDirectory = this.openIndexDirectory(this.filePath);
            this.analyzer = new WhitespaceAnalyzer();
            this.indexWriter = this.createIndexWriter();
        }
        if (configDirPath != null) {
            LogViewerContributorUtils.get().refreshConfigDirectory(configDirPath, this.filePath, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIndexingConfiguration() throws IOException {
        if (this.isShutDown) {
            return;
        }
        Object object = this.configurationLock;
        synchronized (object) {
            if (this.isShutDown) {
                return;
            }
            if (this.indexDirectory != null) {
                this.indexDirectory.close();
            }
            this.indexWriter = null;
            this.analyzer = null;
            this.indexDirectory = null;
        }
    }

    public boolean isArchive() {
        return this.isArchive;
    }

    public String getPathInsideArchive() {
        return this.pathInsideArchive;
    }

    public Path getConfigDirectoryLocation() {
        return this.configDirectoryLocation;
    }

    private boolean isArchive(String filePath) {
        boolean isZipArchive = this.isZIPArchive(filePath);
        if (isZipArchive) {
            this.pathInsideArchive = this.findPathInsideArchive(filePath);
            return true;
        }
        String fileExtension = FilenameUtils.getExtension((String)filePath);
        String[] stringArray = LogViewerConst.ARCHIVE_EXTENSIONS;
        int n = LogViewerConst.ARCHIVE_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (extension.equals(fileExtension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isZIPArchive(String filePath) {
        File file = new File(filePath);
        int fileSignature = 0;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                fileSignature = raf.readInt();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        int[] nArray = LogViewerConst.ZIP_SIGNATURES;
        int n = LogViewerConst.ZIP_SIGNATURES.length;
        int n2 = 0;
        while (n2 < n) {
            int zipFileSig = nArray[n2];
            if (fileSignature == zipFileSig) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findPathInsideArchive(String zipPath) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ZipFile zipFile = new ZipFile(zipPath);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                if (!entries.hasMoreElements()) {
                    return null;
                }
                ZipEntry entry = entries.nextElement();
                if (!entries.hasMoreElements()) return entry.getName();
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Path initConfigDirectory() throws IOException {
        Path configDirPath = this.configDirectoryLocation.resolve(LogViewerConst.logViewerDirectoryName(this.filePath));
        if (this.configDirectoryLocation == null) {
            return null;
        }
        if (Files.isDirectory(configDirPath, new LinkOption[0])) {
            return configDirPath;
        }
        try {
            Files.createDirectory(configDirPath, new FileAttribute[0]);
            LogViewerContributorUtils.get().refreshConfigDirectory(configDirPath, this.filePath, true);
        }
        catch (IOException e) {
            if (this.fileInReadOnlyLocation) {
                throw e;
            }
            this.updateConfigDirectoryLocation();
            this.initConfigDirectory();
        }
        return configDirPath;
    }

    private FSDirectory openIndexDirectory(String filePath) throws IOException {
        try {
            Path indexDirPath = LogViewerUtils.getIndexDirectoryPath(filePath, this.configDirectoryLocation);
            return FSDirectory.open((Path)indexDirPath);
        }
        catch (IOException e) {
            if (this.fileInReadOnlyLocation) {
                throw e;
            }
            this.updateConfigDirectoryLocation();
            return this.openIndexDirectory(filePath);
        }
    }

    protected void updateConfigDirectoryLocation() {
        this.fileInReadOnlyLocation = true;
        this.configDirectoryLocation = LogViewerContributorUtils.get().getWorkspaceLocation(this.filePath);
    }

    public boolean isFileInReadOnlyLocation() {
        return this.fileInReadOnlyLocation;
    }

    private IndexWriter createIndexWriter() throws IOException {
        IndexWriterConfig config = new IndexWriterConfig(this.analyzer);
        config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        config.setRAMBufferSizeMB(1024.0);
        return new IndexWriter((Directory)this.indexDirectory, config);
    }

    public void initStructures() {
        this.entryStructures.clear();
        Set<LogViewerEntryStructure> enabledStructures = this.fetchEnabledStructures();
        this.entryStructures.addAll(enabledStructures);
        this.entryStructures.forEach(struct -> this.allAttributes.putAll(struct.getAttributes()));
        this.allAttributes.putIfAbsent("log_line", LogViewerAttributeType.LONG);
        this.allAttributes.putIfAbsent("entry_structure", LogViewerAttributeType.WORD);
        this.allAttributes.putAll(LogViewerConst.FALLBACK_STRUCTURE.getAttributes());
    }

    private Set<LogViewerEntryStructure> fetchEnabledStructures() {
        LinkedHashSet<LogViewerEntryStructure> enabledStructures = new LinkedHashSet<LogViewerEntryStructure>();
        Set<LogViewerEntryStructureCategory> categories = LogViewerUtils.fetchEntryStructureCategories(this.filePath, this.configDirectoryLocation);
        if (categories == null) {
            return enabledStructures;
        }
        for (LogViewerEntryStructureCategory category : categories) {
            Set<LogViewerEntryStructure> structures;
            if (category == null || (structures = category.getStructures()) == null) continue;
            for (LogViewerEntryStructure structure : structures) {
                if (structure == null || !structure.isEnabled()) continue;
                enabledStructures.add(structure);
            }
        }
        return enabledStructures;
    }

    public boolean hasLatestStructures() {
        Set<LogViewerEntryStructure> enabledStructures = this.fetchEnabledStructures();
        ArrayList<LogViewerEntryStructure> crtStructuresList = new ArrayList<LogViewerEntryStructure>(enabledStructures);
        return this.entryStructures.equals(crtStructuresList);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public LogViewerHandleFilterChangeResponse handleFilterChange(String filterText, boolean validateOnly) {
        StringBuilder statusMessage = new StringBuilder();
        LogViewerQueryWrapper queryWrapper = LogViewerQueryParserUtils.parseQuery(filterText, this.allAttributes, this.entryStructures, this.indexingJob.didFinish(), true, statusMessage);
        if (!validateOnly) {
            this.cancelActiveFinderJob(false);
            this.crtQueryWrapper = queryWrapper;
        }
        if (queryWrapper == null) {
            LogViewerFilterStatus filterStatus = new LogViewerFilterStatus(false, statusMessage.toString(), LogViewerStatusMessageType.ERROR);
            return new LogViewerHandleFilterChangeResponse(filterStatus, 0);
        }
        LogViewerFilterStatus filterStatus = queryWrapper.isTextualInput() ? new LogViewerFilterStatus(false, "The query will be applied on all the log entries attributes.", LogViewerStatusMessageType.INFO) : LogViewerFilterStatus.OK_STATUS;
        if (!statusMessage.isEmpty()) {
            filterStatus = new LogViewerFilterStatus(false, statusMessage.toString(), LogViewerStatusMessageType.WARNING);
        }
        Integer resultsNumber = null;
        if (!validateOnly && this.indexingJob.didFinish()) {
            resultsNumber = this.finder.count(this.crtQueryWrapper.getQuery());
            LogViewerRequestsManager.INSTANCE.updateResultsNumber(new LogViewerUpdateResultsNumberParams(this.filePath, resultsNumber));
        }
        return new LogViewerHandleFilterChangeResponse(filterStatus, resultsNumber);
    }

    public void updateHyperlinks() {
        LogViewerRequestsManager.INSTANCE.updateHyperlinks(new LogViewerUpdateHyperlinksParams(this.filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEntryPage(int pageIndex) {
        if (!DVTPlugin.getDefault().collect().c()) {
            LogViewerConsole.INSTANCE.logError("No DVT license available!");
            return;
        }
        if (pageIndex < 0) {
            return;
        }
        if (this.crtQueryWrapper == null) {
            LogViewerUpdateEntriesParams params = new LogViewerUpdateEntriesParams(this.filePath, pageIndex, Collections.emptyList(), true);
            LogViewerRequestsManager.INSTANCE.updateLogEntries(params);
            return;
        }
        Object object = this.finderLock;
        synchronized (object) {
            if (this.crtFinderJob != null && Objects.equals(this.crtFinderJob.getQueryWrapper(), this.crtQueryWrapper)) {
                this.crtFinderJob.findPage(pageIndex);
                return;
            }
            this.cancelActiveFinderJob(false);
            this.crtFinderJob = new LogViewerFinderJob(this.crtQueryWrapper, pageIndex, this.finder, this.indexingJob);
            this.crtFinderJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelActiveFinderJob(boolean await) {
        LogViewerFinderJob finderJob = null;
        Object object = this.finderLock;
        synchronized (object) {
            if (this.crtFinderJob == null) {
                return;
            }
            finderJob = this.crtFinderJob;
            finderJob.cancel();
        }
        if (!await) {
            return;
        }
        try {
            finderJob.join();
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFinderJob(LogViewerFinderJob job) {
        Object object = this.finderLock;
        synchronized (object) {
            if (this.crtFinderJob == job) {
                this.crtFinderJob = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelActiveSearchJob(boolean await) {
        LogViewerSearchJob searchJob = null;
        Object object = this.searchLock;
        synchronized (object) {
            if (this.crtSearchJob == null) {
                return;
            }
            searchJob = this.crtSearchJob;
            searchJob.cancel();
        }
        if (!await) {
            return;
        }
        try {
            searchJob.join();
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSearchJob(LogViewerSearchJob job) {
        Object object = this.searchLock;
        synchronized (object) {
            if (this.crtSearchJob == job) {
                this.crtSearchJob = null;
            }
        }
    }

    public LogViewerComputeFilterProposalsResponse computeFilterProposals(LogViewerComputeFilterProposalsParams params) {
        Set<String> proposals = LogViewerContentAssistProvider.computeFilterProposals(params.getFilterText(), params.getCursorPosition(), this.entryStructures, this.allAttributes);
        return new LogViewerComputeFilterProposalsResponse(proposals);
    }

    public LogViewerHandleFullIndexingResponse handleFullIndexing() {
        this.indexingJob.enforceFullIndexing();
        return LogViewerHandleFullIndexingResponse.success();
    }

    public int getResultsNumber() {
        if (this.crtQueryWrapper == null) {
            return 0;
        }
        int resultsNumber = this.finder.count(this.crtQueryWrapper.getQuery());
        return resultsNumber;
    }

    public void handleHyperlink(String attributeName, Map<String, LogViewerAttributeWrapper> attributeValues) {
        if (attributeValues == null || this.associatedProject == null) {
            return;
        }
        String structureName = attributeValues.get("entry_structure").getAttributeValue();
        LogViewerEntryStructure structure = this.getEntryStructure(structureName);
        if (structure == null) {
            return;
        }
        LogViewerAttributeType attrType = structure.getAttributeType(attributeName);
        if (attrType == null) {
            return;
        }
        String attrValue = attributeValues.get(attributeName).getAttributeValue();
        if (attrValue != null) {
            attrValue = attrValue.trim();
        }
        switch (attrType) {
            case FILE_AND_LINE: {
                String filePathAttr = structure.getAttributeName(LogViewerAttributeType.FILE_PATH);
                attrValue = attributeValues.get(filePathAttr).getAttributeValue();
            }
            case FILE_PATH: {
                String fileLineAttr = structure.getAttributeName(LogViewerAttributeType.FILE_LINE);
                int fileLine = 0;
                if (fileLineAttr != null) {
                    fileLine = Integer.parseInt(attributeValues.get(fileLineAttr).getAttributeValue());
                }
                String reportObject = this.getReportObject(attributeValues, structure);
                DVTConsoleHyperlinkUtils.getInstance().openFileHyperlink(this.associatedProject, attrValue, fileLine, reportObject, this.getUvmTestTop());
                return;
            }
            case WORD: 
            case REPORT_OBJECT: {
                attrValue = DVTStringUtil.replaceAll((Pattern)LogViewerConst.UVM_SEQUENCE_ITEM_PATTERN, (CharSequence)attrValue, (String)"");
                DVTConsoleHyperlinkUtils.getInstance().openHierarchyPathHyperlink(this.associatedProject, attrValue, this.getUvmTestTop());
            }
        }
    }

    private String getReportObject(Map<String, LogViewerAttributeWrapper> attributeValues, LogViewerEntryStructure structure) {
        String reportObjectName = structure.getAttributeName(LogViewerAttributeType.REPORT_OBJECT);
        if (reportObjectName == null) {
            return null;
        }
        String reportObject = attributeValues.get(reportObjectName).getAttributeValue();
        if (reportObject != null) {
            reportObject = DVTStringUtil.replaceAll((Pattern)LogViewerConst.UVM_SEQUENCE_ITEM_PATTERN, (CharSequence)reportObject.trim(), (String)"");
        }
        return reportObject;
    }

    private LogViewerEntryStructure getEntryStructure(String structureName) {
        if (this.entryStructures == null || this.entryStructures.isEmpty()) {
            return null;
        }
        if (structureName == null) {
            return null;
        }
        if (structureName.equals("N/A")) {
            return LogViewerConst.FALLBACK_STRUCTURE;
        }
        for (LogViewerEntryStructure structure : this.entryStructures) {
            if (structure == null || !structureName.equals(structure.getName())) continue;
            return structure;
        }
        return null;
    }

    public LogViewerValidateSearchResponse validateSearch(String searchText) {
        this.crtSearchQuery = null;
        if (searchText == null || searchText.isBlank()) {
            return LogViewerValidateSearchResponse.invalid(null, null, null);
        }
        StringBuilder statusMessage = new StringBuilder();
        LogViewerQueryWrapper queryWrapper = LogViewerQueryParserUtils.parseQuery(searchText, this.allAttributes, this.entryStructures, true, false, statusMessage);
        if (queryWrapper == null) {
            return LogViewerValidateSearchResponse.invalid(statusMessage.toString(), LogViewerStatusMessageType.ERROR.toString(), null);
        }
        this.crtSearchQuery = queryWrapper.getQuery();
        if (this.crtSearchQuery == null) {
            return LogViewerValidateSearchResponse.invalid("Invalid filtering clause!", LogViewerStatusMessageType.ERROR.toString(), null);
        }
        BooleanQuery fullQuery = new BooleanQuery.Builder().add(this.crtQueryWrapper.getQuery(), BooleanClause.Occur.MUST).add(this.crtSearchQuery, BooleanClause.Occur.MUST).build();
        int matchCount = this.finder.count((Query)fullQuery);
        if (queryWrapper.isTextualInput()) {
            return LogViewerValidateSearchResponse.invalid("The query will be applied on all the log entries attributes.", LogViewerStatusMessageType.INFO.toString(), matchCount);
        }
        return LogViewerValidateSearchResponse.valid(matchCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<LogViewerGetSearchMatchResponse> getSearchMatch(boolean forward, long anchorLogLine) {
        if (this.crtSearchQuery == null || this.crtQueryWrapper == null) {
            return CompletableFuture.completedFuture(null);
        }
        Object object = this.searchLock;
        synchronized (object) {
            this.cancelActiveSearchJob(false);
            LogViewerSearchJob searchJob = new LogViewerSearchJob(this.crtSearchQuery, forward, anchorLogLine, this.crtQueryWrapper, this.finder, this.filePath);
            searchJob.schedule();
            return searchJob.getCompletableFuture();
        }
    }

    public LogViewerComputeFilterProposalsResponse computeSearchProposals(LogViewerComputeFilterProposalsParams params) {
        Set<String> proposals = LogViewerContentAssistProvider.computeSearchProposals(params.getFilterText(), params.getCursorPosition(), this.entryStructures, this.allAttributes);
        return new LogViewerComputeFilterProposalsResponse(proposals);
    }

    public Long showTimeInWaveformViewer(LogViewerHandleTimeRulerDoubleClickParams params) {
        if (params == null) {
            return null;
        }
        String timestamp = params.getTimestamp();
        if (timestamp == null) {
            return null;
        }
        Long timestampLong = Long.valueOf(timestamp);
        if (timestampLong == null) {
            return null;
        }
        IProject project = DVTVCDUtils.getInstance().getLastSelectedProject();
        if (!DVTWaveViewIDEFactory.getInstance().isVcdSetAsInput(project)) {
            DVTVCDUtils.getInstance().displayWarning("Log Viewer", "No current waveform viewer");
            return null;
        }
        WaveDiagramEditor inputWaveEditor = DVTWaveViewIDEFactory.getInstance().getInputWaveEditor(project);
        if (inputWaveEditor == null) {
            return null;
        }
        Canvas canvas = inputWaveEditor.getCanvas();
        if (!(canvas instanceof WCanvas var7_8)) {
            return null;
        }
        if (!DVTVCDUtils.isTimeValidInVcd((long)timestampLong, (WCanvas)wCanvas)) {
            DVTVCDUtils.getInstance().displayWarning("Log Viewer", "Simulation time is not valid in " + DVTVCDUtils.getSourceFileName((WViewport)wCanvas.getViewport()));
            return null;
        }
        return timestampLong;
    }

    public CompletableFuture<LogViewerRefreshIndexingResponse> refreshIndexing(boolean enforceFullIndexing) {
        LogViewerRefreshIndexingJob refreshJob = new LogViewerRefreshIndexingJob(this, enforceFullIndexing);
        refreshJob.schedule();
        return refreshJob.getCompletableFuture();
    }

    public LogViewerIndexingJob getIndexingJob() {
        return this.indexingJob;
    }

    public void setIndexingJob(LogViewerIndexingJob indexingJob) {
        this.indexingJob = indexingJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDirectory getIndexDirectory() throws LogViewerShutdownException {
        if (this.isShutDown) {
            throw new LogViewerShutdownException();
        }
        Object object = this.configurationLock;
        synchronized (object) {
            if (this.isShutDown) {
                throw new LogViewerShutdownException();
            }
            return this.indexDirectory;
        }
    }

    public LogViewerFinder getFinder() {
        return this.finder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexWriter getIndexWriter() throws LogViewerShutdownException {
        if (this.isShutDown) {
            throw new LogViewerShutdownException();
        }
        Object object = this.configurationLock;
        synchronized (object) {
            if (this.isShutDown) {
                throw new LogViewerShutdownException();
            }
            return this.indexWriter;
        }
    }

    public List<LogViewerEntryStructure> getEntryStructures() {
        return this.entryStructures;
    }

    public IProject getAssociatedProject() {
        return this.associatedProject;
    }

    public void setAssociatedProject(IProject associatedProject) {
        this.associatedProject = associatedProject;
    }

    public String getUvmTestTop() {
        if (this.uvmTestTop != null) {
            return this.uvmTestTop;
        }
        this.uvmTestTop = this.searchUvmTestTop();
        if (this.uvmTestTop != null) {
            return this.uvmTestTop;
        }
        this.uvmTestTop = "";
        return this.uvmTestTop;
    }

    private String searchUvmTestTop() {
        LogViewerQueryWrapper queryWrapper;
        String test;
        block3: {
            test = null;
            queryWrapper = LogViewerQueryParserUtils.parseQuery("message = \"+UVM_TESTNAME=\"", this.allAttributes, this.entryStructures, this.indexingJob.didFinish(), true, new StringBuilder());
            if (queryWrapper != null) break block3;
            return null;
        }
        try {
            test = this.getTestName(this.finder.findFirst(queryWrapper));
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return test;
    }

    private String getTestName(Document doc) {
        if (doc == null) {
            return null;
        }
        String message = doc.get("message");
        Matcher matcher = LogViewerConst.INDEXING_UVM_TEST_PATTERN.matcher(message);
        if (!matcher.find()) {
            return null;
        }
        if (matcher.groupCount() < 2) {
            return null;
        }
        return matcher.group(1);
    }

    public LogViewerAttributeType getAttributeType(String attr) {
        return this.allAttributes.get(attr);
    }

    public void setFinsihedIndexing(boolean finishedIndexing) {
        this.finder.setFinishedIndexing(finishedIndexing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.configurationLock;
        synchronized (object) {
            this.isShutDown = true;
        }
        LogViewerShutdownJob shutdownJob = new LogViewerShutdownJob(this.filePath, this.finder, this.crtFinderJob, this.indexingJob, this.crtSearchJob, this.analyzer, this.indexDirectory);
        LogFileManager.INSTANCE.shutdown(this, shutdownJob);
        DVTMixedLangModelManager.getInstance().removeXvmFactoryInitListeners((IXvmFactoryInitListener)this.logViewerListener);
    }
}

