/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.logviewer.ICurrentLogFileListener;
import ro.amiq.dvt.logviewer.LogFile;
import ro.amiq.dvt.logviewer.LogViewerConsole;
import ro.amiq.dvt.logviewer.LogViewerConst;
import ro.amiq.dvt.logviewer.LogViewerEmptyFileException;
import ro.amiq.dvt.logviewer.LogViewerShutdownJob;
import ro.amiq.dvt.logviewer.webview.LogViewerRequestsManager;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerUpdateProjectAssociationParams;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum LogFileManager {
    INSTANCE;

    private final Map<String, LogFile> logFiles = new HashMap<String, LogFile>();
    private final Map<IProject, String> projectAssociationMap = new HashMap<IProject, String>();
    private final Map<LogFile, LogViewerShutdownJob> shutdownJobs = new LinkedHashMap<LogFile, LogViewerShutdownJob>();
    private final Set<ICurrentLogFileListener> currentLogFileListeners = new HashSet<ICurrentLogFileListener>(1);

    public LogFile getOrCreateLogFile(String filePath) {
        try {
            LogFile logFile = this.getLogFile(filePath);
            if (logFile != null) {
                return logFile;
            }
            logFile = new LogFile(filePath);
            this.logFiles.put(filePath, logFile);
            return logFile;
        }
        catch (LogViewerEmptyFileException e) {
            LogViewerConsole.INSTANCE.logError(LogViewerConst.fileOpeningErrorMessage(filePath, e));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            LogViewerConsole.INSTANCE.logError(LogViewerConst.fileOpeningErrorMessage(filePath, e));
        }
        return null;
    }

    public LogFile getLogFile(String filePath) {
        if (filePath == null) {
            return null;
        }
        return this.logFiles.get(filePath);
    }

    protected void shutdown(LogFile logFile, LogViewerShutdownJob shutdownJob) {
        if (logFile == null) {
            return;
        }
        String filePath = logFile.getFilePath();
        if (!this.logFiles.containsKey(filePath)) {
            return;
        }
        this.logFiles.remove(filePath);
        IProject associatedProject = logFile.getAssociatedProject();
        if (associatedProject != null) {
            this.clearProjectAssociation(associatedProject);
        }
        this.shutdownJobs.put(logFile, shutdownJob);
        shutdownJob.schedule();
    }

    protected void clearShutdownJob(LogViewerShutdownJob shutdownJob) {
        if (shutdownJob == null) {
            return;
        }
        this.shutdownJobs.entrySet().removeIf(entry -> entry.getValue() == shutdownJob);
    }

    public void awaitPrevShutdownJobs(LogFile logFile) {
        if (logFile == null) {
            return;
        }
        LinkedHashMap<LogFile, LogViewerShutdownJob> crtShutdownJobs = new LinkedHashMap<LogFile, LogViewerShutdownJob>(this.shutdownJobs);
        for (LogFile file : crtShutdownJobs.keySet()) {
            if (logFile == file || !Objects.equals(logFile.getFilePath(), file.getFilePath())) continue;
            ((LogViewerShutdownJob)((Object)crtShutdownJobs.get(file))).await();
        }
    }

    public String getAssociatedLogFilePath(IProject project) {
        if (project == null) {
            return null;
        }
        return this.projectAssociationMap.get(project);
    }

    public boolean isAssociatedProject(IProject project) {
        if (project == null) {
            return true;
        }
        return this.projectAssociationMap.keySet().contains(project);
    }

    public void associateProject(IProject project, String filePath) {
        LogFile logFile;
        if (this.isAssociatedProject(project)) {
            this.clearProjectAssociation(project);
        }
        if ((logFile = this.getLogFile(filePath)) != null) {
            logFile.setAssociatedProject(project);
        }
        this.projectAssociationMap.put(project, filePath);
        LogViewerRequestsManager.INSTANCE.updateProjectAssociation(new LogViewerUpdateProjectAssociationParams(filePath, project.getName(), true));
        this.notifyCurrentLogFileListeners(project);
    }

    public void clearProjectAssociation(IProject project) {
        if (!this.isAssociatedProject(project)) {
            return;
        }
        String filePath = this.projectAssociationMap.get(project);
        LogFile logFile = this.getLogFile(filePath);
        if (logFile != null) {
            logFile.setAssociatedProject(null);
        }
        LogViewerRequestsManager.INSTANCE.updateProjectAssociation(new LogViewerUpdateProjectAssociationParams(filePath, project.getName(), false));
        this.projectAssociationMap.remove(project);
        this.notifyCurrentLogFileListeners(null);
    }

    public boolean isLogFilesEmpty() {
        return this.logFiles.isEmpty();
    }

    public void addCurrentLogFileListener(ICurrentLogFileListener listener) {
        if (listener == null) {
            return;
        }
        this.currentLogFileListeners.add(listener);
    }

    public void removeCurrentLogFileListener(ICurrentLogFileListener listener) {
        if (listener == null) {
            return;
        }
        this.currentLogFileListeners.remove(listener);
    }

    private void notifyCurrentLogFileListeners(IProject project) {
        for (ICurrentLogFileListener listener : this.currentLogFileListeners) {
            listener.notifyCurrentLogFileChanged(project);
        }
    }
}

