/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import ro.amiq.dvt.logviewer.indexing.LogViewerAttributeType;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructure;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructureCategory;
import ro.amiq.dvt.logviewer.indexing.LogViewerIndexingWorker;
import ro.amiq.dvt.logviewer.query.LogViewerQueryWrapper;

public class LogViewerConst {
    private static final String LOG_VIEWER_DIRECTORY_NAME_FORMAT = ".dvt.%s";
    private static final String FILE_OPENING_ERROR_MESSAGE_FORMAT = "Error while opening %s : %s";
    protected static final String EMPTY_FILE_ERROR_MESSAGE = "File is empty!";
    public static final String INVALID_EDITOR_INPUT_ERROR_MESSAGE = "Invalid input: Must be an instance of LogViewerEditorInput!";
    public static final String NO_LICENSE_ERROR_MESSAGE = "No DVT license available!";
    public static final String INITIALIZATION_ERROR_MESSAGE = "Error while initializing the Log Viewer!";
    public static final String INITIALIZATION_STARTED_MESSAGE = "LogViewer components initialization started.";
    public static final String INITIALIZATION_FAILED_MESSAGE = "LogViewer components initialization failed!";
    public static final String TEXTUAL_INPUT_INFO_MESSAGE = "The query will be applied on all the log entries attributes.";
    public static final String CONSOLE_NAME = "DVT Log Viewer Console";
    private static final String FINDER_JOB_NAME_FORMAT = "LogViewer Finder Job - %s";
    private static final String INDEXING_JOB_NAME_FORMAT = "LogViewer Indexing Job - %s";
    private static final String SEARCH_JOB_NAME_FORMAT = "LogViewer Search Job - %s";
    private static final String SHUTDOWN_JOB_NAME_FORMAT = "LogViewer Shutdown Job - %s";
    private static final String REFRESH_JOB_NAME_FORMAT = "LogViewer Refresh Job - %s";
    private static final String CANCELED_JOB_MESSAGE_FORMAT = "Canceled %s.";
    public static final Long JOB_CANCELING_CHECK_PERIOD = 1000L;
    public static final String HIDE_COMMAND = "hide";
    public static final String SORTBY_COMMAND = "sort_by";
    public static final Set<String> COMMANDS = Set.of("hide", "sort_by");
    protected static final String STRUCTURES_CONFIG_FILE_NAME = "entryStructures.config";
    public static final Pattern STRUCTURE_PARSING_PATTERN = Pattern.compile("<(\\??\\w+)\\s*:\\s*(\\w+)>");
    private static final String RESERVED_ATTRIBUTE_ERROR_MESSAGE_FORMAT = "Attribute '%s' is reserved internally. Please use another attribute name.";
    private static final String DUPLICATE_ATTRIBUTE_ERROR_MESSAGE_FORMAT = "Duplicate attribute '%s'!";
    private static final String INVALID_ATTRIBUTE_TYPE_ERROR_MESSAGE_FORMAT = "Invalid attribute type '%s' - allowed values are " + LogViewerAttributeType.getEnumRegex();
    private static final String UNIQUE_ATTRIBUTE_TYPE_ERROR_MESSAGE_FORMAT = "Attribute type '%s' can only be used once!";
    public static final String MISSING_ATTRIBUTE_ERROR_MESSAGE = "At least one attribute must be extracted!";
    public static final String LOG_LINE_ATTRIBUTE_NAME = "log_line";
    public static final String ENTRY_STRUCTURE_ATTRIBUTE_NAME = "entry_structure";
    public static final Set<String> RESERVED_ATTRIBUTE_NAMES = Set.of("log_line", "entry_structure", "sort_by", "hide");
    public static final String SORTABLE_FIELD_SUFFIX = "_sortable";
    public static final SortField DEFAULT_SORT_FIELD = new SortField("log_line_sortable", SortField.Type.LONG);
    public static final Sort DEFAULT_SORT = new Sort(new SortField[]{DEFAULT_SORT_FIELD});
    public static final int FALLBACK_STRUCTURE_ID = -1;
    public static final String FALLBACK_STRUCTURE_NAME = "N/A";
    public static final String FALLBACK_ATTRIBUTE_NAME = "message";
    public static final LogViewerEntryStructure FALLBACK_STRUCTURE = LogViewerEntryStructure.createStructure("N/A", "<message:text>", true);
    private static final LogViewerEntryStructureCategory UVM_STRUCTURE_CATEGORY = new LogViewerEntryStructureCategory("UVM", new LinkedHashSet<LogViewerEntryStructure>(List.of(LogViewerEntryStructure.createStructure("Default UVM message", "<severity:uvm_severity> <?file_line_str:file_and_line>@ <timestamp:long><?timeunit:word>: <report_object_name:report_object> [<message_id:word>] <message:text>", true))));
    private static final LogViewerEntryStructureCategory VCS_STRUCTURE_CATEGORY = new LogViewerEntryStructureCategory("VCS", new LinkedHashSet<LogViewerEntryStructure>(List.of(LogViewerEntryStructure.createStructure("VCS Syntax Error Message", "<sim_severity:sim_severity>-[<message_id:text>] Syntax error<message:text><file:vcs_file_name>, <line:file_line>:<details:text>", false), LogViewerEntryStructure.createStructure("VCS Syntax Error Macro Message", "<sim_severity:sim_severity>-[<message_id:text>] Syntax error<message:text><file:vcs_file_name>, <line:file_line> (expanding macro):<details:text>", false), LogViewerEntryStructure.createStructure("VCS Source File Message", "<sim_severity:sim_severity>-[<message_id:text>] Source file cannot be opened<message:text><file:vcs_file_name>, <line:file_line><details:text>", false), LogViewerEntryStructure.createStructure("VCS Module Redeclared Message", "<sim_severity:sim_severity>-[<message_id:text>] Module previously declared<message:text>:<file:vcs_file_name>, <line:file_line>:<details:text>", false), LogViewerEntryStructure.createStructure("VCS Message Generic 1", "<sim_severity:sim_severity>-[<message_id:text>] <message:single_line_text><file:vcs_file_name>, <line:file_line><details:text>", false), LogViewerEntryStructure.createStructure("VCS Message Generic 2", "<sim_severity:sim_severity>-[<message_id:text>] <message:text>", false))));
    private static final LogViewerEntryStructureCategory QUESTA_STRUCTURE_CATEGORY = new LogViewerEntryStructureCategory("Questa", new LinkedHashSet<LogViewerEntryStructure>(List.of(LogViewerEntryStructure.createStructure("Questa Suppressible Message", "** <sim_severity:sim_severity> (suppressible): <?file:file_path>(<?line:file_line>): (<v_error_tool:word>-<v_error_id:int>)<message:text>", false), LogViewerEntryStructure.createStructure("Questa Message", "** <sim_severity:sim_severity>: <?file:file_path>(<?line:file_line>): (<v_error_tool:word>-<v_error_id:int>)<message:text>", false), LogViewerEntryStructure.createStructure("Questa Message Generic", "** <sim_severity:sim_severity>: <?file:file_path>(<?line:file_line>): <message:text>", false))));
    private static final LogViewerEntryStructureCategory IUS_STRUCTURE_CATEGORY = new LogViewerEntryStructureCategory("IUS", new LinkedHashSet<LogViewerEntryStructure>(List.of(LogViewerEntryStructure.createStructure("NC Tool UPF/CPF Message", "<nc_tool:ius_tool>: *<nc_severity:ius_severity>,<nc_error_code:word>: [LPS]<message:text> (<file:file_path>:<line:file_line>)<?details:text>.", false), LogViewerEntryStructure.createStructure("NC Tool Message 1", "<nc_tool:ius_tool>: *<nc_severity:ius_severity>,<nc_error_code:word> (<file:file_path>,<line:file_line>|<column:int>): <message:text>", false), LogViewerEntryStructure.createStructure("NC Tool Message 2", "<nc_tool:ius_tool>: *<nc_severity:ius_severity>,<nc_error_code:word> (<file:file_path>,<line:file_line>): <message:text>", false), LogViewerEntryStructure.createStructure("NC Tool Message Generic", "<nc_tool:ius_tool>: *<nc_severity:ius_severity>,<nc_error_code:word>: <message:text>", false))));
    public static final Set<LogViewerEntryStructureCategory> DEFAULT_STRUCTURE_CATEGORIES = new LinkedHashSet<LogViewerEntryStructureCategory>(List.of(UVM_STRUCTURE_CATEGORY, VCS_STRUCTURE_CATEGORY, QUESTA_STRUCTURE_CATEGORY, IUS_STRUCTURE_CATEGORY));
    protected static final String STRUCTURE_SERIALIZATION_ERROR_MESSAGE = "Failed to serialize the entry structures!";
    protected static final String STRUCTURE_DESERIALIZATION_ERROR_MESSAGE = "Failed to deserialize the entry structures!";
    protected static final String CHANGED_STRUCTURES_MESSAGE = "The entry structures were changed - restarting the indexing...";
    public static final String OPTIONAL_ATTRIBUTE_MARKER = "?";
    protected static final String INDEXING_DIRECTORY_NAME = ".indexing";
    protected static final String INDEXING_METADATA_FILE_NAME = ".indexing_metadata";
    public static final int DEFAULT_INDEXING_THREAD_NUM = 4;
    public static final int INDEXING_COMMIT_ENTRY_LIMIT = 20000;
    public static final long INDEXED_SLICE_TIME_LIMIT = 300L;
    public static final long INDEXED_ENTRY_SIZE_LIMIT = 0x100000L;
    public static final long MAX_FILE_BUFFER_SIZE = 0x10000000L;
    public static final long CANCEL_CHECK_FILE_SIZE = 0x20000000L;
    public static final String REUSING_INDEXING_MESSAGE = "The serialized indexing information will be reused.";
    public static final String DIRTY_INDEXING_METADATA_MESSAGE = "No serialized indexing metadata was found or it was not in sync.";
    private static final String WORKER_CREATION_MESSAGE_FORMAT = "Indexing worker %d created for %s";
    private static final String INDEXING_ERROR_MESSAGE_FORMAT = "Indexing worker %d: Could not index entry - %d logLine, %d lineCount";
    private static final String INDEXING_PROGRESS_MESSAGE_FORMAT = "Indexing worker %d: %d indexed entries, %d%% progress";
    private static final String ENFORCING_FULL_INDEXING_MESSAGE_FORMAT = "Enforcing full indexing for %s ...";
    private static final String FINISHED_INDEXING_MESSAGE_FORMAT = "Finished indexing %s :";
    private static final String CANCELED_INDEXING_MESSAGE_FORMAT = "Canceled indexing for %s :";
    private static final String WORKER_INDEXING_REPORT_MESSAGE_FORMAT = "Worker %d: %d entries, %d lines, %dms indexing time.";
    private static final String TOTAL_INDEXING_REPORT_MESSAGE_FORMAT = "Total: %d entries, %d lines, %dms indexing time.";
    protected static final String INDEXING_IN_PROGRESS_NOTIFICATION = "Indexing in progress...";
    protected static final String INDEXING_NOT_COMPLETE_NOTIFICATION = "Indexing is not complete - results computation may be slow.";
    protected static final String INDEXING_FINISHED_NOTIFICATION = "Indexing has been completed.";
    public static final String UVM_TEST_FILTER_TEXT = "message = \"+UVM_TESTNAME=\"";
    public static final Pattern INDEXING_UVM_TEST_PATTERN = Pattern.compile("\\+UVM_TESTNAME=(([^\\s]*))");
    public static final Pattern UVM_SEQUENCE_ITEM_PATTERN = Pattern.compile("@@.*$");
    public static final int DEFAULT_ENTRY_PAGE_SIZE = 100;
    public static final LogViewerQueryWrapper DEFAULT_QUERY_WRAPPER = new LogViewerQueryWrapper("", false, (Query)new MatchAllDocsQuery(), DEFAULT_SORT, Collections.emptySet());
    public static final Character ASCENDING_SORT_ORDER_CHAR = Character.valueOf('+');
    public static final Character DESCENDING_SORT_ORDER_CHAR = Character.valueOf('-');
    public static final String LOGICAL_AND = "&&";
    public static final String LOGICAL_OR = "||";
    public static final String LEFT_PARENTHESIS = "(";
    public static final String RIGHT_PARENTHESIS = ")";
    public static final String COMMAND_ATTRIBUTE_SEPARATOR = ",";
    public static final String INVALID_FILTERING_CLAUSE_MESSAGE = "Invalid filtering clause!";
    public static final String UNSUPPORTED_SORTBY_CLAUSE_MESSAGE = "The 'sort_by' clause is not supported until the indexing is completed!\n";
    private static final String NONEXISTING_ATTRIBUTE_MESSAGE_FORMAT = "Non-existing attribute '%s'!\n";
    private static final String SORTBY_INVALID_ATTRIBUTE_MESSAGE_FORMAT = "Cannot sort by the non-numeric attribute '%s'!\n";
    private static final String INVALID_INT_VALUE_MESSAGE_FORMAT = "The '%s' attribute only supports int values, but '%s' was provided!";
    private static final String INVALID_LONG_VALUE_MESSAGE_FORMAT = "The '%s' attribute only supports long values, but '%s' was provided!";
    private static final String INVALID_STRUCTURE_NAME_MESSAGE_FORMAT = "'%s' is not a valid structure name!";
    private static final String UNSUPPORTED_OPERATOR_MESSAGE_FORMAT = "The '%s' attribute only supports '=' and '!=' as operators!";
    private static final String REQUESTED_ENTRY_PAGE_MESSAGE_FORMAT = "Finder for %s matching '%s': Page %d was requested.";
    private static final String COMPLETED_ENTRY_PAGE_MESSAGE_FORMAT = "Finder for %s matching '%s': %d results found for page %d after %d ms.";
    private static final String SEARCH_UNSUPPORTED_COMMAND_MESSAGE_FORMAT = "The '%s' command cannot be used while searching!";
    public static final String[] ARCHIVE_EXTENSIONS = new String[]{"tar", "gz"};
    public static final int[] ZIP_SIGNATURES = new int[]{1347093252, 1347093766, 1347094280};
    public static final long TAR_GZ_HEADER_SIZE = 512L;

    private LogViewerConst() {
    }

    private static String getFileName(String filePath) {
        return Paths.get(filePath, new String[0]).getFileName().toString();
    }

    protected static String logViewerDirectoryName(String filePath) {
        return String.format(LOG_VIEWER_DIRECTORY_NAME_FORMAT, LogViewerConst.getFileName(filePath));
    }

    protected static String fileOpeningErrorMessage(String filePath, Throwable e) {
        return String.format(FILE_OPENING_ERROR_MESSAGE_FORMAT, filePath, e.getMessage());
    }

    public static String finderJobName(String filePath) {
        return String.format(FINDER_JOB_NAME_FORMAT, LogViewerConst.getFileName(filePath));
    }

    public static String searchJobName(String filePath) {
        return String.format(SEARCH_JOB_NAME_FORMAT, LogViewerConst.getFileName(filePath));
    }

    public static String indexingJobName(String filePath) {
        return String.format(INDEXING_JOB_NAME_FORMAT, LogViewerConst.getFileName(filePath));
    }

    public static String shutdownJobName(String filePath) {
        return String.format(SHUTDOWN_JOB_NAME_FORMAT, LogViewerConst.getFileName(filePath));
    }

    public static String refreshJobName(String filePath) {
        return String.format(REFRESH_JOB_NAME_FORMAT, LogViewerConst.getFileName(filePath));
    }

    public static String canceledJobMessage(String jobName) {
        return String.format(CANCELED_JOB_MESSAGE_FORMAT, jobName);
    }

    public static String reservedAttributeErrorMessage(String attributeName) {
        return String.format(RESERVED_ATTRIBUTE_ERROR_MESSAGE_FORMAT, attributeName);
    }

    public static String duplicateAttributeErrorMessage(String attributeName) {
        return String.format(DUPLICATE_ATTRIBUTE_ERROR_MESSAGE_FORMAT, attributeName);
    }

    public static String invalidAttributeTypeErrorMessage(String attributeType) {
        return String.format(INVALID_ATTRIBUTE_TYPE_ERROR_MESSAGE_FORMAT, attributeType);
    }

    public static String uniqueAttributeTypeErrorMessage(String attributeType) {
        return String.format(UNIQUE_ATTRIBUTE_TYPE_ERROR_MESSAGE_FORMAT, attributeType);
    }

    public static String workerCreationMessage(int workerId, Path filePath) {
        return String.format(WORKER_CREATION_MESSAGE_FORMAT, workerId, filePath.getFileName().toString());
    }

    public static String indexingErrorMessage(int workerId, int logLine, int lineCount) {
        return String.format(INDEXING_ERROR_MESSAGE_FORMAT, workerId, logLine, lineCount);
    }

    public static String indexingProgressMessage(int workerId, int nofIndexedEntries, long progress) {
        return String.format(INDEXING_PROGRESS_MESSAGE_FORMAT, workerId, nofIndexedEntries, progress);
    }

    public static String enforcingFullIndexingMessage(String filePath) {
        return String.format(ENFORCING_FULL_INDEXING_MESSAGE_FORMAT, filePath);
    }

    public static String finishedIndexingMessage(String filePath) {
        return String.format(FINISHED_INDEXING_MESSAGE_FORMAT, filePath);
    }

    public static String canceledIndexingMessage(String filePath) {
        return String.format(CANCELED_INDEXING_MESSAGE_FORMAT, filePath);
    }

    public static String workerIndexingReportMessage(LogViewerIndexingWorker worker) {
        return String.format(WORKER_INDEXING_REPORT_MESSAGE_FORMAT, worker.getWorkerId(), worker.getNofIndexedEntries(), worker.getNofIndexedLines(), worker.getIndexingTime());
    }

    public static String totalIndexingReportMessage(int nofEntries, int nofLines, long time) {
        return String.format(TOTAL_INDEXING_REPORT_MESSAGE_FORMAT, nofEntries, nofLines, time);
    }

    public static String nonExistingAttributeMessage(String attribute) {
        return String.format(NONEXISTING_ATTRIBUTE_MESSAGE_FORMAT, attribute);
    }

    public static String sortByInvalidAttributeMessage(String attribute) {
        return String.format(SORTBY_INVALID_ATTRIBUTE_MESSAGE_FORMAT, attribute);
    }

    public static String invalidIntValueMessage(String attribute, String variable) {
        return String.format(INVALID_INT_VALUE_MESSAGE_FORMAT, attribute, variable);
    }

    public static String invalidLongValueMessage(String attribute, String variable) {
        return String.format(INVALID_LONG_VALUE_MESSAGE_FORMAT, attribute, variable);
    }

    public static String invalidStructureNameMessage(String attribute) {
        return String.format(INVALID_STRUCTURE_NAME_MESSAGE_FORMAT, attribute);
    }

    public static String unsupportedOperatorMessage(String attribute) {
        return String.format(UNSUPPORTED_OPERATOR_MESSAGE_FORMAT, attribute);
    }

    public static String requestedEntryPageMessage(String filePath, String filterText, int pageIndex) {
        return String.format(REQUESTED_ENTRY_PAGE_MESSAGE_FORMAT, LogViewerConst.getFileName(filePath), filterText, pageIndex);
    }

    public static String completedEntryPageMessage(String filePath, String filterText, int nofResults, int pageIndex, long time) {
        return String.format(COMPLETED_ENTRY_PAGE_MESSAGE_FORMAT, LogViewerConst.getFileName(filePath), filterText, nofResults, pageIndex, time);
    }

    public static String searchUnsupportedSortbyMessage() {
        return String.format(SEARCH_UNSUPPORTED_COMMAND_MESSAGE_FORMAT, SORTBY_COMMAND);
    }

    public static String searchUnsupportedHideMessage() {
        return String.format(SEARCH_UNSUPPORTED_COMMAND_MESSAGE_FORMAT, HIDE_COMMAND);
    }
}

