/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.internal.resources.LocalMetaArea;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.logviewer.LogFileManager;
import ro.amiq.dvt.logviewer.LogViewerContributorCommon;
import ro.amiq.dvt.logviewer.LogViewerEditor;
import ro.amiq.dvt.logviewer.LogViewerProjectManager;
import ro.amiq.dvt.logviewer.webview.ILogViewerWebview;
import ro.amiq.dvt.logviewer.webview.LogViewerWebviewManager;
import ro.amiq.dvt.resourcefilters.ResourceFilters;
import ro.amiq.dvt.resourcefilters.ResourceFiltersManager;
import ro.amiq.dvt.startup.core.DVTLogger;

public class LogViewerContributor
extends LogViewerContributorCommon {
    public void openLogViewerWithQuery(IProject project, String query) {
        if (project == null) {
            return;
        }
        String logFilePath = LogFileManager.INSTANCE.getAssociatedLogFilePath(project);
        if (logFilePath == null) {
            return;
        }
        IWorkbenchPage page = DVTPlugin.getActivePage();
        if (page == null) {
            return;
        }
        LogViewerEditor editor = LogViewerWebviewManager.INSTANCE.findLogViewerEditor(page, logFilePath);
        if (editor == null) {
            return;
        }
        ILogViewerWebview webview = LogViewerWebviewManager.INSTANCE.getWebview(logFilePath);
        webview.updateSearchText(query);
        page.activate((IWorkbenchPart)editor);
    }

    @Override
    public IProject getLastSelectedProject() {
        return DVTPlugin.getSelectionManager().getLastSelectedProject();
    }

    public IProject getProject(String filePath) {
        return LogViewerProjectManager.INSTANCE.getProject(filePath);
    }

    public void refreshConfigDirectory(Path configDirPath, String filePath, boolean addFilters) {
        IPath projectLocation;
        Path projectPath;
        Path relativePathToProject;
        if (!this.isFileInsideProject(filePath)) {
            return;
        }
        IProject project = this.getProject(filePath);
        IFolder folder = project.getFolder((relativePathToProject = (projectPath = Paths.get((projectLocation = project.getLocation()).toOSString(), new String[0])).relativize(configDirPath)).toString());
        if (folder == null) {
            return;
        }
        this.refreshFolder(folder, addFilters);
    }

    private void refreshFolder(final IFolder folder, boolean addFilters) {
        IProject project;
        if (addFilters && ResourceFiltersManager.INSTANCE.getActiveFiltersSelection(project = folder.getProject()) != ResourceFiltersManager.FiltersSelectionType.NONE) {
            ResourceFilters.applyAutoFiltersForResource((IContainer)folder, (IPath)folder.getLocation(), (boolean)false);
            return;
        }
        Job job = new Job("Refresh resource"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    folder.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public Path getWorkspaceLocation(String filePath) {
        IPath workingLocation;
        if (this.isFileInsideProject(filePath) && (workingLocation = this.getProject(filePath).getWorkingLocation("")) != null) {
            return Paths.get(workingLocation.toOSString(), new String[0]);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (!(workspace instanceof Workspace)) {
            return null;
        }
        LocalMetaArea metaArea = ((Workspace)workspace).getMetaArea();
        if (metaArea == null) {
            return null;
        }
        IPath location = metaArea.getLocation();
        if (location == null) {
            return null;
        }
        return Paths.get(location.toOSString(), new String[0]);
    }
}

