/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.logviewer.ILogViewerContributor;
import ro.amiq.dvt.logviewer.LogFile;
import ro.amiq.dvt.logviewer.LogFileManager;

public abstract class LogViewerContributorCommon
implements ILogViewerContributor {
    public void updateHyperlinks(IProject project) {
        String associatedLogFilePath = LogFileManager.INSTANCE.getAssociatedLogFilePath(project);
        if (associatedLogFilePath == null) {
            return;
        }
        LogFile logFile = LogFileManager.INSTANCE.getLogFile(associatedLogFilePath);
        if (logFile == null) {
            return;
        }
        logFile.updateHyperlinks();
    }

    public boolean isLogViewerSet() {
        IProject lastSelectedProject = this.getLastSelectedProject();
        if (lastSelectedProject == null) {
            return false;
        }
        String logFilePath = LogFileManager.INSTANCE.getAssociatedLogFilePath(lastSelectedProject);
        return logFilePath != null;
    }

    public abstract IProject getLastSelectedProject();

    protected boolean isFileInsideProject(String filePath) {
        IProject project = this.getProject(filePath);
        if (project == null) {
            return false;
        }
        if (!project.isAccessible()) {
            return false;
        }
        IPath projectLocation = project.getLocation();
        if (projectLocation == null) {
            return false;
        }
        Path path = Paths.get(filePath, new String[0]);
        if (path == null) {
            return false;
        }
        Path projectPath = Paths.get(projectLocation.toOSString(), new String[0]);
        return path.startsWith(projectPath) && !path.equals(projectPath);
    }
}

