/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.logviewer.LogViewerEditorInput;
import ro.amiq.dvt.logviewer.LogViewerEditorSelection;
import ro.amiq.dvt.logviewer.LogViewerProjectManager;
import ro.amiq.dvt.logviewer.webview.LogViewerConnectionManager;
import ro.amiq.dvt.logviewer.webview.LogViewerWebviewManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;

public class LogViewerEditor
extends EditorPart
implements ISelectionProvider {
    private String logFilePath;
    private Browser browser;
    private LogViewerConnectionManager connectionManager;
    private Composite parent;
    public static final String LOG_VIEWER_EDITOR_ID = "ro.amiq.dvt.logviewer.LogViewerEditor";
    private ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList(1);
    private LogViewerEditorSelection currentSelection = new LogViewerEditorSelection();

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!DVTPlugin.getDefault().collect().c()) {
            throw new PartInitException("No DVT license available!");
        }
        this.initFileEditorInput(site, input);
        if (this.logFilePath != null) {
            return;
        }
        this.initOutOfWorkspaceFileEditorInput(site, input);
        site.setSelectionProvider((ISelectionProvider)this);
        this.setSite((IWorkbenchPartSite)site);
    }

    private void initFileEditorInput(IEditorSite site, IEditorInput input) {
        if (input instanceof FileEditorInput var3_4) {
            input = new LogViewerEditorInput(fileEditorInput.getFile());
        } else {
            if (input instanceof LogViewerEditorInput var5_6) {
                input = new LogViewerEditorInput(logViewerEditorInput.getFile());
            } else {
                return;
            }
        }
        site.setSelectionProvider((ISelectionProvider)this);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput((IEditorInput)input);
        IFile file = ((LogViewerEditorInput)input).getFile();
        this.setPartName(file.getName());
        this.logFilePath = file.getLocation().toOSString();
        LogViewerProjectManager.INSTANCE.registerProject(this.logFilePath, file.getProject());
    }

    private void initOutOfWorkspaceFileEditorInput(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof FileStoreEditorInput)) {
            throw new PartInitException("Invalid input: Must be an instance of LogViewerEditorInput!");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        FileStoreEditorInput outsideWSFileEditorInput = (FileStoreEditorInput)input;
        this.setPartName(outsideWSFileEditorInput.getName());
        this.logFilePath = URIUtil.toPath((URI)outsideWSFileEditorInput.getURI()).toOSString();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new FillLayout());
        ((CompletableFuture)LogViewerConnectionManager.init(this.logFilePath).thenAccept(manager -> {
            this.connectionManager = manager;
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                this.browser = manager.getBrowser();
                this.browser.setParent(parent);
                this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
                parent.layout(true, true);
            });
        })).exceptionally(ex -> {
            DVTLogger.INSTANCE.logError(ex);
            return null;
        });
    }

    public Image getTitleImage() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof LogViewerEditorInput) {
            return super.getTitleImage();
        }
        return DVTImages.imageCache.getImage(DVTImages.LOGVIEWER_FILE_GRAY);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void setFocus() {
        this.parent.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public String getTitleToolTip() {
        return this.logFilePath;
    }

    public void dispose() {
        LogViewerWebviewManager.INSTANCE.clearWebview(this.logFilePath);
        if (!this.browser.isDisposed()) {
            this.browser.dispose();
        }
        this.browser = null;
        this.connectionManager.close();
        this.selectionChangedListeners.clear();
        this.selectionChangedListeners = null;
        this.currentSelection = null;
        super.dispose();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        DVTLogger.INSTANCE.logError((Throwable)new UnsupportedOperationException());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            return this.getEditorInput().getAdapter(IResource.class);
        }
        return super.getAdapter(adapter);
    }
}

