/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.concurrent.CountDownLatch;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.FSDirectory;
import ro.amiq.dvt.logviewer.BaseLogViewerJob;
import ro.amiq.dvt.logviewer.LogFileManager;
import ro.amiq.dvt.logviewer.LogViewerConst;
import ro.amiq.dvt.logviewer.indexing.LogViewerIndexingJob;
import ro.amiq.dvt.logviewer.query.LogViewerFinder;
import ro.amiq.dvt.logviewer.query.LogViewerFinderJob;
import ro.amiq.dvt.logviewer.query.LogViewerSearchJob;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;

public class LogViewerShutdownJob
extends BaseLogViewerJob {
    private final LogViewerFinder finder;
    private final LogViewerFinderJob finderJob;
    private final LogViewerIndexingJob indexingJob;
    private final LogViewerSearchJob searchJob;
    private final Analyzer analyzer;
    private final FSDirectory indexDirectory;
    private final CountDownLatch doneLatch;

    protected LogViewerShutdownJob(String filePath, LogViewerFinder finder, LogViewerFinderJob finderJob, LogViewerIndexingJob indexingJob, LogViewerSearchJob searchJob, Analyzer analyzer, FSDirectory indexDirectory) {
        super(LogViewerConst.shutdownJobName(filePath));
        this.finder = finder;
        this.finderJob = finderJob;
        this.indexingJob = indexingJob;
        this.searchJob = searchJob;
        this.analyzer = analyzer;
        this.indexDirectory = indexDirectory;
        this.doneLatch = new CountDownLatch(1);
    }

    @Override
    protected void doWork() {
        try {
            try {
                this.cancelSearchJob();
                this.cancelFinderJob();
                this.clearFinderCaching();
                this.cancelIndexingJob();
                this.closeAnalyzer();
                this.closeIndexDirectory();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.doneLatch.countDown();
                LogFileManager.INSTANCE.clearShutdownJob(this);
            }
        }
        finally {
            this.doneLatch.countDown();
            LogFileManager.INSTANCE.clearShutdownJob(this);
        }
    }

    @Override
    protected Objection getObjection() {
        return Objection.LOG_VIEWER_SHUTDOWN;
    }

    private void cancelFinderJob() {
        try {
            if (this.finderJob == null) {
                return;
            }
            this.finderJob.cancel();
            this.finderJob.join();
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void cancelSearchJob() {
        try {
            if (this.searchJob == null) {
                return;
            }
            this.searchJob.cancel();
            this.searchJob.join();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void clearFinderCaching() {
        if (this.finder == null) {
            return;
        }
        this.finder.clearFilterCaching();
        this.finder.clearSearchCaching();
    }

    private void cancelIndexingJob() {
        try {
            if (this.indexingJob == null) {
                return;
            }
            this.indexingJob.cancel();
            this.indexingJob.join();
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void closeAnalyzer() {
        if (this.analyzer == null) {
            return;
        }
        this.analyzer.close();
    }

    private void closeIndexDirectory() {
        try {
            if (this.indexDirectory == null) {
                return;
            }
            this.indexDirectory.close();
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void await() {
        try {
            if (this.doneLatch.getCount() <= 0L) {
                return;
            }
            this.doneLatch.await();
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

