/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedHashSet;
import java.util.Set;
import ro.amiq.dvt.logviewer.LogFile;
import ro.amiq.dvt.logviewer.LogViewerConsole;
import ro.amiq.dvt.logviewer.LogViewerConst;
import ro.amiq.dvt.logviewer.LogViewerContributorUtils;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructure;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructureCategory;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructureCategorySerializer;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructureLocation;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructureSerializer;
import ro.amiq.dvt.logviewer.indexing.LogViewerIndexingMetadataWrapper;
import ro.amiq.dvt.settings.DVTSConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;

public class LogViewerUtils {
    public static final String LOG_VIEWER = "Log Viewer";
    public static final String CURRENT_LOG_FILE_NOT_SET = "No current log file";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(LogViewerEntryStructure.class, (Object)LogViewerEntryStructureSerializer.INSTANCE).registerTypeAdapter(LogViewerEntryStructureCategory.class, (Object)LogViewerEntryStructureCategorySerializer.INSTANCE).registerTypeAdapter(LogViewerIndexingMetadataWrapper.class, LogViewerIndexingMetadataWrapper.DESERIALIZER).disableHtmlEscaping().setPrettyPrinting().setLenient().create();
    private static final Type STRUCTURE_CATEGORY_GSON_TYPE = new TypeToken<LinkedHashSet<LogViewerEntryStructureCategory>>(){}.getType();
    private static final Type INDEXING_METADATA_GSON_TYPE = new TypeToken<LogViewerIndexingMetadataWrapper>(){}.getType();

    private LogViewerUtils() {
    }

    public static Path getIndexDirectoryPath(String logFilePath, Path configDirectoryLocation) {
        String logViewerDirectory = LogViewerConst.logViewerDirectoryName(logFilePath);
        return configDirectoryLocation.resolve(String.valueOf(logViewerDirectory) + DVTFileUtils.FILE_SEPARATOR + ".indexing");
    }

    public static Path getStructuresConfigFilePath(String logFilePath, Path location) {
        String logViewerDirectory = LogViewerConst.logViewerDirectoryName(logFilePath);
        return location.resolve(String.valueOf(logViewerDirectory) + DVTFileUtils.FILE_SEPARATOR + "entryStructures.config");
    }

    public static Path getIndexingMetadataFilePath(String logFilePath, Path configDirectoryLocation) {
        String logViewerDirectory = LogViewerConst.logViewerDirectoryName(logFilePath);
        return configDirectoryLocation.resolve(String.valueOf(logViewerDirectory) + DVTFileUtils.FILE_SEPARATOR + ".indexing_metadata");
    }

    public static Set<LogViewerEntryStructureCategory> fetchEntryStructureCategories(String filePath, Path configDirectoryLocation) {
        Set<LogViewerEntryStructureCategory> entryStructures = LogViewerUtils.fetchEntryStructureCategoriesInternal(filePath, configDirectoryLocation);
        if (!entryStructures.isEmpty()) {
            return entryStructures;
        }
        return LogViewerConst.DEFAULT_STRUCTURE_CATEGORIES;
    }

    private static Set<LogViewerEntryStructureCategory> fetchEntryStructureCategoriesInternal(String filePath, Path configDirectoryLocation) {
        LinkedHashSet<LogViewerEntryStructureCategory> categories = new LinkedHashSet<LogViewerEntryStructureCategory>();
        categories.addAll(LogViewerUtils.fetchEntryStructureCategories(filePath, configDirectoryLocation, LogViewerEntryStructureLocation.PROJECT_LOCATION));
        if (DVTSConstants.DVT_USER_SETTINGS == null) {
            return categories;
        }
        Set<LogViewerEntryStructureCategory> userSettingsCategories = LogViewerUtils.fetchEntryStructureCategories(filePath, Paths.get(DVTSConstants.DVT_USER_SETTINGS, new String[0]), LogViewerEntryStructureLocation.USER_SETTINGS_LOCATION);
        for (LogViewerEntryStructureCategory category : userSettingsCategories) {
            if (category == null) continue;
            categories.add(category);
        }
        if (DVTSConstants.DVT_COMMON_SETTINGS == null) {
            return categories;
        }
        String[] stringArray = DVTSConstants.DVT_COMMON_SETTINGS;
        int n = DVTSConstants.DVT_COMMON_SETTINGS.length;
        int n2 = 0;
        while (n2 < n) {
            String commonSettingsDirectory = stringArray[n2];
            categories.addAll(LogViewerUtils.fetchEntryStructureCategories(filePath, Paths.get(commonSettingsDirectory, new String[0]), LogViewerEntryStructureLocation.COMMON_SETTINGS_LOCATION));
            ++n2;
        }
        return categories;
    }

    private static Set<LogViewerEntryStructureCategory> fetchEntryStructureCategories(String filePath, Path location, LogViewerEntryStructureLocation structureLocation) {
        if (location == null) {
            return new LinkedHashSet<LogViewerEntryStructureCategory>(0);
        }
        Path configFilePath = LogViewerUtils.getStructuresConfigFilePath(filePath, location);
        if (!Files.exists(configFilePath, new LinkOption[0])) {
            return new LinkedHashSet<LogViewerEntryStructureCategory>(0);
        }
        if (!Files.isReadable(configFilePath)) {
            LogViewerConsole.INSTANCE.logError("Failed to deserialize the entry structures!");
            return new LinkedHashSet<LogViewerEntryStructureCategory>(0);
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader r = Files.newBufferedReader(configFilePath);){
                Set categories = (Set)GSON.fromJson((Reader)r, STRUCTURE_CATEGORY_GSON_TYPE);
                if (categories == null || categories.isEmpty()) {
                    return new LinkedHashSet<LogViewerEntryStructureCategory>(0);
                }
                for (LogViewerEntryStructureCategory category : categories) {
                    if (category == null) continue;
                    category.setLocation(structureLocation);
                }
                return categories;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LogViewerConsole.INSTANCE.logError("Failed to deserialize the entry structures!");
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new LinkedHashSet<LogViewerEntryStructureCategory>(0);
        }
    }

    public static void serializeEntryStructureCategories(String filePath, Path configDirectoryLocation, Set<LogViewerEntryStructureCategory> categories) {
        if (categories == null) {
            return;
        }
        Set<LogViewerEntryStructureCategory> projectCategories = LogViewerUtils.filterCategoriesByLocation(categories, LogViewerEntryStructureLocation.PROJECT_LOCATION);
        LogViewerUtils.serializeEntryStructureCategories(filePath, projectCategories, configDirectoryLocation);
        if (DVTSConstants.DVT_USER_SETTINGS == null) {
            return;
        }
        Set<LogViewerEntryStructureCategory> userSettingsCategories = LogViewerUtils.fetchEntryStructureCategories(filePath, Paths.get(DVTSConstants.DVT_USER_SETTINGS, new String[0]), LogViewerEntryStructureLocation.USER_SETTINGS_LOCATION);
        if (userSettingsCategories == null) {
            userSettingsCategories = new LinkedHashSet<LogViewerEntryStructureCategory>();
        }
        userSettingsCategories.addAll(LogViewerUtils.filterCategoriesByLocation(categories, LogViewerEntryStructureLocation.USER_SETTINGS_LOCATION));
        LogViewerUtils.serializeEntryStructureCategories(filePath, userSettingsCategories, Paths.get(DVTSConstants.DVT_USER_SETTINGS, new String[0]));
    }

    private static Set<LogViewerEntryStructureCategory> filterCategoriesByLocation(Set<LogViewerEntryStructureCategory> categories, LogViewerEntryStructureLocation location) {
        if (categories == null || location == null) {
            return new LinkedHashSet<LogViewerEntryStructureCategory>(0);
        }
        LinkedHashSet<LogViewerEntryStructureCategory> filteredCategories = new LinkedHashSet<LogViewerEntryStructureCategory>();
        for (LogViewerEntryStructureCategory category : categories) {
            if (category == null || !location.equals((Object)category.getLocation())) continue;
            filteredCategories.add(category);
        }
        return filteredCategories;
    }

    private static void serializeEntryStructureCategories(String filePath, Set<LogViewerEntryStructureCategory> categories, Path location) {
        if (location == null) {
            return;
        }
        if (!Files.exists(location, new LinkOption[0])) {
            return;
        }
        Path configFilePath = LogViewerUtils.getStructuresConfigFilePath(filePath, location);
        if (configFilePath.getParent() != null && !Files.exists(configFilePath.getParent(), new LinkOption[0])) {
            return;
        }
        Path tmpFilePath = configFilePath.resolveSibling(configFilePath.getFileName() + ".tmp");
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter w = Files.newBufferedWriter(tmpFilePath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                GSON.toJson(categories, (Appendable)w);
                Files.move(tmpFilePath, configFilePath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                LogViewerContributorUtils.get().refreshConfigDirectory(configFilePath.getParent(), filePath, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LogViewerConsole.INSTANCE.logError("Failed to serialize the entry structures!");
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static long getFileSize(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return 0L;
        }
    }

    public static String getEnumRegex(Enum<?>[] enumValues) {
        if (enumValues == null || enumValues.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("(");
        boolean separatorNeeded = false;
        Enum<?>[] enumArray = enumValues;
        int n = enumValues.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> value = enumArray[n2];
            if (separatorNeeded) {
                sb.append("|");
            }
            sb.append(value.toString());
            separatorNeeded = true;
            ++n2;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getAttributeName(String attributeNameStr) {
        if (attributeNameStr == null) {
            return null;
        }
        if (attributeNameStr.startsWith("?")) {
            return attributeNameStr.substring("?".length());
        }
        return attributeNameStr;
    }

    public static void serializeIndexingMetadata(String filePath, LogViewerIndexingMetadataWrapper wrapper, LogFile logFile) {
        Path infoFilePath = LogViewerUtils.getIndexingMetadataFilePath(filePath, logFile.getConfigDirectoryLocation());
        Path tmpFilePath = infoFilePath.resolveSibling(infoFilePath.getFileName() + ".tmp");
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter w = Files.newBufferedWriter(tmpFilePath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                GSON.toJson((Object)wrapper, (Appendable)w);
                Files.move(tmpFilePath, infoFilePath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            if (logFile.isFileInReadOnlyLocation()) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return;
            }
            logFile.updateConfigDirectoryLocation();
            LogViewerUtils.serializeIndexingMetadata(filePath, wrapper, logFile);
        }
    }

    public static LogViewerIndexingMetadataWrapper fetchIndexingMetadata(String filePath, Path configDirectoryLocation) {
        Path infoFilePath = LogViewerUtils.getIndexingMetadataFilePath(filePath, configDirectoryLocation);
        if (!Files.exists(infoFilePath, new LinkOption[0])) {
            return null;
        }
        if (!Files.isReadable(infoFilePath)) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader r = Files.newBufferedReader(infoFilePath);){
                return (LogViewerIndexingMetadataWrapper)GSON.fromJson((Reader)r, INDEXING_METADATA_GSON_TYPE);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static void deleteIndexingFiles(String filePath, Path configDirectoryLocation, LogFile logFile) {
        try {
            LogViewerUtils.deleteFile(LogViewerUtils.getIndexingMetadataFilePath(filePath, configDirectoryLocation));
            Path indexDir = LogViewerUtils.getIndexDirectoryPath(filePath, configDirectoryLocation);
            if (!Files.exists(indexDir, new LinkOption[0])) {
                return;
            }
            logFile.clearIndexingConfiguration();
            Path parentDir = indexDir.getParent();
            LogViewerUtils.deleteDirectory(indexDir);
            if (LogViewerUtils.isEmptyDirectory(parentDir)) {
                LogViewerUtils.deleteDirectory(parentDir);
            }
        }
        catch (IOException e) {
            if (logFile.isFileInReadOnlyLocation()) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return;
            }
            logFile.updateConfigDirectoryLocation();
            LogViewerUtils.deleteIndexingFiles(filePath, logFile.getConfigDirectoryLocation(), logFile);
        }
    }

    private static void deleteFile(Path filePath) throws IOException {
        if (!Files.exists(filePath, new LinkOption[0]) || !Files.isRegularFile(filePath, new LinkOption[0])) {
            return;
        }
        Files.delete(filePath);
    }

    private static void deleteDirectory(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static boolean isEmptyDirectory(Path dir) {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
                boolean bl = !stream.iterator().hasNext();
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }
}

