/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.indexing;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.SortField;
import ro.amiq.dvt.logviewer.LogViewerUtils;
import ro.amiq.dvt.logviewer.indexing.IusSeverity;
import ro.amiq.dvt.logviewer.indexing.IusTool;
import ro.amiq.dvt.logviewer.indexing.LogViewerAttributeProperty;
import ro.amiq.dvt.logviewer.indexing.SimSeverity;
import ro.amiq.dvt.logviewer.indexing.UvmSeverity;
import ro.amiq.dvt.logviewer.indexing.UvmVerbosity;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum LogViewerAttributeType {
    INT("([+-]?\\\\d+)", SortField.Type.INT, LogViewerAttributeProperty.SUPPORTS_NUMERIC_QUERY),
    LONG("([+-]?\\\\d+[lL]?)", SortField.Type.LONG, LogViewerAttributeProperty.SUPPORTS_NUMERIC_QUERY, LogViewerAttributeProperty.SUPPORTS_LONG_VALUES),
    TEXT("(.*)", null, LogViewerAttributeProperty.SUPPORTS_TEXT_QUERY, LogViewerAttributeProperty.SUPPORTS_REGEX_FILTERING),
    WORD("(\\\\s*\\\\S*\\\\s*)", null, LogViewerAttributeProperty.SUPPORTS_TEXT_QUERY, LogViewerAttributeProperty.SUPPORTS_REGEX_FILTERING, LogViewerAttributeProperty.SUPPORTS_HYPERLINKS),
    FILE_PATH(TEXT.getRegex(), null, LogViewerAttributeProperty.SUPPORTS_TEXT_QUERY, LogViewerAttributeProperty.IS_UNIQUE, LogViewerAttributeProperty.SUPPORTS_REGEX_FILTERING, LogViewerAttributeProperty.SUPPORTS_HYPERLINKS),
    FILE_LINE(INT.getRegex(), SortField.Type.INT, LogViewerAttributeProperty.SUPPORTS_NUMERIC_QUERY, LogViewerAttributeProperty.IS_UNIQUE),
    REPORT_OBJECT(WORD.getRegex(), null, LogViewerAttributeProperty.SUPPORTS_TEXT_QUERY, LogViewerAttributeProperty.IS_UNIQUE, LogViewerAttributeProperty.SUPPORTS_REGEX_FILTERING, LogViewerAttributeProperty.SUPPORTS_HYPERLINKS),
    UVM_SEVERITY(UvmSeverity.values()),
    UVM_VERBOSITY(UvmVerbosity.values()),
    FILE_AND_LINE("(" + FILE_PATH.getRegex() + "\\\\(" + FILE_LINE.getRegex() + "\\\\) )", null, LogViewerAttributeProperty.IS_UNIQUE, LogViewerAttributeProperty.SUPPORTS_HYPERLINKS),
    VCS_FILE_NAME("\\\\n(^\\\\s*\\\\\"?\\\\S+\\\\.\\\\S+\\\\\"?)", null, LogViewerAttributeProperty.SUPPORTS_TEXT_QUERY, LogViewerAttributeProperty.IS_UNIQUE, LogViewerAttributeProperty.SUPPORTS_REGEX_FILTERING, LogViewerAttributeProperty.SUPPORTS_HYPERLINKS),
    SINGLE_LINE_TEXT("([^\\\\r\\\\n]+)", null, LogViewerAttributeProperty.SUPPORTS_TEXT_QUERY, LogViewerAttributeProperty.SUPPORTS_REGEX_FILTERING),
    IUS_TOOL(IusTool.values()),
    IUS_SEVERITY(IusSeverity.values()),
    SIM_SEVERITY(SimSeverity.values());

    private final String regex;
    private final SortField.Type sortFieldType;
    private final EnumSet<LogViewerAttributeProperty> properties;
    private final List<Enum<?>> enumValues;

    private LogViewerAttributeType(String regex, SortField.Type sortFieldType, LogViewerAttributeProperty ... properties) {
        this.regex = regex;
        this.sortFieldType = sortFieldType;
        this.properties = properties.length > 0 ? EnumSet.copyOf(Arrays.asList(properties)) : EnumSet.noneOf(LogViewerAttributeProperty.class);
        this.enumValues = null;
    }

    private LogViewerAttributeType(Enum<?>[] enumValues) {
        this.regex = LogViewerUtils.getEnumRegex(enumValues);
        this.sortFieldType = SortField.Type.INT;
        this.properties = EnumSet.of(LogViewerAttributeProperty.SUPPORTS_NUMERIC_QUERY, LogViewerAttributeProperty.IS_UNIQUE, LogViewerAttributeProperty.IS_ENUM_VALUE);
        this.enumValues = List.of(enumValues);
    }

    protected String getRegex() {
        return this.regex;
    }

    public SortField.Type getSortFieldType() {
        return this.sortFieldType;
    }

    public boolean hasProperty(LogViewerAttributeProperty property) {
        if (property == null) {
            return false;
        }
        return this.properties.contains((Object)property);
    }

    protected void addDocFields(Document doc, String fieldName, String stringValue) {
        if (doc == null || fieldName == null || stringValue == null) {
            return;
        }
        if (this == FILE_AND_LINE) {
            return;
        }
        if (this.hasProperty(LogViewerAttributeProperty.SUPPORTS_LONG_VALUES)) {
            Long longValue = Long.valueOf(stringValue);
            doc.add((IndexableField)new StoredField(fieldName, longValue.longValue()));
            doc.add((IndexableField)new LongPoint(fieldName, new long[]{longValue}));
            doc.add((IndexableField)new NumericDocValuesField(String.valueOf(fieldName) + "_sortable", longValue));
            return;
        }
        if (this.hasProperty(LogViewerAttributeProperty.SUPPORTS_NUMERIC_QUERY)) {
            String indexedValue = this.convertToIndexedVersion(stringValue);
            Integer intValue = Integer.valueOf(indexedValue);
            doc.add((IndexableField)new StoredField(fieldName, intValue.intValue()));
            doc.add((IndexableField)new IntPoint(fieldName, new int[]{intValue}));
            doc.add((IndexableField)new NumericDocValuesField(String.valueOf(fieldName) + "_sortable", (long)intValue.intValue()));
            return;
        }
        if (this.hasProperty(LogViewerAttributeProperty.SUPPORTS_TEXT_QUERY)) {
            doc.add((IndexableField)new TextField(fieldName, stringValue, Field.Store.YES));
            return;
        }
        doc.add((IndexableField)new StringField(fieldName, stringValue, Field.Store.YES));
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static LogViewerAttributeType from(String type) {
        LogViewerAttributeType enumValue;
        block5: {
            block4: {
                try {
                    if (type != null && !type.isEmpty()) break block4;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            enumValue = LogViewerAttributeType.valueOf(type.toUpperCase());
            if (enumValue != null && enumValue.toString().equals(type)) break block5;
            return null;
        }
        return enumValue;
    }

    public static String getEnumRegex() {
        return LogViewerUtils.getEnumRegex(LogViewerAttributeType.values());
    }

    public static EnumSet<LogViewerAttributeType> valuesWithProperty(LogViewerAttributeProperty property) {
        LogViewerAttributeType[] values;
        EnumSet<LogViewerAttributeType> result = EnumSet.noneOf(LogViewerAttributeType.class);
        if (property == null) {
            return result;
        }
        LogViewerAttributeType[] logViewerAttributeTypeArray = values = LogViewerAttributeType.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            LogViewerAttributeType value = logViewerAttributeTypeArray[n2];
            if (value.hasProperty(property)) {
                result.add(value);
            }
            ++n2;
        }
        return result;
    }

    public String convertToIndexedVersion(String value) {
        if (!this.hasProperty(LogViewerAttributeProperty.IS_ENUM_VALUE) || this.enumValues == null) {
            return value;
        }
        for (Enum<?> enumValue : this.enumValues) {
            if (!Objects.equals(value, enumValue.toString())) continue;
            return Integer.toString(enumValue.ordinal());
        }
        return null;
    }

    public String convertFromIndexedVersion(String value) {
        int enumOrdinal;
        block4: {
            try {
                if (!this.hasProperty(LogViewerAttributeProperty.IS_ENUM_VALUE) || this.enumValues == null) {
                    return value;
                }
                enumOrdinal = Integer.parseInt(value);
                if (enumOrdinal >= 0 && enumOrdinal < this.enumValues.size()) break block4;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return this.enumValues.get(enumOrdinal).toString();
    }

    public List<Enum<?>> getEnumValues() {
        return this.enumValues;
    }
}

