/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.indexing;

import com.google.gson.annotations.SerializedName;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.logviewer.LogViewerConsole;
import ro.amiq.dvt.logviewer.LogViewerConst;
import ro.amiq.dvt.logviewer.LogViewerUtils;
import ro.amiq.dvt.logviewer.indexing.LogViewerAttributeProperty;
import ro.amiq.dvt.logviewer.indexing.LogViewerAttributeType;
import ro.amiq.dvt.logviewer.indexing.LogViewerStructureParsingException;

public class LogViewerEntryStructure {
    private static final Set<Character> REGEX_SPECIAL_CHARS = Set.of(Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('$'), Character.valueOf('.'), Character.valueOf('|'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'));
    @SerializedName(value="name")
    private final String name;
    @SerializedName(value="structure")
    private final String structure;
    @SerializedName(value="enabled")
    private final boolean enabled;
    private transient Pattern pattern;
    private transient Map<String, LogViewerAttributeType> attributes;

    private LogViewerEntryStructure(String name, String structure, boolean enabled) throws LogViewerStructureParsingException {
        this.name = name;
        this.structure = structure;
        this.attributes = new LinkedHashMap<String, LogViewerAttributeType>();
        this.enabled = enabled;
        this.parseStructure();
    }

    public static LogViewerEntryStructure createStructure(String name, String structure, boolean enabled) {
        try {
            return new LogViewerEntryStructure(name, structure, enabled);
        }
        catch (LogViewerStructureParsingException e) {
            LogViewerConsole.INSTANCE.logError(e.getMessage());
            return null;
        }
    }

    private void parseStructure() throws LogViewerStructureParsingException {
        LogViewerEntryStructure.validate(this.structure);
        StringBuffer regex = new StringBuffer();
        String escapedStructure = LogViewerEntryStructure.escapeRegexChars(this.structure);
        Matcher matcher = LogViewerConst.STRUCTURE_PARSING_PATTERN.matcher(escapedStructure);
        while (matcher.find()) {
            LogViewerAttributeType type;
            String name = matcher.group(1);
            boolean isOptional = false;
            if (name.startsWith("?")) {
                name = name.substring("?".length());
                isOptional = true;
            }
            if ((type = LogViewerAttributeType.from(matcher.group(2))) == null) continue;
            String replacement = type.getRegex();
            if (isOptional) {
                replacement = String.valueOf(replacement) + "?";
            }
            matcher.appendReplacement(regex, replacement);
            this.attributes.put(name, type);
            if (type != LogViewerAttributeType.FILE_AND_LINE) continue;
            this.attributes.put(LogViewerAttributeType.FILE_PATH.toString(), LogViewerAttributeType.FILE_PATH);
            this.attributes.put(LogViewerAttributeType.FILE_LINE.toString(), LogViewerAttributeType.FILE_LINE);
        }
        matcher.appendTail(regex);
        this.pattern = Pattern.compile(regex.toString(), 40);
    }

    public static void validate(String structure) throws LogViewerStructureParsingException {
        if (structure == null || structure.isEmpty()) {
            throw LogViewerStructureParsingException.missingAttributeException();
        }
        HashSet<String> uniqueAttributeNames = new HashSet<String>();
        HashSet<LogViewerAttributeType> uniqueAttributeTypes = new HashSet<LogViewerAttributeType>();
        String escapedStructure = LogViewerEntryStructure.escapeRegexChars(structure);
        Matcher matcher = LogViewerConst.STRUCTURE_PARSING_PATTERN.matcher(escapedStructure);
        while (matcher.find()) {
            String attributeName = LogViewerUtils.getAttributeName(matcher.group(1));
            if (LogViewerConst.RESERVED_ATTRIBUTE_NAMES.contains(attributeName)) {
                throw LogViewerStructureParsingException.reservedAttributeException(attributeName);
            }
            if (uniqueAttributeNames.contains(attributeName)) {
                throw LogViewerStructureParsingException.duplicateAttributeException(attributeName);
            }
            String type = matcher.group(2);
            LogViewerAttributeType attributeType = LogViewerAttributeType.from(type);
            if (attributeType == null) {
                throw LogViewerStructureParsingException.invalidAttributeTypeException(type);
            }
            if (attributeType.hasProperty(LogViewerAttributeProperty.IS_UNIQUE)) {
                if (uniqueAttributeTypes.contains((Object)attributeType)) {
                    throw LogViewerStructureParsingException.uniqueAttributeTypeException(type);
                }
                uniqueAttributeTypes.add(attributeType);
            }
            if (attributeType == LogViewerAttributeType.FILE_AND_LINE) {
                if (uniqueAttributeTypes.contains((Object)LogViewerAttributeType.FILE_PATH)) {
                    throw LogViewerStructureParsingException.uniqueAttributeTypeException(LogViewerAttributeType.FILE_PATH.toString());
                }
                uniqueAttributeTypes.add(LogViewerAttributeType.FILE_PATH);
                if (uniqueAttributeTypes.contains((Object)LogViewerAttributeType.FILE_LINE)) {
                    throw LogViewerStructureParsingException.uniqueAttributeTypeException(LogViewerAttributeType.FILE_LINE.toString());
                }
                uniqueAttributeTypes.add(LogViewerAttributeType.FILE_LINE);
            }
            uniqueAttributeNames.add(attributeName);
        }
        if (uniqueAttributeNames.isEmpty()) {
            throw LogViewerStructureParsingException.missingAttributeException();
        }
    }

    public String getName() {
        return this.name;
    }

    protected Pattern getPattern() {
        return this.pattern;
    }

    public Map<String, LogViewerAttributeType> getAttributes() {
        return this.attributes;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public LogViewerAttributeType getAttributeType(String attributeName) {
        if (attributeName == null || this.attributes == null) {
            return null;
        }
        return this.attributes.get(attributeName);
    }

    public String getAttributeName(LogViewerAttributeType type) {
        if (type == null || this.attributes == null) {
            return null;
        }
        for (Map.Entry<String, LogViewerAttributeType> entry : this.attributes.entrySet()) {
            if (entry.getValue() != type) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getStructure() {
        return this.structure;
    }

    public String toString() {
        return this.structure;
    }

    public int hashCode() {
        return Objects.hash(this.structure);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogViewerEntryStructure other = (LogViewerEntryStructure)obj;
        return Objects.equals(this.structure, other.structure);
    }

    private static String escapeRegexChars(String entryStructure) {
        if (entryStructure == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(entryStructure.length());
        boolean insideAttrDeclaration = false;
        char[] cArray = entryStructure.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!insideAttrDeclaration && REGEX_SPECIAL_CHARS.contains(Character.valueOf(c))) {
                result.append('\\');
            }
            result.append(c);
            if (c == '<') {
                insideAttrDeclaration = true;
            } else if (c == '>') {
                insideAttrDeclaration = false;
            }
            ++n2;
        }
        return result.toString();
    }
}

