/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.indexing;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructure;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructureCategory;

public enum LogViewerEntryStructureCategorySerializer implements JsonDeserializer<LogViewerEntryStructureCategory>,
JsonSerializer<LogViewerEntryStructureCategory>
{
    INSTANCE;


    public JsonElement serialize(LogViewerEntryStructureCategory src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.addProperty("categoryName", src.getName());
        JsonArray structuresArray = new JsonArray();
        for (LogViewerEntryStructure entry : src.getStructures()) {
            structuresArray.add(context.serialize((Object)entry, LogViewerEntryStructure.class));
        }
        obj.add("structures", (JsonElement)structuresArray);
        return obj;
    }

    public LogViewerEntryStructureCategory deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        String name = null;
        JsonElement jsonElem = obj.get("categoryName");
        if (jsonElem != null && !jsonElem.isJsonNull()) {
            name = jsonElem.getAsString();
        }
        LinkedHashSet<LogViewerEntryStructure> structures = new LinkedHashSet<LogViewerEntryStructure>();
        jsonElem = obj.get("structures");
        if (jsonElem != null && jsonElem.isJsonArray()) {
            for (JsonElement entryJson : jsonElem.getAsJsonArray()) {
                LogViewerEntryStructure entry = (LogViewerEntryStructure)context.deserialize(entryJson, LogViewerEntryStructure.class);
                structures.add(entry);
            }
        }
        return new LogViewerEntryStructureCategory(name, structures);
    }
}

