/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.indexing;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import ro.amiq.dvt.logviewer.BaseLogViewerJob;
import ro.amiq.dvt.logviewer.LogFile;
import ro.amiq.dvt.logviewer.LogFileManager;
import ro.amiq.dvt.logviewer.LogViewerConsole;
import ro.amiq.dvt.logviewer.LogViewerConst;
import ro.amiq.dvt.logviewer.LogViewerFullIndexState;
import ro.amiq.dvt.logviewer.LogViewerShutdownException;
import ro.amiq.dvt.logviewer.LogViewerUtils;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructure;
import ro.amiq.dvt.logviewer.indexing.LogViewerIndexingMetadataWrapper;
import ro.amiq.dvt.logviewer.indexing.LogViewerIndexingWorker;
import ro.amiq.dvt.logviewer.query.LogViewerEntry;
import ro.amiq.dvt.logviewer.query.LogViewerFinder;
import ro.amiq.dvt.logviewer.webview.LogViewerRequestsManager;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerUpdateFullIndexParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerUpdateIndexingProgressParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerUpdateResultsNumberParams;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.utils.DVTStringUtil;

public class LogViewerIndexingJob
extends BaseLogViewerJob {
    private final LogFile logFile;
    private final Set<LogViewerIndexingWorker> workers;
    private final CountDownLatch doneLatch;
    private final CountDownLatch workerCreationLatch;
    private IndexWriter writer;
    private volatile boolean enforcedFullIndexing;
    private volatile boolean didFinish = false;
    private volatile boolean isCanceled = false;
    private volatile boolean submittedWorkers = false;
    private String md5 = null;
    private long fileSize = 0L;
    private String prevMd5 = null;
    private Long prevFileSize = 0L;
    private final CompletableFuture<Boolean> canReuseIndexingFuture;

    public LogViewerIndexingJob(LogFile logFile) {
        super(LogViewerConst.indexingJobName(logFile.getFilePath()));
        this.setSystem(true);
        this.logFile = logFile;
        this.workers = new LinkedHashSet<LogViewerIndexingWorker>(4);
        this.doneLatch = new CountDownLatch(4);
        this.workerCreationLatch = new CountDownLatch(1);
        this.canReuseIndexingFuture = new CompletableFuture();
    }

    public String getFilePath() {
        return this.logFile.getFilePath();
    }

    public Path getConfigDirectoryLocation() {
        return this.logFile.getConfigDirectoryLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LogViewerIndexingWorker> getWorkers() {
        Set<LogViewerIndexingWorker> set = this.workers;
        synchronized (set) {
            return new LinkedHashSet<LogViewerIndexingWorker>(this.workers);
        }
    }

    @Override
    protected void doWork() {
        try {
            try {
                long startTime = System.currentTimeMillis();
                this.startWorkers();
                this.awaitWorkers();
                this.notifyFinishedIndexing();
                long totalTime = System.currentTimeMillis() - startTime;
                this.printIndexingReport(totalTime);
            }
            catch (LogViewerShutdownException logViewerShutdownException) {
                this.workerCreationLatch.countDown();
                if (this.isCanceled()) {
                    this.closeIndexWriter();
                    LogViewerUtils.deleteIndexingFiles(this.getFilePath(), this.getConfigDirectoryLocation(), this.logFile);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                LogViewerConsole.INSTANCE.logError("Error while initializing the Log Viewer!");
                this.workerCreationLatch.countDown();
                if (this.isCanceled()) {
                    this.closeIndexWriter();
                    LogViewerUtils.deleteIndexingFiles(this.getFilePath(), this.getConfigDirectoryLocation(), this.logFile);
                }
            }
        }
        finally {
            this.workerCreationLatch.countDown();
            if (this.isCanceled()) {
                this.closeIndexWriter();
                LogViewerUtils.deleteIndexingFiles(this.getFilePath(), this.getConfigDirectoryLocation(), this.logFile);
            }
        }
    }

    @Override
    protected Objection getObjection() {
        return Objection.LOG_VIEWER_INDEXING;
    }

    private void notifyFinishedIndexing() {
        if (this.workers == null || this.isCanceled()) {
            return;
        }
        this.didFinish = true;
        this.logFile.setFinsihedIndexing(true);
        this.closeIndexWriter();
        String filePath = this.logFile.getFilePath();
        LogViewerRequestsManager.INSTANCE.updateFullIndexOpState(new LogViewerUpdateFullIndexParams(filePath, LogViewerFullIndexState.FULL_INDEXING_FINISHED));
        LogViewerRequestsManager.INSTANCE.updateIndexingProgress(new LogViewerUpdateIndexingProgressParams(filePath, this.fileSize, this.fileSize));
        int resultsNumber = this.logFile.getResultsNumber();
        LogViewerRequestsManager.INSTANCE.updateResultsNumber(new LogViewerUpdateResultsNumberParams(filePath, resultsNumber));
        LogViewerIndexingMetadataWrapper metadataWrapper = new LogViewerIndexingMetadataWrapper(this.fileSize, this.getLastIndexingChangeTimestamp(), this.md5, this.logFile.getEntryStructures());
        LogViewerUtils.serializeIndexingMetadata(filePath, metadataWrapper, this.logFile);
    }

    private void initConfiguration() throws IOException, LogViewerShutdownException {
        this.writer = this.logFile.getIndexWriter();
        if (this.writer == null) {
            LogFileManager.INSTANCE.awaitPrevShutdownJobs(this.logFile);
            this.logFile.configureIndexing();
            this.writer = this.logFile.getIndexWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void canceling() {
        if (this.didFinish()) {
            return;
        }
        this.canReuseIndexingFuture.complete(false);
        if (this.workers == null) {
            return;
        }
        Set<LogViewerIndexingWorker> set = this.workers;
        synchronized (set) {
            this.isCanceled = true;
            int uninitializedWorkers = 4;
            if (this.submittedWorkers) {
                uninitializedWorkers -= this.workers.size();
                for (LogViewerIndexingWorker worker : this.workers) {
                    worker.cancelWorker();
                }
            }
            while (uninitializedWorkers > 0) {
                this.doneLatch.countDown();
                --uninitializedWorkers;
            }
        }
        this.awaitWorkers();
        LogViewerConsole.INSTANCE.logInfo(LogViewerConst.canceledJobMessage(this.getName()));
    }

    private void startWorkers() throws IOException, LogViewerShutdownException {
        if (!this.workers.isEmpty()) {
            return;
        }
        int workerCount = 4;
        String filePath = this.getFilePath();
        Path path = Paths.get(filePath, new String[0]);
        this.fileSize = LogViewerUtils.getFileSize(path);
        long sliceSize = this.fileSize / (long)workerCount;
        LogViewerIndexingMetadataWrapper prevMetadata = LogViewerUtils.fetchIndexingMetadata(filePath, this.getConfigDirectoryLocation());
        if (this.hasDirtyIndexingMetadata(prevMetadata)) {
            this.canReuseIndexingFuture.complete(false);
            LogViewerUtils.deleteIndexingFiles(filePath, this.getConfigDirectoryLocation(), this.logFile);
            LogViewerConsole.INSTANCE.logInfo("No serialized indexing metadata was found or it was not in sync.");
        } else {
            this.prevMd5 = prevMetadata.getMd5();
            this.prevFileSize = prevMetadata.getSize();
            if (this.prevFileSize == null) {
                this.prevFileSize = 0L;
            }
        }
        this.initConfiguration();
        LogViewerUpdateIndexingProgressParams params = new LogViewerUpdateIndexingProgressParams(filePath, 0L, this.fileSize);
        LogViewerRequestsManager.INSTANCE.updateIndexingProgress(params);
        ExecutorService executor = Executors.newFixedThreadPool(workerCount);
        if (this.logFile.isArchive() && this.logFile.getPathInsideArchive() != null) {
            this.createWorkersFromZIP(workerCount, path, this.logFile.getPathInsideArchive(), sliceSize, executor);
        } else {
            this.createWorkersFromLogFile(workerCount, path, sliceSize, this.logFile.isArchive(), executor);
        }
    }

    private boolean hasDirtyIndexingMetadata(LogViewerIndexingMetadataWrapper prevMetadata) {
        block9: {
            block8: {
                block7: {
                    block6: {
                        try {
                            if (prevMetadata != null) break block6;
                            return true;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return true;
                        }
                    }
                    Long prevSize = prevMetadata.getSize();
                    if (prevSize != null && prevSize <= this.fileSize) break block7;
                    return true;
                }
                Path indexDirPath = LogViewerUtils.getIndexDirectoryPath(this.getFilePath(), this.getConfigDirectoryLocation());
                if (Files.exists(indexDirPath, new LinkOption[0]) && Files.isDirectory(indexDirPath, new LinkOption[0])) break block8;
                return true;
            }
            Long lastIndexingChangeTimestamp = this.getLastIndexingChangeTimestamp();
            if (Objects.equals(lastIndexingChangeTimestamp, prevMetadata.getLastIndexingChangeTimestamp())) break block9;
            return true;
        }
        List<LogViewerEntryStructure> entryStructures = this.logFile.getEntryStructures();
        return !Objects.equals(entryStructures, prevMetadata.getEntryStructures());
    }

    private Long getLastIndexingChangeTimestamp() {
        FileTime lastModifiedTime;
        block5: {
            Path indexDirPath;
            block4: {
                try {
                    indexDirPath = LogViewerUtils.getIndexDirectoryPath(this.getFilePath(), this.getConfigDirectoryLocation());
                    if (Files.exists(indexDirPath, new LinkOption[0]) && Files.isDirectory(indexDirPath, new LinkOption[0])) break block4;
                    return null;
                }
                catch (IOException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            lastModifiedTime = Files.getLastModifiedTime(indexDirPath, new LinkOption[0]);
            if (lastModifiedTime != null) break block5;
            return null;
        }
        return lastModifiedTime.toMillis();
    }

    private void createWorkersFromZIP(int workerCount, Path archivePath, String logFilePath, long sliceSize, ExecutorService executor) {
        try {
            try {
                Throwable throwable = null;
                Object var8_9 = null;
                try (FileSystem fs = FileSystems.newFileSystem(archivePath);){
                    Path fileInZip = fs.getPath(logFilePath, new String[0]);
                    Throwable throwable2 = null;
                    Object var12_15 = null;
                    try (SeekableByteChannel channel = Files.newByteChannel(fileInZip, new OpenOption[0]);){
                        this.createWorkers(channel, archivePath, logFilePath, true, workerCount, sliceSize, executor);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.workerCreationLatch.countDown();
                this.releaseUnusedLatchPermits(this.workers.size() + 1, workerCount);
            }
        }
        finally {
            this.workerCreationLatch.countDown();
            this.releaseUnusedLatchPermits(this.workers.size() + 1, workerCount);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createWorkersFromLogFile(int workerCount, Path path, long sliceSize, boolean isArchive, ExecutorService executor) {
        try {
            try {
                Throwable throwable = null;
                Object var8_9 = null;
                try {
                    RandomAccessFile raf = new RandomAccessFile(path.toFile(), "r");
                    try {
                        try (FileChannel channel = raf.getChannel();){
                            this.createWorkers(channel, path, null, isArchive, workerCount, sliceSize, executor);
                        }
                        if (raf == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (raf == null) throw throwable;
                        raf.close();
                        throw throwable;
                    }
                    raf.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.workerCreationLatch.countDown();
                this.releaseUnusedLatchPermits(this.workers.size() + 1, workerCount);
            }
            return;
        }
        finally {
            this.workerCreationLatch.countDown();
            this.releaseUnusedLatchPermits(this.workers.size() + 1, workerCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWorkers(SeekableByteChannel channel, Path path, String logInsideArchive, boolean isArchive, int workerCount, long sliceSize, ExecutorService executor) throws IOException, NoSuchAlgorithmException, CloneNotSupportedException, LogViewerShutdownException {
        long offset = 0L;
        int lineNumber = 1;
        int workerId = 1;
        int workerStartLine = 1;
        long workerStartOffset = 0L;
        long workerEndOffset = sliceSize;
        if (isArchive && logInsideArchive == null) {
            channel.position(512L);
            offset = 512L;
            workerStartOffset = 512L;
        }
        long remaining = this.fileSize - offset;
        long bufferSize = Math.min(0x10000000L, remaining);
        ByteBuffer buffer = this.loadBuffer(channel, offset, bufferSize);
        int bufferPos = 0;
        MessageDigest digest = MessageDigest.getInstance("MD5");
        while (offset < this.fileSize) {
            if (offset % 0x20000000L == 0L && this.isCanceled()) {
                return;
            }
            byte b = buffer.get(bufferPos);
            ++bufferPos;
            if (this.prevMd5 != null && ++offset == this.prevFileSize) {
                String partialMd5 = this.computePartialMd5(digest, buffer, bufferPos);
                if (Objects.equals(partialMd5, this.prevMd5)) {
                    LogViewerFinder logViewerFinder;
                    this.canReuseIndexingFuture.complete(true);
                    LogViewerConsole.INSTANCE.logInfo("The serialized indexing information will be reused.");
                    if (offset == this.fileSize) {
                        for (LogViewerIndexingWorker logViewerIndexingWorker : this.workers) {
                            logViewerIndexingWorker.closeReader();
                        }
                        Set<LogViewerIndexingWorker> set = this.workers;
                        synchronized (set) {
                            this.workers.clear();
                            break;
                        }
                    }
                    Set<LogViewerIndexingWorker> set = this.workers;
                    synchronized (set) {
                        this.workers.clear();
                    }
                    sliceSize = (this.fileSize - offset) / (long)workerCount;
                    workerId = 1;
                    workerStartOffset = offset;
                    workerEndOffset = workerStartOffset + sliceSize;
                    workerStartLine = lineNumber;
                    if (b == 10) {
                        ++workerStartLine;
                    }
                    if ((lastEntry = (logViewerFinder = this.logFile.getFinder()).findLast((Query)new MatchAllDocsQuery(), LogViewerConst.DEFAULT_SORT)) != null) {
                        workerStartLine = ((LogViewerEntry)lastEntry).getLogLine();
                        String rawContent = ((LogViewerEntry)lastEntry).toString();
                        if (rawContent != null) {
                            workerStartOffset -= (long)rawContent.getBytes().length;
                        }
                        if (b == 10) {
                            --workerStartOffset;
                        }
                        logViewerFinder.clearFirstPageCaching();
                        this.writer.deleteDocuments(new Query[]{LongPoint.newExactQuery((String)"log_line", (long)workerStartLine)});
                        this.writer.commit();
                    }
                } else {
                    this.canReuseIndexingFuture.complete(false);
                    LogViewerUtils.deleteIndexingFiles(this.getFilePath(), this.getConfigDirectoryLocation(), this.logFile);
                    LogViewerConsole.INSTANCE.logInfo("No serialized indexing metadata was found or it was not in sync.");
                    this.initConfiguration();
                    lastEntry = this.workers.iterator();
                    while (lastEntry.hasNext()) {
                        LogViewerIndexingWorker logViewerIndexingWorker = lastEntry.next();
                        logViewerIndexingWorker.enforceFullIndexing();
                    }
                    Set<LogViewerIndexingWorker> set = this.workers;
                    synchronized (set) {
                        if (this.isCanceled) {
                            return;
                        }
                        for (LogViewerIndexingWorker worker : this.workers) {
                            this.submitWorker(worker, executor);
                        }
                    }
                }
                this.prevMd5 = null;
            }
            if ((long)bufferPos >= bufferSize && offset < this.fileSize) {
                buffer.rewind();
                digest.update(buffer);
                remaining = this.fileSize - offset;
                bufferSize = Math.min(0x10000000L, remaining);
                buffer = this.loadBuffer(channel, offset, bufferSize);
                bufferPos = 0;
            }
            if (b != 10) continue;
            ++lineNumber;
            if (workerId > workerCount) continue;
            if (offset >= workerEndOffset || offset >= this.fileSize) {
                int workerEndLine = lineNumber - 1;
                Set<LogViewerIndexingWorker> set = this.workers;
                synchronized (set) {
                    if (this.isCanceled) {
                        return;
                    }
                    LogViewerIndexingWorker worker3 = new LogViewerIndexingWorker(workerId, path, logInsideArchive, workerStartLine, workerEndLine, workerStartOffset, this.logFile.getEntryStructures(), this.doneLatch);
                    this.workers.add(worker3);
                    if (this.prevMd5 == null) {
                        this.submitWorker(worker3, executor);
                    }
                }
                ++workerId;
                workerStartOffset = offset;
                workerStartLine = lineNumber;
                workerEndOffset += sliceSize;
            }
            if (workerId != workerCount || workerStartOffset >= this.fileSize) continue;
            Set<LogViewerIndexingWorker> workerEndLine = this.workers;
            synchronized (workerEndLine) {
                if (this.isCanceled) {
                    return;
                }
                LogViewerIndexingWorker logViewerIndexingWorker = new LogViewerIndexingWorker(workerId, path, logInsideArchive, workerStartLine, Integer.MAX_VALUE, workerStartOffset, this.logFile.getEntryStructures(), this.doneLatch);
                this.workers.add(logViewerIndexingWorker);
                if (this.prevMd5 == null) {
                    this.submitWorker(logViewerIndexingWorker, executor);
                }
            }
            ++workerId;
        }
        if (this.isCanceled()) {
            return;
        }
        digest.update(buffer);
        this.md5 = Base64.getEncoder().encodeToString(digest.digest());
        if (workerId <= workerCount && workerStartOffset < this.fileSize && !Objects.equals(this.prevMd5, this.md5)) {
            Set<LogViewerIndexingWorker> set = this.workers;
            synchronized (set) {
                if (this.isCanceled) {
                    return;
                }
                LogViewerIndexingWorker worker = new LogViewerIndexingWorker(workerId, path, logInsideArchive, workerStartLine, Integer.MAX_VALUE, workerStartOffset, this.logFile.getEntryStructures(), this.doneLatch);
                this.workers.add(worker);
                this.submitWorker(worker, executor);
            }
        }
    }

    private String computePartialMd5(MessageDigest digest, ByteBuffer buffer, int bufferPos) throws CloneNotSupportedException {
        MessageDigest tmpDigest = (MessageDigest)digest.clone();
        ByteBuffer auxBuffer = buffer.duplicate();
        auxBuffer.rewind();
        auxBuffer.limit(bufferPos);
        tmpDigest.update(auxBuffer);
        return Base64.getEncoder().encodeToString(tmpDigest.digest());
    }

    private ByteBuffer loadBuffer(SeekableByteChannel channel, long offset, long bufferSize) throws IOException {
        channel.position(offset);
        ByteBuffer buffer = ByteBuffer.allocateDirect((int)bufferSize);
        while (buffer.hasRemaining()) {
            int n = channel.read(buffer);
            if (n >= 0) continue;
            throw new IOException("Premature EOF");
        }
        buffer.flip();
        return buffer;
    }

    private void submitWorker(LogViewerIndexingWorker worker, ExecutorService executor) {
        this.submittedWorkers = true;
        worker.useWriter(this.writer);
        if (this.enforcedFullIndexing) {
            worker.enforceFullIndexing();
        }
        executor.submit(worker);
        if (worker.getWorkerId() == 1) {
            this.workerCreationLatch.countDown();
            if (!this.enforcedFullIndexing) {
                LogViewerRequestsManager.INSTANCE.updateFullIndexOpState(new LogViewerUpdateFullIndexParams(this.getFilePath(), LogViewerFullIndexState.INDEXING_IN_PROGRESS));
            }
        }
    }

    private void releaseUnusedLatchPermits(int nextWorkerId, int totalCount) {
        while (nextWorkerId <= totalCount) {
            this.doneLatch.countDown();
            ++nextWorkerId;
        }
    }

    private void awaitWorkers() {
        try {
            this.doneLatch.await();
            if (this.writer != null && this.writer.isOpen() && !this.isCanceled) {
                this.writer.commit();
            }
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean didFinish() {
        return this.didFinish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestSlices(int count) {
        try {
            if (count <= 0 || this.workers == null || this.workers.isEmpty() || this.didFinish()) {
                return;
            }
            Set<LogViewerIndexingWorker> set = this.workers;
            synchronized (set) {
                CountDownLatch requestLatch = new CountDownLatch(this.workers.size());
                for (LogViewerIndexingWorker worker : this.workers) {
                    worker.requestSlices(count, requestLatch);
                }
                requestLatch.await();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void enforceFullIndexing() {
        if (this.didFinish() || this.enforcedFullIndexing) {
            return;
        }
        String filePath = this.getFilePath();
        LogViewerConsole.INSTANCE.logInfo(LogViewerConst.enforcingFullIndexingMessage(filePath));
        this.enforcedFullIndexing = true;
        LogViewerRequestsManager.INSTANCE.updateFullIndexOpState(new LogViewerUpdateFullIndexParams(filePath, LogViewerFullIndexState.FULL_INDEXING_IN_PROGRESS));
        if (this.workers == null || this.workers.isEmpty()) {
            return;
        }
        for (LogViewerIndexingWorker worker : this.workers) {
            worker.enforceFullIndexing();
        }
    }

    public void awaitWorkerCreation() {
        try {
            this.workerCreationLatch.await();
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void printIndexingReport(long indexingTime) {
        if (this.workers == null || this.workers.isEmpty()) {
            return;
        }
        String filePath = this.getFilePath();
        StringBuilder sb = new StringBuilder();
        if (this.isCanceled()) {
            sb.append(String.valueOf(LogViewerConst.canceledIndexingMessage(filePath)) + DVTStringUtil.LINE_SEPARATOR);
        } else {
            sb.append(String.valueOf(LogViewerConst.finishedIndexingMessage(filePath)) + DVTStringUtil.LINE_SEPARATOR);
        }
        int totalEntries = 0;
        int totalLines = 0;
        for (LogViewerIndexingWorker worker : this.workers) {
            totalEntries += worker.getNofIndexedEntries();
            totalLines += worker.getNofIndexedLines();
            sb.append(String.valueOf(LogViewerConst.workerIndexingReportMessage(worker)) + DVTStringUtil.LINE_SEPARATOR);
        }
        sb.append(LogViewerConst.totalIndexingReportMessage(totalEntries, totalLines, indexingTime));
        LogViewerConsole.INSTANCE.logInfo(sb.toString());
    }

    private void closeIndexWriter() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean isEnforcedFullIndexing() {
        return this.enforcedFullIndexing;
    }

    protected Boolean canReuseIndexing() {
        try {
            return this.canReuseIndexingFuture.get();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }
}

