/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.indexing;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructure;

public class LogViewerIndexingMetadataWrapper {
    @SerializedName(value="size")
    private final Long size;
    @SerializedName(value="lastIndexingChangeTimestamp")
    private final Long lastIndexingChangeTimestamp;
    @SerializedName(value="md5")
    private final String md5;
    @SerializedName(value="entryStructures")
    private final List<LogViewerEntryStructure> entryStructures;
    public static final JsonDeserializer<LogViewerIndexingMetadataWrapper> DESERIALIZER = (json, typeOfT, ctx) -> {
        JsonObject obj = json.getAsJsonObject();
        Long size = null;
        JsonElement jsonElem = obj.get("size");
        if (jsonElem != null) {
            size = jsonElem.getAsLong();
        }
        Long lastIndexingChangeTimestamp = null;
        jsonElem = obj.get("lastIndexingChangeTimestamp");
        if (jsonElem != null) {
            lastIndexingChangeTimestamp = jsonElem.getAsLong();
        }
        String md5 = null;
        jsonElem = obj.get("md5");
        if (jsonElem != null) {
            md5 = jsonElem.getAsString();
        }
        ArrayList<LogViewerEntryStructure> structures = new ArrayList<LogViewerEntryStructure>();
        jsonElem = obj.get("entryStructures");
        if (jsonElem != null && jsonElem.isJsonArray()) {
            for (JsonElement entryJson : jsonElem.getAsJsonArray()) {
                LogViewerEntryStructure entry = (LogViewerEntryStructure)ctx.deserialize(entryJson, LogViewerEntryStructure.class);
                structures.add(entry);
            }
        }
        return new LogViewerIndexingMetadataWrapper(size, lastIndexingChangeTimestamp, md5, structures);
    };

    protected LogViewerIndexingMetadataWrapper(Long size, Long lastIndexingChangeTimestamp, String md5, List<LogViewerEntryStructure> entryStructures) {
        this.size = size;
        this.lastIndexingChangeTimestamp = lastIndexingChangeTimestamp;
        this.md5 = md5;
        this.entryStructures = entryStructures;
    }

    protected Long getSize() {
        return this.size;
    }

    protected Long getLastIndexingChangeTimestamp() {
        return this.lastIndexingChangeTimestamp;
    }

    protected String getMd5() {
        return this.md5;
    }

    public List<LogViewerEntryStructure> getEntryStructures() {
        return this.entryStructures;
    }
}

