/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.indexing;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import ro.amiq.dvt.logviewer.LogViewerConsole;
import ro.amiq.dvt.logviewer.LogViewerConst;
import ro.amiq.dvt.logviewer.LogViewerUtils;
import ro.amiq.dvt.logviewer.indexing.LogViewerAttributeType;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructure;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;

public class LogViewerIndexingWorker
implements Runnable {
    private final int id;
    private final Path path;
    private final String pathInsideArchive;
    private final int startLine;
    private final int endLine;
    private final long startOffset;
    private final long associatedSize;
    private SeekableByteChannel fileChannel;
    private BufferedReader reader;
    private IndexWriter writer;
    private final List<LogViewerEntryStructure> structures;
    private final CountDownLatch doneLatch;
    private final StringBuilder entryBuilder = new StringBuilder();
    private int nofIndexedLines;
    private int nofIndexedEntries;
    private long indexingTime;
    private long indexedSize;
    private int crtLine;
    private int crtEntryStartLine;
    private int crtSliceEntryCount;
    private long crtSliceStartTime;
    private int prevEntrySize;
    private int prevEntryLineCount;
    private int prevStructureIndex = -1;
    private volatile boolean canceled;
    private volatile boolean finished;
    private volatile boolean enforcedFullIndexing;
    private final Semaphore sliceSemaphore = new Semaphore(0);
    private final Object requestLock = new Object();
    private CountDownLatch requestLatch;

    protected LogViewerIndexingWorker(int id, Path path, String pathInsideArchive, int startLine, int endLine, long startOffset, List<LogViewerEntryStructure> structures, CountDownLatch latch) {
        this.id = id;
        this.path = path;
        this.pathInsideArchive = pathInsideArchive;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startOffset = startOffset;
        this.associatedSize = LogViewerUtils.getFileSize(path) / 4L;
        this.crtEntryStartLine = startLine;
        this.crtLine = startLine - 1;
        this.structures = structures;
        this.doneLatch = latch;
    }

    protected void useWriter(IndexWriter writer) {
        this.writer = writer;
        this.initReader();
    }

    private void initReader() {
        try {
            block12: {
                if (this.pathInsideArchive != null) {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (FileSystem fs = FileSystems.newFileSystem(this.path);){
                        Path fileInZip = fs.getPath(this.pathInsideArchive, new String[0]);
                        this.fileChannel = Files.newByteChannel(fileInZip, new OpenOption[0]);
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                this.fileChannel = FileChannel.open(this.path, StandardOpenOption.READ);
            }
            this.fileChannel.position(this.startOffset);
            this.reader = new BufferedReader(new InputStreamReader(Channels.newInputStream(this.fileChannel)));
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.canceled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block29: {
            block27: {
                if (this.writer != null && this.reader != null) break block27;
                this.doneLatch.countDown();
                this.closeReader();
                Object object = this.requestLock;
                synchronized (object) {
                    if (this.requestLatch != null && this.sliceSemaphore.availablePermits() >= 0) {
                        this.requestLatch.countDown();
                    }
                }
                return;
            }
            try {
                try {
                    LogViewerConsole.INSTANCE.logInfo(LogViewerConst.workerCreationMessage(this.id, this.path));
                    while (!this.finished && !this.canceled) {
                        this.sliceSemaphore.acquire();
                        this.indexNextSlice();
                        Object object = this.requestLock;
                        synchronized (object) {
                            if (this.requestLatch != null && this.sliceSemaphore.availablePermits() == 0) {
                                this.requestLatch.countDown();
                            }
                        }
                        if (!this.finished && !this.canceled) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    this.doneLatch.countDown();
                    this.closeReader();
                    Object object = this.requestLock;
                    synchronized (object) {
                        if (this.requestLatch != null && this.sliceSemaphore.availablePermits() >= 0) {
                            this.requestLatch.countDown();
                        }
                        break block29;
                    }
                }
            }
            catch (Throwable throwable) {
                this.doneLatch.countDown();
                this.closeReader();
                Object object = this.requestLock;
                synchronized (object) {
                    if (this.requestLatch != null && this.sliceSemaphore.availablePermits() >= 0) {
                        this.requestLatch.countDown();
                    }
                }
                throw throwable;
            }
            this.doneLatch.countDown();
            this.closeReader();
            Object object = this.requestLock;
            synchronized (object) {
                if (this.requestLatch != null && this.sliceSemaphore.availablePermits() >= 0) {
                    this.requestLatch.countDown();
                }
            }
        }
    }

    protected void cancelWorker() {
        if (this.finished) {
            return;
        }
        this.canceled = true;
        this.sliceSemaphore.release(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void requestSlices(int count, CountDownLatch requestLatch) {
        if (this.finished || this.canceled) {
            requestLatch.countDown();
            return;
        }
        if (this.enforcedFullIndexing) {
            requestLatch.countDown();
            return;
        }
        this.softKillPrevRequest();
        Object object = this.requestLock;
        synchronized (object) {
            this.requestLatch = requestLatch;
            this.sliceSemaphore.release(count);
        }
    }

    private void softKillPrevRequest() {
        try {
            if (this.requestLatch == null) {
                return;
            }
            int availablePermits = this.sliceSemaphore.availablePermits();
            if (availablePermits > 1) {
                this.sliceSemaphore.acquire(availablePermits - 1);
            }
            this.requestLatch.await();
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void enforceFullIndexing() {
        try {
            if (this.finished || this.canceled || this.enforcedFullIndexing) {
                return;
            }
            if (this.requestLatch != null && this.requestLatch.getCount() > 0L) {
                this.requestLatch.await();
            }
            this.enforcedFullIndexing = true;
            this.sliceSemaphore.release(1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void indexNextSlice() throws IOException {
        String line;
        if (this.finished || this.canceled) {
            return;
        }
        this.crtSliceStartTime = System.currentTimeMillis();
        this.crtSliceEntryCount = 0;
        while ((line = this.reader.readLine()) != null) {
            if (this.isNewEntryStart(line) || (long)this.entryBuilder.length() >= 0x100000L) {
                this.indexPrevContent();
            } else if (this.entryBuilder.isEmpty()) {
                this.handleUnstructuredLine(line);
                if (!this.shouldStopIndexing()) continue;
                this.reportSliceIndexingTime();
                return;
            }
            if (!this.entryBuilder.isEmpty()) {
                this.entryBuilder.append(DVTStringUtil.LINE_SEPARATOR);
            }
            this.entryBuilder.append(line);
            ++this.crtLine;
            this.checkEntryStructuresMatch();
            if (!this.shouldStopIndexing()) continue;
            this.reportSliceIndexingTime();
            return;
        }
        this.indexPrevContent();
        this.reportSliceIndexingTime();
        this.finished = true;
    }

    private boolean isNewEntryStart(String line) {
        if (line == null || line.isEmpty()) {
            return false;
        }
        for (LogViewerEntryStructure structure : this.structures) {
            Pattern pattern = structure.getPattern();
            Matcher matcher = pattern.matcher(line);
            if (!matcher.lookingAt() && !matcher.hitEnd()) continue;
            return true;
        }
        return false;
    }

    private void indexPrevContent() throws IOException {
        String prevEntry = this.entryBuilder.substring(0, this.prevEntrySize);
        this.indexLogEntry(prevEntry, this.prevEntryLineCount, this.prevStructureIndex);
        this.indexTrailingLines();
        this.clearPrevContent();
        if (this.crtLine >= this.endLine) {
            this.writer.commit();
            this.finished = true;
        }
    }

    private void indexTrailingLines() {
        String[] unstructuredLines;
        if (this.entryBuilder.length() <= this.prevEntrySize) {
            return;
        }
        int trailingLinesStartIndex = 0;
        if (this.prevEntrySize > 0) {
            trailingLinesStartIndex = this.prevEntrySize + DVTStringUtil.LINE_SEPARATOR.length();
        }
        String[] stringArray = unstructuredLines = this.entryBuilder.substring(trailingLinesStartIndex).split(DVTStringUtil.LINE_SEPARATOR, -1);
        int n = unstructuredLines.length;
        int n2 = 0;
        while (n2 < n) {
            String unstructuredLine = stringArray[n2];
            this.indexLogEntry(unstructuredLine, 1, -1);
            ++n2;
        }
    }

    private void indexLogEntry(String logEntry, int lineCount, int structureId) {
        try {
            Document doc;
            if (lineCount == 0) {
                return;
            }
            if (logEntry == null || logEntry.isEmpty()) {
                logEntry = " ";
            }
            if ((doc = this.createDocument(logEntry, structureId)) == null) {
                LogViewerConsole.INSTANCE.logError(LogViewerConst.indexingErrorMessage(this.id, this.crtEntryStartLine, lineCount));
                this.crtEntryStartLine += lineCount;
                return;
            }
            this.writer.addDocument((Iterable)doc);
            this.crtEntryStartLine += lineCount;
            ++this.crtSliceEntryCount;
            ++this.nofIndexedEntries;
            this.nofIndexedLines += lineCount;
            this.indexedSize += (long)(logEntry.length() + DVTStringUtil.LINE_SEPARATOR.length());
            if (this.nofIndexedEntries % 20000 == 0) {
                this.writer.commit();
                long progress = this.getProgressPercentage();
                LogViewerConsole.INSTANCE.logInfo(LogViewerConst.indexingProgressMessage(this.id, this.nofIndexedEntries, progress));
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private Document createDocument(String logEntry, int structureId) {
        LogViewerEntryStructure structure = this.getEntryStructure(structureId);
        Map<String, LogViewerAttributeType> attributes = structure.getAttributes();
        Matcher matcher = structure.getPattern().matcher(logEntry);
        if (!matcher.find()) {
            return null;
        }
        Document doc = new Document();
        LogViewerAttributeType.LONG.addDocFields(doc, "log_line", Long.toString(this.crtEntryStartLine));
        LogViewerAttributeType.WORD.addDocFields(doc, "entry_structure", Integer.toString(structureId));
        int i = 1;
        for (Map.Entry<String, LogViewerAttributeType> attributeEntry : attributes.entrySet()) {
            String name = attributeEntry.getKey();
            LogViewerAttributeType attributeType = attributeEntry.getValue();
            String value = matcher.group(i++);
            attributeType.addDocFields(doc, name, value);
        }
        return doc;
    }

    private LogViewerEntryStructure getEntryStructure(int structureId) {
        if (structureId < 0 || structureId >= this.structures.size()) {
            return LogViewerConst.FALLBACK_STRUCTURE;
        }
        return this.structures.get(structureId);
    }

    private void checkEntryStructuresMatch() {
        if (this.entryBuilder.isEmpty()) {
            return;
        }
        String entryCandidate = this.entryBuilder.toString();
        for (LogViewerEntryStructure structure : this.structures) {
            Matcher matcher = structure.getPattern().matcher(entryCandidate);
            if (!matcher.matches()) continue;
            this.prevEntrySize = this.entryBuilder.length();
            this.prevEntryLineCount = this.crtLine - this.crtEntryStartLine + 1;
            this.prevStructureIndex = this.structures.indexOf(structure);
            return;
        }
    }

    private void handleUnstructuredLine(String line) throws IOException {
        if (this.id == 1) {
            this.indexLogEntry(line, 1, -1);
            ++this.crtLine;
            return;
        }
        ++this.crtLine;
        ++this.crtEntryStartLine;
        if (this.crtLine >= this.endLine) {
            this.writer.commit();
            this.finished = true;
        }
    }

    private boolean shouldStopIndexing() {
        if (this.canceled || this.finished) {
            return true;
        }
        if (this.enforcedFullIndexing) {
            return false;
        }
        long deltaTime = System.currentTimeMillis() - this.crtSliceStartTime;
        if (deltaTime >= 300L) {
            return true;
        }
        return this.crtSliceEntryCount >= 100;
    }

    private void reportSliceIndexingTime() {
        this.indexingTime += System.currentTimeMillis() - this.crtSliceStartTime;
    }

    private long getProgressPercentage() {
        long maxPercentage = this.finished ? 100 : 99;
        return Math.min(100L * this.indexedSize / this.associatedSize, maxPercentage);
    }

    public int getWorkerId() {
        return this.id;
    }

    public int getNofIndexedLines() {
        return this.nofIndexedLines;
    }

    public int getNofIndexedEntries() {
        return this.nofIndexedEntries;
    }

    public long getIndexingTime() {
        return this.indexingTime;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public boolean didFinish() {
        return this.finished;
    }

    private void clearPrevContent() {
        this.prevEntrySize = 0;
        this.prevEntryLineCount = 0;
        this.prevStructureIndex = -1;
        this.entryBuilder.setLength(0);
    }

    protected void closeReader() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = null;
            if (this.fileChannel != null) {
                this.fileChannel.close();
            }
            this.fileChannel = null;
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

