/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.indexing;

import java.util.concurrent.CompletableFuture;
import ro.amiq.dvt.logviewer.BaseLogViewerJob;
import ro.amiq.dvt.logviewer.LogFile;
import ro.amiq.dvt.logviewer.LogViewerConst;
import ro.amiq.dvt.logviewer.LogViewerUtils;
import ro.amiq.dvt.logviewer.indexing.LogViewerIndexingJob;
import ro.amiq.dvt.logviewer.query.LogViewerFinder;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerRefreshIndexingResponse;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;

public class LogViewerRefreshIndexingJob
extends BaseLogViewerJob {
    private final LogFile logFile;
    private final boolean enforceFullIndexing;
    private final CompletableFuture<LogViewerRefreshIndexingResponse> completableFuture;

    public LogViewerRefreshIndexingJob(LogFile logFile, boolean enforceFullIndexing) {
        super(LogViewerConst.refreshJobName(logFile.getFilePath()));
        this.logFile = logFile;
        this.enforceFullIndexing = enforceFullIndexing;
        this.completableFuture = new CompletableFuture();
    }

    @Override
    protected void doWork() {
        try {
            this.logFile.cancelActiveSearchJob(true);
            this.logFile.cancelActiveFinderJob(true);
            LogViewerIndexingJob indexingJob = this.logFile.getIndexingJob();
            if (!indexingJob.didFinish()) {
                indexingJob.cancel();
                indexingJob.join();
            }
            if (!this.logFile.hasLatestStructures()) {
                this.logFile.initStructures();
                LogViewerUtils.deleteIndexingFiles(this.logFile.getFilePath(), this.logFile.getConfigDirectoryLocation(), this.logFile);
            }
            this.logFile.clearIndexingConfiguration();
            LogViewerFinder finder = this.logFile.getFinder();
            finder.clearIndexingConfiguration();
            indexingJob = new LogViewerIndexingJob(this.logFile);
            if (this.enforceFullIndexing) {
                indexingJob.enforceFullIndexing();
            }
            indexingJob.schedule();
            this.logFile.setIndexingJob(indexingJob);
            Boolean canReuseIndexing = indexingJob.canReuseIndexing();
            if (!canReuseIndexing.booleanValue()) {
                finder.clearFilterCaching();
                finder.clearSearchCaching();
            }
            this.completableFuture.complete(new LogViewerRefreshIndexingResponse(canReuseIndexing));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.completableFuture.complete(null);
        }
    }

    @Override
    protected Objection getObjection() {
        return Objection.LOG_VIEWER_REFRESH_INDEXING;
    }

    public CompletableFuture<LogViewerRefreshIndexingResponse> getCompletableFuture() {
        return this.completableFuture;
    }
}

