/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.query;

import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import ro.amiq.dvt.logviewer.LogFile;
import ro.amiq.dvt.logviewer.LogViewerConst;
import ro.amiq.dvt.logviewer.LogViewerUtils;
import ro.amiq.dvt.logviewer.indexing.LogViewerAttributeProperty;
import ro.amiq.dvt.logviewer.indexing.LogViewerAttributeType;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructure;
import ro.amiq.dvt.logviewer.query.LogViewerAttributeWrapper;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.DVTConsoleHyperlinkUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public class LogViewerEntry {
    @SerializedName(value="message")
    private final String message;
    @SerializedName(value="details")
    private final LinkedHashMap<String, LogViewerAttributeWrapper> attributeMap;

    public LogViewerEntry(Document doc, List<LogViewerEntryStructure> structures, Set<String> hiddenFields) {
        this(doc, structures, hiddenFields, null);
    }

    public LogViewerEntry(Document doc, List<LogViewerEntryStructure> structures, Set<String> hiddenFields, LogFile logFile) {
        this.attributeMap = new LinkedHashMap();
        this.initAttributeValues(doc, structures, logFile);
        this.message = this.initMessage(doc, structures, hiddenFields);
    }

    private LogViewerEntry(String message, LinkedHashMap<String, LogViewerAttributeWrapper> attributeValues) {
        this.message = message;
        this.attributeMap = attributeValues;
    }

    private void initAttributeValues(Document doc, List<LogViewerEntryStructure> structures, LogFile logFile) {
        if (doc == null) {
            return;
        }
        int structureId = -1;
        for (IndexableField field : doc.getFields()) {
            String name = field.name();
            String value = doc.get(name);
            boolean isValidHyperlink = false;
            if ("entry_structure".equals(name)) {
                structureId = Integer.parseInt(value);
                if (structureId < 0 || structureId >= structures.size()) {
                    value = "N/A";
                } else {
                    LogViewerEntryStructure logViewerEntryStructure = structures.get(structureId);
                    LogViewerAttributeType logViewerAttributeType = logViewerEntryStructure.getAttributes().get(name);
                    isValidHyperlink = this.isValidHyperlink(value, logViewerAttributeType, logFile);
                    value = logViewerEntryStructure.getName();
                }
            } else {
                LogViewerAttributeType attrType = this.findAttrTypeFromStruct(structureId, structures, name);
                if (attrType != null && attrType.hasProperty(LogViewerAttributeProperty.IS_ENUM_VALUE) && (value = attrType.convertFromIndexedVersion(value)) == null) continue;
                if (!structures.isEmpty() && structureId >= 0 && structureId < structures.size()) {
                    isValidHyperlink = this.isValidHyperlink(value, structures.get(structureId).getAttributes().get(name), logFile);
                }
            }
            this.attributeMap.put(name, new LogViewerAttributeWrapper(value, isValidHyperlink));
        }
    }

    private LogViewerAttributeType findAttrTypeFromStruct(int structureId, List<LogViewerEntryStructure> structures, String name) {
        if (structures == null) {
            return null;
        }
        if (structureId != -1 && structureId < structures.size()) {
            return structures.get(structureId).getAttributeType(name);
        }
        for (LogViewerEntryStructure structure : structures) {
            LogViewerAttributeType attributeType = structure.getAttributeType(name);
            if (attributeType == null) continue;
            return attributeType;
        }
        return null;
    }

    private String initMessage(Document doc, List<LogViewerEntryStructure> structures, Set<String> hiddenAttributes) {
        if (structures == null || structures.isEmpty()) {
            return "";
        }
        LogViewerEntryStructure structure = LogViewerEntry.getStructure(doc, structures);
        if (hiddenAttributes == null) {
            hiddenAttributes = Collections.emptySet();
        }
        Map<String, LogViewerAttributeType> attributes = structure.getAttributes();
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = LogViewerConst.STRUCTURE_PARSING_PATTERN.matcher(structure.toString());
        while (matcher.find()) {
            String attrName = LogViewerUtils.getAttributeName(matcher.group(1));
            LogViewerAttributeType attrType = attributes.get(attrName);
            String replacement = this.computeAttributeReplacement(attrName, attrType, hiddenAttributes);
            matcher.appendReplacement(buffer, replacement);
            if (replacement == null || replacement.isEmpty() || attrType == null) continue;
            this.updateAttributeOffset(attrName, buffer.length() - replacement.length());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private void updateAttributeOffset(String attrType, int length) {
        LogViewerAttributeWrapper attributeWrapper;
        if ("file_line_str".equals(attrType)) {
            attrType = "file_path";
        }
        if ((attributeWrapper = this.attributeMap.get(attrType)) == null) {
            return;
        }
        attributeWrapper.setOffset(length);
    }

    private boolean isValidHyperlink(String hierarchyPath, LogViewerAttributeType attrType, LogFile logFile) {
        if (attrType == LogViewerAttributeType.FILE_PATH || attrType == LogViewerAttributeType.FILE_AND_LINE) {
            return true;
        }
        hierarchyPath = DVTStringUtil.replaceAll((Pattern)LogViewerConst.UVM_SEQUENCE_ITEM_PATTERN, (CharSequence)hierarchyPath, (String)"");
        return logFile == null || DVTConsoleHyperlinkUtils.getInstance().isValidHyperlink(hierarchyPath, logFile.getUvmTestTop(), logFile.getAssociatedProject());
    }

    private String computeAttributeReplacement(String attrName, LogViewerAttributeType attrType, Set<String> hiddenAttributes) {
        if (attrType == LogViewerAttributeType.FILE_AND_LINE) {
            return this.computeFileAndLineReplacement(attrName, hiddenAttributes);
        }
        if (hiddenAttributes.contains(attrName)) {
            return "";
        }
        LogViewerAttributeWrapper logViewerAttributeWrapper = this.attributeMap.get(attrName);
        if (logViewerAttributeWrapper == null) {
            return "";
        }
        String replacement = logViewerAttributeWrapper.getAttributeValue();
        if (replacement != null) {
            return Matcher.quoteReplacement(replacement);
        }
        return "";
    }

    private String computeFileAndLineReplacement(String attrName, Set<String> hiddenAttributes) {
        String filePathAttr = LogViewerAttributeType.FILE_PATH.toString();
        if (!this.attributeMap.containsKey(filePathAttr)) {
            return "";
        }
        if (hiddenAttributes.contains(attrName)) {
            return "";
        }
        String filePath = !hiddenAttributes.contains(filePathAttr) ? this.attributeMap.get(filePathAttr).getAttributeValue() : "";
        String fileLineAttr = LogViewerAttributeType.FILE_LINE.toString();
        String fileLine = !hiddenAttributes.contains(fileLineAttr) ? this.attributeMap.get(fileLineAttr).getAttributeValue() : "";
        return Matcher.quoteReplacement(String.valueOf(filePath) + "(" + fileLine + ") ");
    }

    private static LogViewerEntryStructure getStructure(Document doc, List<LogViewerEntryStructure> structures) {
        String value = doc.get("entry_structure");
        if (value == null) {
            return LogViewerConst.FALLBACK_STRUCTURE;
        }
        try {
            Integer structureId = Integer.valueOf(value);
            if (structureId == -1) {
                return LogViewerConst.FALLBACK_STRUCTURE;
            }
            return structures.get(structureId);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return LogViewerConst.FALLBACK_STRUCTURE;
        }
    }

    public int getLogLine() {
        if (!this.attributeMap.containsKey("log_line")) {
            return 0;
        }
        String logLine = this.attributeMap.get("log_line").getAttributeValue();
        return Integer.parseInt(logLine);
    }

    protected boolean isUnstructured() {
        if (!this.attributeMap.containsKey("entry_structure")) {
            return true;
        }
        String structureName = this.attributeMap.get("entry_structure").getAttributeValue();
        return "N/A".equals(structureName);
    }

    protected String getUnstructuredMessage() {
        if (!this.isUnstructured()) {
            return null;
        }
        return this.attributeMap.get("message").getAttributeValue();
    }

    protected void removeUnstructuredAttributes() {
        if (!this.isUnstructured()) {
            return;
        }
        this.attributeMap.remove("message");
    }

    public String getAttributeValue(String attribute) {
        if (attribute == null) {
            return null;
        }
        LogViewerAttributeWrapper attributeWrapper = this.attributeMap.get(attribute);
        if (attributeWrapper == null) {
            return null;
        }
        return attributeWrapper.getAttributeValue();
    }

    protected static LogViewerEntry createUnstructuredEntry(String message, int logLine) {
        LinkedHashMap<String, LogViewerAttributeWrapper> attributes = new LinkedHashMap<String, LogViewerAttributeWrapper>();
        attributes.put("log_line", new LogViewerAttributeWrapper(Integer.toString(logLine), false));
        attributes.put("entry_structure", new LogViewerAttributeWrapper("N/A", false));
        return new LogViewerEntry(message, attributes);
    }

    public LinkedHashMap<String, LogViewerAttributeWrapper> testGetAttributes() {
        if (!TestHelper.isTestMode()) {
            return null;
        }
        return this.attributeMap;
    }

    public int hashCode() {
        return Objects.hash(this.attributeMap, this.message);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogViewerEntry other = (LogViewerEntry)obj;
        return Objects.equals(this.attributeMap, other.attributeMap) && Objects.equals(this.message, other.message);
    }

    public String toString() {
        return this.message;
    }
}

