/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import ro.amiq.dvt.logviewer.LogFile;
import ro.amiq.dvt.logviewer.LogFileManager;
import ro.amiq.dvt.logviewer.LogViewerConsole;
import ro.amiq.dvt.logviewer.LogViewerConst;
import ro.amiq.dvt.logviewer.LogViewerShutdownException;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructure;
import ro.amiq.dvt.logviewer.query.LogViewerEntry;
import ro.amiq.dvt.logviewer.query.LogViewerQueryWrapper;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;

public class LogViewerFinder {
    private static final int TEST_MAX_ENTRIES = 10000;
    private final LogFile logFile;
    private Directory indexDir;
    private IndexWriter writer;
    private SearcherManager searcherManager;
    private List<LogViewerEntryStructure> entryStructures;
    private boolean finishedIndexing;
    private int cachedResultsNumber = -1;
    private int cachedPageIndex = -1;
    private ScoreDoc[] cachedPageScoreDocs = null;
    private ScoreDoc[] lastPageScoreDocs = null;
    private LogViewerQueryWrapper cachedQueryWrapper = null;
    private int cachedSearchEntryIndex = -1;
    private ScoreDoc cachedSearchEntryScoreDoc = null;
    private final Object searcherManagerLock = new Object();

    public LogViewerFinder(LogFile logFile) {
        this.logFile = logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFinishedIndexing(boolean finishedIndexing) {
        try {
            if (this.finishedIndexing == finishedIndexing) {
                return;
            }
            this.finishedIndexing = finishedIndexing;
            if (!finishedIndexing) {
                return;
            }
            this.configureIndexingIfNeeded();
            Object object = this.searcherManagerLock;
            synchronized (object) {
                if (this.searcherManager != null) {
                    this.searcherManager.close();
                }
                if (this.indexDir == null) {
                    this.searcherManager = null;
                    return;
                }
                this.searcherManager = new SearcherManager(this.indexDir, null);
            }
        }
        catch (LogViewerShutdownException logViewerShutdownException) {
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void clearFilterCaching() {
        this.cachedResultsNumber = -1;
        this.cachedPageIndex = -1;
        this.cachedQueryWrapper = null;
        this.cachedPageScoreDocs = null;
        this.lastPageScoreDocs = null;
    }

    public Document findFirst(LogViewerQueryWrapper queryWrapper) throws IOException {
        IndexSearcher searcher;
        Query query = queryWrapper.getQuery();
        if (query == null) {
            query = new MatchAllDocsQuery();
        }
        if ((searcher = this.getSearcher()) == null) {
            return null;
        }
        TopDocs topDocs = searcher.search(query, 1);
        if (topDocs == null) {
            return null;
        }
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        if (scoreDocs == null || scoreDocs.length == 0) {
            return null;
        }
        StoredFields storedFields = searcher.storedFields();
        if (storedFields == null) {
            return null;
        }
        return storedFields.document(scoreDocs[0].doc);
    }

    public synchronized List<LogViewerEntry> find(LogViewerQueryWrapper queryWrapper, int pageIndex, Supplier<Boolean> isCanceled) throws IOException {
        IndexSearcher searcher;
        Sort sort;
        if (pageIndex < 0 || isCanceled.get().booleanValue()) {
            return Collections.emptyList();
        }
        if (!Objects.equals(queryWrapper, this.cachedQueryWrapper)) {
            this.clearFilterCaching();
            this.clearSearchCaching();
        }
        if (pageIndex == this.cachedPageIndex) {
            return this.docsToEntries(this.cachedPageScoreDocs, queryWrapper.getHiddenFields());
        }
        Query query = queryWrapper.getQuery();
        if (query == null) {
            query = new MatchAllDocsQuery();
        }
        if ((sort = queryWrapper.getSort()) == null) {
            sort = LogViewerConst.DEFAULT_SORT;
        }
        if ((searcher = this.getSearcher()) == null) {
            return Collections.emptyList();
        }
        this.cachedQueryWrapper = queryWrapper;
        if (this.finishedIndexing && this.cachedResultsNumber <= 0) {
            this.cachedResultsNumber = this.count(queryWrapper.getQuery());
        }
        ScoreDoc anchorScoreDoc = null;
        int nofPagesToAnchor = 0;
        boolean reversedOrder = false;
        int firstBatchSize = 100;
        int firstPageDifference = pageIndex;
        int cachedPageDifference = Math.abs(this.cachedPageIndex - pageIndex);
        int lastPageIndex = Math.max((this.cachedResultsNumber - 1) / 100, 0);
        int lastPageDifference = Math.abs(lastPageIndex - pageIndex);
        if (this.finishedIndexing && pageIndex > lastPageIndex) {
            return Collections.emptyList();
        }
        int cachedSearchPageIndex = this.getCachedSearchPageIndex();
        int cachedSearchPageDifference = Math.abs(cachedSearchPageIndex - pageIndex);
        nofPagesToAnchor = Math.min(firstPageDifference, Math.min(cachedPageDifference, Math.min(lastPageDifference, cachedSearchPageDifference)));
        int anchorPageIndex = -1;
        if (nofPagesToAnchor == firstPageDifference) {
            anchorPageIndex = 0;
        } else if (nofPagesToAnchor == cachedPageDifference && this.cachedPageScoreDocs != null && this.cachedPageScoreDocs.length > 0) {
            anchorPageIndex = this.cachedPageIndex;
            anchorScoreDoc = pageIndex > this.cachedPageIndex ? this.cachedPageScoreDocs[this.cachedPageScoreDocs.length - 1] : this.cachedPageScoreDocs[0];
        } else if (this.finishedIndexing && nofPagesToAnchor == lastPageDifference) {
            anchorPageIndex = lastPageIndex + 1;
            firstBatchSize = this.cachedResultsNumber - lastPageIndex * 100;
        } else if (this.finishedIndexing && nofPagesToAnchor == cachedSearchPageDifference) {
            anchorPageIndex = cachedSearchPageIndex;
            anchorScoreDoc = this.findSearchAnchorDoc(pageIndex, query, sort, searcher);
            if (pageIndex == cachedSearchPageIndex) {
                LinkedList<ScoreDoc> scoreDocList = new LinkedList<ScoreDoc>();
                scoreDocList.add(anchorScoreDoc);
                ScoreDoc[] scoreDocs = this.searchAfter(anchorScoreDoc, 1, query, sort, searcher, 99, isCanceled);
                if (scoreDocs != null) {
                    scoreDocList.addAll(List.of(scoreDocs));
                }
                this.lastPageScoreDocs = scoreDocList.toArray(new ScoreDoc[100]);
                this.cacheCompletedPage(pageIndex);
                return this.docsToEntries(this.lastPageScoreDocs, queryWrapper.getHiddenFields());
            }
        }
        if (anchorPageIndex > pageIndex) {
            reversedOrder = true;
            sort = LogViewerFinder.reverseSort(sort);
        }
        if (anchorScoreDoc == null) {
            ++nofPagesToAnchor;
        }
        this.lastPageScoreDocs = this.searchAfter(anchorScoreDoc, nofPagesToAnchor, query, sort, searcher, firstBatchSize, isCanceled);
        if (reversedOrder && this.lastPageScoreDocs != null) {
            Collections.reverse(Arrays.asList(this.lastPageScoreDocs));
        }
        List<LogViewerEntry> entries = this.docsToEntries(this.lastPageScoreDocs, queryWrapper.getHiddenFields());
        if (this.finishedIndexing && entries != null && !entries.isEmpty()) {
            this.cacheCompletedPage(pageIndex);
        }
        return entries;
    }

    private int getCachedSearchPageIndex() {
        return Math.max((this.cachedSearchEntryIndex - 1) / 100, 0);
    }

    private ScoreDoc findSearchAnchorDoc(int pageIndex, Query query, Sort sort, IndexSearcher searcher) {
        ScoreDoc[] scoreDocs;
        block12: {
            TopDocs topDocs;
            block11: {
                block10: {
                    block9: {
                        try {
                            if (this.cachedSearchEntryIndex > 0) break block9;
                            return null;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return null;
                        }
                    }
                    if (query != null && sort != null && searcher != null) break block10;
                    return null;
                }
                int cachedSearchPageIndex = (this.cachedSearchEntryIndex - 1) / 100;
                int nofEntries = 0;
                if (pageIndex <= cachedSearchPageIndex) {
                    nofEntries = this.cachedSearchEntryIndex - cachedSearchPageIndex * 100;
                    sort = LogViewerFinder.reverseSort(sort);
                } else {
                    nofEntries = Math.min((cachedSearchPageIndex + 1) * 100 - 1, this.cachedResultsNumber);
                }
                if (nofEntries == 0) {
                    return this.cachedSearchEntryScoreDoc;
                }
                topDocs = searcher.searchAfter(this.cachedSearchEntryScoreDoc, query, nofEntries, sort);
                if (topDocs != null) break block11;
                return null;
            }
            scoreDocs = topDocs.scoreDocs;
            if (scoreDocs != null && scoreDocs.length != 0) break block12;
            return null;
        }
        return scoreDocs[scoreDocs.length - 1];
    }

    protected static Sort reverseSort(Sort originalSort) {
        if (originalSort == null) {
            return null;
        }
        SortField[] originalFields = originalSort.getSort();
        SortField[] reversedFields = new SortField[originalFields.length];
        int i = 0;
        while (i < originalFields.length) {
            SortField field = originalFields[i];
            reversedFields[i] = new SortField(field.getField(), field.getType(), !field.getReverse());
            ++i;
        }
        return new Sort(reversedFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureIndexingIfNeeded() throws LogViewerShutdownException {
        try {
            if (this.indexDir != null) {
                return;
            }
            this.indexDir = this.logFile.getIndexDirectory();
            if (this.indexDir == null) {
                LogFileManager.INSTANCE.awaitPrevShutdownJobs(this.logFile);
                this.logFile.configureIndexing();
                this.indexDir = this.logFile.getIndexDirectory();
            }
            this.writer = this.logFile.getIndexWriter();
            this.entryStructures = this.logFile.getEntryStructures();
            if (this.finishedIndexing) {
                return;
            }
            Object object = this.searcherManagerLock;
            synchronized (object) {
                this.searcherManager = new SearcherManager(this.writer, null);
            }
        }
        catch (IOException e) {
            LogViewerConsole.INSTANCE.logError("Error while initializing the Log Viewer!");
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void cacheCompletedPage(int pageIndex) {
        this.cachedPageIndex = pageIndex;
        this.cachedPageScoreDocs = this.lastPageScoreDocs;
    }

    private ScoreDoc[] searchAfter(ScoreDoc scoreDocAnchor, int nofPagesToAnchor, Query query, Sort sort, IndexSearcher searcher, int batchSize, Supplier<Boolean> isCanceled) throws IOException {
        long anchorTime = System.currentTimeMillis();
        int i = 1;
        while (i <= nofPagesToAnchor) {
            TopDocs topDocs;
            long timeInterval = System.currentTimeMillis() - anchorTime;
            if (timeInterval >= LogViewerConst.JOB_CANCELING_CHECK_PERIOD) {
                if (isCanceled.get().booleanValue()) {
                    return null;
                }
                anchorTime = System.currentTimeMillis();
            }
            if ((topDocs = searcher.searchAfter(scoreDocAnchor, query, i == 1 ? batchSize : 100, sort)) == null) {
                return null;
            }
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            if (scoreDocs == null || scoreDocs.length == 0) {
                return null;
            }
            if (i == nofPagesToAnchor) {
                return scoreDocs;
            }
            scoreDocAnchor = scoreDocs[scoreDocs.length - 1];
            ++i;
        }
        return null;
    }

    private List<LogViewerEntry> docsToEntries(ScoreDoc[] scoreDocs, Set<String> hiddenFields) {
        try {
            if (scoreDocs == null) {
                return Collections.emptyList();
            }
            IndexSearcher searcher = this.getSearcher();
            if (searcher == null) {
                return Collections.emptyList();
            }
            StoredFields storedFields = searcher.storedFields();
            ArrayList<LogViewerEntry> entries = new ArrayList<LogViewerEntry>(scoreDocs.length);
            ScoreDoc[] scoreDocArray = scoreDocs;
            int n = scoreDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc sd = scoreDocArray[n2];
                if (sd != null) {
                    Document doc = storedFields.document(sd.doc);
                    entries.add(new LogViewerEntry(doc, this.entryStructures, hiddenFields, this.logFile));
                }
                ++n2;
            }
            return entries;
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    public int count(Query query) {
        IndexSearcher searcher;
        block4: {
            try {
                if (query == null) {
                    query = new MatchAllDocsQuery();
                }
                if ((searcher = this.getSearcher()) != null) break block4;
                return 0;
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return 0;
            }
        }
        return searcher.count(query);
    }

    protected LogViewerEntry findEntryByLine(Query query, long logLine) {
        Document document;
        block13: {
            ScoreDoc scoreDoc;
            IndexSearcher searcher;
            block12: {
                ScoreDoc[] scoreDocs;
                block11: {
                    TopDocs topDocs;
                    block10: {
                        BooleanQuery finalQuery;
                        block9: {
                            block8: {
                                try {
                                    if (query != null && logLine >= 0L) break block8;
                                    return null;
                                }
                                catch (IOException e) {
                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                    return null;
                                }
                            }
                            Query uidQuery = LongPoint.newExactQuery((String)"log_line", (long)logLine);
                            finalQuery = new BooleanQuery.Builder().add(query, BooleanClause.Occur.FILTER).add(uidQuery, BooleanClause.Occur.FILTER).build();
                            searcher = this.getSearcher();
                            if (searcher != null) break block9;
                            return null;
                        }
                        topDocs = searcher.search((Query)finalQuery, 1);
                        if (topDocs != null) break block10;
                        return null;
                    }
                    scoreDocs = topDocs.scoreDocs;
                    if (scoreDocs != null && scoreDocs.length != 0) break block11;
                    return null;
                }
                scoreDoc = scoreDocs[0];
                if (scoreDoc != null) break block12;
                return null;
            }
            document = searcher.storedFields().document(scoreDoc.doc);
            if (document != null) break block13;
            return null;
        }
        return new LogViewerEntry(document, this.entryStructures, null);
    }

    protected LogViewerEntry findFirst(Query query, Sort sort) {
        Document document;
        block13: {
            IndexSearcher searcher;
            block12: {
                ScoreDoc[] scoreDocs;
                block11: {
                    TopFieldDocs topDocs;
                    block10: {
                        block9: {
                            block8: {
                                try {
                                    if (query != null && sort != null) break block8;
                                    return null;
                                }
                                catch (IOException e) {
                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                    return null;
                                }
                            }
                            searcher = this.getSearcher();
                            if (searcher != null) break block9;
                            return null;
                        }
                        topDocs = searcher.search(query, 1, sort);
                        if (topDocs != null) break block10;
                        return null;
                    }
                    scoreDocs = topDocs.scoreDocs;
                    if (scoreDocs != null && scoreDocs.length != 0) break block11;
                    return null;
                }
                this.cachedSearchEntryScoreDoc = scoreDocs[0];
                if (this.cachedSearchEntryScoreDoc != null) break block12;
                return null;
            }
            document = searcher.storedFields().document(this.cachedSearchEntryScoreDoc.doc);
            if (document != null) break block13;
            return null;
        }
        return new LogViewerEntry(document, this.entryStructures, null);
    }

    public LogViewerEntry findLast(Query query, Sort sort) {
        return this.findFirst(query, LogViewerFinder.reverseSort(sort));
    }

    protected void cacheSearchEntry(int entryId) {
        this.cachedSearchEntryIndex = entryId;
    }

    public void clearSearchCaching() {
        this.cachedSearchEntryIndex = -1;
        this.cachedSearchEntryScoreDoc = null;
    }

    public void clearFirstPageCaching() {
        if (this.cachedPageIndex == 0) {
            this.clearFilterCaching();
        }
        if (this.cachedSearchEntryIndex <= 100) {
            this.clearSearchCaching();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher getSearcher() {
        try {
            Object object = this.searcherManagerLock;
            synchronized (object) {
                try {
                    this.configureIndexingIfNeeded();
                    this.searcherManager.maybeRefresh();
                }
                catch (AlreadyClosedException alreadyClosedException) {
                    this.setFinishedIndexing(true);
                }
                return (IndexSearcher)this.searcherManager.acquire();
            }
        }
        catch (LogViewerShutdownException logViewerShutdownException) {
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIndexingConfiguration() {
        try {
            try {
                this.indexDir = null;
                this.writer = null;
                this.entryStructures = null;
                this.finishedIndexing = false;
                this.cachedResultsNumber = -1;
                Object object = this.searcherManagerLock;
                synchronized (object) {
                    if (this.searcherManager != null) {
                        this.searcherManager.close();
                    }
                }
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.searcherManager = null;
            }
        }
        finally {
            this.searcherManager = null;
        }
    }

    public List<LogViewerEntry> testGetAllEntries() throws IOException {
        if (!TestHelper.isTestMode()) {
            return null;
        }
        IndexSearcher searcher = this.getSearcher();
        TopFieldDocs topDocs = searcher.search((Query)new MatchAllDocsQuery(), 10000, LogViewerConst.DEFAULT_SORT);
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        List<LogViewerEntry> entries = this.docsToEntries(scoreDocs, null);
        return entries;
    }
}

