/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.query;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import ro.amiq.dvt.logviewer.BaseLogViewerJob;
import ro.amiq.dvt.logviewer.LogFile;
import ro.amiq.dvt.logviewer.LogFileManager;
import ro.amiq.dvt.logviewer.LogViewerConsole;
import ro.amiq.dvt.logviewer.LogViewerConst;
import ro.amiq.dvt.logviewer.indexing.LogViewerIndexingJob;
import ro.amiq.dvt.logviewer.indexing.LogViewerIndexingWorker;
import ro.amiq.dvt.logviewer.query.LogViewerEntry;
import ro.amiq.dvt.logviewer.query.LogViewerFinder;
import ro.amiq.dvt.logviewer.query.LogViewerQueryWrapper;
import ro.amiq.dvt.logviewer.webview.LogViewerRequestsManager;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerUpdateEntriesParams;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;

public class LogViewerFinderJob
extends BaseLogViewerJob {
    private final LogViewerQueryWrapper queryWrapper;
    private final LogViewerFinder finder;
    private final LogViewerIndexingJob indexer;
    private final LinkedList<Integer> pageIndexes;
    private List<LogViewerEntry> crtResults;

    public LogViewerFinderJob(LogViewerQueryWrapper queryWrapper, int pageIndex, LogViewerFinder finder, LogViewerIndexingJob indexer) {
        super(LogViewerConst.finderJobName(indexer.getFilePath()));
        this.queryWrapper = queryWrapper;
        this.finder = finder;
        this.indexer = indexer;
        this.pageIndexes = new LinkedList();
        this.findPage(pageIndex);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doWork() {
        long time = System.currentTimeMillis();
        String filePath = this.indexer.getFilePath();
        try {
            try {
                this.indexer.awaitWorkerCreation();
                List<Object> prevResults = Collections.emptyList();
                while (!this.isCanceled()) {
                    if (this.pageIndexes.isEmpty()) {
                        return;
                    }
                    int pageIndex = this.pageIndexes.peek();
                    boolean finishedIndexing = this.indexer.didFinish();
                    this.finder.setFinishedIndexing(finishedIndexing);
                    this.crtResults = this.finder.find(this.queryWrapper, pageIndex, () -> this.isCanceled());
                    boolean foundFinalResults = finishedIndexing || this.foundFinalResults();
                    this.handleUnstructuredEntries();
                    if (foundFinalResults || !Objects.equals(prevResults, this.crtResults)) {
                        LogViewerUpdateEntriesParams entriesParams = new LogViewerUpdateEntriesParams(filePath, pageIndex, this.crtResults, foundFinalResults);
                        LogViewerRequestsManager.INSTANCE.updateLogEntries(entriesParams);
                    }
                    if (foundFinalResults) {
                        this.pageIndexes.pop();
                        this.finder.cacheCompletedPage(pageIndex);
                        time = System.currentTimeMillis() - time;
                        LogViewerConsole.INSTANCE.logInfo(LogViewerConst.completedEntryPageMessage(filePath, this.queryWrapper.getFilterText(), this.crtResults.size(), pageIndex, time));
                        time = System.currentTimeMillis();
                        continue;
                    }
                    this.finder.clearFilterCaching();
                    prevResults = this.crtResults;
                    this.indexer.requestSlices(1);
                }
                return;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                LogFile logFile = LogFileManager.INSTANCE.getLogFile(filePath);
                if (logFile != null) {
                    logFile.clearFinderJob(this);
                }
                if (!this.isCanceled()) return;
                LogViewerConsole.INSTANCE.logInfo(LogViewerConst.canceledJobMessage(this.getName()));
                return;
            }
        }
        finally {
            LogFile logFile = LogFileManager.INSTANCE.getLogFile(filePath);
            if (logFile != null) {
                logFile.clearFinderJob(this);
            }
            if (this.isCanceled()) {
                LogViewerConsole.INSTANCE.logInfo(LogViewerConst.canceledJobMessage(this.getName()));
            }
        }
    }

    @Override
    protected Objection getObjection() {
        return Objection.LOG_VIEWER_PAGE;
    }

    private void handleUnstructuredEntries() {
        if (this.crtResults == null || this.crtResults.isEmpty()) {
            return;
        }
        this.crtResults.stream().forEach(e -> {
            if (e.isUnstructured()) {
                e.removeUnstructuredAttributes();
            }
        });
    }

    private boolean foundFinalResults() {
        if (this.crtResults == null) {
            return false;
        }
        Set<LogViewerIndexingWorker> workers = this.indexer.getWorkers();
        if (this.crtResults.size() < 100) {
            for (LogViewerIndexingWorker worker : workers) {
                if (worker.didFinish()) continue;
                return false;
            }
            return true;
        }
        int lastWorkerId = this.getLastContributingWorkerId(workers);
        for (LogViewerIndexingWorker worker : workers) {
            if (worker.getWorkerId() >= lastWorkerId) break;
            if (worker.didFinish()) continue;
            return false;
        }
        return true;
    }

    private int getLastContributingWorkerId(Set<LogViewerIndexingWorker> workers) {
        int lastWorkerId = 0;
        for (LogViewerEntry entry : this.crtResults) {
            int logLine = entry.getLogLine();
            int workerId = 0;
            for (LogViewerIndexingWorker worker : workers) {
                if (logLine < worker.getStartLine()) break;
                ++workerId;
            }
            if (workerId <= lastWorkerId) continue;
            lastWorkerId = workerId;
        }
        return lastWorkerId;
    }

    public void findPage(int pageIndex) {
        this.pageIndexes.add(pageIndex);
        LogViewerConsole.INSTANCE.logInfo(LogViewerConst.requestedEntryPageMessage(this.indexer.getFilePath(), this.queryWrapper.getFilterText(), pageIndex));
    }

    public LogViewerQueryWrapper getQueryWrapper() {
        return this.queryWrapper;
    }

    public LogViewerFinder getFinder() {
        return this.finder;
    }
}

