/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.query;

import java.util.concurrent.CompletableFuture;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import ro.amiq.dvt.logviewer.BaseLogViewerJob;
import ro.amiq.dvt.logviewer.LogFile;
import ro.amiq.dvt.logviewer.LogFileManager;
import ro.amiq.dvt.logviewer.LogViewerConsole;
import ro.amiq.dvt.logviewer.LogViewerConst;
import ro.amiq.dvt.logviewer.indexing.LogViewerAttributeProperty;
import ro.amiq.dvt.logviewer.indexing.LogViewerAttributeType;
import ro.amiq.dvt.logviewer.query.LogViewerEntry;
import ro.amiq.dvt.logviewer.query.LogViewerFinder;
import ro.amiq.dvt.logviewer.query.LogViewerQueryWrapper;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerQueryOperator;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerQueryParserUtils;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerGetSearchMatchResponse;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;

public class LogViewerSearchJob
extends BaseLogViewerJob {
    private final String filePath;
    private final Query searchQuery;
    private final boolean searchForward;
    private final long anchorLogLine;
    private final LogViewerQueryWrapper queryWrapper;
    private final LogViewerFinder finder;
    private final CompletableFuture<LogViewerGetSearchMatchResponse> result;

    public LogViewerSearchJob(Query searchQuery, boolean searchForward, long anchorLogLine, LogViewerQueryWrapper queryWrapper, LogViewerFinder finder, String filePath) {
        super(LogViewerConst.searchJobName(filePath));
        this.filePath = filePath;
        this.searchQuery = searchQuery;
        this.anchorLogLine = anchorLogLine;
        this.searchForward = searchForward;
        this.queryWrapper = queryWrapper;
        this.finder = finder;
        this.result = new CompletableFuture();
    }

    @Override
    protected void doWork() {
        try {
            if (this.queryWrapper == null || this.searchQuery == null) {
                this.result.complete(null);
                return;
            }
            try {
                LogViewerGetSearchMatchResponse response = this.computeResponse();
                this.result.complete(response);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.result.complete(null);
            }
        }
        finally {
            LogFile logFile = LogFileManager.INSTANCE.getLogFile(this.filePath);
            if (logFile != null) {
                logFile.clearSearchJob(this);
            }
            if (this.isCanceled()) {
                LogViewerConsole.INSTANCE.logInfo(LogViewerConst.canceledJobMessage(this.getName()));
            }
        }
    }

    @Override
    protected Objection getObjection() {
        return Objection.LOG_VIEWER_SEARCH;
    }

    private LogViewerGetSearchMatchResponse computeResponse() {
        if (this.queryWrapper == null || this.searchQuery == null) {
            return null;
        }
        LogViewerEntry firstMatch = this.findEntryMatch();
        if (firstMatch == null) {
            return null;
        }
        Integer entryId = this.findEntryIndex(firstMatch, false);
        if (entryId == null) {
            return null;
        }
        this.finder.cacheSearchEntry(entryId);
        Integer matchIndex = this.findEntryIndex(firstMatch, true);
        if (matchIndex == null) {
            return null;
        }
        return new LogViewerGetSearchMatchResponse(entryId, matchIndex);
    }

    private LogViewerEntry findEntryMatch() {
        Query completeQuery;
        if (this.isCanceled()) {
            return null;
        }
        Sort sort = this.queryWrapper.getSort();
        if (!this.searchForward) {
            sort = LogViewerFinder.reverseSort(sort);
        }
        if ((completeQuery = this.buildCompleteQuery(sort)) == null) {
            return null;
        }
        LogViewerEntry entryMatch = this.finder.findFirst(completeQuery, sort);
        if (entryMatch != null) {
            return entryMatch;
        }
        completeQuery = this.buildCompleteQuery(null);
        return this.finder.findFirst(completeQuery, sort);
    }

    private Integer findEntryIndex(LogViewerEntry entry, boolean includeSearchQuery) {
        if (this.isCanceled() || entry == null) {
            return null;
        }
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add(this.queryWrapper.getQuery(), BooleanClause.Occur.MUST);
        if (includeSearchQuery) {
            queryBuilder.add(this.searchQuery, BooleanClause.Occur.MUST);
        }
        this.addSortQueries(queryBuilder, this.queryWrapper.getSort(), entry, true);
        return this.finder.count((Query)queryBuilder.build()) - 1;
    }

    private Query buildCompleteQuery(Sort sort) {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add(this.queryWrapper.getQuery(), BooleanClause.Occur.MUST);
        queryBuilder.add(this.searchQuery, BooleanClause.Occur.MUST);
        if (sort == null || this.anchorLogLine < 0L) {
            return queryBuilder.build();
        }
        LogViewerEntry anchorEntry = this.finder.findEntryByLine(this.queryWrapper.getQuery(), this.anchorLogLine);
        if (anchorEntry == null) {
            return queryBuilder.build();
        }
        Query differentFromAnchorQuery = LogViewerQueryParserUtils.createLongQuery("log_line", LogViewerQueryOperator.NOT_EQUAL, Long.toString(this.anchorLogLine));
        queryBuilder.add(differentFromAnchorQuery, BooleanClause.Occur.MUST);
        this.addSortQueries(queryBuilder, sort, anchorEntry, false);
        return queryBuilder.build();
    }

    private void addSortQueries(BooleanQuery.Builder queryBuilder, Sort sort, LogViewerEntry anchorEntry, boolean findPrevEntries) {
        if (queryBuilder == null || sort == null || anchorEntry == null) {
            return;
        }
        SortField[] sortFieldArray = sort.getSort();
        int n = sortFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attr;
            String anchorFieldValue;
            String sortableAttr;
            SortField field = sortFieldArray[n2];
            SortField.Type type = field.getType();
            if (type != null && (sortableAttr = field.getField()) != null && (anchorFieldValue = anchorEntry.getAttributeValue(attr = sortableAttr.substring(0, sortableAttr.length() - "_sortable".length()))) != null) {
                boolean reverse = field.getReverse();
                if (findPrevEntries) {
                    reverse = !reverse;
                }
                LogViewerQueryOperator op = reverse ? LogViewerQueryOperator.LESS_OR_EQUAL : LogViewerQueryOperator.GREATER_OR_EQUAL;
                LogFile logFile = LogFileManager.INSTANCE.getLogFile(this.filePath);
                if (logFile == null) {
                    return;
                }
                LogViewerAttributeType attrType = logFile.getAttributeType(attr);
                if (attrType == null || !attrType.hasProperty(LogViewerAttributeProperty.IS_ENUM_VALUE) || (anchorFieldValue = attrType.convertToIndexedVersion(anchorFieldValue)) != null) {
                    switch (type) {
                        case INT: {
                            queryBuilder.add(LogViewerQueryParserUtils.createIntQuery(attr, op, anchorFieldValue), BooleanClause.Occur.MUST);
                            break;
                        }
                        case LONG: {
                            queryBuilder.add(LogViewerQueryParserUtils.createLongQuery(attr, op, anchorFieldValue), BooleanClause.Occur.MUST);
                            break;
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public CompletableFuture<LogViewerGetSearchMatchResponse> getCompletableFuture() {
        return this.result;
    }
}

