/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.query.parsing;

import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.logviewer.LogViewerConst;
import ro.amiq.dvt.logviewer.indexing.LogViewerAttributeProperty;
import ro.amiq.dvt.logviewer.indexing.LogViewerAttributeType;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructure;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerContentAssistAvailableException;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerContentAssistQueryParser;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerQueryLexer;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerQueryOperator;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerQueryParsingStatus;

public class LogViewerContentAssistProvider {
    private LogViewerContentAssistProvider() {
    }

    public static Set<String> computeFilterProposals(String filterText, int cursorPosition, List<LogViewerEntryStructure> entryStructures, Map<String, LogViewerAttributeType> validAttributes) {
        LinkedHashSet<String> proposals = new LinkedHashSet<String>();
        if (filterText == null || filterText.isBlank() || cursorPosition == 0) {
            proposals.addAll(LogViewerContentAssistProvider.getFilterableAttributes(validAttributes));
            proposals.add("sort_by");
            proposals.add("hide");
            return proposals;
        }
        int lexerTextEndIndex = Math.min(cursorPosition, filterText.length());
        String lexerText = filterText.substring(0, lexerTextEndIndex);
        char lastTextChar = lexerText.charAt(lexerText.length() - 1);
        boolean endsWithWhitespace = Character.isSpaceChar(lastTextChar);
        LogViewerQueryLexer lexer = new LogViewerQueryLexer(new StringReader(lexerText));
        LogViewerContentAssistQueryParser parser = new LogViewerContentAssistQueryParser(lexer);
        try {
            parser.expression();
            LogViewerContentAssistProvider.handleSuccessfulParse(parser, endsWithWhitespace, validAttributes, proposals);
            return proposals;
        }
        catch (LogViewerContentAssistAvailableException logViewerContentAssistAvailableException) {
            LogViewerContentAssistProvider.handlePartialParse(parser, endsWithWhitespace, validAttributes, proposals);
            LogViewerContentAssistProvider.handleExpectedToken(parser, endsWithWhitespace, validAttributes, entryStructures, proposals);
            return proposals;
        }
        catch (Exception exception) {
            return Collections.emptySet();
        }
    }

    public static Set<String> computeSearchProposals(String filterText, int cursorPosition, List<LogViewerEntryStructure> entryStructures, Map<String, LogViewerAttributeType> validAttributes) {
        Set<String> proposals = LogViewerContentAssistProvider.computeFilterProposals(filterText, cursorPosition, entryStructures, validAttributes);
        proposals.removeIf(prop -> LogViewerConst.COMMANDS.contains(prop));
        return proposals;
    }

    private static void handleSuccessfulParse(LogViewerContentAssistQueryParser parser, boolean endsWithWhitespace, Map<String, LogViewerAttributeType> validAttributes, Set<String> proposals) {
        String prevAttribute = parser.getPrevAttribute();
        LogViewerAttributeType prevAttrType = prevAttribute != null ? validAttributes.get(prevAttribute) : null;
        String prevTokenText = parser.getPrevTokenText();
        LogViewerQueryParsingStatus prevStatus = parser.getPrevStatus();
        if (prevStatus == null || prevTokenText == null) {
            return;
        }
        switch (prevStatus) {
            case ATTRIBUTE: {
                if (endsWithWhitespace) break;
                for (Map.Entry<String, LogViewerAttributeType> entry : validAttributes.entrySet()) {
                    String attr;
                    LogViewerAttributeType type = entry.getValue();
                    if (type == LogViewerAttributeType.FILE_AND_LINE || (attr = entry.getKey()).equals(prevTokenText) || !attr.startsWith(prevTokenText)) continue;
                    proposals.add(attr);
                }
                break;
            }
            case VALUE: {
                if (endsWithWhitespace) break;
                LogViewerContentAssistProvider.addEnumValueProposals(prevAttrType, prevTokenText, proposals);
                break;
            }
            case SORTBY_COMMAND: {
                if (!endsWithWhitespace) {
                    LogViewerContentAssistProvider.addSortByProposals(parser.getSortAttributes(), prevTokenText, validAttributes, proposals);
                }
                LogViewerContentAssistProvider.addLogicalOperators(proposals);
                proposals.add(",");
                return;
            }
            case HIDE_COMMAND: {
                if (!endsWithWhitespace) {
                    LogViewerContentAssistProvider.addHideProposals(parser.getHideAttributes(), prevTokenText, validAttributes, proposals);
                }
                LogViewerContentAssistProvider.addLogicalOperators(proposals);
                proposals.add(",");
                return;
            }
        }
        LogViewerContentAssistProvider.addLogicalOperators(proposals);
    }

    private static void handlePartialParse(LogViewerContentAssistQueryParser parser, boolean endsWithWhitespace, Map<String, LogViewerAttributeType> validAttributes, Set<String> proposals) {
        String prevAttribute = parser.getPrevAttribute();
        LogViewerAttributeType prevAttrType = prevAttribute != null ? validAttributes.get(prevAttribute) : null;
        String prevTokenText = parser.getPrevTokenText();
        LogViewerQueryParsingStatus prevStatus = parser.getPrevStatus();
        if (prevTokenText == null || prevStatus == null) {
            return;
        }
        switch (prevStatus) {
            case ATTRIBUTE: {
                if (endsWithWhitespace) break;
                for (String attr : LogViewerContentAssistProvider.getFilterableAttributes(validAttributes)) {
                    if (attr.equals(prevTokenText) || !attr.startsWith(prevTokenText)) continue;
                    proposals.add(attr);
                }
                if ("hide".startsWith(prevTokenText)) {
                    proposals.add("hide");
                }
                if (!"sort_by".startsWith(prevTokenText)) break;
                proposals.add("sort_by");
                break;
            }
            case OPERATOR: {
                if (endsWithWhitespace || prevAttrType == null || !prevAttrType.hasProperty(LogViewerAttributeProperty.SUPPORTS_NUMERIC_QUERY)) break;
                LogViewerQueryOperator op = LogViewerQueryOperator.from(prevTokenText);
                if (op == LogViewerQueryOperator.GREATER) {
                    proposals.add(LogViewerQueryOperator.GREATER_OR_EQUAL.toString());
                }
                if (op != LogViewerQueryOperator.LESS) break;
                proposals.add(LogViewerQueryOperator.LESS_OR_EQUAL.toString());
                break;
            }
            case VALUE: {
                if (endsWithWhitespace) {
                    LogViewerContentAssistProvider.addLogicalOperators(proposals);
                    break;
                }
                LogViewerContentAssistProvider.addEnumValueProposals(prevAttrType, prevTokenText, proposals);
                break;
            }
            case SORTBY_COMMAND: {
                if (!endsWithWhitespace) {
                    LogViewerContentAssistProvider.addSortByProposals(parser.getSortAttributes(), prevTokenText, validAttributes, proposals);
                }
                LogViewerContentAssistProvider.addLogicalOperators(proposals);
                proposals.add(",");
                break;
            }
            case HIDE_COMMAND: {
                if (!endsWithWhitespace) {
                    LogViewerContentAssistProvider.addHideProposals(parser.getHideAttributes(), prevTokenText, validAttributes, proposals);
                }
                LogViewerContentAssistProvider.addLogicalOperators(proposals);
                proposals.add(",");
                break;
            }
            case CLAUSE_CHAINING: 
            case LEFT_PARENTHESIS: {
                proposals.addAll(LogViewerContentAssistProvider.getFilterableAttributes(validAttributes));
                proposals.add("hide");
                proposals.add("sort_by");
                break;
            }
        }
    }

    private static void handleExpectedToken(LogViewerContentAssistQueryParser parser, boolean endsWithWhitespace, Map<String, LogViewerAttributeType> validAttributes, List<LogViewerEntryStructure> entryStructures, Set<String> proposals) {
        LogViewerQueryParsingStatus expectedTokenStatus = parser.getExpectedTokenStatus();
        if (expectedTokenStatus == null) {
            return;
        }
        String prevAttribute = parser.getPrevAttribute();
        LogViewerAttributeType prevAttrType = prevAttribute != null ? validAttributes.get(prevAttribute) : null;
        LogViewerQueryParsingStatus prevStatus = parser.getPrevStatus();
        block0 : switch (expectedTokenStatus) {
            case ATTRIBUTE: {
                if (prevStatus == null) {
                    proposals.addAll(LogViewerContentAssistProvider.getFilterableAttributes(validAttributes));
                    break;
                }
                switch (prevStatus) {
                    case SORTBY_TOKEN: 
                    case SORTBY_ATTRIBUTE_SEPARATOR: {
                        if (!endsWithWhitespace) break block0;
                        LogViewerContentAssistProvider.addSortByProposals(parser.getSortAttributes(), "", validAttributes, proposals);
                        break block0;
                    }
                    case HIDE_TOKEN: 
                    case HIDE_ATTRIBUTE_SEPARATOR: {
                        if (!endsWithWhitespace) break block0;
                        LogViewerContentAssistProvider.addHideProposals(parser.getHideAttributes(), "", validAttributes, proposals);
                        break block0;
                    }
                }
                proposals.addAll(LogViewerContentAssistProvider.getFilterableAttributes(validAttributes));
                break;
            }
            case OPERATOR: {
                if (prevAttrType == null) break;
                if (prevAttrType.hasProperty(LogViewerAttributeProperty.SUPPORTS_TEXT_QUERY)) {
                    proposals.add(LogViewerQueryOperator.EQUAL.toString());
                    proposals.add(LogViewerQueryOperator.NOT_EQUAL.toString());
                }
                if (!prevAttrType.hasProperty(LogViewerAttributeProperty.SUPPORTS_NUMERIC_QUERY)) break;
                LogViewerQueryOperator[] logViewerQueryOperatorArray = LogViewerQueryOperator.values();
                int n = logViewerQueryOperatorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LogViewerQueryOperator op = logViewerQueryOperatorArray[n2];
                    proposals.add(op.toString());
                    ++n2;
                }
                break;
            }
            case VALUE: {
                LogViewerContentAssistProvider.addEnumValueProposals(prevAttrType, "", proposals);
                LogViewerContentAssistProvider.addEntryStructuresProposals(prevAttribute, entryStructures, proposals);
                break;
            }
            case CLAUSE_CHAINING: {
                LogViewerContentAssistProvider.addLogicalOperators(proposals);
                break;
            }
            case RIGHT_PARENTHESIS: {
                LogViewerContentAssistProvider.addLogicalOperators(proposals);
                proposals.add(")");
                break;
            }
        }
    }

    private static void addEnumValueProposals(LogViewerAttributeType attrType, String prefix, Set<String> proposals) {
        if (attrType == null || !attrType.hasProperty(LogViewerAttributeProperty.IS_ENUM_VALUE)) {
            return;
        }
        List<Enum<?>> enumValues = attrType.getEnumValues();
        if (enumValues == null) {
            return;
        }
        for (Enum<?> enumValue : enumValues) {
            String val = enumValue.toString();
            if (val.equals(prefix) || !val.startsWith(prefix)) continue;
            proposals.add(val);
        }
    }

    private static void addEntryStructuresProposals(String prevAttribute, List<LogViewerEntryStructure> entryStructures, Set<String> proposals) {
        if (!"entry_structure".equals(prevAttribute)) {
            return;
        }
        entryStructures.forEach(struct -> {
            boolean bl = proposals.add("\"" + struct.getName() + "\"");
        });
        proposals.add("N/A");
    }

    private static void addLogicalOperators(Set<String> proposals) {
        proposals.add("&&");
        proposals.add("||");
    }

    private static void addSortByProposals(List<String> sortAttributes, String prefix, Map<String, LogViewerAttributeType> validAttributes, Set<String> proposals) {
        boolean sortOrderSpecified;
        if (prefix == null) {
            prefix = "";
        }
        Character firstPrefixChar = null;
        if (!prefix.isEmpty()) {
            firstPrefixChar = Character.valueOf(prefix.charAt(0));
        }
        boolean bl = sortOrderSpecified = firstPrefixChar == LogViewerConst.ASCENDING_SORT_ORDER_CHAR || firstPrefixChar == LogViewerConst.DESCENDING_SORT_ORDER_CHAR;
        if (sortOrderSpecified) {
            prefix = prefix.substring(1);
        }
        for (Map.Entry<String, LogViewerAttributeType> entry : validAttributes.entrySet()) {
            LogViewerAttributeType type;
            String attr = entry.getKey();
            if (sortAttributes.contains(attr) || !(type = entry.getValue()).hasProperty(LogViewerAttributeProperty.SUPPORTS_NUMERIC_QUERY) || attr.equals(prefix) || !attr.startsWith(prefix)) continue;
            proposals.add(attr);
            if (sortOrderSpecified) continue;
            proposals.add(String.valueOf(Character.toString(LogViewerConst.DESCENDING_SORT_ORDER_CHAR.charValue())) + attr);
        }
    }

    private static void addHideProposals(List<String> hideAttributes, String prefix, Map<String, LogViewerAttributeType> validAttributes, Set<String> proposals) {
        boolean hasFileAndLineWrapper = LogViewerContentAssistProvider.containsFileAndLineWrapper(validAttributes);
        for (Map.Entry<String, LogViewerAttributeType> entry : validAttributes.entrySet()) {
            String attr = entry.getKey();
            if (hideAttributes.contains(attr)) continue;
            LogViewerAttributeType type = entry.getValue();
            if (hasFileAndLineWrapper && (type == LogViewerAttributeType.FILE_PATH || type == LogViewerAttributeType.FILE_LINE) || attr.equals(prefix) || !attr.startsWith(prefix)) continue;
            proposals.add(attr);
        }
    }

    private static Set<String> getFilterableAttributes(Map<String, LogViewerAttributeType> validAttributes) {
        LinkedHashSet<String> attributes = new LinkedHashSet<String>();
        for (Map.Entry<String, LogViewerAttributeType> entry : validAttributes.entrySet()) {
            LogViewerAttributeType type = entry.getValue();
            if (type == LogViewerAttributeType.FILE_AND_LINE) continue;
            attributes.add(entry.getKey());
        }
        return attributes;
    }

    private static boolean containsFileAndLineWrapper(Map<String, LogViewerAttributeType> validAttributes) {
        return validAttributes.containsValue((Object)LogViewerAttributeType.FILE_AND_LINE);
    }
}

