/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.query.parsing;

import antlr.LLkParser;
import antlr.Parser;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import ro.amiq.dvt.logviewer.LogViewerConst;
import ro.amiq.dvt.logviewer.indexing.LogViewerAttributeType;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructure;
import ro.amiq.dvt.logviewer.query.LogViewerQueryWrapper;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerInvalidQueryException;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerInvalidQuerySyntaxException;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerQueryLexer;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerQueryParserTokenTypes;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerQueryParserUtils;

public class LogViewerQueryParser
extends LLkParser
implements LogViewerQueryParserTokenTypes {
    private String filterText;
    private Map<String, LogViewerAttributeType> validAttributes;
    private List<LogViewerEntryStructure> entryStructures;
    private boolean canSort;
    private boolean allowCommands;
    private StringBuilder statusMessage;
    private Set<String> sortAttributes = new LinkedHashSet<String>();
    private Set<String> hideAttributes = new HashSet<String>();
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "HIDE", "SORTBY", "LPAREN", "RPAREN", "AND", "OR", "EQ", "NE", "LE", "GE", "LT", "GT", "COMMA", "STRING", "WORD", "WS"};
    public static final BitSet _tokenSet_0 = new BitSet(LogViewerQueryParser.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(LogViewerQueryParser.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(LogViewerQueryParser.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(LogViewerQueryParser.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(LogViewerQueryParser.mk_tokenSet_4());
    public static final BitSet _tokenSet_5 = new BitSet(LogViewerQueryParser.mk_tokenSet_5());

    public LogViewerQueryParser(LogViewerQueryLexer lexer, String filterText, Map<String, LogViewerAttributeType> validAttributes, List<LogViewerEntryStructure> entryStructures, boolean canSort, boolean allowCommands, StringBuilder statusMessage) {
        this(lexer);
        this.filterText = filterText;
        this.validAttributes = validAttributes;
        this.entryStructures = entryStructures;
        this.canSort = canSort;
        this.allowCommands = allowCommands;
        this.statusMessage = statusMessage;
    }

    public void reportError(RecognitionException e) {
        throw new LogViewerInvalidQuerySyntaxException();
    }

    protected LogViewerQueryParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public LogViewerQueryParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 2);
    }

    protected LogViewerQueryParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public LogViewerQueryParser(TokenStream lexer) {
        this(lexer, 2);
    }

    public LogViewerQueryParser(ParserSharedInputState state) {
        super(state, 2);
        this.tokenNames = _tokenNames;
    }

    public final LogViewerQueryWrapper expression() throws RecognitionException, TokenStreamException {
        Parser.UserMark userMark = null;
        Runnable finalRunnable = null;
        Query query = null;
        LogViewerQueryWrapper wrapper = null;
        try {
            try {
                query = this.logicalOr();
                this.match(1);
                Sort sort = LogViewerQueryParserUtils.createSort(this.sortAttributes, this.validAttributes, this.statusMessage);
                query = LogViewerQueryParserUtils.addQueryChecksForSort(query, sort, this.validAttributes);
                this.hideAttributes = LogViewerQueryParserUtils.validateHideAttributes(this.hideAttributes, this.validAttributes, this.statusMessage);
                wrapper = new LogViewerQueryWrapper(this.filterText, false, query, sort, this.hideAttributes);
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_0);
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
            }
        }
        finally {
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        return wrapper;
    }

    public final Query logicalOr() throws RecognitionException, TokenStreamException {
        Parser.UserMark userMark = null;
        Runnable finalRunnable = null;
        Query auxQuery = null;
        Query q = null;
        try {
            try {
                q = auxQuery = this.logicalAnd();
                while (this.LA(1) == 9) {
                    this.match(9);
                    auxQuery = this.logicalAnd();
                    BooleanQuery.Builder bld = new BooleanQuery.Builder();
                    if (q != null) {
                        bld.add(q, BooleanClause.Occur.SHOULD);
                    }
                    if (auxQuery == null) continue;
                    bld.add(auxQuery, BooleanClause.Occur.SHOULD);
                    q = bld.build();
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_1);
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
            }
        }
        finally {
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        return q;
    }

    public final Query logicalAnd() throws RecognitionException, TokenStreamException {
        Parser.UserMark userMark = null;
        Runnable finalRunnable = null;
        Query auxQuery = null;
        Query q = null;
        try {
            try {
                q = auxQuery = this.clause();
                while (this.LA(1) == 8) {
                    this.match(8);
                    auxQuery = this.clause();
                    BooleanQuery.Builder bld = new BooleanQuery.Builder();
                    if (q != null) {
                        bld.add(q, BooleanClause.Occur.MUST);
                    }
                    if (auxQuery == null) continue;
                    bld.add(auxQuery, BooleanClause.Occur.MUST);
                    q = bld.build();
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_2);
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
            }
        }
        finally {
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        return q;
    }

    public final Query clause() throws RecognitionException, TokenStreamException {
        Parser.UserMark userMark = null;
        Runnable finalRunnable = null;
        Query auxQuery = null;
        Query q = null;
        try {
            try {
                switch (this.LA(1)) {
                    case 6: {
                        this.match(6);
                        auxQuery = this.logicalOr();
                        this.match(7);
                        q = auxQuery;
                        break;
                    }
                    case 18: {
                        q = auxQuery = this.comparison();
                        break;
                    }
                    case 4: 
                    case 5: {
                        q = auxQuery = this.command();
                        break;
                    }
                    default: {
                        throw this.getNoViableAltException(this.LT(1), this.getFilename());
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_3);
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
            }
        }
        finally {
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        return q;
    }

    public final Query comparison() throws RecognitionException, TokenStreamException {
        Parser.UserMark userMark = null;
        Runnable finalRunnable = null;
        String attr = null;
        String op = null;
        String val = null;
        Query q = null;
        try {
            try {
                attr = this.attribute();
                op = this.operator();
                val = this.value();
                q = LogViewerQueryParserUtils.createQuery(attr, op, val, this.validAttributes, this.entryStructures);
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_3);
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
            }
        }
        finally {
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        return q;
    }

    public final Query command() throws RecognitionException, TokenStreamException {
        Parser.UserMark userMark = null;
        Runnable finalRunnable = null;
        Set<String> attributes = null;
        Query q = null;
        try {
            try {
                switch (this.LA(1)) {
                    case 5: {
                        this.match(5);
                        attributes = this.attrList();
                        if (!this.allowCommands) {
                            throw new LogViewerInvalidQueryException(LogViewerConst.searchUnsupportedSortbyMessage());
                        }
                        if (this.canSort) {
                            this.sortAttributes.addAll(attributes);
                        } else {
                            this.statusMessage.append("The 'sort_by' clause is not supported until the indexing is completed!\n");
                        }
                        break;
                    }
                    case 4: {
                        this.match(4);
                        attributes = this.attrList();
                        if (!this.allowCommands) {
                            throw new LogViewerInvalidQueryException(LogViewerConst.searchUnsupportedHideMessage());
                        }
                        this.hideAttributes.addAll(attributes);
                        break;
                    }
                    default: {
                        throw this.getNoViableAltException(this.LT(1), this.getFilename());
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_3);
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
            }
        }
        finally {
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        return q;
    }

    public final String attribute() throws RecognitionException, TokenStreamException {
        Parser.UserMark userMark = null;
        Runnable finalRunnable = null;
        Token w = null;
        String text = null;
        try {
            try {
                w = this.LT(1);
                this.match(18);
                text = w.getText();
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_4);
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
            }
        }
        finally {
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        return text;
    }

    public final String operator() throws RecognitionException, TokenStreamException {
        Parser.UserMark userMark = null;
        Runnable finalRunnable = null;
        String text = null;
        try {
            try {
                switch (this.LA(1)) {
                    case 10: {
                        this.match(10);
                        text = "=";
                        break;
                    }
                    case 11: {
                        this.match(11);
                        text = "!=";
                        break;
                    }
                    case 14: {
                        this.match(14);
                        text = "<";
                        break;
                    }
                    case 12: {
                        this.match(12);
                        text = "<=";
                        break;
                    }
                    case 15: {
                        this.match(15);
                        text = ">";
                        break;
                    }
                    case 13: {
                        this.match(13);
                        text = ">=";
                        break;
                    }
                    default: {
                        throw this.getNoViableAltException(this.LT(1), this.getFilename());
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_5);
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
            }
        }
        finally {
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        return text;
    }

    public final String value() throws RecognitionException, TokenStreamException {
        Parser.UserMark userMark = null;
        Runnable finalRunnable = null;
        Token s = null;
        Token w = null;
        String text = null;
        try {
            try {
                switch (this.LA(1)) {
                    case 17: {
                        s = this.LT(1);
                        this.match(17);
                        text = s.getText();
                        break;
                    }
                    case 18: {
                        w = this.LT(1);
                        this.match(18);
                        text = w.getText();
                        break;
                    }
                    default: {
                        throw this.getNoViableAltException(this.LT(1), this.getFilename());
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_3);
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
            }
        }
        finally {
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        return text;
    }

    public final Set<String> attrList() throws RecognitionException, TokenStreamException {
        Parser.UserMark userMark = null;
        Runnable finalRunnable = null;
        LinkedHashSet<String> attributes = new LinkedHashSet<String>();
        String attributeName = null;
        try {
            try {
                attributeName = this.attribute();
                attributes.add(attributeName);
                while (this.LA(1) == 16) {
                    this.match(16);
                    attributeName = this.attribute();
                    attributes.add(attributeName);
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_3);
                this.userRelease(userMark);
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
            }
        }
        finally {
            this.userRelease(userMark);
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        return attributes;
    }

    private static final long[] mk_tokenSet_0() {
        long[] lArray = new long[2];
        lArray[0] = 2L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] lArray = new long[2];
        lArray[0] = 130L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] lArray = new long[2];
        lArray[0] = 642L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] lArray = new long[2];
        lArray[0] = 898L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_4() {
        long[] lArray = new long[2];
        lArray[0] = 130946L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_5() {
        long[] lArray = new long[2];
        lArray[0] = 393216L;
        long[] data = lArray;
        return data;
    }
}

