/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.query.parsing;

import java.io.StringReader;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import ro.amiq.dvt.logviewer.LogViewerConst;
import ro.amiq.dvt.logviewer.indexing.LogViewerAttributeProperty;
import ro.amiq.dvt.logviewer.indexing.LogViewerAttributeType;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructure;
import ro.amiq.dvt.logviewer.query.LogViewerQueryWrapper;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerInvalidQueryException;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerInvalidQuerySyntaxException;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerQueryLexer;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerQueryOperator;
import ro.amiq.dvt.logviewer.query.parsing.LogViewerQueryParser;

public class LogViewerQueryParserUtils {
    private static final String EQ_OPERATOR = "=";
    private static final String STRING_WITH_SPACES_REGEX = ".*\\s.*";
    private static final String SPACE_SEPARATOR_REGEX = "\\s+";

    private LogViewerQueryParserUtils() {
    }

    public static LogViewerQueryWrapper parseQuery(String filterText, Map<String, LogViewerAttributeType> validAttributes, List<LogViewerEntryStructure> entryStructures, boolean finishedIndexing, boolean allowCommands, StringBuilder sb) {
        if (filterText == null || filterText.isBlank()) {
            return LogViewerConst.DEFAULT_QUERY_WRAPPER;
        }
        try {
            LogViewerQueryLexer lexer = new LogViewerQueryLexer(new StringReader(filterText));
            LogViewerQueryParser parser = new LogViewerQueryParser(lexer, filterText, validAttributes, entryStructures, finishedIndexing, allowCommands, sb);
            LogViewerQueryWrapper queryWrapper = parser.expression();
            return queryWrapper;
        }
        catch (LogViewerInvalidQuerySyntaxException logViewerInvalidQuerySyntaxException) {
            return LogViewerQueryParserUtils.computeTextualInputQuery(filterText, validAttributes, entryStructures);
        }
        catch (LogViewerInvalidQueryException ex) {
            sb.append(ex.getMessage());
            return null;
        }
        catch (Exception exception) {
            sb.setLength(0);
            sb.append("Invalid filtering clause!");
            return null;
        }
    }

    private static LogViewerQueryWrapper computeTextualInputQuery(String filterText, Map<String, LogViewerAttributeType> validAttributes, List<LogViewerEntryStructure> entryStructures) {
        filterText = LogViewerQueryParserUtils.removeTextQuotes(filterText.trim());
        Query query = null;
        BooleanQuery.Builder bld = new BooleanQuery.Builder();
        for (String attribute : validAttributes.keySet()) {
            try {
                query = LogViewerQueryParserUtils.createQuery(attribute, EQ_OPERATOR, filterText, validAttributes, entryStructures);
            }
            catch (Exception exception) {
                continue;
            }
            if (query == null) continue;
            bld.add(query, BooleanClause.Occur.SHOULD);
        }
        query = LogViewerQueryParserUtils.addQueryChecksForSort((Query)bld.build(), LogViewerConst.DEFAULT_SORT, validAttributes);
        return new LogViewerQueryWrapper(filterText, true, query, LogViewerConst.DEFAULT_SORT, null);
    }

    protected static Query createQuery(String attribute, String operator, String value, Map<String, LogViewerAttributeType> validAttributes, List<LogViewerEntryStructure> entryStructures) {
        if (attribute == null || attribute.isBlank() || operator == null || operator.isBlank() || value == null || value.isBlank()) {
            throw new LogViewerInvalidQuerySyntaxException();
        }
        if (!validAttributes.containsKey(attribute)) {
            throw LogViewerInvalidQueryException.nonExistingAttribute(attribute);
        }
        LogViewerAttributeType attrType = validAttributes.get(attribute);
        if (attrType == null) {
            throw new LogViewerInvalidQuerySyntaxException();
        }
        LogViewerQueryOperator op = LogViewerQueryOperator.from(operator);
        if (op == null) {
            throw new LogViewerInvalidQuerySyntaxException();
        }
        if (attrType.hasProperty(LogViewerAttributeProperty.SUPPORTS_TEXT_QUERY)) {
            return LogViewerQueryParserUtils.handleTextQuery(attribute, attrType, op, value, entryStructures);
        }
        if (attrType.hasProperty(LogViewerAttributeProperty.SUPPORTS_NUMERIC_QUERY)) {
            return LogViewerQueryParserUtils.handleNumericQuery(attribute, attrType, op, value);
        }
        throw new LogViewerInvalidQuerySyntaxException();
    }

    private static Query handleTextQuery(String attribute, LogViewerAttributeType attrType, LogViewerQueryOperator op, String value, List<LogViewerEntryStructure> entryStructures) {
        boolean isNotEqualOperator;
        boolean bl = isNotEqualOperator = op == LogViewerQueryOperator.NOT_EQUAL;
        if (!isNotEqualOperator && op != LogViewerQueryOperator.EQUAL) {
            throw LogViewerInvalidQueryException.unsupportedOperator(attribute);
        }
        Query query = LogViewerQueryParserUtils.createTextQuery(attribute, attrType, value, entryStructures);
        if (isNotEqualOperator) {
            return LogViewerQueryParserUtils.createTextNotEqualQuery(query);
        }
        return query;
    }

    private static Query createTextNotEqualQuery(Query query) {
        return new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST_NOT).add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST).build();
    }

    private static Query createTextQuery(String attribute, LogViewerAttributeType attrType, String value, List<LogViewerEntryStructure> entryStructures) {
        value = LogViewerQueryParserUtils.removeTextQuotes(value);
        if ("entry_structure".equals(attribute)) {
            value = LogViewerQueryParserUtils.convertStructureNameToId(value, attribute, entryStructures);
            return new TermQuery(new Term(attribute, value));
        }
        if (!attrType.hasProperty(LogViewerAttributeProperty.SUPPORTS_REGEX_FILTERING)) {
            return new TermQuery(new Term(attribute, value));
        }
        if (value.matches(STRING_WITH_SPACES_REGEX)) {
            String[] queryTokens = value.split(SPACE_SEPARATOR_REGEX);
            return new PhraseQuery(attribute, queryTokens);
        }
        value = LogViewerQueryParserUtils.allowSubstrings(value);
        return new RegexpQuery(new Term(attribute, value), 0);
    }

    private static String removeTextQuotes(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        if (text.charAt(0) != '\"' || text.charAt(text.length() - 1) != '\"') {
            return text;
        }
        return text.substring(1, text.length() - 1);
    }

    private static String convertStructureNameToId(String queryText, String attribute, List<LogViewerEntryStructure> entryStructures) {
        if (!"entry_structure".equals(attribute)) {
            return queryText;
        }
        int i = 0;
        while (i < entryStructures.size()) {
            LogViewerEntryStructure structure = entryStructures.get(i);
            if (queryText.equals(structure.getName())) {
                return Integer.toString(i);
            }
            ++i;
        }
        if (!queryText.equals("N/A")) {
            throw LogViewerInvalidQueryException.invalidStructureName(queryText);
        }
        queryText = Integer.toString(-1);
        return queryText;
    }

    private static String allowSubstrings(String pattern) {
        char lastChar;
        if (pattern == null || pattern.isEmpty()) {
            return pattern;
        }
        char firstChar = pattern.charAt(0);
        if (firstChar == '*') {
            pattern = "." + pattern;
        }
        if (firstChar != '^') {
            pattern = ".*" + pattern;
        }
        if ((lastChar = pattern.charAt(pattern.length() - 1)) != '$') {
            pattern = String.valueOf(pattern) + ".*";
        }
        return pattern;
    }

    private static Query handleNumericQuery(String attribute, LogViewerAttributeType attrType, LogViewerQueryOperator op, String value) {
        if (attrType.hasProperty(LogViewerAttributeProperty.SUPPORTS_LONG_VALUES)) {
            return LogViewerQueryParserUtils.createLongQuery(attribute, op, value);
        }
        if (attrType.hasProperty(LogViewerAttributeProperty.IS_ENUM_VALUE) && (value = attrType.convertToIndexedVersion(value)) == null) {
            return new MatchNoDocsQuery();
        }
        return LogViewerQueryParserUtils.createIntQuery(attribute, op, value);
    }

    public static Query createIntQuery(String attribute, LogViewerQueryOperator operator, String valueStr) {
        int value;
        try {
            value = Integer.parseInt(valueStr);
        }
        catch (Exception exception) {
            throw LogViewerInvalidQueryException.invalidIntValue(attribute, valueStr);
        }
        if (operator == null) {
            throw new LogViewerInvalidQuerySyntaxException();
        }
        switch (operator) {
            case EQUAL: {
                return IntPoint.newExactQuery((String)attribute, (int)value);
            }
            case NOT_EQUAL: {
                Query lessThan = IntPoint.newRangeQuery((String)attribute, (int)Integer.MIN_VALUE, (int)(value - 1));
                Query greater = IntPoint.newRangeQuery((String)attribute, (int)(value + 1), (int)Integer.MAX_VALUE);
                return new BooleanQuery.Builder().add(lessThan, BooleanClause.Occur.SHOULD).add(greater, BooleanClause.Occur.SHOULD).build();
            }
            case LESS_OR_EQUAL: {
                return IntPoint.newRangeQuery((String)attribute, (int)Integer.MIN_VALUE, (int)value);
            }
            case LESS: {
                return IntPoint.newRangeQuery((String)attribute, (int)Integer.MIN_VALUE, (int)(value - 1));
            }
            case GREATER_OR_EQUAL: {
                return IntPoint.newRangeQuery((String)attribute, (int)value, (int)Integer.MAX_VALUE);
            }
            case GREATER: {
                return IntPoint.newRangeQuery((String)attribute, (int)(value + 1), (int)Integer.MAX_VALUE);
            }
        }
        throw new LogViewerInvalidQuerySyntaxException();
    }

    public static Query createLongQuery(String attribute, LogViewerQueryOperator operator, String valueStr) {
        long value;
        try {
            value = Long.parseLong(valueStr);
        }
        catch (NumberFormatException numberFormatException) {
            throw LogViewerInvalidQueryException.invalidLongValue(attribute, valueStr);
        }
        if (operator == null) {
            throw new LogViewerInvalidQuerySyntaxException();
        }
        switch (operator) {
            case EQUAL: {
                return LongPoint.newExactQuery((String)attribute, (long)value);
            }
            case NOT_EQUAL: {
                Query lessThan = LongPoint.newRangeQuery((String)attribute, (long)Long.MIN_VALUE, (long)(value - 1L));
                Query greater = LongPoint.newRangeQuery((String)attribute, (long)(value + 1L), (long)Long.MAX_VALUE);
                return new BooleanQuery.Builder().add(lessThan, BooleanClause.Occur.SHOULD).add(greater, BooleanClause.Occur.SHOULD).build();
            }
            case LESS_OR_EQUAL: {
                return LongPoint.newRangeQuery((String)attribute, (long)Long.MIN_VALUE, (long)value);
            }
            case LESS: {
                return LongPoint.newRangeQuery((String)attribute, (long)Long.MIN_VALUE, (long)(value - 1L));
            }
            case GREATER_OR_EQUAL: {
                return LongPoint.newRangeQuery((String)attribute, (long)value, (long)Long.MAX_VALUE);
            }
            case GREATER: {
                return LongPoint.newRangeQuery((String)attribute, (long)(value + 1L), (long)Long.MAX_VALUE);
            }
        }
        throw new LogViewerInvalidQuerySyntaxException();
    }

    protected static Sort createSort(Set<String> sortAttributes, Map<String, LogViewerAttributeType> validAttributes, StringBuilder statusMessage) {
        if (sortAttributes == null || sortAttributes.isEmpty()) {
            return LogViewerConst.DEFAULT_SORT;
        }
        LinkedHashSet<SortField> sortFields = new LinkedHashSet<SortField>();
        for (String attribute : sortAttributes) {
            boolean descending = false;
            char firstChar = attribute.charAt(0);
            if (firstChar == LogViewerConst.DESCENDING_SORT_ORDER_CHAR.charValue()) {
                descending = true;
                attribute = attribute.substring(1).trim();
            } else if (firstChar == LogViewerConst.ASCENDING_SORT_ORDER_CHAR.charValue()) {
                attribute = attribute.substring(1).trim();
            }
            if (!validAttributes.containsKey(attribute)) {
                statusMessage.append(LogViewerConst.nonExistingAttributeMessage(attribute));
                continue;
            }
            if (validAttributes.get(attribute).getSortFieldType() == null) {
                statusMessage.append(LogViewerConst.sortByInvalidAttributeMessage(attribute));
                continue;
            }
            SortField sortField = new SortField(String.valueOf(attribute) + "_sortable", validAttributes.get(attribute).getSortFieldType(), descending);
            sortFields.add(sortField);
        }
        sortFields.add(LogViewerConst.DEFAULT_SORT_FIELD);
        return new Sort(sortFields.toArray(new SortField[0]));
    }

    protected static Query addQueryChecksForSort(Query query, Sort sort, Map<String, LogViewerAttributeType> validAttributes) {
        if (sort == null || sort == LogViewerConst.DEFAULT_SORT) {
            return query;
        }
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        SortField[] sortFieldArray = sort.getSort();
        int n = sortFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            SortField sortField = sortFieldArray[n2];
            String sortableFieldName = sortField.getField();
            String fieldName = sortableFieldName.substring(0, sortableFieldName.length() - "_sortable".length());
            LogViewerAttributeType attributeType = validAttributes.get(fieldName);
            if (attributeType.hasProperty(LogViewerAttributeProperty.SUPPORTS_NUMERIC_QUERY)) {
                Query sortableFieldExists = attributeType.hasProperty(LogViewerAttributeProperty.SUPPORTS_LONG_VALUES) ? LongPoint.newRangeQuery((String)fieldName, (long)Long.MIN_VALUE, (long)Long.MAX_VALUE) : IntPoint.newRangeQuery((String)fieldName, (int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
                queryBuilder.add(sortableFieldExists, BooleanClause.Occur.MUST);
            }
            ++n2;
        }
        if (query != null) {
            queryBuilder.add(query, BooleanClause.Occur.MUST);
        }
        return queryBuilder.build();
    }

    protected static Set<String> validateHideAttributes(Set<String> candidates, Map<String, LogViewerAttributeType> validAttributes, StringBuilder statusMessage) {
        HashSet<String> hiddenAttributes = new HashSet<String>();
        for (String candidate : candidates) {
            if (!validAttributes.containsKey(candidate)) {
                statusMessage.append(LogViewerConst.nonExistingAttributeMessage(candidate));
                continue;
            }
            hiddenAttributes.add(candidate);
        }
        return hiddenAttributes;
    }
}

