/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.webview;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.swt.browser.Browser;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.logviewer.LogViewerConsole;
import ro.amiq.dvt.logviewer.webview.ILogViewerWebview;
import ro.amiq.dvt.logviewer.webview.LogViewerConnectionFailedException;
import ro.amiq.dvt.logviewer.webview.LogViewerPlugin;
import ro.amiq.dvt.webview.IRemoteProxySetter;
import ro.amiq.dvt.webview.WebServer;
import ro.amiq.dvt.webview.browser.DVTBrowserUtils;

public class LogViewerConnectionManager {
    private final LogViewerPlugin plugin;
    private WebServer<ILogViewerWebview> webServer;
    private Browser browser;
    private static final int MAX_NOF_INIT_ATTEMPTS = 3;
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();

    private LogViewerConnectionManager(String logFilePath) {
        this.plugin = new LogViewerPlugin(logFilePath);
        this.webServer = new WebServer((IRemoteProxySetter)this.plugin, ILogViewerWebview.class, "/resources/logViewer/index.html");
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            this.browser = DVTBrowserUtils.INSTANCE.initializeBrowser();
            this.browser.setUrl(this.webServer.getStaticServingURL());
        });
    }

    public static CompletableFuture<LogViewerConnectionManager> init(String logFilePath) {
        return CompletableFuture.supplyAsync(() -> {
            int nofInitAttempts = 0;
            Exception initException = null;
            while (nofInitAttempts < 3) {
                try {
                    ++nofInitAttempts;
                    LogViewerConsole.INSTANCE.logInfo("LogViewer components initialization started.");
                    return new LogViewerConnectionManager(logFilePath);
                }
                catch (Exception e) {
                    LogViewerConsole.INSTANCE.logInfo("LogViewer components initialization failed!");
                    initException = e;
                }
            }
            throw new LogViewerConnectionFailedException(initException);
        }, EXECUTOR_SERVICE);
    }

    public LogViewerPlugin getPlugin() {
        return this.plugin;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void close() {
        this.webServer.close();
        this.plugin.close();
    }
}

