/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.webview;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.logviewer.LogFile;
import ro.amiq.dvt.logviewer.LogFileManager;
import ro.amiq.dvt.logviewer.LogViewerProjectManager;
import ro.amiq.dvt.logviewer.LogViewerUtils;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructure;
import ro.amiq.dvt.logviewer.indexing.LogViewerEntryStructureCategory;
import ro.amiq.dvt.logviewer.indexing.LogViewerStructureParsingException;
import ro.amiq.dvt.logviewer.webview.ILogViewerPlugin;
import ro.amiq.dvt.logviewer.webview.ILogViewerWebview;
import ro.amiq.dvt.logviewer.webview.LogViewerWebviewManager;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerComputeFilterProposalsParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerComputeFilterProposalsResponse;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerGetEntryStructuresResponse;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerGetPreferenceParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerGetPreferenceResponse;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerGetSearchMatchParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerGetSearchMatchResponse;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerHandleEntryPageParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerHandleFilterChangeParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerHandleFilterChangeResponse;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerHandleFullIndexingParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerHandleFullIndexingResponse;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerHandleHyperlinkParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerHandleTimeRulerDoubleClickParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerOpenFileParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerOpenFileResponse;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerRefreshIndexingParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerRefreshIndexingResponse;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerSaveConfigurationParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerSetPreferenceParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerToggleProjectAssociationParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerValidateEntryStructureParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerValidateEntryStructureResponse;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerValidateSearchParams;
import ro.amiq.dvt.logviewer.webview.messages.LogViewerValidateSearchResponse;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.webview.IRemoteProxySetter;
import ro.amiq.dvt.webview.PluginResponseWrapper;

public class LogViewerPlugin
implements ILogViewerPlugin,
IRemoteProxySetter<ILogViewerWebview> {
    private final String logFilePath;
    private LogFile logFile;
    private ILogViewerWebview webview;

    public LogViewerPlugin(String filePath) {
        this.logFilePath = filePath;
    }

    public void setRemoteProxy(ILogViewerWebview webviewInterface) {
        this.webview = webviewInterface;
        LogViewerWebviewManager.INSTANCE.registerWebView(this.logFilePath, webviewInterface);
    }

    @Override
    public CompletableFuture<PluginResponseWrapper<LogViewerOpenFileResponse>> openFile(LogViewerOpenFileParams params) {
        LogFile logFile = LogFileManager.INSTANCE.getOrCreateLogFile(this.logFilePath);
        if (logFile == null) {
            return CompletableFuture.completedFuture(PluginResponseWrapper.of((Object)LogViewerOpenFileResponse.error()));
        }
        if (this.logFile == logFile) {
            return CompletableFuture.completedFuture(PluginResponseWrapper.of((Object)LogViewerOpenFileResponse.success()));
        }
        this.logFile = logFile;
        IProject project = LogViewerProjectManager.INSTANCE.getProject(this.logFilePath);
        if (project != null) {
            LogFileManager.INSTANCE.associateProject(project, this.logFilePath);
        }
        return CompletableFuture.completedFuture(PluginResponseWrapper.of((Object)LogViewerOpenFileResponse.success()));
    }

    @Override
    public CompletableFuture<PluginResponseWrapper<LogViewerHandleFilterChangeResponse>> handleFilterChange(LogViewerHandleFilterChangeParams params) {
        if (params == null || this.logFile == null) {
            return null;
        }
        LogViewerHandleFilterChangeResponse response = this.logFile.handleFilterChange(params.getFilterText(), params.validateOnly());
        return CompletableFuture.completedFuture(PluginResponseWrapper.of((Object)response));
    }

    @Override
    public CompletableFuture<Void> handleEntryPage(LogViewerHandleEntryPageParams params) {
        if (this.logFile == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.logFile.handleEntryPage(params.getPageIndex());
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<PluginResponseWrapper<LogViewerComputeFilterProposalsResponse>> computeFilterProposals(LogViewerComputeFilterProposalsParams params) {
        if (params == null) {
            return null;
        }
        LogViewerComputeFilterProposalsResponse response = this.logFile.computeFilterProposals(params);
        return CompletableFuture.completedFuture(PluginResponseWrapper.of((Object)response));
    }

    @Override
    public CompletableFuture<Void> handleFullIndexing(LogViewerHandleFullIndexingParams params) {
        if (params == null || this.logFile == null) {
            return null;
        }
        LogViewerHandleFullIndexingResponse response = this.logFile.handleFullIndexing();
        if (response == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.webview.updateFullIndexing(response);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<PluginResponseWrapper<LogViewerGetEntryStructuresResponse>> getEntryStructures() {
        if (this.logFile == null) {
            return null;
        }
        Set<LogViewerEntryStructureCategory> categories = LogViewerUtils.fetchEntryStructureCategories(this.logFilePath, this.logFile.getConfigDirectoryLocation());
        LogViewerGetEntryStructuresResponse response = new LogViewerGetEntryStructuresResponse(categories);
        return CompletableFuture.completedFuture(PluginResponseWrapper.of((Object)response));
    }

    @Override
    public CompletableFuture<PluginResponseWrapper<LogViewerValidateEntryStructureResponse>> validateEntryStructure(LogViewerValidateEntryStructureParams params) {
        try {
            LogViewerEntryStructure.validate(params.getEntryStructure());
            LogViewerValidateEntryStructureResponse response = LogViewerValidateEntryStructureResponse.validStructureResponse();
            return CompletableFuture.completedFuture(PluginResponseWrapper.of((Object)response));
        }
        catch (LogViewerStructureParsingException e) {
            LogViewerValidateEntryStructureResponse response = new LogViewerValidateEntryStructureResponse(false, e.getMessage());
            return CompletableFuture.completedFuture(PluginResponseWrapper.of((Object)response));
        }
    }

    @Override
    public CompletableFuture<Void> saveConfiguration(LogViewerSaveConfigurationParams params) {
        if (params == null || this.logFile == null) {
            return null;
        }
        LogViewerUtils.serializeEntryStructureCategories(this.logFilePath, this.logFile.getConfigDirectoryLocation(), params.getEntryStructureCategories());
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<PluginResponseWrapper<LogViewerGetPreferenceResponse>> getPreferenceValue(LogViewerGetPreferenceParams params) {
        LogViewerGetPreferenceResponse response;
        IPreferenceStore preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        if (!preferenceStore.contains(params.getPreferenceName())) {
            response = new LogViewerGetPreferenceResponse(null);
        } else {
            String preferenceValue = preferenceStore.getString(params.getPreferenceName());
            response = new LogViewerGetPreferenceResponse(preferenceValue);
        }
        return CompletableFuture.completedFuture(PluginResponseWrapper.of((Object)response));
    }

    @Override
    public CompletableFuture<Void> setPreferenceValue(LogViewerSetPreferenceParams params) {
        IPreferenceStore preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        if (preferenceStore.contains(params.getPreferenceName())) {
            preferenceStore.setValue(params.getPreferenceName(), params.getPreferenceValue().toString());
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> handleHyperlink(LogViewerHandleHyperlinkParams params) {
        if (this.logFile == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.logFile.handleHyperlink(params.getAttributeName(), params.getAttributeValues());
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> toggleProjectAssociation(LogViewerToggleProjectAssociationParams params) {
        if (this.logFile == null) {
            return CompletableFuture.completedFuture(null);
        }
        IProject project = this.logFile.getAssociatedProject();
        if (project != null) {
            LogFileManager.INSTANCE.clearProjectAssociation(project);
            return CompletableFuture.completedFuture(null);
        }
        project = LogViewerProjectManager.INSTANCE.getProject(this.logFilePath);
        if (project == null) {
            return CompletableFuture.completedFuture(null);
        }
        LogFileManager.INSTANCE.associateProject(project, this.logFile.getFilePath());
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<PluginResponseWrapper<LogViewerValidateSearchResponse>> validateSearch(LogViewerValidateSearchParams params) {
        if (this.logFile == null) {
            return CompletableFuture.completedFuture(null);
        }
        LogViewerValidateSearchResponse response = this.logFile.validateSearch(params.getSearchText());
        return CompletableFuture.completedFuture(PluginResponseWrapper.of((Object)response));
    }

    @Override
    public CompletableFuture<PluginResponseWrapper<LogViewerGetSearchMatchResponse>> getSearchMatch(LogViewerGetSearchMatchParams params) {
        if (this.logFile == null) {
            return CompletableFuture.completedFuture(null);
        }
        Boolean forward = params.isForward();
        if (forward == null) {
            return CompletableFuture.completedFuture(null);
        }
        Integer anchorLogLine = params.getAnchorLogLine();
        if (anchorLogLine == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.logFile.getSearchMatch(forward, anchorLogLine.intValue()).thenApply(value -> PluginResponseWrapper.of((Object)value));
    }

    @Override
    public CompletableFuture<PluginResponseWrapper<LogViewerComputeFilterProposalsResponse>> computeSearchProposals(LogViewerComputeFilterProposalsParams params) {
        if (params == null) {
            return null;
        }
        LogViewerComputeFilterProposalsResponse response = this.logFile.computeSearchProposals(params);
        return CompletableFuture.completedFuture(PluginResponseWrapper.of((Object)response));
    }

    @Override
    public CompletableFuture<PluginResponseWrapper<LogViewerRefreshIndexingResponse>> refreshIndexing(LogViewerRefreshIndexingParams params) {
        if (this.logFile == null || params == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.logFile.refreshIndexing(params.enforceFullIndexing()).thenApply(value -> PluginResponseWrapper.of((Object)value));
    }

    protected void close() {
        LogViewerProjectManager.INSTANCE.clearProject(this.logFilePath);
        if (this.logFile != null) {
            this.logFile.close();
        }
    }

    @Override
    public CompletableFuture<Void> handleTimeRulerDoubleClick(LogViewerHandleTimeRulerDoubleClickParams params) {
        IWorkbenchPage page;
        WViewport viewport;
        Long resultTime;
        block8: {
            if (this.logFile == null) {
                return null;
            }
            if (params == null) {
                return null;
            }
            resultTime = this.logFile.showTimeInWaveformViewer(params);
            if (resultTime == null) {
                return null;
            }
            viewport = DVTVCDUtils.getInstance().getCurrentWaveformViewport();
            if (viewport == null) {
                return null;
            }
            IWorkbenchWindow window = Utils.getActiveWorkbenchWindow();
            if (window == null) {
                return null;
            }
            page = window.getActivePage();
            if (page != null) break block8;
            return null;
        }
        try {
            Display.getDefault().asyncExec(() -> {
                viewport.updatePrimaryCursorAtFixedTime(resultTime.longValue());
                viewport.panToTime(resultTime.longValue());
                WaveDiagramEditor inputWaveEditor = DVTWaveViewIDEFactory.getInstance().getInputWaveEditor(this.logFile.getAssociatedProject());
                page.bringToTop((IWorkbenchPart)inputWaveEditor);
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return CompletableFuture.completedFuture(null);
    }
}

